/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.wizards.component;

import com.ibm.team.filesystem.ui.UiPlugin;
import com.ibm.team.filesystem.ui.changes.actions.DialogUtil;
import com.ibm.team.filesystem.ui.item.AdapterUtil;
import com.ibm.team.filesystem.ui.queries.WorkspaceComponentsQuery;
import com.ibm.team.filesystem.ui.wrapper.AbstractPlaceWrapper;
import com.ibm.team.filesystem.ui.wrapper.ComponentWrapper;
import com.ibm.team.filesystem.ui.wrapper.WorkspaceComponentWrapper;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.WildcardFilter;
import com.ibm.team.internal.filesystem.ui.wizards.AdvanceableWizard;
import com.ibm.team.internal.filesystem.ui.wizards.component.ComponentConfigurationPickerWizard;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.common.NullUtil;
import com.ibm.team.repository.rcp.ui.internal.utils.IRunnableWithSelection;
import com.ibm.team.repository.rcp.ui.internal.viewers.ISetWithListeners;
import com.ibm.team.repository.rcp.ui.internal.viewers.LabelColumn;
import com.ibm.team.repository.rcp.ui.internal.viewers.SimpleTableViewer;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.repository.rcp.ui.parts.WidgetToolkit;
import com.ibm.team.repository.rcp.ui.wizards.BaseWizardPage;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;

public class ComponentPickerPage
extends BaseWizardPage {
    private IOperationRunner runner;
    private SimpleTableViewer viewer;
    private AbstractPlaceWrapper workspace;
    private List components;
    private ComponentWrapper componentToReplace;
    private boolean allowMultiSelect;
    private ComponentConfigurationPickerWizard.ConfigurationPickerInput componentConfigurationPickerInput;
    private boolean traverseComponentHierarchy = false;
    private boolean showTraverseComponentHierarchyButton = false;
    private Button traverseComponentHierarchyButton;
    private Runnable timerRunnable;

    public ComponentPickerPage(IOperationRunner runner) {
        this(runner, null, true);
    }

    public ComponentPickerPage(IOperationRunner runner, ComponentWrapper toReplace, boolean allowMultiSelect) {
        this(new ComponentConfigurationPickerWizard.ConfigurationPickerInput(ComponentConfigurationPickerWizard.ConfigurationPickerInput.ConfigurationPickerMode.NON_SPECIFIC, false), runner, toReplace, allowMultiSelect);
    }

    public ComponentPickerPage(ComponentConfigurationPickerWizard.ConfigurationPickerInput componentConfigurationPickerInput, IOperationRunner runner, ComponentWrapper componentToReplace, boolean allowMultiSelect) {
        super("fromWorkspace2", Messages.AddComponentFromWorkspacePage2_title, null);
        this.runner = runner;
        this.componentToReplace = componentToReplace;
        this.allowMultiSelect = allowMultiSelect;
        this.componentConfigurationPickerInput = componentConfigurationPickerInput;
        this.setPageComplete(false);
    }

    public void setWorkspace(AbstractPlaceWrapper workspace) {
        if (NullUtil.equals((Object)((Object)this.workspace), (Object)((Object)workspace))) {
            return;
        }
        this.workspace = workspace;
        if (workspace != null) {
            this.setDescription(NLS.bind((String)Messages.AddComponentFromWorkspacePage2_description, (Object)workspace.getWorkspace().getName()));
        }
        this.updateViewerInput("");
    }

    protected void createBody(Composite parent) {
        Label filterLabel = new Label(parent, 0);
        filterLabel.setText(Messages.ComponentPickerPage_filterLabel);
        filterLabel.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        final Text filterText = new Text(parent, 2048);
        filterText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        DialogUtil.setFocusControl(filterLabel, (Control)filterText);
        filterText.setFocus();
        filterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (ComponentPickerPage.this.timerRunnable == null) {
                    ComponentPickerPage.this.timerRunnable = new Runnable(){

                        @Override
                        public void run() {
                            if (!filterText.isDisposed()) {
                                ComponentPickerPage.this.updateViewerInput(filterText.getText());
                            }
                        }
                    };
                }
                filterText.getDisplay().timerExec(500, ComponentPickerPage.this.timerRunnable);
            }
        });
        Label matchesLabel = new Label(parent, 0);
        matchesLabel.setText(Messages.ComponentPickerPage_componentMatchesLabel);
        matchesLabel.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        Table table = new Table(parent, 68354);
        table.setHeaderVisible(false);
        this.viewer = new SimpleTableViewer(table, null, null);
        new LabelColumn(this.viewer, Messages.AddComponentFromWorkspacePage2_componentsColumnHeading, -1).setComparator(new Comparator(){

            public int compare(Object e1, Object e2) {
                WorkspaceComponentWrapper c1 = (WorkspaceComponentWrapper)e1;
                WorkspaceComponentWrapper c2 = (WorkspaceComponentWrapper)e2;
                return c1.getComponent().getName().compareToIgnoreCase(c2.getComponent().getName());
            }
        });
        this.viewer.getSelectionProvider().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ComponentPickerPage.this.onSelectionChanged((IStructuredSelection)event.getSelection());
            }
        });
        this.viewer.setDoubleClickHandler(new IRunnableWithSelection(){

            public void run(Object selectedObject, Shell targetShell) {
                AdvanceableWizard.advance(ComponentPickerPage.this.getWizard());
            }
        });
        if (this.componentConfigurationPickerInput.isHierarchyAware() && this.componentConfigurationPickerInput.isAddComponent()) {
            if (this.showTraverseComponentHierarchyButton) {
                WidgetToolkit toolkit = WidgetToolkit.createSwtToolkit();
                this.traverseComponentHierarchyButton = toolkit.createButton(parent, Messages.ComponentConfigurationFromWorkspacePage2_ADD_SUBCOMPONENTS_BUTTON_LABEL, 32);
                final IPreferenceStore store = UiPlugin.getDefault().getPreferenceStore();
                this.traverseComponentHierarchyButton.setSelection(store.getBoolean("com.ibm.team.filesystem.ide.ui.add_component_from_workspace_with_hierarchy"));
                this.traverseComponentHierarchy = this.traverseComponentHierarchyButton.getSelection();
                this.traverseComponentHierarchyButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        ComponentPickerPage.this.traverseComponentHierarchy = ComponentPickerPage.this.traverseComponentHierarchyButton.isEnabled() && ComponentPickerPage.this.traverseComponentHierarchyButton.getSelection();
                        store.setValue("com.ibm.team.filesystem.ide.ui.add_component_from_workspace_with_hierarchy", ComponentPickerPage.this.traverseComponentHierarchyButton.getSelection());
                    }
                });
                GridDataFactory.fillDefaults().align(1, 0x1000008).grab(true, false).applyTo((Control)this.traverseComponentHierarchyButton);
            } else {
                this.traverseComponentHierarchy = true;
            }
        }
        this.updateViewerInput("");
        this.onSelectionChanged((IStructuredSelection)StructuredSelection.EMPTY);
        GridLayoutFactory.fillDefaults().generateLayout(parent);
    }

    private void updateViewerInput(final String filter) {
        if (this.workspace == null || this.viewer == null) {
            return;
        }
        WorkspaceComponentsQuery query = new WorkspaceComponentsQuery(this.workspace.getRepository(), this.workspace.getWorkspace(), this.runner){

            @Override
            public List<WorkspaceComponentWrapper> fetchResult(boolean shouldRefresh, IProgressMonitor monitor) throws TeamRepositoryException {
                List<WorkspaceComponentWrapper> components = super.fetchResult(shouldRefresh, monitor);
                if (ComponentPickerPage.this.componentToReplace == null) {
                    Pattern pattern = new WildcardFilter(filter).getPatter();
                    return components.stream().filter(wrapper -> pattern.matcher(wrapper.getComponent().getName()).matches()).collect(Collectors.toList());
                }
                for (WorkspaceComponentWrapper wrapper2 : components) {
                    if (!wrapper2.getComponent().sameItemId((IItemHandle)ComponentPickerPage.this.componentToReplace.getComponent())) continue;
                    return Collections.singletonList(wrapper2);
                }
                return Collections.emptyList();
            }
        };
        this.viewer.setInput((ISetWithListeners)query);
    }

    private void onSelectionChanged(IStructuredSelection selection) {
        this.components = selection.toList();
        if (this.allowMultiSelect) {
            this.setPageComplete(!this.components.isEmpty());
        } else {
            this.setPageComplete(this.components.size() == 1);
        }
    }

    public List<WorkspaceComponentWrapper> getComponents() {
        return AdapterUtil.adaptList(this.components, WorkspaceComponentWrapper.class);
    }

    public boolean traverseComponentHierarchy() {
        return this.traverseComponentHierarchy;
    }
}

