/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.wizards.component;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.internal.namespace.ItemNamespace;
import com.ibm.team.filesystem.client.internal.namespace.WorkspaceNamespace;
import com.ibm.team.filesystem.client.internal.snapshot.ISnapshot;
import com.ibm.team.filesystem.client.internal.snapshot.SnapshotId;
import com.ibm.team.filesystem.ui.WORKSPACES_OR_STREAMS;
import com.ibm.team.filesystem.ui.wrapper.AbstractPlaceWrapper;
import com.ibm.team.filesystem.ui.wrapper.ComponentWrapper;
import com.ibm.team.internal.filesystem.ui.ImagePool;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.wizards.component.ComponentConfigurationChoicePage;
import com.ibm.team.internal.filesystem.ui.wizards.component.PickBaselineChain;
import com.ibm.team.internal.filesystem.ui.wizards.component.SnapshotPickerPage;
import com.ibm.team.internal.filesystem.ui.wizards.component.WorkspacePickerPage;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.JobRunner;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.repository.rcp.ui.parts.impl.IPartResult;
import com.ibm.team.repository.rcp.ui.wizards.ChainedWizard;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.internal.util.ItemId;
import com.ibm.team.scm.common.internal.util.NewCollection;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public class ComponentConfigurationPickerWizard
extends ChainedWizard {
    private final ConfigurationPickerInput configurationPickerInput;
    private final ComponentWrapper component;
    private final IWorkspaceHandle sourceWorkspace;
    private final IWorkspaceHandle additionalWorkspace;
    private final boolean filterSourceWorkspace;
    private final boolean allowFlowTargetsChoice;
    private final IPartResult<ComponentConfigurationPickerResult> callback;
    private String description;
    private ComponentConfigurationChoicePage choicePage;
    private WorkspacePickerPage fromWorkspacePage1;
    private PickBaselineChain pickBaselineChain;
    private WorkspacePickerPage fromSnapshotPage1;
    private SnapshotPickerPage fromSnapshotPage2;
    private JobRunner backgroundRunner = new JobRunner(false);
    private JobRunner foregroundRunner = new JobRunner(true);

    public ComponentConfigurationPickerWizard(ConfigurationPickerInput configurationPickerInput, ComponentWrapper component, IWorkspaceHandle sourceWorkspace, IWorkspaceHandle additionalWorkspace, boolean filterSourceWorkspace, boolean allowFlowTargetsChoice, IPartResult<ComponentConfigurationPickerResult> callback) {
        Assert.isLegal((configurationPickerInput != null ? 1 : 0) != 0);
        Assert.isLegal((component != null ? 1 : 0) != 0);
        Assert.isLegal((callback != null ? 1 : 0) != 0);
        this.configurationPickerInput = configurationPickerInput;
        this.component = component;
        this.sourceWorkspace = sourceWorkspace;
        this.additionalWorkspace = additionalWorkspace;
        this.filterSourceWorkspace = filterSourceWorkspace;
        this.allowFlowTargetsChoice = allowFlowTargetsChoice;
        this.callback = callback;
        this.setForcePreviousAndNextButtons(true);
        this.setWindowTitle(Messages.ReplaceComponentWizard_title);
        this.setDefaultPageImageDescriptor(ImagePool.REPLACE_COMPONENT_WIZBAN);
    }

    public void setDescription(String description) {
        this.description = description;
        if (this.choicePage != null) {
            this.choicePage.setDescription(description);
        }
    }

    public void addPages() {
        ComponentConfigurationChoicePage.ComponentChoice defaultChoice = this.configurationPickerInput.isReplaceComponent() ? ComponentConfigurationChoicePage.ComponentChoice.BASELINE : ComponentConfigurationChoicePage.ComponentChoice.WORKSPACE;
        ITeamRepository repo = this.component.getRepository();
        this.choicePage = new ComponentConfigurationChoicePage(repo, this.sourceWorkspace, this.allowFlowTargetsChoice, defaultChoice);
        this.choicePage.setDescription(this.description);
        this.addPage((IWizardPage)this.choicePage);
        this.pickBaselineChain = new PickBaselineChain(this.configurationPickerInput, repo, this.sourceWorkspace, this.additionalWorkspace, (IComponentHandle)this.component.getComponent());
        this.pickBaselineChain.init(this.getPageChainSite());
        this.pickBaselineChain.setBaselinePageDescription(NLS.bind((String)Messages.ReplaceComponentWizard_selectBaselineDesc, (Object)this.component.getComponent().getName()));
        ITeamRepository repository = this.component.getRepository();
        this.fromWorkspacePage1 = new WorkspacePickerPage(this.configurationPickerInput, repository, this.filterSourceWorkspace ? this.sourceWorkspace : null, WORKSPACES_OR_STREAMS.STREAMS);
        this.fromWorkspacePage1.setDesiredComponent((ItemId<IComponent>)ItemId.forItem((IItem)this.component.getComponent()));
        this.addPage((IWizardPage)this.fromWorkspacePage1);
        this.fromSnapshotPage1 = new WorkspacePickerPage(new ConfigurationPickerInput(this.configurationPickerInput.getMode(), false), repository, null, WORKSPACES_OR_STREAMS.BOTH);
        this.fromSnapshotPage1.setDescription(Messages.ReplaceComponentWizard_0);
        this.addPage((IWizardPage)this.fromSnapshotPage1);
        this.fromSnapshotPage2 = new SnapshotPickerPage((IOperationRunner)this.backgroundRunner);
        this.fromSnapshotPage2.setDescription(Messages.ReplaceComponentWizard_1);
        this.addPage((IWizardPage)this.fromSnapshotPage2);
        this.foregroundRunner = new JobRunner(true);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.getShell(), "com.ibm.team.filesystem.ide.ui.wizard_selectecomponentfromanywhere");
    }

    public boolean performFinish() {
        switch (this.choicePage.getChoice()) {
            case BASELINE: {
                this.callback.setResult((Object)new ComponentConfigurationPickerResult((ItemNamespace)this.pickBaselineChain.getBaseline(), this.pickBaselineChain.traverseBaselineHierarchy()));
                return true;
            }
            case WORKSPACE: {
                AbstractPlaceWrapper place = this.fromWorkspacePage1.getWorkspace();
                this.callback.setResult((Object)new ComponentConfigurationPickerResult(WorkspaceNamespace.create((IWorkspaceHandle)place.getWorkspace(), (IComponentHandle)this.component.getComponent()), this.fromWorkspacePage1.replaceSubcomponents()));
                return true;
            }
            case FLOWS: {
                this.callback.setResult(null);
                return true;
            }
            case SNAPSHOT: {
                final SnapshotId snapshotId = this.fromSnapshotPage2.getSnapshotId();
                final ItemId componentId = ItemId.forItem((IItem)this.component.getComponent());
                final Display d = Display.getCurrent();
                this.foregroundRunner.enqueue(Messages.ReplaceComponentWizard_2, (Operation)new RepositoryOperation(){

                    public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, FileSystemException, OperationFailedException {
                        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                        ISnapshot snapshot = snapshotId.getSnapshot((IProgressMonitor)progress.newChild(20));
                        final ItemNamespace namespace = snapshot.getNamespaceFor(componentId, (IProgressMonitor)progress.newChild(80));
                        d.asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                ComponentConfigurationPickerWizard.this.callback.setResult((Object)new ComponentConfigurationPickerResult(namespace, false));
                            }
                        });
                    }
                });
                return true;
            }
        }
        return false;
    }

    public List<IWizardPage> getPageOrder() {
        ArrayList result = NewCollection.arrayList();
        result.add(this.choicePage);
        switch (this.choicePage.getChoice()) {
            case BASELINE: {
                result.addAll(this.pickBaselineChain.getPageOrder());
                break;
            }
            case WORKSPACE: {
                result.add(this.fromWorkspacePage1);
                break;
            }
            case FLOWS: {
                break;
            }
            case SNAPSHOT: {
                result.add(this.fromSnapshotPage1);
                this.fromSnapshotPage2.setWorkspace(this.fromSnapshotPage1.getWorkspace());
                result.add(this.fromSnapshotPage2);
            }
        }
        return result;
    }

    public static class ComponentConfigurationPickerResult {
        private final ItemNamespace fItemNamespace;
        private final boolean fisReplaceWithHierarchy;

        public ComponentConfigurationPickerResult(ItemNamespace itemNamespace, boolean isReplaceWithHierarchy) {
            this.fItemNamespace = itemNamespace;
            this.fisReplaceWithHierarchy = isReplaceWithHierarchy;
        }

        public ItemNamespace getItemNamespace() {
            return this.fItemNamespace;
        }

        public boolean isReplaceWithHierarchy() {
            return this.fisReplaceWithHierarchy;
        }
    }

    public static class ConfigurationPickerInput {
        private final ConfigurationPickerMode fMode;
        private final boolean fHierarchyAware;

        public ConfigurationPickerInput(ConfigurationPickerMode mode, boolean hierarchyAware) {
            this.fMode = mode;
            this.fHierarchyAware = hierarchyAware;
        }

        public ConfigurationPickerMode getMode() {
            return this.fMode;
        }

        public boolean isAddComponent() {
            return this.fMode.equals((Object)ConfigurationPickerMode.ADD_COMPONENT);
        }

        public boolean isReplaceComponent() {
            return this.fMode.equals((Object)ConfigurationPickerMode.REPLACE_COMPONENT);
        }

        public boolean isHierarchyAware() {
            return this.fHierarchyAware;
        }

        public static enum ConfigurationPickerMode {
            ADD_COMPONENT,
            REPLACE_COMPONENT,
            NON_SPECIFIC;

        }
    }
}

