/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.wizards.component;

import com.ibm.team.filesystem.ui.WorkspaceAndStreamSelectionDialog;
import com.ibm.team.filesystem.ui.queries.WorkspaceFlowTargetQuery;
import com.ibm.team.filesystem.ui.wrapper.AbstractPlaceWrapper;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.wizards.AdvanceableWizard;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.rcp.common.IChangeListener;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.internal.utils.ToolkitUtil;
import com.ibm.team.repository.rcp.ui.internal.viewers.ISetWithListeners;
import com.ibm.team.repository.rcp.ui.internal.viewers.LabelColumn;
import com.ibm.team.repository.rcp.ui.internal.viewers.SimpleTableViewer;
import com.ibm.team.repository.rcp.ui.internal.viewers.WritableValue;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.repository.rcp.ui.utils.WidgetFactoryContext;
import com.ibm.team.repository.rcp.ui.wizards.BaseWizardPage;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IFlowNodeHandle;
import com.ibm.team.scm.common.IFlowTable;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.LayoutConstants;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class ComponentConfigurationChoicePage
extends BaseWizardPage {
    private final ITeamRepository repo;
    private final IWorkspaceHandle sourceWorkspace;
    private final boolean allowFlowTargetChoice;
    private WritableValue<ComponentChoice> currentChoice = new WritableValue((Object)ComponentChoice.BASELINE);
    private WidgetFactoryContext context;
    private Button flowButton;
    private Table flowTable;
    private Composite flowTargetsGroup;
    private Button addButton;
    private Listener doubleClickListener = new Listener(){

        public void handleEvent(Event event) {
            switch (event.type) {
                case 8: {
                    AdvanceableWizard.advance(ComponentConfigurationChoicePage.this.getWizard());
                }
            }
        }
    };

    public ComponentConfigurationChoicePage(ITeamRepository repo, IWorkspaceHandle sourceWorkspace, boolean allowFlowTargetChoice, ComponentChoice initialChoice) {
        super("choice", Messages.ReplaceComponentChoicePage_title, null);
        this.repo = repo;
        this.sourceWorkspace = sourceWorkspace;
        this.allowFlowTargetChoice = allowFlowTargetChoice;
        this.currentChoice.setValue((Object)initialChoice);
        this.setDescription(Messages.ReplaceComponentChoicePage_description);
    }

    protected void createBody(Composite composite) {
        this.context = WidgetFactoryContext.forWizardPage((IWizardPage)this);
        this.createButton(composite, Messages.ReplaceComponentChoicePage_buttons_baseline, ComponentChoice.BASELINE);
        this.createButton(composite, Messages.ReplaceComponentChoicePage_buttons_workspace, ComponentChoice.WORKSPACE);
        this.createButton(composite, Messages.ReplaceComponentChoicePage_0, ComponentChoice.SNAPSHOT);
        if (this.allowFlowTargetChoice) {
            GridDataFactory dynamicData = GridDataFactory.fillDefaults().align(4, 0x1000000).indent(10, 0).grab(true, false).hint(300, -1);
            this.flowButton = (Button)this.createButton(composite, Messages.ReplaceComponentChoicePage_1, ComponentChoice.FLOWS);
            this.flowButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ComponentConfigurationChoicePage.this.updateEnablements(true);
                }
            });
            this.flowTargetsGroup = new Composite(composite, 0);
            Label label = new Label(this.flowTargetsGroup, 64);
            label.setText(Messages.ReplaceComponentChoicePage_flowTargetsListLabel);
            dynamicData.copy().span(2, 1).applyTo((Control)label);
            this.flowTable = new Table(this.flowTargetsGroup, 2816);
            this.flowTable.setHeaderVisible(false);
            GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)composite);
            final SimpleTableViewer viewer = new SimpleTableViewer(this.flowTable, null, null);
            new LabelColumn(viewer, Messages.ReplaceComponentChoicePage_workspacesColumnHeading, -1);
            this.addButton = new Button(this.flowTargetsGroup, 8);
            this.addButton.setText(Messages.ReplaceComponentChoicePage_addButton);
            this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ComponentConfigurationChoicePage.this.doAddFlowTarget(viewer);
                    super.widgetSelected(e);
                }
            });
            int minX = Math.max(this.addButton.computeSize((int)-1, (int)-1, (boolean)true).x, LayoutConstants.getMinButtonSize().x);
            GridDataFactory.fillDefaults().align(4, 128).hint(minX, -1).applyTo((Control)this.addButton);
            IOperationRunner runner = this.context.getBackgroundOperationRunner();
            viewer.setInput((ISetWithListeners)new WorkspaceFlowTargetQuery(this.repo, this.sourceWorkspace, runner));
            GridDataFactory.fillDefaults().grab(true, true).indent(10, 0).applyTo((Control)this.flowTable);
            GridLayoutFactory.fillDefaults().numColumns(2).generateLayout(this.flowTargetsGroup);
        }
        GridLayoutFactory.fillDefaults().generateLayout(composite);
        this.currentChoice.addListener(new IChangeListener(){

            public void changed(Object source, Object property) {
                ComponentConfigurationChoicePage.this.updateEnablements(true);
            }
        });
        this.updateEnablements(false);
    }

    private void doAddFlowTarget(SimpleTableViewer viewer) {
        TableItem[] items = viewer.getTable().getItems();
        ArrayList<IWorkspace> toIgnore = new ArrayList<IWorkspace>();
        int i = 0;
        while (i < items.length) {
            TableItem tableItem = items[i];
            if (tableItem.getData() instanceof AbstractPlaceWrapper) {
                AbstractPlaceWrapper wrapper = (AbstractPlaceWrapper)((Object)tableItem.getData());
                toIgnore.add(wrapper.getWorkspace());
            }
            ++i;
        }
        final AbstractPlaceWrapper pw = WorkspaceAndStreamSelectionDialog.getWorkspaceOrStream(this.getShell(), this.repo, toIgnore);
        if (pw != null) {
            try {
                this.getContainer().run(true, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.ReplaceComponentChoicePage_addingFlowTargetProgress, (int)100);
                        try {
                            try {
                                IWorkspaceConnection connection = SCMPlatform.getWorkspaceManager((ITeamRepository)ComponentConfigurationChoicePage.this.repo).getWorkspaceConnection(ComponentConfigurationChoicePage.this.sourceWorkspace, (IProgressMonitor)progress.newChild(30));
                                IFlowTable table = connection.getFlowTable().getWorkingCopy();
                                IWorkspaceConnection targetConnection = pw.getWorkspaceConnection((IProgressMonitor)progress.newChild(30));
                                UUID remoteRepoId = null;
                                String remoteRepoURI = null;
                                if (!connection.sameRepository((IConnection)targetConnection)) {
                                    ITeamRepository teamRepository = targetConnection.teamRepository();
                                    remoteRepoId = teamRepository.getId();
                                    remoteRepoURI = teamRepository.getRepositoryURI();
                                }
                                table.addDeliverFlow((IFlowNodeHandle)pw.getWorkspace(), remoteRepoId, remoteRepoURI, (Collection)Collections.EMPTY_LIST, null);
                                connection.setFlowTable(table, (IProgressMonitor)progress.newChild(40));
                            }
                            catch (TeamRepositoryException e) {
                                throw new InvocationTargetException(e);
                            }
                        }
                        finally {
                            progress.done();
                        }
                    }
                });
            }
            catch (InvocationTargetException e) {
                ErrorDialog.openError((Shell)this.getShell(), (String)Messages.ReplaceComponentChoicePage_flowTargetErrorDialogTitle, (String)Messages.ReplaceComponentChoicePage_flowTargetErrorDialogText, (IStatus)StatusUtil.newStatus((Object)((Object)this), (Throwable)e));
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private void updateEnablements(boolean updateButtons) {
        if (this.flowButton != null) {
            this.flowTargetsGroup.setEnabled(this.flowButton.getSelection());
            this.flowTable.setEnabled(this.flowButton.getSelection());
            this.addButton.setEnabled(this.flowButton.getSelection());
        }
        if (updateButtons) {
            this.getContainer().updateButtons();
        }
    }

    private Control createButton(Composite composite, String text, ComponentChoice choice) {
        Control button = ToolkitUtil.createRadio((Composite)composite, (WidgetFactoryContext)this.context, (String)text, (Object)((Object)choice), this.currentChoice);
        button.addListener(8, this.doubleClickListener);
        return button;
    }

    public ComponentChoice getChoice() {
        return (ComponentChoice)((Object)this.currentChoice.getValue());
    }

    public static enum ComponentChoice {
        BASELINE,
        WORKSPACE,
        SNAPSHOT,
        FLOWS;

    }
}

