/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.wizards.component;

import com.ibm.team.filesystem.client.internal.namespace.ItemLocator;
import com.ibm.team.filesystem.ui.BaselineSelectionPart;
import com.ibm.team.filesystem.ui.UiPlugin;
import com.ibm.team.filesystem.ui.wrapper.BaselineWrapper;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.wizards.AdvanceableWizard;
import com.ibm.team.internal.filesystem.ui.wizards.component.ComponentConfigurationPickerWizard;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.rcp.ui.internal.utils.IRunnableWithSelection;
import com.ibm.team.repository.rcp.ui.parts.WidgetToolkit;
import com.ibm.team.repository.rcp.ui.utils.WidgetFactoryContext;
import com.ibm.team.repository.rcp.ui.wizards.BaseWizardPage;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.internal.util.ItemId;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class BaselineSelectionPage
extends BaseWizardPage {
    public static final String PAGE_NAME = "fromBaseline2";
    private final ComponentConfigurationPickerWizard.ConfigurationPickerInput baselinePickerInput;
    private ITeamRepository repo;
    private IComponentHandle component;
    private IWorkspaceHandle sourceWorkspace;
    private IWorkspaceHandle additionalScope;
    private BaselineSelectionPart viewer;
    private Set<ISelectionChangedListener> fBaselineSelectionListeners = new HashSet<ISelectionChangedListener>();
    private BaselineWrapper selectedBaseline;
    private Button traverseBaselineHierarchyButton;
    private boolean traverseBaselineHierarchy = false;
    private Set<SelectionListener> fTraverseBaselineHierarchyButtonListeners = new HashSet<SelectionListener>();

    public BaselineSelectionPage() {
        this(new ComponentConfigurationPickerWizard.ConfigurationPickerInput(ComponentConfigurationPickerWizard.ConfigurationPickerInput.ConfigurationPickerMode.NON_SPECIFIC, false));
    }

    public BaselineSelectionPage(ComponentConfigurationPickerWizard.ConfigurationPickerInput baselinePickerInput) {
        super(PAGE_NAME, Messages.AddComponentFromBaselinePage2_title, null);
        this.setPageComplete(false);
        this.baselinePickerInput = baselinePickerInput;
    }

    public void setContext(ITeamRepository repo, IComponentHandle component, IWorkspaceHandle sourceWorkspace, IWorkspaceHandle additionalWorkspace) {
        if (BaselineSelectionPage.equals((IItemHandle)this.component, (IItemHandle)component) && BaselineSelectionPage.equals((IItemHandle)this.sourceWorkspace, (IItemHandle)sourceWorkspace) && BaselineSelectionPage.equals((IItemHandle)this.additionalScope, (IItemHandle)additionalWorkspace)) {
            return;
        }
        this.repo = repo;
        this.component = component;
        this.sourceWorkspace = sourceWorkspace;
        this.additionalScope = additionalWorkspace;
        this.updateViewerInput();
    }

    private static boolean equals(IItemHandle handle1, IItemHandle handle2) {
        if (handle1 == null) {
            return handle2 == null;
        }
        return handle1.sameItemId(handle2);
    }

    protected void createBody(Composite composite) {
        this.viewer = new BaselineSelectionPart(composite, WidgetFactoryContext.forWizardPage((IWizardPage)this));
        this.viewer.getSelectionProvider().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                BaselineSelectionPage.this.onBaselineSelectionChanged((IStructuredSelection)event.getSelection());
            }
        });
        for (ISelectionChangedListener listener : this.fBaselineSelectionListeners) {
            this.viewer.getSelectionProvider().addSelectionChangedListener(listener);
        }
        this.viewer.setDoubleClickHandler(new IRunnableWithSelection(){

            public void run(Object selectedObject, Shell targetShell) {
                if (BaselineSelectionPage.this.selectedBaseline != null) {
                    AdvanceableWizard.advance(BaselineSelectionPage.this.getWizard());
                }
            }
        });
        GridDataFactory.fillDefaults().grab(true, true).applyTo(this.viewer.getControl());
        if (this.baselinePickerInput.isHierarchyAware()) {
            if (this.baselinePickerInput.isAddComponent()) {
                this.traverseBaselineHierarchy = true;
            } else if (this.baselinePickerInput.isReplaceComponent()) {
                WidgetToolkit toolkit = WidgetToolkit.createSwtToolkit();
                this.traverseBaselineHierarchyButton = toolkit.createButton(composite, Messages.BaselineSelectionPage_Hierarchical_Baseline_Replace_Button, 32);
                final IPreferenceStore store = UiPlugin.getDefault().getPreferenceStore();
                this.traverseBaselineHierarchyButton.setSelection(store.getBoolean("com.ibm.team.filesystem.ide.ui.replace_with_hierarchy"));
                this.traverseBaselineHierarchy = this.traverseBaselineHierarchyButton.getSelection();
                this.traverseBaselineHierarchyButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        BaselineSelectionPage.this.traverseBaselineHierarchy = BaselineSelectionPage.this.traverseBaselineHierarchyButton.isEnabled() && BaselineSelectionPage.this.traverseBaselineHierarchyButton.getSelection();
                        store.setValue("com.ibm.team.filesystem.ide.ui.replace_with_hierarchy", BaselineSelectionPage.this.traverseBaselineHierarchyButton.getSelection());
                        BaselineSelectionPage.this.setPageComplete(BaselineSelectionPage.this.selectedBaseline != null);
                    }
                });
                for (SelectionListener listener : this.fTraverseBaselineHierarchyButtonListeners) {
                    this.traverseBaselineHierarchyButton.addSelectionListener(listener);
                }
                GridDataFactory.fillDefaults().align(1, 0x1000008).grab(true, false).applyTo((Control)this.traverseBaselineHierarchyButton);
            }
        }
        GridLayoutFactory.fillDefaults().generateLayout(composite);
        this.updateViewerInput();
        this.onBaselineSelectionChanged((IStructuredSelection)StructuredSelection.EMPTY);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible && this.viewer != null) {
            this.viewer.setFocusOnTable();
        }
    }

    private void updateViewerInput() {
        if (this.viewer == null) {
            return;
        }
        if (this.component == null) {
            this.viewer.setComponent(null);
        } else {
            this.viewer.setComponent((ItemLocator<IComponent>)ItemLocator.create((ITeamRepository)this.repo, (IAuditableHandle)this.component));
        }
        if (this.sourceWorkspace == null) {
            this.viewer.setWorkspace(null);
        } else {
            ItemId workspaceItemId = ItemId.create((IItemHandle)this.sourceWorkspace);
            this.viewer.setWorkspace((ItemId<IWorkspace>)workspaceItemId);
        }
    }

    private void onBaselineSelectionChanged(IStructuredSelection selection) {
        this.selectedBaseline = null;
        if (selection.size() == 1 && selection.getFirstElement() instanceof BaselineWrapper) {
            this.selectedBaseline = (BaselineWrapper)selection.getFirstElement();
        }
        this.setPageComplete(this.selectedBaseline != null);
    }

    public void addBaselineSelectionChangeListener(ISelectionChangedListener listener) {
        if (this.viewer == null) {
            this.fBaselineSelectionListeners.add(listener);
        } else if (!this.viewer.getControl().isDisposed()) {
            this.viewer.getSelectionProvider().addSelectionChangedListener(listener);
        }
    }

    public void addTraverseBaselineHierarchyButtonSelectionListener(SelectionListener listener) {
        if (this.traverseBaselineHierarchyButton == null) {
            this.fTraverseBaselineHierarchyButtonListeners.add(listener);
        } else if (!this.traverseBaselineHierarchyButton.isDisposed()) {
            this.traverseBaselineHierarchyButton.addSelectionListener(listener);
        }
    }

    public void setTraverseBaselineHierarchy(boolean traverseBaselineHierarchy) {
        if (this.traverseBaselineHierarchyButton != null && !this.traverseBaselineHierarchyButton.isDisposed()) {
            this.traverseBaselineHierarchyButton.setSelection(traverseBaselineHierarchy);
        }
        this.traverseBaselineHierarchy = traverseBaselineHierarchy;
    }

    public boolean traverseBaselineHierarchy() {
        return this.traverseBaselineHierarchy;
    }

    public BaselineWrapper getBaseline() {
        return this.selectedBaseline;
    }
}

