/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.wizards.component;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.ide.ui.internal.editors.baseline.BaselineHierarchyTreeComparator;
import com.ibm.team.filesystem.ide.ui.internal.editors.baseline.BaselineHierarchyTreeContentProvider;
import com.ibm.team.filesystem.ide.ui.internal.editors.baseline.BaselinePropertyTreeLabelProvider;
import com.ibm.team.filesystem.ui.UiPlugin;
import com.ibm.team.filesystem.ui.wrapper.BaselineWrapper;
import com.ibm.team.filesystem.ui.wrapper.IHierarchicalBaselineWrapper;
import com.ibm.team.filesystem.ui.wrapper.InaccessibleBaselineWrapper;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.wizards.component.ComponentConfigurationPickerWizard;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IFetchResult;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.repository.rcp.ui.parts.WidgetToolkit;
import com.ibm.team.repository.rcp.ui.utils.WidgetFactoryContext;
import com.ibm.team.repository.rcp.ui.wizards.BaseWizardPage;
import com.ibm.team.scm.client.IBaselineConnection;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IBaseline;
import com.ibm.team.scm.common.IBaselineHandle;
import com.ibm.team.scm.common.IBaselineHierarchyNode;
import com.ibm.team.scm.common.IBaselineHierarchyResult;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.PlatformUI;

public class BaselineHierarchyPage
extends BaseWizardPage {
    public static final String PAGE_NAME = "baselineHierarchyPage";
    private final ComponentConfigurationPickerWizard.ConfigurationPickerInput fBaselinePickerInput;
    private BaselineWrapper fBaseline;
    private WidgetFactoryContext fContext;
    private TreeViewer fTreeViewer;
    private Button fTraverseBaselineHierarchyButton;
    private boolean fTraverseBaselineHierarchy = false;
    private Set<SelectionListener> fTraverseBaselineHierarchyButtonListeners = new HashSet<SelectionListener>();

    public BaselineHierarchyPage(ComponentConfigurationPickerWizard.ConfigurationPickerInput baselinePickerInput, BaselineWrapper baseline) {
        super(PAGE_NAME, Messages.AddComponentFromBaselinePage2_title, null);
        this.fBaselinePickerInput = baselinePickerInput;
    }

    public void setBaseline(BaselineWrapper baselineToShow) {
        if (baselineToShow != null && baselineToShow.equals(this.fBaseline)) {
            return;
        }
        this.fBaseline = baselineToShow;
        this.updateViewerInput();
    }

    public BaselineWrapper getBaseline() {
        return this.fBaseline;
    }

    public boolean traverseBaselineHierarchy() {
        return this.fTraverseBaselineHierarchy;
    }

    public void addTraverseBaselineHierarchyButtonSelectionListener(SelectionListener listener) {
        if (this.fTraverseBaselineHierarchyButton == null) {
            this.fTraverseBaselineHierarchyButtonListeners.add(listener);
        } else if (!this.fTraverseBaselineHierarchyButton.isDisposed()) {
            this.fTraverseBaselineHierarchyButton.addSelectionListener(listener);
        }
    }

    public void setTraverseBaselineHierarchy(boolean traverseBaselineHierarchy) {
        if (this.fTraverseBaselineHierarchyButton != null && !this.fTraverseBaselineHierarchyButton.isDisposed()) {
            this.fTraverseBaselineHierarchyButton.setSelection(traverseBaselineHierarchy);
        }
        this.fTraverseBaselineHierarchy = traverseBaselineHierarchy;
    }

    protected void createBody(Composite composite) {
        this.fContext = WidgetFactoryContext.forWizardPage((IWizardPage)this);
        Label baselineHierarchyLabel = new Label(composite, 0);
        baselineHierarchyLabel.setText(Messages.BaselineHierarchyPage_BaselineHierarchyLabel);
        this.fTreeViewer = new TreeViewer(composite, 2818);
        Dialog.applyDialogFont((Control)baselineHierarchyLabel);
        GridDataFactory.fillDefaults().grab(true, true).applyTo(this.fTreeViewer.getControl());
        this.fTreeViewer.setContentProvider((IContentProvider)new BaselineHierarchyTreeContentProvider());
        ILabelDecorator decorator = PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator();
        DecoratingLabelProvider labelProvider = new DecoratingLabelProvider((ILabelProvider)new BaselinePropertyTreeLabelProvider(), decorator);
        this.fTreeViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.fTreeViewer.setComparator((ViewerComparator)new BaselineHierarchyTreeComparator());
        this.fTreeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (!event.getSelection().isEmpty()) {
                    BaselineHierarchyPage.this.fTreeViewer.setSelection((ISelection)StructuredSelection.EMPTY);
                }
            }
        });
        this.fTreeViewer.expandAll();
        if (this.fBaselinePickerInput.isAddComponent()) {
            this.fTraverseBaselineHierarchy = true;
        } else if (this.fBaselinePickerInput.isReplaceComponent()) {
            WidgetToolkit toolkit = WidgetToolkit.createSwtToolkit();
            this.fTraverseBaselineHierarchyButton = toolkit.createButton(composite, Messages.BaselineSelectionPage_Hierarchical_Baseline_Replace_Button, 32);
            final IPreferenceStore store = UiPlugin.getDefault().getPreferenceStore();
            this.fTraverseBaselineHierarchyButton.setSelection(store.getBoolean("com.ibm.team.filesystem.ide.ui.replace_with_hierarchy"));
            this.fTraverseBaselineHierarchy = this.fTraverseBaselineHierarchyButton.getSelection();
            this.fTraverseBaselineHierarchyButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    BaselineHierarchyPage.this.fTraverseBaselineHierarchy = BaselineHierarchyPage.this.fTraverseBaselineHierarchyButton.isEnabled() && BaselineHierarchyPage.this.fTraverseBaselineHierarchyButton.getSelection();
                    store.setValue("com.ibm.team.filesystem.ide.ui.replace_with_hierarchy", BaselineHierarchyPage.this.fTraverseBaselineHierarchyButton.getSelection());
                }
            });
            for (SelectionListener listener : this.fTraverseBaselineHierarchyButtonListeners) {
                this.fTraverseBaselineHierarchyButton.addSelectionListener(listener);
            }
            GridDataFactory.fillDefaults().align(1, 0x1000008).grab(true, false).applyTo((Control)this.fTraverseBaselineHierarchyButton);
        }
        GridLayoutFactory.fillDefaults().generateLayout(composite);
        this.updateViewerInput();
    }

    private void updateViewerInput() {
        if (this.fTreeViewer == null) {
            return;
        }
        if (!this.fTreeViewer.getControl().isDisposed()) {
            this.fTreeViewer.getControl().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    final BaselineWrapper baseline = BaselineHierarchyPage.this.fBaseline;
                    if (baseline != null) {
                        if (baseline.getHierarchyData() != null) {
                            BaselineHierarchyPage.this.fTreeViewer.setInput((Object)baseline.getHierarchyData());
                            BaselineHierarchyPage.this.fTreeViewer.expandAll();
                        } else {
                            final ITeamRepository repo = baseline.getRepository();
                            BaselineHierarchyPage.this.fContext.getBackgroundOperationRunner().enqueue(Messages.BaselinesInSyncReportQuery_queryName, (Operation)new RepositoryOperation(repo){

                                public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, FileSystemException, OperationFailedException {
                                    SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                                    IBaselineConnection baselineConnection = SCMPlatform.getWorkspaceManager((ITeamRepository)repo).getBaselineConnection(baseline.getBaseline(), (IProgressMonitor)progress.newChild(15));
                                    IBaselineHierarchyResult baselineHierarchy = baselineConnection.getBaselineHierarchy((IProgressMonitor)progress.newChild(15));
                                    Collection baselineHandles = baselineHierarchy.getFlattenedElementsMap().values();
                                    Map baselines = BaselineHierarchyPage.fetchCompleteItems(repo, baselineHandles, 0, (IProgressMonitor)progress.newChild(35));
                                    ArrayList<IComponentHandle> componentHandles = new ArrayList<IComponentHandle>(baselines.size());
                                    for (IBaseline baseline2 : baselines.values()) {
                                        componentHandles.add(baseline2.getComponent());
                                    }
                                    Map components = BaselineHierarchyPage.fetchCompleteItems(repo, componentHandles, 0, (IProgressMonitor)progress.newChild(35));
                                    BaselineWrapper newBaselineWrapper = (BaselineWrapper)BaselineHierarchyPage.this.createHierarchy(repo, baselineHierarchy.getRoot(), baselines, components, null);
                                    BaselineHierarchyPage.this.setBaseline(newBaselineWrapper);
                                }
                            });
                        }
                    } else {
                        BaselineHierarchyPage.this.fTreeViewer.setInput(null);
                    }
                }
            });
        }
    }

    private IHierarchicalBaselineWrapper createHierarchy(ITeamRepository repo, IBaselineHierarchyNode baselineHierarchyNode, Map<UUID, IBaseline> baselines, Map<UUID, IComponent> components, IHierarchicalBaselineWrapper parent) {
        IBaselineHandle baselineHandle = baselineHierarchyNode.getBaselineHandle();
        IBaseline baseline = baselines.get(baselineHandle.getItemId());
        IComponent component = components.get(baselineHierarchyNode.getComponentHandle().getItemId());
        IHierarchicalBaselineWrapper baselineWrapper = null;
        baselineWrapper = baseline == null || component == null ? new InaccessibleBaselineWrapper(repo, baselineHandle) : new BaselineWrapper(repo, baseline, component);
        baselineWrapper.createHierarchyData(baselineHierarchyNode, parent);
        ArrayList<IHierarchicalBaselineWrapper> children = new ArrayList<IHierarchicalBaselineWrapper>();
        for (IBaselineHierarchyNode childNode : baselineHierarchyNode.getChildren()) {
            IHierarchicalBaselineWrapper childWrapper = this.createHierarchy(repo, childNode, baselines, components, baselineWrapper);
            children.add(childWrapper);
        }
        baselineWrapper.getHierarchyData().setChildren(children);
        return baselineWrapper;
    }

    private static <H extends IItemHandle, I extends H> Map<UUID, I> fetchCompleteItems(ITeamRepository repo, Collection items, int flags, IProgressMonitor monitor) throws TeamRepositoryException {
        IFetchResult fetchResult = repo.itemManager().fetchCompleteItemsPermissionAware(new ArrayList(items), flags, monitor);
        return BaselineHierarchyPage.getUuidToItemMap(fetchResult.getRetrievedItems());
    }

    private static <I extends IItemHandle> Map<UUID, I> getUuidToItemMap(Collection<I> items) {
        HashMap<UUID, IItemHandle> map = new HashMap<UUID, IItemHandle>(items.size());
        for (IItemHandle item : items) {
            map.put(item.getItemId(), item);
        }
        return map;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible && this.fTreeViewer != null && !this.fTreeViewer.getControl().isDisposed()) {
            this.fTreeViewer.getControl().setFocus();
        }
    }
}

