/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.wizards.component;

import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.internal.namespace.BaselineNamespace;
import com.ibm.team.filesystem.client.internal.namespace.ItemNamespace;
import com.ibm.team.filesystem.ui.WORKSPACES_OR_STREAMS;
import com.ibm.team.filesystem.ui.wrapper.BaselineWrapper;
import com.ibm.team.filesystem.ui.wrapper.SnapshotWrapper;
import com.ibm.team.filesystem.ui.wrapper.WorkspaceComponentWrapper;
import com.ibm.team.internal.filesystem.ui.ImagePool;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.adapters.WrapperUtil;
import com.ibm.team.internal.filesystem.ui.wizards.component.AddComponentChoicePage;
import com.ibm.team.internal.filesystem.ui.wizards.component.ComponentConfigurationPickerWizard;
import com.ibm.team.internal.filesystem.ui.wizards.component.ComponentPickerPage;
import com.ibm.team.internal.filesystem.ui.wizards.component.PickBaselineChain;
import com.ibm.team.internal.filesystem.ui.wizards.component.SnapshotPickerPage;
import com.ibm.team.internal.filesystem.ui.wizards.component.WorkspacePickerPage;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.ui.internal.utils.SWTUtil;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.JobRunner;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.repository.rcp.ui.wizards.ChainedWizard;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.internal.util.NewCollection;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public class AddComponentWizard
extends ChainedWizard {
    private ITeamRepository repository;
    private ICallback callback;
    private final JobRunner jobRunner = new JobRunner(false);
    private AddComponentChoicePage choicePage;
    private PickBaselineChain fromBaselineChain;
    private WorkspacePickerPage fromWorkspacePage1;
    private ComponentPickerPage fromWorkspacePage2;
    private WorkspacePickerPage fromSnapshotPage1;
    private SnapshotPickerPage fromSnapshotPage2;
    private IWorkspaceHandle workspaceToIgnore;

    public AddComponentWizard(ITeamRepository repository, IWorkspaceHandle workspaceToIgnore, ICallback callback) {
        Assert.isLegal((repository != null ? 1 : 0) != 0);
        Assert.isLegal((callback != null ? 1 : 0) != 0);
        this.repository = repository;
        this.callback = callback;
        this.workspaceToIgnore = workspaceToIgnore;
        this.setForcePreviousAndNextButtons(true);
        this.setWindowTitle(Messages.AddComponentWizard_title);
        this.setDefaultPageImageDescriptor(ImagePool.ADD_COMPONENT_WIZBAN);
    }

    public void addPages() {
        boolean hierarchyAware = FileSystemCore.getComponentHierarchyManager().isHierarchicalComponentsEnabled(this.repository);
        this.choicePage = new AddComponentChoicePage();
        this.addPage((IWizardPage)this.choicePage);
        this.fromBaselineChain = new PickBaselineChain(new ComponentConfigurationPickerWizard.ConfigurationPickerInput(ComponentConfigurationPickerWizard.ConfigurationPickerInput.ConfigurationPickerMode.ADD_COMPONENT, hierarchyAware), this.repository, null, null, null);
        this.fromBaselineChain.init(this.getPageChainSite());
        this.fromWorkspacePage1 = new WorkspacePickerPage(new ComponentConfigurationPickerWizard.ConfigurationPickerInput(ComponentConfigurationPickerWizard.ConfigurationPickerInput.ConfigurationPickerMode.ADD_COMPONENT, hierarchyAware), this.repository, this.workspaceToIgnore, WORKSPACES_OR_STREAMS.STREAMS);
        this.fromWorkspacePage1.setDescription(Messages.AddComponentWizard_selectWorkspaceForComponents);
        this.addPage((IWizardPage)this.fromWorkspacePage1);
        this.fromWorkspacePage2 = new ComponentPickerPage(new ComponentConfigurationPickerWizard.ConfigurationPickerInput(ComponentConfigurationPickerWizard.ConfigurationPickerInput.ConfigurationPickerMode.ADD_COMPONENT, hierarchyAware), (IOperationRunner)this.jobRunner, null, true);
        this.addPage((IWizardPage)this.fromWorkspacePage2);
        this.fromSnapshotPage1 = new WorkspacePickerPage(new ComponentConfigurationPickerWizard.ConfigurationPickerInput(ComponentConfigurationPickerWizard.ConfigurationPickerInput.ConfigurationPickerMode.ADD_COMPONENT, false), this.repository, null, WORKSPACES_OR_STREAMS.BOTH);
        this.fromSnapshotPage1.setDescription(Messages.AddComponentWizard_selectWorkspaceForSnapshot);
        this.addPage((IWizardPage)this.fromSnapshotPage1);
        this.fromSnapshotPage2 = new SnapshotPickerPage((IOperationRunner)this.jobRunner);
        this.fromSnapshotPage2.setDescription(Messages.AddComponentWizard_selectSnapshot);
        this.addPage((IWizardPage)this.fromSnapshotPage2);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.getShell(), "com.ibm.team.filesystem.ide.ui.wizard_addcomponent");
    }

    public List<IWizardPage> getPageOrder() {
        ArrayList result = NewCollection.arrayList();
        result.add(this.choicePage);
        switch (this.choicePage.getChoice()) {
            case BASELINE: {
                result.addAll(this.fromBaselineChain.getPageOrder());
                break;
            }
            case WORKSPACE: {
                result.add(this.fromWorkspacePage1);
                this.fromWorkspacePage2.setWorkspace(this.fromWorkspacePage1.getWorkspace());
                result.add(this.fromWorkspacePage2);
                break;
            }
            case SNAPSHOT: {
                result.add(this.fromSnapshotPage1);
                this.fromSnapshotPage2.setWorkspace(this.fromSnapshotPage1.getWorkspace());
                result.add(this.fromSnapshotPage2);
            }
        }
        return result;
    }

    public boolean performFinish() {
        final Display display = Display.getCurrent();
        switch (this.choicePage.getChoice()) {
            case BASELINE: {
                final BaselineNamespace baseline = this.fromBaselineChain.getBaseline();
                JobRunner userRunner = new JobRunner(true);
                userRunner.enqueue(Messages.AddComponentWizard_0, (Operation)new RepositoryOperation(){

                    public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, FileSystemException, OperationFailedException {
                        Object wrapper = WrapperUtil.createWrapperFromNamespace((ItemNamespace)baseline, monitor);
                        if (wrapper instanceof BaselineWrapper) {
                            final BaselineWrapper bw = (BaselineWrapper)wrapper;
                            SWTUtil.greedyExec((Display)display, (Runnable)new Runnable(){

                                @Override
                                public void run() {
                                    AddComponentWizard.this.callback.addComponentFromBaseline(bw, AddComponentWizard.this.fromBaselineChain.traverseBaselineHierarchy());
                                }
                            });
                        }
                    }
                });
                return true;
            }
            case WORKSPACE: {
                List<WorkspaceComponentWrapper> components = this.fromWorkspacePage2.getComponents();
                this.callback.addComponentsFromWorkspace(components, this.fromWorkspacePage2.traverseComponentHierarchy());
                return true;
            }
            case SNAPSHOT: {
                SnapshotWrapper snapshot = this.fromSnapshotPage2.getSnapshot();
                this.callback.addComponentsFromSnapshot(snapshot);
                return true;
            }
        }
        return false;
    }

    public static interface ICallback {
        public void addComponentFromBaseline(BaselineWrapper var1, boolean var2);

        public void addComponentsFromSnapshot(SnapshotWrapper var1);

        public void addComponentsFromWorkspace(List<WorkspaceComponentWrapper> var1, boolean var2);
    }
}

