/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.wizards.component;

import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.wizards.AdvanceableWizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class AddComponentChoicePage
extends WizardPage {
    private ComponentChoice componentChoice = ComponentChoice.BASELINE;
    private Listener listener = new Listener(){

        public void handleEvent(Event event) {
            switch (event.type) {
                case 13: {
                    Button button = (Button)event.widget;
                    if (!button.getSelection()) break;
                    AddComponentChoicePage.this.componentChoice = (ComponentChoice)((Object)button.getData());
                    break;
                }
                case 8: {
                    AdvanceableWizard.advance(AddComponentChoicePage.this.getWizard());
                }
            }
        }
    };

    public AddComponentChoicePage() {
        super("choice", Messages.AddComponentChoicePage_title, null);
        this.setDescription(Messages.AddComponentChoicePage_description);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        this.createButton(composite, Messages.AddComponentChoicePage_baselineButtonText, ComponentChoice.BASELINE);
        this.createButton(composite, Messages.AddComponentChoicePage_workspaceButtonText, ComponentChoice.WORKSPACE);
        this.createButton(composite, Messages.AddComponentChoicePage_snapshotButtonText, ComponentChoice.SNAPSHOT);
        this.setControl((Control)composite);
    }

    private void createButton(Composite composite, String text, ComponentChoice choice) {
        Button button = new Button(composite, 16);
        button.setText(text);
        button.setData((Object)choice);
        button.setSelection(choice == this.componentChoice);
        button.addListener(13, this.listener);
        button.addListener(8, this.listener);
    }

    public ComponentChoice getChoice() {
        return this.componentChoice;
    }

    public static enum ComponentChoice {
        BASELINE,
        WORKSPACE,
        SNAPSHOT;

    }
}

