/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.wizards.applypatch;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.common.changemodel.VersionablePath;
import com.ibm.team.filesystem.rcp.core.internal.patches.ParsedPatch;
import com.ibm.team.filesystem.ui.UiPlugin;
import com.ibm.team.internal.filesystem.ui.ImagePool;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.wizards.applypatch.PatchViewerNode;
import com.ibm.team.jface.labelProviders.TypeLabelProvider;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.ui.internal.viewers.ISetWithListeners;
import com.ibm.team.repository.rcp.ui.internal.viewers.ITreeProvider;
import com.ibm.team.repository.rcp.ui.internal.viewers.SimpleTreeViewer;
import com.ibm.team.repository.rcp.ui.internal.viewers.WritableSetWithListeners;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.repository.rcp.ui.utils.WidgetFactoryContext;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.internal.util.NewCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IViewerLabelProvider;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Tree;

public class PatchViewer {
    private SimpleTreeViewer treeViewer;
    private IOperationRunner background;

    public PatchViewer(Composite parent, WidgetFactoryContext context) {
        this.background = context.getBackgroundOperationRunner();
        ITreeProvider treeProvider = new ITreeProvider(){

            public ISetWithListeners getChildren(Object element) {
                if (element instanceof List) {
                    WritableSetWithListeners children = new WritableSetWithListeners();
                    children.addAll((Collection)((List)element));
                    return children;
                }
                if (element instanceof PatchViewerNode) {
                    PatchViewerNode pf = (PatchViewerNode)element;
                    WritableSetWithListeners children = new WritableSetWithListeners();
                    children.addAll(pf.getChildren());
                    return children;
                }
                return null;
            }
        };
        Tree tree = context.getToolkit().createTree(parent, 2056);
        this.treeViewer = new SimpleTreeViewer(tree, treeProvider);
        this.treeViewer.setLabelProvider((IViewerLabelProvider)new TypeLabelProvider(){

            public void updateLabel(ViewerLabel label, Object element) {
                if (element instanceof PatchViewerNode) {
                    PatchViewerNode node = (PatchViewerNode)element;
                    ImageDescriptor imageDescriptor = null;
                    String text = null;
                    ResourceType resourceType = node.getResourceType();
                    if (resourceType != null) {
                        switch (resourceType) {
                            case FOLDER: {
                                text = node.getPath().makeRelative().toOSString();
                                imageDescriptor = UiPlugin.getFileSystemImageDescriptor(null);
                                break;
                            }
                            case SYMBOLIC_LINK: {
                                text = node.getPath().lastSegment();
                                imageDescriptor = ImagePool.SYMBOLIC_LINK;
                                break;
                            }
                            default: {
                                text = node.getPath().lastSegment();
                                imageDescriptor = UiPlugin.getFileSystemImageDescriptor(text);
                                break;
                            }
                        }
                    } else {
                        text = node.getPath().lastSegment();
                        imageDescriptor = UiPlugin.getFileSystemImageDescriptor(text);
                    }
                    label.setImage((Image)this.getResources().get((DeviceResourceDescriptor)imageDescriptor));
                    label.setText(text);
                }
            }
        });
    }

    public void setInput(final ParsedPatch patch) {
        final Display display = Display.getCurrent();
        this.background.enqueue(Messages.PatchViewer_translatingPathsJobName, (Operation)new RepositoryOperation(){

            public void repositoryRun(IProgressMonitor progress, IStatusCollector problems) throws TeamRepositoryException, FileSystemException, OperationFailedException {
                SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
                HashMap folders = NewCollection.hashMap();
                Set paths = patch.getAffectedVersionablePaths((IPath)new Path(""), (IProgressMonitor)monitor.newChild(45));
                Map affectedPaths = ParsedPatch.getAffectedShareables((Set)paths, (IProgressMonitor)monitor.newChild(45));
                monitor.setWorkRemaining(affectedPaths.size() * 2);
                for (Map.Entry entry : affectedPaths.entrySet()) {
                    boolean isFolder;
                    IPath directory;
                    PatchViewerNode theFolder;
                    IItemHandle itemHandle;
                    IVersionableHandle versionableHandle;
                    IShareable shareable = (IShareable)entry.getValue();
                    if (shareable == null) continue;
                    IPath resPath = this.getFullPath(shareable);
                    ResourceType resourceType = shareable.getResourceType((IProgressMonitor)monitor.newChild(1));
                    SubMonitor submonitor = monitor.newChild(1);
                    if (resourceType == null && (versionableHandle = shareable.getVersionable((IProgressMonitor)submonitor)) != null) {
                        resourceType = ResourceType.getResourceType((IVersionableHandle)versionableHandle);
                    }
                    if (resourceType == null && (itemHandle = ((VersionablePath)entry.getKey()).getItemId().toHandle()) instanceof IVersionableHandle) {
                        IVersionableHandle versionableHandle2 = (IVersionableHandle)itemHandle;
                        resourceType = ResourceType.getResourceType((IVersionableHandle)versionableHandle2);
                    }
                    if ((theFolder = (PatchViewerNode)folders.get(directory = (isFolder = resourceType == ResourceType.FOLDER) ? resPath : resPath.removeLastSegments(1))) == null) {
                        theFolder = new PatchViewerNode(directory, ResourceType.FOLDER);
                        folders.put(directory, theFolder);
                    }
                    if (isFolder) continue;
                    theFolder.addChild(new PatchViewerNode(resPath, resourceType));
                }
                final ArrayList newInput = NewCollection.arrayList();
                newInput.addAll(folders.values());
                display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        PatchViewer.this.treeViewer.setInput((Object)newInput);
                        PatchViewer.this.treeViewer.expandAll();
                    }
                });
            }

            private IPath getFullPath(IShareable shareable) {
                Object adapter = shareable.getAdapter(IResource.class);
                if (adapter instanceof IResource) {
                    return ((IResource)adapter).getFullPath();
                }
                return shareable.getLocalPath().toPath();
            }
        });
    }

    public Control getControl() {
        return this.treeViewer.getControl();
    }

    public void clearInput() {
        this.treeViewer.setInput(null);
    }
}

