/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.wizards.applypatch;

import com.ibm.team.filesystem.ide.ui.internal.dialogs.ClipboardOrFilePart;
import com.ibm.team.filesystem.ide.ui.internal.dialogs.EncodingPart;
import com.ibm.team.filesystem.rcp.core.internal.patches.ParsedPatch;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.patches.CreatePatchPart;
import com.ibm.team.internal.filesystem.ui.wizards.applypatch.PatchViewer;
import com.ibm.team.internal.repository.rcp.streams.ByteArrayInputStreamProvider;
import com.ibm.team.internal.repository.rcp.streams.EmptyInputStreamProvider;
import com.ibm.team.repository.common.utils.IInputStreamProvider;
import com.ibm.team.repository.rcp.core.utils.FileInputStreamProvider;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.internal.databinding.DatabindingUtil;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.parts.WidgetToolkit;
import com.ibm.team.repository.rcp.ui.utils.WidgetFactoryContext;
import com.ibm.team.repository.rcp.ui.wizards.BaseWizardPage;
import java.io.File;
import java.text.DateFormat;
import java.util.Date;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.osgi.service.prefs.Preferences;

public class JazzInputPatchPage
extends BaseWizardPage {
    public static final Object PATCH_TYPE_NONE = new String("eclipse");
    private IInputStreamProvider patch = EmptyInputStreamProvider.getDefault();
    private Object patchType = PATCH_TYPE_NONE;
    private Operation parsePatchOp;
    private PatchViewer patchViewer;
    private String patchDescription = "";
    private ClipboardOrFilePart clipboardOrFile;
    private EncodingPart encodingPart;
    private String encoding;

    protected JazzInputPatchPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
    }

    protected void createBody(Composite parent) {
        this.setDescription(Messages.JazzInputPatchPage_pageDescription);
        WidgetFactoryContext context = WidgetFactoryContext.forWizardPage((IWizardPage)this);
        WidgetToolkit toolkit = context.getToolkit();
        Preferences prefs = this.getInstancePrefs();
        ClipboardOrFilePart.ClipboardOrFilePartInput clipboadOrFilePartInput = new ClipboardOrFilePart.ClipboardOrFilePartInput(Messages.JazzInputPatchPage_locationGroup, Messages.JazzInputPatchPage_fromFileRadio, Messages.JazzInputPatchPage_BROWSE, prefs, false, CreatePatchPart.FILTER_EXTENSIONS, CreatePatchPart.FILTER_NAMES);
        this.clipboardOrFile = new ClipboardOrFilePart(clipboadOrFilePartInput);
        this.clipboardOrFile.create(parent, context);
        this.encodingPart = new EncodingPart(new EncodingPart.EncodingPartInput(Messages.CreatePatchPart_Encoding, Messages.CreatePatchPart_EncodingLabel, prefs));
        this.encodingPart.create(parent, context);
        this.clipboardOrFile.getBrowseableFilenameField().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JazzInputPatchPage.this.updateNextButton();
            }
        });
        this.clipboardOrFile.getRadioSelection().addChangeListener(new IChangeListener(){

            public void handleChange(ChangeEvent event) {
                JazzInputPatchPage.this.updateNextButton();
            }
        });
        this.encodingPart.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JazzInputPatchPage.this.updateNextButton();
            }
        });
        toolkit.createLabel(parent, Messages.JazzInputPatchPage_affectedFilesLabel, 64);
        this.patchViewer = new PatchViewer(parent, context);
        Dialog.applyDialogFont((Control)parent);
        GridLayoutFactory.fillDefaults().generateLayout(parent);
        this.updateNextButton();
    }

    private Preferences getInstancePrefs() {
        IEclipsePreferences prefs = new InstanceScope().getNode("com.ibm.team.filesystem.ide.ui");
        Preferences edilogPrefs = prefs.node(((Object)((Object)this)).getClass().getName());
        return edilogPrefs;
    }

    public IInputStreamProvider getPatch() {
        return this.patch;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public boolean hasPatch() {
        return this.patchType != PATCH_TYPE_NONE;
    }

    public Object getPatchType() {
        return this.patchType;
    }

    private void updateNextButton() {
        ByteArrayInputStreamProvider patchStream = null;
        String errorMessage = Messages.JazzInputPatchPage_fileNotFoundErrorMessage;
        ClipboardOrFilePart.ClipboardOrFileResult result = this.clipboardOrFile.getResult();
        String newDescription = "";
        boolean checkEncoding = false;
        if (result.isClipboard()) {
            Clipboard clippy = new Clipboard(Display.getCurrent());
            Object contents = null;
            try {
                contents = clippy.getContents((Transfer)TextTransfer.getInstance());
            }
            finally {
                clippy.dispose();
            }
            if (contents instanceof String) {
                String stringContents = (String)contents;
                patchStream = new ByteArrayInputStreamProvider(stringContents.getBytes());
            } else {
                errorMessage = Messages.JazzInputPatchPage_invalidPatchOnClipboardError;
            }
            Date date = new Date(System.currentTimeMillis());
            newDescription = NLS.bind((String)Messages.JazzInputPatchPage_defaultPatchDescriptionByDate, (Object)DateFormat.getDateTimeInstance(0, 3).format(date));
        } else {
            String filename = result.getFilename();
            if (filename.length() == 0) {
                this.setMessage(null);
                this.setPageComplete(false);
                this.patchViewer.clearInput();
                return;
            }
            IStatus status = (IStatus)this.clipboardOrFile.getValidationStatus().getValue();
            if (!status.isOK()) {
                DatabindingUtil.setMessage((DialogPage)this, (IStatus)status, (boolean)false);
                if (status.getSeverity() >= 4) {
                    this.setPageComplete(false);
                    return;
                }
            }
            if (!(status = (IStatus)this.encodingPart.getValidationStatus().getValue()).isOK()) {
                DatabindingUtil.setMessage((DialogPage)this, (IStatus)status, (boolean)false);
                if (status.getSeverity() >= 4) {
                    this.setPageComplete(false);
                    return;
                }
            }
            checkEncoding = true;
            File theFile = new File(filename);
            if (theFile.exists() && theFile.isFile() && theFile.length() > 0L) {
                patchStream = new FileInputStreamProvider(theFile);
            }
            Path path = new Path(filename);
            newDescription = path.lastSegment();
        }
        if (patchStream == null) {
            this.setMessage(errorMessage, 3);
            this.setPageComplete(false);
            this.patchViewer.clearInput();
            return;
        }
        this.setMessage(Messages.JazzInputPatchPage_readingPatchProgressMessage);
        this.setPageComplete(false);
        this.patchDescription = newDescription;
        ByteArrayInputStreamProvider finalInputStream = patchStream;
        if (this.parsePatchOp != null) {
            this.getUserOperationRunner().dequeue(this.parsePatchOp);
        }
        Display display = Display.getCurrent();
        this.encoding = checkEncoding ? this.encodingPart.getResult().getEncoding() : null;
        this.parsePatchOp = new Operation((IInputStreamProvider)finalInputStream, display){
            private final /* synthetic */ IInputStreamProvider val$finalInputStream;
            private final /* synthetic */ Display val$display;
            {
                this.val$finalInputStream = iInputStreamProvider;
                this.val$display = display;
            }

            public void run(IProgressMonitor monitor, IStatusCollector problems) throws OperationFailedException {
                try {
                    final ParsedPatch patch = ParsedPatch.parse((IInputStreamProvider)this.val$finalInputStream, (String)JazzInputPatchPage.this.encoding, (int)0, (IPath)new Path(""), (IProgressMonitor)monitor);
                    final Object patchType = patch.getPatchType();
                    this.val$display.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (!JazzInputPatchPage.this.patchViewer.getControl().isDisposed()) {
                                JazzInputPatchPage.this.patchViewer.setInput(patch);
                                JazzInputPatchPage.this.patchType = patchType;
                                JazzInputPatchPage.this.patch = val$finalInputStream;
                                JazzInputPatchPage.this.setMessage(null);
                                JazzInputPatchPage.this.setPageComplete(true);
                            }
                        }
                    });
                }
                catch (Exception e) {
                    StatusUtil.log((Object)this, (Throwable)e);
                    this.val$display.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            JazzInputPatchPage.this.patchViewer.clearInput();
                            if (!JazzInputPatchPage.this.patchViewer.getControl().isDisposed()) {
                                JazzInputPatchPage.this.setMessage(Messages.JazzInputPatchPage_unableToParsePatchErrorMessage, 3);
                                JazzInputPatchPage.this.setPageComplete(false);
                            }
                        }
                    });
                }
            }
        };
        this.getUserOperationRunner().enqueue(Messages.JazzInputPatchPage_parsingPatchJobName, this.parsePatchOp);
    }

    public void dispose() {
        this.clipboardOrFile.savePreferences();
        super.dispose();
    }

    public String getPatchDescription() {
        return this.patchDescription;
    }
}

