/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.wizards.applypatch;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.ui.changes.actions.StandardApplyPatchDilemmaHandler;
import com.ibm.team.internal.filesystem.ui.ImagePool;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.patches.ApplyPatchUtil;
import com.ibm.team.internal.filesystem.ui.wizards.applypatch.JazzInputPatchPage;
import com.ibm.team.internal.filesystem.ui.wizards.applypatch.JazzPatchTargetPage;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.repository.rcp.ui.utils.UIContext;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.ui.IConfigurationWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;

public class ApplyPatchWizard
extends Wizard
implements IConfigurationWizard {
    private JazzInputPatchPage inputPatchPage;
    private JazzPatchTargetPage patchTargetPage;

    public void addPages() {
        this.setWindowTitle(Messages.ApplyPatchWizard_windowTitle);
        this.inputPatchPage = new JazzInputPatchPage("InputPatchPage", Messages.ApplyPatchWizard_selectPatchPageTitle, null);
        this.addPage((IWizardPage)this.inputPatchPage);
        this.patchTargetPage = new JazzPatchTargetPage("PatchTargetPage", Messages.ApplyPatchWizard_selectPatchTargetPageTitle, null);
        this.addPage((IWizardPage)this.patchTargetPage);
        this.setDefaultPageImageDescriptor(ImagePool.APPLY_PATCH_WIZBAN_IMAGE);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.getShell(), "com.ibm.team.filesystem.ide.ui.wizard_applypatch");
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (page == this.inputPatchPage) {
            if (this.inputPatchPage.getPatchType() == ApplyPatchUtil.PATCH_TYPE_NORMAL) {
                return this.patchTargetPage;
            }
            return null;
        }
        return super.getNextPage(page);
    }

    public boolean performFinish() {
        final UIContext context = UIContext.createShellContext((Shell)((Shell)this.getShell().getParent()));
        IContainer container = this.getSelectedContainer();
        final IPath targetPath = container.getFullPath();
        context.getUserOperationRunner().enqueue(Messages.ApplyPatchWizard_applyPatchJobName, (Operation)new RepositoryOperation(){

            public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, FileSystemException, OperationFailedException {
                ApplyPatchUtil.applyPatch(new StandardApplyPatchDilemmaHandler(context), ApplyPatchWizard.this.inputPatchPage.getPatch(), ApplyPatchWizard.this.inputPatchPage.getEncoding(), targetPath, ApplyPatchWizard.this.inputPatchPage.getPatchDescription(), monitor);
            }
        });
        return true;
    }

    private IContainer getSelectedContainer() {
        IContainer target = null;
        if (this.inputPatchPage.getPatchType() == ApplyPatchUtil.PATCH_TYPE_NORMAL) {
            target = this.patchTargetPage.getSelectedContainer();
        }
        if (target == null) {
            target = ResourcesPlugin.getWorkspace().getRoot();
        }
        return target;
    }

    public void init(IWorkbench workbench, IProject project) {
    }

    public boolean canFinish() {
        return super.canFinish();
    }
}

