/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.wizards;

import com.ibm.team.filesystem.client.IRelativeLocation;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.internal.utils.RepositoryUtils;
import com.ibm.team.filesystem.rcp.core.internal.FileSystemResourcesPlugin;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IComponentSyncModel;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IWorkspaceSyncContext;
import com.ibm.team.filesystem.ui.views.ContributorPlacesTreeProvider;
import com.ibm.team.filesystem.ui.views.TeamPlaceViewSorter;
import com.ibm.team.filesystem.ui.wrapper.AbstractPlaceWrapper;
import com.ibm.team.filesystem.ui.wrapper.ContributorPlaceComponentWrapper;
import com.ibm.team.filesystem.ui.wrapper.ContributorPlaceWrapper;
import com.ibm.team.filesystem.ui.wrapper.FolderItemWrapper;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.picker.RepositoryCombo;
import com.ibm.team.internal.filesystem.ui.wizards.AdvanceableWizard;
import com.ibm.team.internal.filesystem.ui.wizards.sharing.ITeamRepositoryFactory;
import com.ibm.team.internal.filesystem.ui.wizards.sharing.TeamAreaSelection;
import com.ibm.team.internal.filesystem.ui.wizards.sharing.TeamAreaSelectionPart;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.rcp.common.IChangeListener;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.internal.databinding.CombinedStatus;
import com.ibm.team.repository.rcp.ui.internal.databinding.DatabindingUtil;
import com.ibm.team.repository.rcp.ui.internal.utils.ToolkitUtil;
import com.ibm.team.repository.rcp.ui.internal.viewers.ITreePathRunnable;
import com.ibm.team.repository.rcp.ui.internal.viewers.WritableValue;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.repository.rcp.ui.operations.JobRunner;
import com.ibm.team.repository.rcp.ui.parts.WidgetToolkit;
import com.ibm.team.repository.rcp.ui.utils.LayoutConstants2;
import com.ibm.team.repository.rcp.ui.utils.MnemonicGenerator;
import com.ibm.team.repository.rcp.ui.utils.WidgetFactoryContext;
import com.ibm.team.repository.rcp.ui.wizards.BaseWizardPage;
import com.ibm.team.scm.common.dto.IAncestorReport;
import com.ibm.team.scm.common.dto.INameItemPair;
import com.ibm.team.scm.common.internal.util.ItemId;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IFilter;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.osgi.service.prefs.Preferences;

public class TeamPlaceSelectionPage
extends BaseWizardPage
implements ITeamRepositoryFactory {
    private JobRunner runner;
    private boolean folderSelection;
    public static final Object RADIO_CREATE = new String("Create");
    public static final Object RADIO_REUSE = new String("Reuse");
    private WritableValue createOrReuse = new WritableValue(RADIO_REUSE);
    private Text workspaceName;
    private boolean workspaceNameFirstTime = true;
    private RepositoryCombo repository;
    private CombinedStatus validationStatus = new CombinedStatus();
    private org.eclipse.core.databinding.observable.value.WritableValue manualValidation = new org.eclipse.core.databinding.observable.value.WritableValue();
    private Display display;
    private TeamAreaSelectionPart picker;
    private final String helpContextId;
    private final IStatus NO_WORKSPACE_NAME;
    private final IStatus NO_COMPONENT;
    private Map<IShare, IAncestorReport> fShareForDefaultSelection;

    public TeamPlaceSelectionPage(String pageName, String title, ImageDescriptor titleImage, boolean folderSelection, String helpContextId) {
        this(pageName, title, titleImage, folderSelection, helpContextId, null);
    }

    public TeamPlaceSelectionPage(String pageName, String title, ImageDescriptor titleImage, boolean folderSelection, String helpContextId, Map<IShare, IAncestorReport> shareForDefaultSelection) {
        super(pageName, title, titleImage);
        this.folderSelection = folderSelection;
        this.helpContextId = helpContextId;
        this.fShareForDefaultSelection = shareForDefaultSelection;
        this.setPageComplete(false);
        this.runner = new JobRunner(false);
        this.manualValidation.setValue((Object)Status.OK_STATUS);
        this.display = Display.getCurrent();
        this.NO_WORKSPACE_NAME = StatusUtil.newStatus((Object)this, (String)Messages.TeamPlaceSelectionPage_noWorkspaceNameErrorMessage);
        this.NO_COMPONENT = StatusUtil.newStatus((Object)this, (String)Messages.TeamPlaceSelectionPage_noComponentSelectedErrorMessage);
    }

    public void createBody(Composite composite) {
        WidgetFactoryContext context = WidgetFactoryContext.forWizardPage((IWizardPage)this);
        WidgetToolkit toolkit = context.getToolkit();
        MnemonicGenerator mnemonics = context.getMnemonics();
        Composite repositoryComposite = new Composite(composite, 0);
        Label repositoryLabel = new Label(repositoryComposite, 0);
        repositoryLabel.setText(Messages.ChangeSetSearchCriteriaPart_repositoryComboLabel);
        ITeamRepository seedRepo = null;
        if (this.fShareForDefaultSelection != null && !this.fShareForDefaultSelection.isEmpty()) {
            IShare share = this.fShareForDefaultSelection.entrySet().iterator().next().getKey();
            ISharingDescriptor descr = share.getSharingDescriptor();
            seedRepo = RepositoryUtils.getTeamRepositoryById((UUID)descr.getRepositoryId());
        }
        this.repository = new RepositoryCombo(repositoryComposite, this.getInstancePrefs().node("repository"), context, seedRepo);
        this.repository.getSelectionProvider().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TeamPlaceSelectionPage.this.updateRepository();
            }
        });
        this.validationStatus.addStatus(this.repository.getValidationStatus());
        GridDataFactory.fillDefaults().grab(true, false).hint(100, -1).applyTo(this.repository.getControl());
        GridLayoutFactory.fillDefaults().numColumns(2).generateLayout(repositoryComposite);
        final Button selectComponentRadio = (Button)ToolkitUtil.createRadio((WidgetToolkit)toolkit, (Composite)composite, (String)mnemonics.generate(Messages.TeamPlaceSelectionPage_selectExistingComponentRadio), (Object)RADIO_REUSE, (WritableValue)this.createOrReuse);
        this.picker = new TeamAreaSelectionPart(composite, context, new ContributorPlacesTreeProvider((IOperationRunner)this.runner), this.folderSelection, true);
        this.picker.setSorter((Comparator)((Object)new TeamPlaceViewSorter()));
        this.picker.setDoubleClickHandler(new ITreePathRunnable(){

            public void run(TreePath selectedObject, Shell theShell) {
                if (selectedObject.getLastSegment() instanceof ContributorPlaceWrapper) {
                    TeamPlaceSelectionPage.this.picker.toggleExpandedState(selectedObject);
                    return;
                }
                if (TeamPlaceSelectionPage.this.getTarget() == null) {
                    return;
                }
                AdvanceableWizard.advance(TeamPlaceSelectionPage.this.getWizard());
            }
        });
        final Button newWorkspaceRadio = (Button)ToolkitUtil.createRadio((WidgetFactoryContext)context, (Composite)composite, (String)mnemonics.generate(Messages.TeamPlaceSelectionPage_createWorkspaceRadio), (Object)RADIO_CREATE, (WritableValue)this.createOrReuse);
        this.workspaceName = toolkit.createText(composite, "", 2048);
        selectComponentRadio.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (selectComponentRadio.getSelection()) {
                    IWizardContainer container = TeamPlaceSelectionPage.this.getContainer();
                    if (container != null) {
                        container.updateButtons();
                    }
                    TeamPlaceSelectionPage.this.picker.setFocus();
                    TeamPlaceSelectionPage.this.updateEnablement();
                }
            }
        });
        selectComponentRadio.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                TeamPlaceSelectionPage.this.picker.setFocus();
            }

            public void focusLost(FocusEvent e) {
            }
        });
        newWorkspaceRadio.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (newWorkspaceRadio.getSelection()) {
                    IWizardContainer container = TeamPlaceSelectionPage.this.getContainer();
                    if (container != null) {
                        container.updateButtons();
                    }
                    TeamPlaceSelectionPage.this.workspaceName.setFocus();
                    TeamPlaceSelectionPage.this.updateEnablement();
                }
            }
        });
        newWorkspaceRadio.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                TeamPlaceSelectionPage.this.workspaceName.setFocus();
            }

            public void focusLost(FocusEvent e) {
            }
        });
        this.picker.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TeamPlaceSelectionPage.this.updateEnablement();
            }
        });
        this.createOrReuse.addListener(new IChangeListener(){

            public void changed(Object source, Object property) {
                TeamPlaceSelectionPage.this.updateEnablement();
            }
        });
        this.workspaceName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TeamPlaceSelectionPage.this.workspaceNameFirstTime = false;
                IWizardContainer container = TeamPlaceSelectionPage.this.getContainer();
                if (container != null) {
                    container.updateButtons();
                }
                TeamPlaceSelectionPage.this.updateEnablement();
            }
        });
        this.validationStatus.addStatus((IObservableValue)this.manualValidation);
        composite.setTabList(composite.getChildren());
        Dialog.applyDialogFont((Control)composite);
        GridLayoutFactory.fillDefaults().extendedMargins(LayoutConstants2.getWizardPageMargins()).generateLayout(composite);
        this.updateEnablement();
        this.updateRepository();
        DatabindingUtil.bindMessage((DialogPage)this, (IObservableValue)this.validationStatus);
        if (this.helpContextId != null) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, this.helpContextId);
        }
    }

    private void expandLoadedWorkspaces() {
        IComponentSyncModel model = FileSystemResourcesPlugin.getComponentSyncModel();
        IWorkspaceSyncContext[] contexts = model.getWorkspaceSyncContexts();
        final HashSet<ItemId> loadedWorkspaces = new HashSet<ItemId>();
        int i = 0;
        while (i < contexts.length) {
            IWorkspaceSyncContext workspaceSyncContext = contexts[i];
            loadedWorkspaces.add(ItemId.forItem((IItem)workspaceSyncContext.getLocal().getResolvedWorkspace()));
            ++i;
        }
        this.picker.expandMatching(new IFilter(){

            public boolean select(Object toTest) {
                if (toTest instanceof AbstractPlaceWrapper) {
                    AbstractPlaceWrapper wrapper = (AbstractPlaceWrapper)((Object)toTest);
                    return loadedWorkspaces.contains(ItemId.forItem((IItem)wrapper.getWorkspace()));
                }
                return false;
            }
        });
    }

    private void expandToShareFolder() {
        if (this.fShareForDefaultSelection != null && this.fShareForDefaultSelection.size() > 0) {
            Map.Entry<IShare, IAncestorReport> shareEntry = this.fShareForDefaultSelection.entrySet().iterator().next();
            final IShare share = shareEntry.getKey();
            final IAncestorReport ancestors = shareEntry.getValue();
            this.picker.expandMatching(new IFilter(){

                public boolean select(Object toTest) {
                    if (toTest instanceof AbstractPlaceWrapper) {
                        AbstractPlaceWrapper wrapper = (AbstractPlaceWrapper)((Object)toTest);
                        return share.getSharingDescriptor().getConnectionHandle().sameItemId((IItemHandle)wrapper.getContextHandle());
                    }
                    if (toTest instanceof ContributorPlaceComponentWrapper) {
                        ContributorPlaceComponentWrapper wrapper = (ContributorPlaceComponentWrapper)toTest;
                        return share.getSharingDescriptor().getComponent().sameItemId((IItemHandle)wrapper.getComponent());
                    }
                    if (toTest instanceof FolderItemWrapper) {
                        FolderItemWrapper wrapper = (FolderItemWrapper)((Object)toTest);
                        boolean expand = false;
                        if (ancestors == null || ancestors.getNameItemPairs().isEmpty()) {
                            String shareParentFQName;
                            String currentNodeFQName = "/" + wrapper.getFQName();
                            IRelativeLocation shareParent = share.getPath().getParent();
                            String string = shareParentFQName = shareParent == null ? "/" : shareParent.toPath().toPortableString();
                            if (shareParentFQName.startsWith(currentNodeFQName)) {
                                expand = true;
                            }
                            if (currentNodeFQName.equals(shareParentFQName)) {
                                TeamPlaceSelectionPage.this.picker.setSelection((ISelection)new StructuredSelection(toTest));
                            }
                        } else {
                            List namePairs = ancestors.getNameItemPairs();
                            int j = 0;
                            Iterator i = namePairs.iterator();
                            i.next();
                            ++j;
                            while (i.hasNext()) {
                                ++j;
                                INameItemPair pair = (INameItemPair)i.next();
                                if (!pair.getItem().sameItemId(wrapper.getItem().toHandle())) continue;
                                expand = true;
                                if (j != namePairs.size() - 1) continue;
                                TeamPlaceSelectionPage.this.picker.setSelection((ISelection)new StructuredSelection(toTest));
                            }
                        }
                        return expand;
                    }
                    return false;
                }
            });
        }
    }

    protected Preferences getInstancePrefs() {
        return new InstanceScope().getNode("com.ibm.team.filesystem.ide.ui").node(this.getClass().getName());
    }

    public boolean creatingNewWorkspace() {
        return this.createOrReuse.getValue() == RADIO_CREATE;
    }

    public String getWorkspaceName() {
        return this.workspaceName.getText();
    }

    private void updateEnablement() {
        boolean creating = this.creatingNewWorkspace();
        this.workspaceName.setEnabled(creating);
        this.picker.setEnabled(!creating);
        IStatus error = null;
        if (creating) {
            if (this.getWorkspaceName().equals("") && !this.workspaceNameFirstTime) {
                error = this.NO_WORKSPACE_NAME;
            }
        } else if (this.getTarget() == null) {
            error = this.NO_COMPONENT;
        }
        if (error == null) {
            this.manualValidation.setValue((Object)Status.OK_STATUS);
        } else if (!error.equals(this.manualValidation.getValue())) {
            this.manualValidation.setValue((Object)error);
        }
    }

    public Object getTarget() {
        if (this.createOrReuse.getValue() == RADIO_CREATE) {
            return null;
        }
        return this.picker.getSelection();
    }

    public void dispose() {
        super.dispose();
        this.runner.dispose();
    }

    public ITeamRepository getRepository() {
        return this.repository.getRepository();
    }

    @Override
    public ITeamRepository createRepository(IProgressMonitor monitor) throws TeamRepositoryException {
        final ITeamRepository[] repo = new ITeamRepository[1];
        this.display.syncExec(new Runnable(){

            @Override
            public void run() {
                repo[0] = TeamPlaceSelectionPage.this.repository.getRepository();
            }
        });
        return repo[0];
    }

    private void updateRepository() {
        ITeamRepository repo = this.repository.getRepository();
        this.picker.setInput(repo);
        if (this.fShareForDefaultSelection == null || this.fShareForDefaultSelection.size() == 0) {
            this.expandLoadedWorkspaces();
        } else {
            this.expandToShareFolder();
        }
    }

    public TeamAreaSelection getTeamSelection() {
        return this.picker.getTeamAreaSelection();
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            if (this.repository.getRepository() == null) {
                this.repository.getControl().setFocus();
            } else {
                this.picker.setFocus();
            }
        }
    }

    public boolean isPageComplete() {
        if (this.creatingNewWorkspace() && this.getWorkspaceName().equals("")) {
            return false;
        }
        return super.isPageComplete();
    }
}

