/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.wizards;

import com.ibm.team.filesystem.ui.queries.WorkspaceComponentsQuery;
import com.ibm.team.filesystem.ui.views.StreamsInTeamAreaTreeProvider;
import com.ibm.team.filesystem.ui.wrapper.AbstractPlaceWrapper;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.wizards.AdvanceableWizard;
import com.ibm.team.internal.filesystem.ui.wizards.sharing.ITeamRepositoryFactory;
import com.ibm.team.internal.filesystem.ui.wizards.sharing.TeamAreaSelection;
import com.ibm.team.internal.filesystem.ui.wizards.sharing.TeamAreaSelectionPart;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.common.IChangeListener;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.internal.utils.SWTUtil;
import com.ibm.team.repository.rcp.ui.internal.utils.ToolkitUtil;
import com.ibm.team.repository.rcp.ui.internal.viewers.ISetWithListeners;
import com.ibm.team.repository.rcp.ui.internal.viewers.ITreePathRunnable;
import com.ibm.team.repository.rcp.ui.internal.viewers.WritableValue;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.repository.rcp.ui.operations.JobRunner;
import com.ibm.team.repository.rcp.ui.utils.LayoutConstants2;
import com.ibm.team.repository.rcp.ui.utils.WidgetFactoryContext;
import com.ibm.team.repository.rcp.ui.wizards.BaseWizardPage;
import java.lang.reflect.InvocationTargetException;
import java.util.Comparator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IFilter;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class TeamAreaSelectionPage
extends BaseWizardPage {
    private JobRunner operationRunner = new JobRunner(false);
    private ITeamRepository repo;
    public static final Object RADIO_CREATE = new String("Create");
    public static final Object RADIO_REUSE = new String("Reuse");
    private WritableValue radioValue = new WritableValue(RADIO_CREATE);
    private ITeamRepositoryFactory factory = null;
    private TeamAreaSelectionPart picker;
    private Control radio1;

    public TeamAreaSelectionPage(ITeamRepositoryFactory repo) {
        super("Select Stream", Messages.TeamAreaPickerPage_selectStreamPageTitle, null);
        this.setDescription(Messages.TeamAreaPickerPage_selectStreamPageDescription);
        this.setPageComplete(false);
        this.factory = repo;
    }

    public void setRepo(ITeamRepositoryFactory repo) {
        if (repo == this.factory) {
            return;
        }
        this.factory = repo;
        this.picker.setInput(null);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.radio1.setFocus();
            try {
                final Display display = Display.getCurrent();
                this.getContainer().run(true, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                        try {
                            TeamAreaSelectionPage.this.repo = TeamAreaSelectionPage.this.factory.createRepository((IProgressMonitor)progress.newChild(50));
                            if (TeamAreaSelectionPage.this.repo != null) {
                                TeamAreaSelectionPage.this.repo.login((IProgressMonitor)progress.newChild(50));
                                SWTUtil.greedyExec((Display)display, (Runnable)new Runnable(){

                                    @Override
                                    public void run() {
                                        TeamAreaSelectionPage.this.picker.setInput(TeamAreaSelectionPage.this.repo);
                                    }
                                });
                            }
                        }
                        catch (TeamRepositoryException e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                });
            }
            catch (InvocationTargetException e) {
                StatusUtil.log((Object)((Object)this), (Throwable)e.getTargetException());
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public ITeamRepository getRepository() {
        return this.repo;
    }

    protected void createBody(Composite composite) {
        WidgetFactoryContext context = WidgetFactoryContext.forWizardPage((IWizardPage)this);
        this.radio1 = ToolkitUtil.createRadio((WidgetFactoryContext)context, (Composite)composite, (String)Messages.TeamAreaPickerPage_dontShareRadio, (Object)RADIO_CREATE, (WritableValue)this.radioValue);
        GridDataFactory.generate((Control)this.radio1, (int)2, (int)1);
        Control radio2 = ToolkitUtil.createRadio((WidgetFactoryContext)context, (Composite)composite, (String)Messages.TeamAreaPickerPage_shareWithStreamRadio, (Object)RADIO_REUSE, (WritableValue)this.radioValue);
        GridDataFactory.generate((Control)radio2, (int)2, (int)1);
        this.radioValue.addListener(new IChangeListener(){

            public void changed(Object source, Object property) {
                if (TeamAreaSelectionPage.this.radioValue.getValue() == RADIO_CREATE) {
                    TeamAreaSelectionPage.this.picker.setSelection((ISelection)StructuredSelection.EMPTY);
                }
                TeamAreaSelectionPage.this.updateArea();
            }
        });
        this.picker = new TeamAreaSelectionPart(composite, context, new StreamsInTeamAreaTreeProvider((IOperationRunner)this.operationRunner){

            @Override
            public ISetWithListeners getChildren(Object element) {
                if (element instanceof AbstractPlaceWrapper) {
                    AbstractPlaceWrapper apw = (AbstractPlaceWrapper)((Object)element);
                    return new WorkspaceComponentsQuery(apw.getRepository(), apw.getWorkspace(), (IOperationRunner)TeamAreaSelectionPage.this.operationRunner);
                }
                return super.getChildren(element);
            }
        }, true, false);
        this.picker.expandMatching(new IFilter(){

            public boolean select(Object toTest) {
                return toTest instanceof IProcessAreaHandle;
            }
        });
        this.picker.setSorter(new Comparator(){

            public int compare(Object e1, Object e2) {
                if (e1 instanceof AbstractPlaceWrapper && e2 instanceof AbstractPlaceWrapper) {
                    AbstractPlaceWrapper apw1 = (AbstractPlaceWrapper)((Object)e1);
                    AbstractPlaceWrapper apw2 = (AbstractPlaceWrapper)((Object)e2);
                    return apw1.getWorkspace().getName().compareToIgnoreCase(apw2.getWorkspace().getName());
                }
                if (e1 instanceof IProcessArea && e2 instanceof IProcessArea) {
                    IProcessArea ta1 = (IProcessArea)e1;
                    IProcessArea ta2 = (IProcessArea)e2;
                    return ta1.getName().compareToIgnoreCase(ta2.getName());
                }
                if (e1 instanceof AbstractPlaceWrapper) {
                    return 1;
                }
                if (e2 instanceof AbstractPlaceWrapper) {
                    return -1;
                }
                return 0;
            }
        });
        this.picker.setDoubleClickHandler(new ITreePathRunnable(){

            public void run(TreePath selectedObject, Shell targetShell) {
                if (TeamAreaSelectionPage.this.picker.getSelection() != null) {
                    AdvanceableWizard.advance(TeamAreaSelectionPage.this.getWizard());
                } else {
                    TeamAreaSelectionPage.this.picker.toggleExpandedState(selectedObject);
                }
            }
        });
        this.picker.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (!event.getSelection().isEmpty()) {
                    TeamAreaSelectionPage.this.radioValue.setValue(RADIO_REUSE);
                }
                TeamAreaSelectionPage.this.updateArea();
            }
        });
        GridLayoutFactory.fillDefaults().extendedMargins(LayoutConstants2.getWizardPageMargins()).generateLayout(composite);
        this.updateArea();
        Dialog.applyDialogFont((Control)composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "com.ibm.team.filesystem.ide.ui.wizard_share_selectteamarea");
    }

    protected void updateArea() {
        boolean dontCollborate = this.dontCollaborate();
        this.picker.setEnabled(!dontCollborate);
        this.setPageComplete(dontCollborate || this.picker.getSelection() != null);
    }

    public boolean dontCollaborate() {
        return this.radioValue.getValue() == RADIO_CREATE;
    }

    public TeamAreaSelection getTeamAreaSelection() {
        return this.picker.getTeamAreaSelection();
    }
}

