/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.web.common;

import com.ibm.team.filesystem.client.internal.utils.RepositoryUtils;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.json.JSONArray;
import com.ibm.team.repository.common.json.JSONObject;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.internal.dto2.ScmDto2Factory;
import com.ibm.team.scm.common.internal.dto2.WorkspaceComponentState;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class SimpleJSONdeSerializer {
    private static final String TYPE_DATE = "Date";
    private static final String TYPE_LONG = "Long";
    private static final String TYPE_STRING = "String";
    private static final String TYPE_I_WORKSPACE_HANDLE = "IWorkspaceHandle";
    private static final String TYPE_I_COMPONENT_HANDLE = "IComponentHandle";
    private static final String TYPE_I_CHANGE_SET_HANDLE = "IChangeSetHandle";
    private static final String TYPE_WORKSPACE_COMPONENT_STATE = "WorkspaceComponentState";
    private static final String TYPE_LIST = "List";
    private static final String FIELD_REPOSITORY = "repositoryUri";
    private static final String FIELD_WORKSPACE = "workspace";
    private static final String FIELD_COMPONENT = "component";
    private static final String FIELD_STATE = "state";
    private static final String FIELD_STATE_ID = "stateId";
    private static final String KEY_TYPE = "TYPE";
    private static final String KEY_VALUE = "VALUE";

    public static Object getField(String fieldName, JSONObject json, ITeamRepository repo) {
        JSONObject field = (JSONObject)json.get((Object)fieldName);
        if (field == null) {
            return null;
        }
        return SimpleJSONdeSerializer.getObject(field, repo);
    }

    private static Object getObject(JSONObject json, ITeamRepository repo) {
        String type = (String)json.get((Object)KEY_TYPE);
        if (type == null) {
            throw new IllegalArgumentException();
        }
        return SimpleJSONdeSerializer.getObject(type, json, repo);
    }

    private static Object getObject(String type, JSONObject json, ITeamRepository repo) {
        Object value = json.get((Object)KEY_VALUE);
        if (value == null) {
            throw new IllegalArgumentException();
        }
        ITeamRepository repository = SimpleJSONdeSerializer.getRepository(json.get((Object)FIELD_REPOSITORY));
        if (repository != null) {
            repo = repository;
        }
        switch (type) {
            case "WorkspaceComponentState": {
                return SimpleJSONdeSerializer.getWorkspaceComponentState(value, repo);
            }
            case "Date": {
                return SimpleJSONdeSerializer.getDate(value);
            }
            case "IWorkspaceHandle": {
                return SimpleJSONdeSerializer.getWorkspaceHandle(value, repo);
            }
            case "IComponentHandle": {
                return SimpleJSONdeSerializer.getComponentHandle(value, repo);
            }
            case "IChangeSetHandle": {
                return SimpleJSONdeSerializer.getChangeSetHandle(value, repo, json);
            }
            case "Long": {
                return SimpleJSONdeSerializer.getLong(value);
            }
            case "String": {
                return SimpleJSONdeSerializer.getString(value);
            }
            case "List": {
                return SimpleJSONdeSerializer.getList(value, repo);
            }
        }
        throw new IllegalArgumentException("Unsupported type");
    }

    private static ITeamRepository getRepository(Object obj) {
        String repoURI = (String)obj;
        if (repoURI != null) {
            return RepositoryUtils.getTeamRepository((String)repoURI);
        }
        return null;
    }

    private static List<Object> getList(Object obj, ITeamRepository repo) {
        JSONObject json = (JSONObject)obj;
        String arrayType = (String)json.get((Object)KEY_TYPE);
        JSONArray value = (JSONArray)json.get((Object)KEY_VALUE);
        if (value == null) {
            throw new IllegalArgumentException("Improperly serialized array");
        }
        ArrayList<Object> result = new ArrayList<Object>(value.size());
        for (Object jsonElement : value) {
            result.add(SimpleJSONdeSerializer.getObject(arrayType, (JSONObject)jsonElement, repo));
        }
        return result;
    }

    private static IWorkspaceHandle getWorkspaceHandle(Object obj, ITeamRepository repo) {
        String uuidString = (String)obj;
        UUID id = UUID.valueOf((String)uuidString);
        IWorkspaceHandle workspace = (IWorkspaceHandle)IWorkspace.ITEM_TYPE.createItemHandle((Object)repo, id, null);
        return workspace;
    }

    private static IComponentHandle getComponentHandle(Object obj, ITeamRepository repo) {
        String uuidString = (String)obj;
        UUID id = UUID.valueOf((String)uuidString);
        IComponentHandle component = (IComponentHandle)IComponent.ITEM_TYPE.createItemHandle((Object)repo, id, null);
        return component;
    }

    private static IChangeSetHandle getChangeSetHandle(Object obj, ITeamRepository repo, JSONObject json) {
        String uuidString = (String)obj;
        UUID id = UUID.valueOf((String)uuidString);
        UUID stateId = null;
        if (json.containsKey((Object)FIELD_STATE_ID) && json.get((Object)FIELD_STATE_ID) != null) {
            stateId = UUID.valueOf((String)((String)json.get((Object)FIELD_STATE_ID)));
        }
        IChangeSetHandle changeSet = (IChangeSetHandle)IChangeSet.ITEM_TYPE.createItemHandle((Object)repo, id, stateId);
        return changeSet;
    }

    private static Long getLong(Object obj) {
        String longString = (String)obj;
        return Long.parseLong(longString);
    }

    private static String getString(Object obj) {
        return (String)obj;
    }

    private static Date getDate(Object obj) {
        String longString = (String)obj;
        long value = Long.valueOf(longString);
        return new Date(value);
    }

    private static WorkspaceComponentState getWorkspaceComponentState(Object obj, ITeamRepository repo) {
        JSONObject json = (JSONObject)obj;
        ITeamRepository repository = SimpleJSONdeSerializer.getRepository(json.get((Object)FIELD_REPOSITORY));
        if (repository != null) {
            repo = repository;
        }
        WorkspaceComponentState state = ScmDto2Factory.eINSTANCE.createWorkspaceComponentState();
        state.setWorkspace((IWorkspaceHandle)SimpleJSONdeSerializer.getField(FIELD_WORKSPACE, json, repo));
        state.setComponent((IComponentHandle)SimpleJSONdeSerializer.getField(FIELD_COMPONENT, json, repo));
        state.setState(((Long)SimpleJSONdeSerializer.getField(FIELD_STATE, json, repo)).longValue());
        return state;
    }
}

