/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.web.common;

import com.ibm.team.filesystem.client.internal.LoggingHelper;
import com.ibm.team.filesystem.ui.UiPlugin;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.repository.client.IStatistics;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.json.JSONObject;
import com.ibm.team.repository.common.transport.TeamServiceException;
import com.ibm.team.repository.common.util.Base64;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.repository.transport.client.ITeamRawRestServiceClient;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.widgets.Display;

public class RichClientRequest {
    final String XHR_REQUEST;
    final String XHR_DEFERRED;
    final String XHR_RELEASE;
    final String XHR_CHECK;
    private Browser browser;
    private ITeamRepository repository;
    private IOperationRunner opRunner;
    private Display display;
    private URI requestUri;
    private String requestMethod;

    public RichClientRequest(Long requestId, Browser browser, ITeamRepository repository, IOperationRunner opRunner) {
        this.browser = browser;
        this.opRunner = opRunner;
        this.repository = repository;
        this.display = browser.getDisplay();
        this.XHR_REQUEST = "_eclipseClientXhrRequest['' + " + requestId + "]";
        this.XHR_DEFERRED = String.valueOf(this.XHR_REQUEST) + ".deferred";
        this.XHR_RELEASE = String.valueOf(this.XHR_REQUEST) + " = null;";
        this.XHR_CHECK = "('_eclipseClientXhrRequest' in window && " + this.XHR_REQUEST + " && " + this.XHR_REQUEST + ".hash == {0})";
    }

    public int performRequest() throws UnsupportedEncodingException, IOException {
        this.display.asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    long hash = RichClientRequest.this.initialize();
                    if (RichClientRequest.this.requestUri == null || RichClientRequest.this.requestMethod == null) {
                        RichClientRequest.this.reject(hash, new IllegalArgumentException());
                        return;
                    }
                    JSONObject requestHeaders = JSONObject.parse((Reader)new StringReader((String)RichClientRequest.this.browser.evaluate("return JSON.stringify(" + RichClientRequest.this.XHR_REQUEST + ".headers)")));
                    byte[] postData = RichClientRequest.this.getPostData();
                    RepositoryOperation repositoryOperation = RichClientRequest.this.getRepositoryOperation(hash, postData, requestHeaders);
                    RichClientRequest.this.opRunner.enqueue(Messages.EmbeddedBrowser_PerformRichClientNetworkRequest, (Operation)repositoryOperation);
                }
                catch (IOException e) {
                    UiPlugin.getDefault().getLog().log((IStatus)new Status(4, "com.ibm.team.filesystem.ide.ui", e.getMessage(), (Throwable)e));
                }
            }
        });
        return 1;
    }

    private RepositoryOperation getRepositoryOperation(final long hash, final byte[] postData, final JSONObject requestHeaders) {
        return new RepositoryOperation(this.repository){

            public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, OperationFailedException {
                if (RichClientRequest.this.browser.isDisposed()) {
                    return;
                }
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                try (ITeamRawRestServiceClient.IRawRestClientConnection.Response response = null;){
                    try {
                        response = RichClientRequest.this.doRequest(requestHeaders, postData, (IProgressMonitor)progress.newChild(90));
                        int statusCode = response.getStatusCode();
                        String statusText = response.getStatusText();
                        Map responseHeaders = response.getAllResponseHeaders();
                        ByteArrayOutputStream responseBytes = RichClientRequest.this.getResponseBytes(response);
                        RichClientRequest.this.processResponse(hash, statusCode, statusText != null ? statusText : "", responseBytes, responseHeaders != null ? responseHeaders : Collections.EMPTY_MAP);
                    }
                    catch (Exception e) {
                        RichClientRequest.this.reject(hash, e);
                        if (response != null) {
                            response.close();
                        }
                    }
                }
            }

            protected void ensureLoggedIn(IProgressMonitor monitor) throws TeamRepositoryException {
                try {
                    super.ensureLoggedIn(monitor);
                }
                catch (Exception e) {
                    RichClientRequest.this.reject(hash, e);
                    throw e;
                }
            }
        };
    }

    private ITeamRawRestServiceClient.IRawRestClientConnection.Response doRequest(JSONObject requestHeaders, byte[] postData, IProgressMonitor monitor) throws TeamServiceException, TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        ITeamRawRestServiceClient rawClient = this.repository.getRawRestServiceClient();
        ITeamRawRestServiceClient.IRawRestClientConnection connection = null;
        ITeamRawRestServiceClient.IRawRestClientConnection.Response response = null;
        if (progress.isCanceled()) {
            throw new OperationCanceledException();
        }
        int retries = 0;
        while (retries < 2) {
            connection = this.getConnectionWithHeaders(requestHeaders, rawClient, this.requestUri);
            long startTime = System.currentTimeMillis();
            if ("GET".equalsIgnoreCase(this.requestMethod)) {
                response = connection.doGet();
            } else if ("POST".equalsIgnoreCase(this.requestMethod)) {
                response = connection.doPost((InputStream)new ByteArrayInputStream(postData), (long)postData.length, (String)requestHeaders.get((Object)"Content-Type"));
            } else {
                throw new TeamRepositoryException(NLS.bind((String)"Method {0} is not supported in rich client networking.", (Object)this.requestMethod, (Object[])new Object[0]));
            }
            if (response.getStatusCode() == 401 || response.getStatusCode() == 302) {
                this.repository.logout();
                this.repository.login((IProgressMonitor)progress.newChild(5));
                if (progress.isCanceled()) {
                    throw new OperationCanceledException();
                }
                progress.setWorkRemaining(50);
            } else {
                this.trackStatistics(startTime, System.currentTimeMillis());
                progress.done();
            }
            ++retries;
        }
        return response;
    }

    private ITeamRawRestServiceClient.IRawRestClientConnection getConnectionWithHeaders(JSONObject headers, ITeamRawRestServiceClient rawClient, URI uri) throws TeamRepositoryException {
        try {
            ITeamRawRestServiceClient.IRawRestClientConnection connection = rawClient.getConnection(uri);
            if (headers != null) {
                for (Object k : headers.keySet()) {
                    if (!(k instanceof String)) continue;
                    connection.addRequestHeader((String)k, (String)headers.get(k));
                }
            }
            return connection;
        }
        catch (URISyntaxException e) {
            throw new TeamRepositoryException((Throwable)e);
        }
    }

    protected void reject(final long hash, final Exception e) {
        LoggingHelper.log((IStatus)new Status(4, "com.ibm.team.filesystem.ide.ui", e.getMessage(), (Throwable)e));
        if (!this.display.isDisposed()) {
            this.display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (RichClientRequest.this.browser.isDisposed()) {
                        return;
                    }
                    String checkRequestString = RichClientRequest.this.XHR_CHECK.replace("{0}", String.valueOf(hash));
                    String response = String.valueOf(RichClientRequest.this.XHR_REQUEST) + ".response";
                    String errorMessage = e.getMessage() != null ? e.getMessage() : "cancelled";
                    StringBuilder script = new StringBuilder();
                    script.append("(function(){                                                    \r\n");
                    script.append("   if (" + checkRequestString + " && " + RichClientRequest.this.XHR_DEFERRED + ") {    \r\n");
                    script.append("     " + response + " = {};                                     \r\n");
                    script.append("     " + response + ".status = -1;                              \r\n");
                    script.append("     " + response + ".statusText = 'error';                     \r\n");
                    script.append("     " + response + ".responseText = '" + errorMessage + "';    \r\n");
                    script.append("     var error = new Error();                                   \r\n");
                    script.append("     error.name = '" + e.getClass().getName() + "';             \r\n");
                    script.append("     error.message = '" + errorMessage + "';                    \r\n");
                    script.append("     " + RichClientRequest.this.XHR_DEFERRED + ".reject(error);                        \r\n");
                    script.append("     " + RichClientRequest.this.XHR_RELEASE + "                                        \r\n");
                    script.append("   }                                                            \r\n");
                    script.append("})();                                                           \r\n");
                    RichClientRequest.this.browser.evaluate(script.toString());
                }
            });
        }
    }

    private byte[] getPostData() throws UnsupportedEncodingException {
        boolean hasPostData = (Boolean)this.browser.evaluate("return ('postData' in " + this.XHR_REQUEST + ") && " + this.XHR_REQUEST + ".postData != null;");
        StringBuilder postDataBuffer = new StringBuilder();
        if (hasPostData) {
            int chunkSize = 1024;
            long length = ((Number)this.browser.evaluate("return " + this.XHR_REQUEST + ".postData.length;")).longValue();
            int i = 0;
            while ((long)i < length) {
                if (this.isDisposed()) {
                    return null;
                }
                String chunk = (String)this.browser.evaluate("return " + this.XHR_REQUEST + ".postData.slice(" + i + "," + Math.min((long)(i + chunkSize), length) + ");");
                postDataBuffer.append(chunk);
                this.display.readAndDispatch();
                i += chunkSize;
            }
        }
        byte[] postData = postDataBuffer.toString().getBytes("UTF-8");
        postDataBuffer = null;
        return postData;
    }

    private boolean isDisposed() {
        return this.browser.isDisposed() || this.display.isDisposed();
    }

    private long initialize() {
        long hash = new SecureRandom().nextLong();
        StringBuilder script = new StringBuilder();
        script.append("if (" + this.XHR_REQUEST + " == null || " + this.XHR_DEFERRED + " == null)                \r\n");
        script.append("    return null;                                                                \r\n");
        script.append("if (" + this.XHR_REQUEST + ".url == null || " + this.XHR_REQUEST + ".method == null) {    \r\n");
        script.append("    " + this.XHR_DEFERRED + ".reject(new Error('Request url or method not set.'));   \r\n");
        script.append("    " + this.XHR_REQUEST + " = null;                                                 \r\n");
        script.append("    return null;                                                                \r\n");
        script.append("} else {                                                                        \r\n");
        script.append("    " + this.XHR_REQUEST + ".hash = " + hash + ";                                    \r\n");
        script.append("    return [" + this.XHR_REQUEST + ".url, " + this.XHR_REQUEST + ".method];               \r\n");
        script.append("}                                                                               \r\n");
        Object[] urlAndMethod = (Object[])this.browser.evaluate(script.toString());
        if (urlAndMethod != null) {
            String url = (String)urlAndMethod[0];
            this.requestUri = URI.create(url);
            this.requestMethod = (String)urlAndMethod[1];
        }
        return hash;
    }

    private void trackStatistics(long startTime, long endTime) {
        long elapsedTime = endTime - startTime;
        Method serviceMethod = null;
        String[] requestPathSegments = this.requestUri.getPath().split("/");
        if (requestPathSegments != null && requestPathSegments.length >= 5) {
            try {
                Class<?> serviceClass = Class.forName(requestPathSegments[3]);
                Method[] methodArray = serviceClass.getDeclaredMethods();
                int n = methodArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Method m = methodArray[n2];
                    if (m.getName().equalsIgnoreCase(String.valueOf(this.requestMethod) + requestPathSegments[4])) {
                        serviceMethod = m;
                        break;
                    }
                    ++n2;
                }
            }
            catch (ClassNotFoundException serviceClass) {
                // empty catch block
            }
        }
        if (serviceMethod != null) {
            IStatistics stats = this.repository.statistics();
            String serviceName = serviceMethod.getDeclaringClass().getName();
            stats.incStatisticValue("com.ibm.team.repository.statistics.service", (Object)serviceName, "serviceElapsedTime", elapsedTime);
            stats.incStatisticValue("com.ibm.team.repository.statistics.service", (Object)serviceName, "totalServiceElapsedTime", elapsedTime);
            stats.incStatisticValue("com.ibm.team.repository.statistics.serviceMethod", (Object)serviceMethod, "serviceMethodElapsedTime", elapsedTime);
            stats.incStatisticValue("com.ibm.team.repository.statistics.serviceMethod", (Object)serviceMethod, "serviceMethodCallCount", 1L);
            stats.incStatisticValue("com.ibm.team.repository.totalContext", (Object)this.repository, "totalServiceCallCount", 1L);
            stats.incStatisticValue("com.ibm.team.repository.totalContext", (Object)this.repository, "totalServiceElapsedTime", elapsedTime);
        }
    }

    private ByteArrayOutputStream getResponseBytes(ITeamRawRestServiceClient.IRawRestClientConnection.Response response) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[4096];
        int bytesRead = 0;
        Throwable throwable = null;
        Object var6_7 = null;
        try (InputStream responseStream = response.getResponseStream();){
            while ((bytesRead = responseStream.read(buffer)) != -1) {
                baos.write(buffer, 0, bytesRead);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return baos;
    }

    private void processHeaders(Map<String, String> responseHeaders) {
        if (responseHeaders.containsKey("Set-Cookie")) {
            String headerValue = responseHeaders.get("Set-Cookie");
            Browser.setCookie((String)headerValue, (String)this.repository.getRepositoryURI());
        }
    }

    private void processResponse(final long hash, final int statusCode, final String statusText, final ByteArrayOutputStream baos, final Map<String, String> responseHeaders) {
        if (this.display.isDisposed()) {
            return;
        }
        this.display.asyncExec(new Runnable(){

            @Override
            public void run() {
                if (RichClientRequest.this.browser.isDisposed()) {
                    return;
                }
                RichClientRequest.this.processHeaders(responseHeaders);
                String checkRequestString = RichClientRequest.this.XHR_CHECK.replace("{0}", String.valueOf(hash));
                String response = String.valueOf(RichClientRequest.this.XHR_REQUEST) + ".response";
                String payload = String.valueOf(response) + ".responseText";
                StringBuilder script = new StringBuilder();
                script.append("if (" + checkRequestString + ") { ");
                script.append(String.valueOf(response) + " = {};");
                script.append(String.valueOf(payload) + " = '';");
                script.append(String.valueOf(response) + ".statusCode = " + statusCode + ";");
                script.append(String.valueOf(response) + ".statusText = '" + statusText.replaceAll("\"", "\\\"") + "';");
                script.append(String.valueOf(response) + ".responseHeaders = {};");
                for (Map.Entry header : responseHeaders.entrySet()) {
                    script.append(String.valueOf(response) + ".responseHeaders['" + (String)header.getKey() + "'] = '" + (String)header.getValue() + "';");
                }
                script.append(String.valueOf(payload) + " = '';");
                script.append("return true; ");
                script.append("} else { return false; }");
                if (!((Boolean)RichClientRequest.this.browser.evaluate(script.toString())).booleanValue()) {
                    return;
                }
                int chunkSize = 4096;
                byte[] bodyBytes = Base64.encode((byte[])baos.toByteArray());
                int i = 0;
                while (i < bodyBytes.length / chunkSize + 1) {
                    if (RichClientRequest.this.isDisposed()) {
                        return;
                    }
                    script = new StringBuilder();
                    script.append("if (" + checkRequestString + ") { ");
                    script.append(String.valueOf(payload) + " += '" + new String(Arrays.copyOfRange(bodyBytes, i * chunkSize, Math.min(bodyBytes.length, (i + 1) * chunkSize))) + "';");
                    script.append("return true;");
                    script.append("} else { return false; }");
                    if (!((Boolean)RichClientRequest.this.browser.evaluate(script.toString())).booleanValue()) {
                        LoggingHelper.log((IStatus)new Status(4, "com.ibm.team.filesystem.ide.ui", "Unable to transfer block of text for rich client networking to the web browser."));
                        RichClientRequest.this.browser.execute(RichClientRequest.this.XHR_RELEASE);
                        return;
                    }
                    RichClientRequest.this.display.readAndDispatch();
                    ++i;
                }
                script = new StringBuilder();
                script.append("if (" + checkRequestString + ") { ");
                script.append(String.valueOf(payload) + " = window.atob(" + payload + ");");
                script.append(String.valueOf(RichClientRequest.this.XHR_DEFERRED) + ".resolve(" + payload + ");");
                script.append(RichClientRequest.this.XHR_RELEASE);
                script.append("}");
                RichClientRequest.this.browser.execute(script.toString());
            }
        });
    }
}

