/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.web.common;

import com.ibm.team.filesystem.client.internal.FileSystemStatusUtil;
import com.ibm.team.filesystem.client.internal.LoggingHelper;
import com.ibm.team.filesystem.ui.UiPlugin;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.web.common.RichClientRequest;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.internal.TeamRepository;
import com.ibm.team.repository.client.util.IClientLibraryContext;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.NotLoggedInException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.internal.IRepositoryRemoteService;
import com.ibm.team.repository.common.internal.marshal.MarshalFactory;
import com.ibm.team.repository.common.internal.marshal.MarshallerType;
import com.ibm.team.repository.common.internal.marshal.impl.EObjectJSONMarshaller;
import com.ibm.team.repository.common.json.IJSONSerializable;
import com.ibm.team.repository.common.json.JSONArray;
import com.ibm.team.repository.common.json.JSONObject;
import com.ibm.team.repository.common.transport.ITeamServer;
import com.ibm.team.repository.common.util.Base64;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.repository.transport.client.RemoteTeamServer;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import org.apache.commons.logging.Log;
import org.apache.http.Header;
import org.apache.http.client.CookieStore;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.cookie.Cookie;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.BrowserFunction;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;

public class EmbeddedBrowser
implements ProgressListener,
ITeamRepository.ILoginParticipant {
    private static final String JSA_AUTH_URL_HEADER = "X-JSA-AUTHORIZATION-URL";
    private static final String JAZZOP_ENDPOINT = "/endpoint/jazzop";
    private static final String AUTHENTICATED_IDENTITY = "authenticated/identity";
    private static final String JSA_SUFFIX = "jsa";
    private static final String OIDC_SUFFIX = "oidc";
    private static final String JAZZOP_SUFFIX = "jazzop";
    private static final String OIDC_INTERCEPT_SERVICE = "service/com.ibm.team.repository.service.internal.oidc.IOidcUiInterceptService";
    public boolean DISABLE_RICH_CLIENT_NETWORKING = System.getProperty("com.ibm.team.filesystem.ide.ui.editors.disableRichClientNetwork", "false").equalsIgnoreCase("true");
    private static final int EDGE = 262144;
    private static final String OUTGOING_RESULT = "result";
    private static final String OUTGOING_RETURN = "return";
    private static final String RESULT_NAME_LOOKUP_FAIL = "name_lookup_fail";
    private static final String RESULT_SUCCEEDED = "succeeded";
    private static final String RESULT_PROTOCOL_ERROR = "protoError";
    private static final String RESULT_EXCEPTION_ERROR = "exceptionError";
    private static final String OUTGOING_EXCEPTION = "exception";
    private static final String OUTGOING_ERROR_MESSAGE = "error_message";
    private static final String OUTGOING_REQUEST_ID = "requestId";
    private static final String EMBEDDED_BROWSER_READY = "onReady";
    private static final String INCOMING_OP = "op";
    private static final String INCOMING_OP_CALL = "call";
    private static final String INCOMING_OP_GET_FUNCTIONS = "getFunctions";
    private static final String INCOMING_ARGS = "args";
    private static final String INCOMING_CALL_NAME = "name";
    private static final String INCOMING_RETURN_CALLBACK = "returnCallback";
    private static final String INCOMING_REQUEST_ID = "requestId";
    private static final String JAVASCRIPT_ENTRY = "_richClientEntryPoint";
    private final Composite parent;
    private BrowserProgress progressJob;
    private IOperationRunner opRunner = null;
    private List<String> allowedPrefixes = Collections.emptyList();
    private final Map<String, EmbeddedFunction> functions = new HashMap<String, EmbeddedFunction>();
    private Browser browser;
    private BrowserFunction browserFunction;
    private BrowserFunction eclipseLogFunction;
    private BrowserFunction richClientXhrFunction;
    private BrowserFunction richClientItemManagerFunction;
    private Link apology;
    private String url;
    private String jobName;
    private String noUrlApology;
    private BrowserCreationParticipant creationParticipant;
    private ITeamRepository repository;
    private boolean oidcEnabled = false;
    private volatile boolean authDiscoveryComplete = false;
    private Log log;

    public EmbeddedBrowser(Composite parent, IOperationRunner opRunner) {
        this.parent = parent;
        this.opRunner = opRunner;
    }

    public Control createWidget(int browserStyle) {
        try {
            this.browser = new Browser(this.parent, browserStyle);
        }
        catch (Throwable e) {
            StatusUtil.log((Object)this, (String)("Error initializing browser: " + e.getMessage()));
            this.apology = new Link(this.parent, 0x1000040);
            this.apology.setText(Messages.EmbeddedBrowser_ERROR_COULD_NOT_INSTANTIATE_BROWSER);
            this.apology.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    if (EmbeddedBrowser.this.url != null) {
                        Program.launch((String)EmbeddedBrowser.this.url);
                    }
                }
            });
            return this.apology;
        }
        this.browser.setMenu(new Menu((Control)this.browser));
        this.browser.addProgressListener((ProgressListener)this);
        this.browserFunction = this.createRichClientEntryPoint();
        this.eclipseLogFunction = this.createLogFunction();
        this.initAllowedPrefixes();
        this.installReadyCallback();
        this.installEclipseConsole();
        this.browser.addLocationListener(new LocationListener(){

            public void changing(LocationEvent event) {
            }

            public void changed(LocationEvent event) {
                EmbeddedBrowser.this.installEclipseConsole();
            }
        });
        this.tweakSafari();
        this.update();
        return this.browser;
    }

    private void initAllowedPrefixes() {
        this.allowedPrefixes = new ArrayList<String>();
        this.allowedPrefixes.add("data:");
        this.allowedPrefixes.add("about:");
        this.allowedPrefixes.add("javascript:");
        this.allowedPrefixes.add("res:");
    }

    private void installReadyCallback() {
        this.addCallback(EMBEDDED_BROWSER_READY, new EmbeddedFunction(){

            @Override
            public void run(EmbeddedBrowser browser, String name, BrowserArguments callArgs, EmbeddedFunctionCallback callback) {
                if (EmbeddedBrowser.this.isTracingEnabled()) {
                    EmbeddedBrowser.this.trace("Browser ready callback invoked");
                }
                EmbeddedBrowser.this.completed(null);
            }
        });
    }

    private void installClientXhrHandler() {
        if (this.DISABLE_RICH_CLIENT_NETWORKING) {
            return;
        }
        if (this.browser != null && !this.browser.isDisposed()) {
            StringBuilder script = new StringBuilder();
            script.append("if (!('_eclipseClientXhrRequest' in window)) {          ");
            script.append("   window._eclipseClientXhrRequest = {};                         ");
            script.append("   window._eclipseClientXhrRequestNum = 0;                       ");
            script.append("}                                                         ");
            script.append("if (!('_richClientXhr' in window)) {                                                       ");
            script.append("   window._richClientXhr = function(request) {                                             ");
            script.append("      try {                                                                                ");
            script.append("         console.log('Begin rich client network request ' + request.url);                  ");
            script.append("         var requestId = _eclipseClientXhrRequestNum++;                                    ");
            script.append("         _eclipseClientXhrRequest['' + requestId] = request;                               ");
            script.append("         _eclipseClientXhr(requestId);                                                     ");
            script.append("      } catch (e) { console.error(e); }                                                    ");
            script.append("   };                                                                                      ");
            script.append("}                                                                                          ");
            script.append("if ('_richClientRequests' in window) {                           ");
            script.append("   for (var idx = 0; idx < _richClientRequests.length; idx++) {  ");
            script.append("      _richClientXhr(_richClientRequests[idx]);                  ");
            script.append("   }                                                             ");
            script.append("   _richClientRequests = [];                                     ");
            script.append("}                                                                ");
            if (!this.browser.execute(script.toString())) {
                LoggingHelper.log((IStatus)new Status(4, "com.ibm.team.filesystem.ide.ui", "Rich client networking support could not be installed."));
            }
        }
    }

    private void installClientItemManager() {
        if (this.DISABLE_RICH_CLIENT_NETWORKING) {
            return;
        }
        if (this.browser != null && !this.browser.isDisposed()) {
            StringBuilder script = new StringBuilder();
            script.append("if (!('_eclipseClientItemManagerRequest' in window)) {          ");
            script.append("   window._eclipseClientItemManagerRequest = {};                ");
            script.append("   window._eclipseClientItemManagerRequestNum = 0;              ");
            script.append("}                                                               ");
            script.append("if (!('_richClientItemManager' in window)) {                    ");
            script.append("   window._richClientItemManager = function(request) {          ");
            script.append("      try {                                                     ");
            script.append("         console.log('Begin rich client item manager request ');");
            script.append("         var requestId = _eclipseClientItemManagerRequestNum++; ");
            script.append("         _eclipseClientItemManagerRequest['' + requestId] = request; ");
            script.append("         _eclipseClientItemManager(requestId);                       ");
            script.append("      } catch (e) { console.error(e); }                              ");
            script.append("   };                                                                ");
            script.append("}                                                                    ");
            script.append("if ('_richClientItemManagerRequests' in window) {                           ");
            script.append("   for (var idx = 0; idx < _richClientItemManagerRequests.length; idx++) {  ");
            script.append("      _richClientItemManager(_richClientItemManagerRequests[idx]);          ");
            script.append("   }                                                                        ");
            script.append("   _richClientItemManagerRequests = [];                                     ");
            script.append("}                                                                           ");
            if (!this.browser.execute(script.toString())) {
                LoggingHelper.log((IStatus)new Status(4, "com.ibm.team.filesystem.ide.ui", "Rich client item manager support could not be installed."));
            }
        }
    }

    private BrowserFunction createRichClientEntryPoint() {
        return new BrowserFunction(this.browser, JAVASCRIPT_ENTRY){

            public Object function(Object[] arguments) {
                if (EmbeddedBrowser.this.isTracingEnabled()) {
                    String message = "Entry point _richClientEntryPoint invoked with parameters: ";
                    Object[] objectArray = arguments;
                    int n = arguments.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object object = objectArray[n2];
                        message = String.valueOf(message) + object + ", ";
                        ++n2;
                    }
                    EmbeddedBrowser.this.trace(message);
                }
                try {
                    return EmbeddedBrowser.this.javascriptEntry(arguments);
                }
                catch (Exception e) {
                    StatusUtil.log((Object)((Object)this), (Throwable)e);
                    JSONObject retVal = EmbeddedBrowser.createExceptionData(e);
                    return EmbeddedBrowser.this.serialize(retVal);
                }
            }
        };
    }

    private BrowserFunction createLogFunction() {
        return new BrowserFunction(this.browser, "eclipselog"){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public Object function(Object[] arguments) {
                if (EmbeddedBrowser.this.isTracingEnabled()) {
                    String message = "Entry point eclipselog invoked with parameters: ";
                    Object[] objectArray = arguments;
                    int n = arguments.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object object = objectArray[n2];
                        message = String.valueOf(message) + object + ", ";
                        ++n2;
                    }
                    EmbeddedBrowser.this.trace(message);
                }
                try {
                    String type = (String)arguments[0];
                    Object[] parameters = (Object[])arguments[1];
                    int statusType = 4;
                    if (type.equals("info")) {
                        if (EmbeddedBrowser.this.url != null && EmbeddedBrowser.this.url.indexOf("?debug=true") == -1) {
                            return null;
                        }
                        statusType = 1;
                    } else if (type.equals("warn")) {
                        statusType = 2;
                    } else if (type.equals("error")) {
                        statusType = 4;
                    } else if (type.equals("windowerror")) {
                        if (parameters.length >= 4 && parameters[0] instanceof String && parameters[1] instanceof String && parameters[2] instanceof Number && parameters[3] instanceof Number) {
                            String msg = parameters[0].toString();
                            String file = parameters[1].toString();
                            int line = ((Number)parameters[2]).intValue();
                            int column = ((Number)parameters[3]).intValue();
                            Status status = new Status(4, "com.ibm.team.filesystem.ide.ui", String.valueOf(msg) + " file:" + file + ":" + line + ":" + column);
                            UiPlugin.getDefault().getLog().log((IStatus)status);
                            return null;
                        }
                        UiPlugin.getDefault().getLog().log((IStatus)new Status(4, "com.ibm.team.filesystem.ide.ui", "Embedded browser error: " + parameters[0].toString()));
                        return null;
                    }
                    StringBuffer logMessage = new StringBuffer();
                    Object[] objectArray = parameters;
                    int n = parameters.length;
                    int n3 = 0;
                    while (true) {
                        if (n3 >= n) {
                            UiPlugin.getDefault().getLog().log((IStatus)new Status(statusType, "com.ibm.team.filesystem.ide.ui", logMessage.toString()));
                            return null;
                        }
                        Object o = objectArray[n3];
                        if (!(o instanceof Object[] && ((Object[])o).length == 0 || o instanceof String && ((String)o).isEmpty())) {
                            if (logMessage.length() != 0) {
                                logMessage.append(' ');
                            }
                            if (o instanceof Object[]) {
                                logMessage.append(Arrays.toString((Object[])o));
                            } else {
                                logMessage.append(o.toString());
                            }
                        }
                        ++n3;
                    }
                }
                catch (Exception e) {
                    UiPlugin.getDefault().getLog().log((IStatus)new Status(4, "com.ibm.team.filesystem.ide.ui", e.getMessage(), (Throwable)e));
                }
                return null;
            }
        };
    }

    private void installEclipseConsole() {
        if (this.browser.getUrl() == null || this.browser.getUrl().startsWith("about:")) {
            return;
        }
        StringBuilder script = new StringBuilder();
        script.append("if (!('_eclipsefilterdomnodes' in window)) {                                 ");
        script.append("   _eclipsefilterdomnodes = function(input) {                                ");
        script.append("      for (var idx = 0; idx < input.length; idx++) {                         ");
        script.append("         if (typeof input[idx] === 'object') {                               ");
        script.append("            if (('message' in input[idx]) && ('filename' in input[idx]) &&   ");
        script.append("                ('lineno' in input[idx]) && ('colno' in input[idx]))         ");
        script.append("            {                                                                ");
        script.append("               input[idx] = input[idx].message + ' ' + input[idx].filename   ");
        script.append("                  + ':' + input[idx].lineno + ':' + input[idx].colno;        ");
        script.append("            } else {                                                         ");
        script.append("               input[idx] = JSON.stringify(input[idx]);                      ");
        script.append("            }                                                                ");
        script.append("         }                                                                   ");
        script.append("      }                                                                      ");
        if (this.isEdge()) {
            script.append("      return [...input];                                                     ");
        } else {
            script.append("      return input;                                                          ");
        }
        script.append("   };                                                                        ");
        script.append("}                                                                            ");
        script.append("if (!('_eclipsewindowhandler' in window)) { _eclipsewindowhandler = function() { eclipselog('windowerror', _eclipsefilterdomnodes(arguments)); }; }");
        script.append("if (!('_eclipselog' in window))   {_eclipselog   = function() { eclipselog('info',  _eclipsefilterdomnodes(arguments)); };}");
        script.append("if (!('_eclipsedebug' in window)) {_eclipsedebug = function() { eclipselog('info',  _eclipsefilterdomnodes(arguments)); };}");
        script.append("if (!('_eclipseerror' in window)) {_eclipseerror = function() { eclipselog('error', _eclipsefilterdomnodes(arguments)); };}");
        script.append("if (!('_eclipseinfo' in window))  {_eclipseinfo  = function() { eclipselog('info',  _eclipsefilterdomnodes(arguments)); };}");
        script.append("if (!('_eclipsewarn' in window))  {_eclipsewarn  = function() { eclipselog('warn',  _eclipsefilterdomnodes(arguments)); };}");
        script.append("if (!('firebuglite' in console)) { console.error = _eclipseerror; }");
        script.append("if (!('firebuglite' in console)) { console.warn  = _eclipsewarn;  }");
        script.append("if (!('firebuglite' in console)) { console.log   = _eclipselog;   }");
        script.append("if (!('firebuglite' in console)) { console.info  = _eclipseinfo;  }");
        script.append("if (!('firebuglite' in console)) { console.debug = _eclipsedebug; }");
        script.append("window.onerror = _eclipsewindowhandler;                     ");
        script.append("window.removeEventListener('error', _eclipsewindowhandler); ");
        script.append("window.addEventListener('error', _eclipsewindowhandler);    ");
        script.append("window.alert = _eclipseerror;");
        script.append("if ('_consoleStack' in window) {                                                           ");
        script.append("   _consoleStack.forEach(function(entry) { console[entry[0]].apply(console, entry[1]); }); ");
        script.append("   window._consoleStack = [];                                                              ");
        script.append("}                                                                                          ");
        script.append("if ('_errorStack' in window) {                                                             ");
        script.append("   _errorStack.forEach(function(entry)   { window.onerror.apply(window, entry); });        ");
        script.append("   window._errorStack = [];                                                                ");
        script.append("}                                                                                          ");
        if (!this.browser.execute(script.toString())) {
            UiPlugin.getDefault().getLog().log((IStatus)new Status(4, "com.ibm.team.filesystem.ide.ui", "Unable to install console and error handlers."));
        }
    }

    private boolean isEdge() {
        return (this.browser.getStyle() & 0x40000) != 0;
    }

    private String getBaseUri(ITeamRepository repo) {
        String uriToFix = repo.getRepositoryURI();
        if (uriToFix.endsWith("/")) {
            uriToFix = uriToFix.substring(0, uriToFix.length() - 1);
        }
        if (uriToFix.endsWith("/secure")) {
            uriToFix = uriToFix.substring(0, uriToFix.length() - "/secure".length());
        }
        String uri = uriToFix;
        return uri;
    }

    public void setRepository(ITeamRepository newRepository) {
        ITeamRepository oldRepository = this.repository;
        if (this.repository != null) {
            this.repository.removeLoginParticipant((ITeamRepository.ILoginParticipant)this);
        }
        this.repository = newRepository;
        newRepository.addLoginParticipant((ITeamRepository.ILoginParticipant)this);
        this.updateBrowserCredentials(newRepository);
        if (oldRepository == null || !oldRepository.getRepositoryURI().equals(newRepository.getRepositoryURI())) {
            this.determineAuthURLs(newRepository);
        }
        for (EmbeddedFunction function : this.functions.values()) {
            function.setRepository(newRepository);
        }
    }

    private void updateBrowserCredentials(ITeamRepository repository) {
        if (repository == null) {
            return;
        }
        if (this.isTracingEnabled()) {
            this.trace(NLS.bind((String)"Requesting browser credential update for repository {0}", (Object)repository.getRepositoryURI(), (Object[])new Object[0]));
        }
        this.runBrowserOperation(() -> this.internalUpdateBrowserCredentials(repository));
    }

    private void internalUpdateBrowserCredentials(ITeamRepository repository) {
        try {
            if (this.isTracingEnabled()) {
                this.trace(NLS.bind((String)"Starting to update browser credential for repository {0}", (Object)repository.getRepositoryURI(), (Object[])new Object[0]));
            }
            Field teamServerField = TeamRepository.class.getDeclaredField("teamServer");
            teamServerField.setAccessible(true);
            ITeamServer ts = (ITeamServer)teamServerField.get(repository);
            Method getCookieStoreMethod = RemoteTeamServer.class.getDeclaredMethod("getCookieStore", new Class[0]);
            getCookieStoreMethod.setAccessible(true);
            CookieStore store = (CookieStore)getCookieStoreMethod.invoke((Object)ts, new Object[0]);
            for (Cookie cookie : store.getCookies()) {
                String cookieURI;
                String nvp = String.valueOf(cookie.getName()) + "=" + cookie.getValue();
                boolean set = Browser.setCookie((String)nvp, (String)(cookieURI = new URI("https", cookie.getDomain(), cookie.getPath(), null).toString()));
                if (set) continue;
                LoggingHelper.log((IStatus)FileSystemStatusUtil.getStatusFor((int)4, (String)"com.ibm.team.filesystem.ide.ui", (String)("Unable to set cookie: " + nvp), null));
            }
            if (this.isTracingEnabled()) {
                this.trace(NLS.bind((String)"Done updating browser credential for repository {0}", (Object)repository.getRepositoryURI(), (Object[])new Object[0]));
            }
        }
        catch (Exception e) {
            LoggingHelper.log((IStatus)FileSystemStatusUtil.getStatusFor((int)4, (String)"com.ibm.team.filesystem.ide.ui", (String)"Unable to initialize cookies", (Throwable)e));
        }
    }

    private synchronized void startProgress(String jobName) {
        if (this.progressJob != null) {
            this.progressJob.setProgress(100);
            this.progressJob = null;
        }
        if (jobName != null) {
            this.progressJob = new BrowserProgress(jobName);
            this.progressJob.schedule();
        }
    }

    private synchronized void reportProgress(int progress) {
        if (this.progressJob != null) {
            this.progressJob.setProgress(progress);
            if (progress == 100) {
                this.progressJob = null;
            }
        }
    }

    public void changed(ProgressEvent event) {
        if (this.isTracingEnabled()) {
            this.trace("Browser load has in progress: " + event.toString());
        }
        if (event.total > 0) {
            this.reportProgress(event.current / event.total * 100);
        }
    }

    public void completed(ProgressEvent event) {
        if (this.isTracingEnabled()) {
            this.trace("Browser load has completed");
        }
        this.reportProgress(100);
        this.installClientXhrHandler();
        this.installClientItemManager();
    }

    public void setupNetworking() {
        if (this.repository == null) {
            return;
        }
        this.updateBrowserCredentials(this.repository);
        this.setBrowserCreationParticipant(new BrowserCreationParticipant(){

            @Override
            public void configureBrowserOnCreation(Browser b, String baseURI) {
                Browser.setCookie((String)("_richClientNetwork=" + String.valueOf(!EmbeddedBrowser.this.DISABLE_RICH_CLIENT_NETWORKING).toLowerCase()), (String)baseURI);
                Browser.setCookie((String)("_richClientItemManager=" + String.valueOf(!EmbeddedBrowser.this.DISABLE_RICH_CLIENT_NETWORKING).toLowerCase()), (String)baseURI);
            }
        });
        if (this.DISABLE_RICH_CLIENT_NETWORKING) {
            return;
        }
        if (this.richClientXhrFunction != null) {
            this.richClientXhrFunction.dispose();
            this.richClientXhrFunction = null;
        }
        if (this.richClientItemManagerFunction != null) {
            this.richClientItemManagerFunction.dispose();
            this.richClientItemManagerFunction = null;
        }
        if (this.browser == null) {
            return;
        }
        this.richClientXhrFunction = new BrowserFunction(this.browser, "_eclipseClientXhr"){

            public Object function(Object[] arguments) {
                super.function(arguments);
                if (EmbeddedBrowser.this.isTracingEnabled()) {
                    String message = "Entry point _eclipseClientXhr invoked with parameters: ";
                    Object[] objectArray = arguments;
                    int n = arguments.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object object = objectArray[n2];
                        message = String.valueOf(message) + object + ", ";
                        ++n2;
                    }
                    EmbeddedBrowser.this.trace(message);
                }
                if (EmbeddedBrowser.this.repository == null || EmbeddedBrowser.this.browser == null || EmbeddedBrowser.this.browser.isDisposed()) {
                    return 0;
                }
                if (arguments.length != 1) {
                    UiPlugin.getDefault().getLog().log((IStatus)new Status(4, "com.ibm.team.filesystem.ide.ui", "Eclipse rich client xhr called with insufficient arguments."));
                    return 0;
                }
                try {
                    Long requestId = ((Number)arguments[0]).longValue();
                    RichClientRequest request = new RichClientRequest(requestId, this.getBrowser(), EmbeddedBrowser.this.repository, EmbeddedBrowser.this.opRunner);
                    return request.performRequest();
                }
                catch (IOException e1) {
                    UiPlugin.getDefault().getLog().log((IStatus)new Status(4, "com.ibm.team.filesystem.ide.ui", e1.getMessage(), (Throwable)e1));
                    return 0;
                }
            }
        };
        this.richClientItemManagerFunction = new BrowserFunction(this.browser, "_eclipseClientItemManager"){

            public Object function(Object[] arguments) {
                if (EmbeddedBrowser.this.isTracingEnabled()) {
                    String message = "Entry point _eclipseClientItemManager invoked with parameters: ";
                    Object[] objectArray = arguments;
                    int n = arguments.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object object = objectArray[n2];
                        message = String.valueOf(message) + object + ", ";
                        ++n2;
                    }
                    EmbeddedBrowser.this.trace(message);
                }
                if (EmbeddedBrowser.this.repository == null) {
                    return 0;
                }
                if (arguments.length != 1) {
                    UiPlugin.getDefault().getLog().log((IStatus)new Status(4, "com.ibm.team.filesystem.ide.ui", "Eclipse rich client item manager called with insufficient arguments."));
                    return 0;
                }
                final Long requestId = ((Number)arguments[0]).longValue();
                Display display = EmbeddedBrowser.this.browser.getDisplay();
                if (display.isDisposed() || EmbeddedBrowser.this.browser.isDisposed()) {
                    return 0;
                }
                EmbeddedBrowser.this.runBrowserOperation(() -> {
                    if (EmbeddedBrowser.this.browser.isDisposed()) {
                        return;
                    }
                    JSONObject requestObj = null;
                    try {
                        requestObj = JSONObject.parse((Reader)new StringReader((String)EmbeddedBrowser.this.browser.evaluate("return JSON.stringify(_eclipseClientItemManagerRequest[" + requestId + "]);")));
                    }
                    catch (Exception e) {
                        LoggingHelper.log((IStatus)new Status(4, "com.ibm.team.filesystem.ide.ui", e.getMessage(), (Throwable)e));
                    }
                    final String cleanRequest = "_eclipseClientItemManagerRequest[" + requestId + "] = null;";
                    final String deferred = "_eclipseClientItemManagerRequest[" + requestId + "].deferred";
                    final JSONArray itemHandles = (JSONArray)requestObj.get((Object)"itemHandles");
                    final String flags = (String)requestObj.get((Object)"flags");
                    EmbeddedBrowser.this.opRunner.enqueue(Messages.EmbeddedBrowser_PerformRichClientNetworkRequest, (Operation)new RepositoryOperation(EmbeddedBrowser.this.repository){

                        public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, OperationFailedException {
                            if (EmbeddedBrowser.this.browser == null || EmbeddedBrowser.this.browser.isDisposed()) {
                                return;
                            }
                            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                            ArrayList<IItemHandle> nativeItemHandles = new ArrayList<IItemHandle>();
                            Object[] objectArray = itemHandles.toArray();
                            int n = objectArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                Object o = objectArray[n2];
                                JSONObject itemHandle = (JSONObject)o;
                                UUID itemId = UUID.valueOf((String)((String)itemHandle.get((Object)"itemId")));
                                IItemType itemType = IItemType.IRegistry.INSTANCE.getItemType((String)itemHandle.get((Object)"itemType"), (String)itemHandle.get((Object)"itemNs"));
                                if (itemType != null) {
                                    IItemHandle nativeItemHandle = itemType.createItemHandle(itemId, null);
                                    nativeItemHandles.add(nativeItemHandle);
                                }
                                ++n2;
                            }
                            int nativeFlags = 0;
                            if (flags != null && flags.contains("refresh")) {
                                nativeFlags |= 1;
                            }
                            Throwable exception = null;
                            List fetchedItems = Collections.emptyList();
                            try {
                                fetchedItems = EmbeddedBrowser.this.repository.itemManager().fetchCompleteItems(nativeItemHandles, nativeFlags, (IProgressMonitor)progress.newChild(10));
                            }
                            catch (TeamRepositoryException e) {
                                if (e instanceof NotLoggedInException) {
                                    try {
                                        EmbeddedBrowser.this.repository.login((IProgressMonitor)progress.newChild(10));
                                        fetchedItems = EmbeddedBrowser.this.repository.itemManager().fetchCompleteItems(nativeItemHandles, nativeFlags, (IProgressMonitor)progress.newChild(10));
                                    }
                                    catch (TeamRepositoryException e1) {
                                        e = e1;
                                    }
                                }
                                LoggingHelper.log((IStatus)new Status(4, "com.ibm.team.filesystem.ide.ui", e.getMessage(), (Throwable)e));
                                exception = e;
                            }
                            StringWriter writer = new StringWriter();
                            JSONArray resultItems = new JSONArray();
                            EObjectJSONMarshaller marshaller = (EObjectJSONMarshaller)MarshalFactory.eINSTANCE.getMarshaller(MarshallerType.JSON_LITERAL);
                            int i = 0;
                            while (i < nativeItemHandles.size()) {
                                IItem item = null;
                                IItemHandle handle = (IItemHandle)nativeItemHandles.get(i);
                                if (handle == null) {
                                    resultItems.add(null);
                                } else {
                                    for (IItem fetchedItem : fetchedItems) {
                                        if (fetchedItem == null || !fetchedItem.getItemId().equals((Object)((IItemHandle)nativeItemHandles.get(i)).getItemId())) continue;
                                        item = fetchedItem;
                                        break;
                                    }
                                    if (item == null) {
                                        resultItems.add(null);
                                    } else {
                                        try {
                                            JSONObject json = (JSONObject)marshaller.marshalObjectToJSON(item);
                                            resultItems.add((Object)json);
                                        }
                                        catch (Exception e) {
                                            LoggingHelper.log((IStatus)new Status(4, "com.ibm.team.filesystem.ide.ui", e.getMessage(), (Throwable)e));
                                            exception = e;
                                        }
                                    }
                                }
                                ++i;
                            }
                            try {
                                resultItems.serialize((Writer)writer);
                                writer.close();
                            }
                            catch (IOException e) {
                                LoggingHelper.log((IStatus)new Status(4, "com.ibm.team.filesystem.ide.ui", e.getMessage(), (Throwable)e));
                                exception = e;
                            }
                            byte[] b = new byte[]{};
                            try {
                                b = Base64.encode((byte[])writer.toString().getBytes("UTF-8"));
                            }
                            catch (UnsupportedEncodingException e) {
                                LoggingHelper.log((IStatus)new Status(4, "com.ibm.team.filesystem.ide.ui", e.getMessage(), (Throwable)e));
                                exception = e;
                            }
                            byte[] bodyBytes = b;
                            final String request = "_eclipseClientItemManagerRequest[" + requestId + "]";
                            String payload = "_eclipseClientItemManagerRequest[" + requestId + "].payload";
                            Throwable exceptionFinal = exception;
                            Display display = EmbeddedBrowser.this.browser.getDisplay();
                            if (display.isDisposed() || EmbeddedBrowser.this.browser.isDisposed()) {
                                return;
                            }
                            display.asyncExec(new Runnable((Exception)exceptionFinal, payload, bodyBytes, display, deferred, cleanRequest){
                                private final /* synthetic */ Exception val$exceptionFinal;
                                private final /* synthetic */ String val$payload;
                                private final /* synthetic */ byte[] val$bodyBytes;
                                private final /* synthetic */ Display val$display;
                                private final /* synthetic */ String val$deferred;
                                private final /* synthetic */ String val$cleanRequest;
                                {
                                    this.val$exceptionFinal = exception;
                                    this.val$payload = string2;
                                    this.val$bodyBytes = byArray;
                                    this.val$display = display;
                                    this.val$deferred = string3;
                                    this.val$cleanRequest = string4;
                                }

                                @Override
                                public void run() {
                                    if (EmbeddedBrowser.this.browser.isDisposed()) {
                                        return;
                                    }
                                    boolean checkRequest = (Boolean)EmbeddedBrowser.this.browser.evaluate("return ('_eclipseClientItemManagerRequest' in window) && typeof " + request + " != undefined;");
                                    if (!checkRequest) {
                                        return;
                                    }
                                    if (this.val$exceptionFinal == null) {
                                        int chunkSize = 4096;
                                        boolean success = EmbeddedBrowser.this.browser.execute(String.valueOf(this.val$payload) + " = '';");
                                        int i = 0;
                                        while (i < this.val$bodyBytes.length / chunkSize + 1) {
                                            if (EmbeddedBrowser.this.browser.isDisposed() || this.val$display.isDisposed()) {
                                                return;
                                            }
                                            if (!(success &= EmbeddedBrowser.this.browser.execute(String.valueOf(this.val$payload) + " += '" + new String(Arrays.copyOfRange(this.val$bodyBytes, i * chunkSize, Math.min(this.val$bodyBytes.length, (i + 1) * chunkSize))) + "'"))) {
                                                LoggingHelper.log((IStatus)new Status(4, "com.ibm.team.filesystem.ide.ui", "Unable to transfer block of text for rich client item manager to the web browser."));
                                                EmbeddedBrowser.this.browser.execute(String.valueOf(this.val$deferred) + ".reject({'status':500, 'message':'Unable to transfer block of text for rich client item manager to the web browser.'});");
                                                EmbeddedBrowser.this.browser.execute(this.val$cleanRequest);
                                                return;
                                            }
                                            this.val$display.readAndDispatch();
                                            ++i;
                                        }
                                        EmbeddedBrowser.this.browser.execute(String.valueOf(this.val$payload) + " = JSON.parse(window.atob(" + this.val$payload + "));");
                                        EmbeddedBrowser.this.browser.execute(String.valueOf(this.val$deferred) + ".resolve(" + this.val$payload + ");");
                                        EmbeddedBrowser.this.browser.execute(this.val$cleanRequest);
                                    } else {
                                        EmbeddedBrowser.this.browser.execute(String.valueOf(this.val$deferred) + ".reject({'status':500, 'message':'" + this.val$exceptionFinal.getMessage() + "'});");
                                        EmbeddedBrowser.this.browser.execute(this.val$cleanRequest);
                                    }
                                }
                            });
                        }
                    });
                });
                return 1;
            }
        };
    }

    private void tweakSafari() {
        Field webBrowserField = null;
        try {
            webBrowserField = this.browser.getClass().getDeclaredField("webBrowser");
            webBrowserField.setAccessible(true);
        }
        catch (NoSuchFieldException e1) {
            return;
        }
        catch (SecurityException e1) {
            return;
        }
        Object webBrowser = null;
        try {
            webBrowser = webBrowserField.get(this.browser);
        }
        catch (IllegalArgumentException e1) {
            return;
        }
        catch (IllegalAccessException e1) {
            return;
        }
        Class<?> browserClass = webBrowser.getClass();
        if ("macosx".equals(Platform.getOS())) {
            try {
                Class<?> webViewClass = browserClass.getClassLoader().loadClass("org.eclipse.swt.internal.cocoa.WebView");
                Class<?> nssStringClass = browserClass.getClassLoader().loadClass("org.eclipse.swt.internal.cocoa.NSString");
                Method setApplicationNameForUserAgentMethod = webViewClass.getDeclaredMethod("setApplicationNameForUserAgent", nssStringClass);
                Field webViewField = browserClass.getDeclaredField("webView");
                Method nssStringWith = nssStringClass.getDeclaredMethod("stringWith", String.class);
                webViewField.setAccessible(true);
                Object webView = webViewField.get(webBrowser);
                Object nsString = nssStringWith.invoke(nssStringClass, "Version/7 Safari/601.3.9");
                setApplicationNameForUserAgentMethod.invoke(webView, nsString);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (NoSuchFieldException noSuchFieldException) {
            }
            catch (SecurityException securityException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
    }

    public void addLocationListener(LocationListener l) {
        if (this.browser != null) {
            this.browser.addLocationListener(l);
        }
    }

    public boolean shouldAllowLocationChange(LocationEvent event) {
        String location = event.location;
        if (location == null || location.length() == 0) {
            return true;
        }
        for (String prefix : this.allowedPrefixes) {
            if (!location.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    protected String javascriptEntry(Object[] arguments) {
        JSONObject args;
        JSONObject error;
        if (this.browser == null || this.browser.isDisposed() || this.browser.getDisplay().isDisposed()) {
            error = new JSONObject();
            error.put((Object)OUTGOING_RESULT, (Object)RESULT_PROTOCOL_ERROR);
            error.put((Object)OUTGOING_ERROR_MESSAGE, (Object)Messages.EmbeddedBrowser_ERROR_BROWSER_IS_DISPOSED);
        }
        if (arguments.length != 1) {
            error = new JSONObject();
            error.put((Object)OUTGOING_RESULT, (Object)RESULT_PROTOCOL_ERROR);
            error.put((Object)OUTGOING_ERROR_MESSAGE, (Object)Messages.EmbeddedBrowser_ERROR_NEED_ONE_ARGUMENT);
            return this.serialize(error);
        }
        try {
            args = JSONObject.parse((Reader)new StringReader((String)arguments[0]));
        }
        catch (IOException e) {
            JSONObject error2 = new JSONObject();
            error2.put((Object)OUTGOING_RESULT, (Object)RESULT_PROTOCOL_ERROR);
            error2.put((Object)OUTGOING_ERROR_MESSAGE, (Object)Messages.EmbeddedBrowser_ERROR_ARG_PARSE_ERROR);
            return this.serialize(error2);
        }
        JSONObject retVal = new JSONObject();
        Object op = args.get((Object)INCOMING_OP);
        if (INCOMING_OP_CALL.equals(op)) {
            boolean callbackRequested;
            final BrowserArguments callArgs = new BrowserArguments((IJSONSerializable)args.get((Object)INCOMING_ARGS));
            final String fnName = (String)args.get((Object)INCOMING_CALL_NAME);
            final EmbeddedFunction fn = this.functions.get(fnName);
            if (fn == null) {
                JSONObject error3 = new JSONObject();
                error3.put((Object)OUTGOING_RESULT, (Object)RESULT_NAME_LOOKUP_FAIL);
                return this.serialize(error3);
            }
            final String retCallback = (String)args.get((Object)INCOMING_RETURN_CALLBACK);
            final String requestID = (String)args.get((Object)"requestId");
            final Display currentDisplay = this.browser.getDisplay();
            boolean bl = callbackRequested = retCallback != null;
            if (retCallback != null && requestID == null) {
                JSONObject error4 = new JSONObject();
                error4.put((Object)OUTGOING_RESULT, (Object)RESULT_PROTOCOL_ERROR);
                error4.put((Object)OUTGOING_ERROR_MESSAGE, (Object)Messages.EmbeddedBrowser_ERROR_MISSING_ASYNC_CALL_ID);
                return this.serialize(error4);
            }
            retVal.put((Object)OUTGOING_RESULT, (Object)RESULT_SUCCEEDED);
            if (currentDisplay.isDisposed() || this.browser.isDisposed()) {
                JSONObject error5 = new JSONObject();
                error5.put((Object)OUTGOING_RESULT, (Object)RESULT_PROTOCOL_ERROR);
                error5.put((Object)OUTGOING_ERROR_MESSAGE, (Object)Messages.EmbeddedBrowser_ERROR_BROWSER_IS_DISPOSED);
            }
            currentDisplay.asyncExec(new Runnable(){

                @Override
                public void run() {
                    block3: {
                        if (EmbeddedBrowser.this.browser.isDisposed()) {
                            return;
                        }
                        EmbeddedFunctionCallback callback = new EmbeddedFunctionCallback(){

                            @Override
                            public void setResult(JSONObject result, Exception error) {
                                JSONObject resultToReport;
                                if (currentDisplay.isDisposed() || EmbeddedBrowser.this.browser.isDisposed()) {
                                    return;
                                }
                                if (!callbackRequested) {
                                    UiPlugin.getDefault().getLog().log((IStatus)new Status(2, "com.ibm.team.filesystem.ide.ui", "Function call to " + fnName + " does not expect a return value."));
                                }
                                if (error == null) {
                                    resultToReport = new JSONObject();
                                    resultToReport.put((Object)EmbeddedBrowser.OUTGOING_RESULT, (Object)EmbeddedBrowser.RESULT_SUCCEEDED);
                                    resultToReport.put((Object)EmbeddedBrowser.OUTGOING_RETURN, (Object)result);
                                } else {
                                    UiPlugin.getDefault().getLog().log((IStatus)new Status(4, "com.ibm.team.filesystem.ide.ui", error.getMessage(), (Throwable)error));
                                    resultToReport = EmbeddedBrowser.createExceptionData(error);
                                }
                                resultToReport.put((Object)"requestId", (Object)requestID);
                                if (callbackRequested) {
                                    final String script = String.valueOf(retCallback) + "('" + EmbeddedBrowser.this.serialize(resultToReport) + "');";
                                    currentDisplay.asyncExec(new Runnable(){

                                        @Override
                                        public void run() {
                                            if (!EmbeddedBrowser.this.browser.isDisposed()) {
                                                EmbeddedBrowser.this.browser.execute(script);
                                            }
                                        }
                                    });
                                }
                            }
                        };
                        try {
                            fn.run(EmbeddedBrowser.this, fnName, callArgs, callback);
                        }
                        catch (Exception e) {
                            UiPlugin.getDefault().getLog().log((IStatus)new Status(4, "com.ibm.team.filesystem.ide.ui", e.getMessage(), (Throwable)e));
                            if (!callbackRequested) break block3;
                            JSONObject errorToReport = EmbeddedBrowser.createExceptionData(e);
                            errorToReport.put((Object)"requestId", (Object)requestID);
                            String script = String.valueOf(retCallback) + "('" + EmbeddedBrowser.this.serialize(errorToReport) + "');";
                            EmbeddedBrowser.this.browser.execute(script);
                        }
                    }
                }
            });
        } else if (INCOMING_OP_GET_FUNCTIONS.equals(op)) {
            retVal.put((Object)OUTGOING_RESULT, (Object)RESULT_SUCCEEDED);
            this.doGetNames(retVal);
        } else {
            retVal.put((Object)OUTGOING_RESULT, (Object)RESULT_PROTOCOL_ERROR);
            retVal.put((Object)OUTGOING_ERROR_MESSAGE, (Object)NLS.bind((String)Messages.EmbeddedBrowser_ERROR_UNKNOWN_OP, (Object)op, (Object[])new Object[0]));
        }
        return this.serialize(retVal);
    }

    private void doGetNames(JSONObject retVal) {
        JSONObject names = new JSONObject();
        for (String name : this.functions.keySet()) {
            names.put((Object)name, (Object)name);
        }
        retVal.put((Object)OUTGOING_RETURN, (Object)names);
    }

    private static JSONObject createExceptionData(Exception e) {
        JSONObject retVal = new JSONObject();
        JSONArray jsonException = new JSONArray();
        StackTraceElement[] stackTraceElementArray = e.getStackTrace();
        int n = stackTraceElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            StackTraceElement stackEntry = stackTraceElementArray[n2];
            String stackMessage = stackEntry.toString();
            jsonException.add((Object)stackMessage);
            ++n2;
        }
        retVal.put((Object)OUTGOING_EXCEPTION, (Object)jsonException);
        retVal.put((Object)OUTGOING_RESULT, (Object)RESULT_EXCEPTION_ERROR);
        if (e.getMessage() != null) {
            retVal.put((Object)OUTGOING_ERROR_MESSAGE, (Object)e.getMessage());
        } else {
            retVal.put((Object)OUTGOING_ERROR_MESSAGE, (Object)e.getClass().getName());
        }
        return retVal;
    }

    private String serialize(JSONObject returnObj) {
        StringWriter writer = new StringWriter();
        try {
            returnObj.serialize((Writer)writer);
        }
        catch (IOException e) {
            LoggingHelper.error((String)"com.ibm.team.filesystem.rcp.ui", (String)"Exception serializing message", (Throwable)e);
            return "{'exception_message': 'failedToSerialize'}";
        }
        return writer.toString();
    }

    public void addCallback(String javascriptName, EmbeddedFunction fn) {
        if (this.isCurrentlyDisplayed()) {
            throw new IllegalStateException(Messages.EmbeddedBrowser_ERROR_INIT_ERROR);
        }
        this.functions.put(javascriptName, fn);
    }

    public void setUrl(String url) {
        this.setUrl(url, null);
    }

    public void setUrl(String url, String jobName) {
        this.url = url;
        this.jobName = jobName;
        if (this.isTracingEnabled()) {
            this.trace(NLS.bind((String)"URL set to {0}", (Object)url, (Object[])new Object[0]));
        }
        this.update();
    }

    private void update() {
        if (this.browser == null) {
            String text = this.apology.getText();
            if (text != null) {
                if (text.indexOf(Messages.EmbeddedBrowser_APOLOGY_WITH_LINK) == -1) {
                    this.apology.setText(String.valueOf(text) + Messages.EmbeddedBrowser_APOLOGY_WITH_LINK);
                }
            } else {
                this.apology.setText(Messages.EmbeddedBrowser_APOLOGY_WITH_LINK);
            }
            this.apology.getParent().layout();
            return;
        }
        if (this.url == null) {
            this.browser.setText(NLS.bind((String)"<html><body>{0}</body></html>", (Object)this.noUrlApology, (Object[])new Object[0]));
        } else {
            this.repositoryRunWithProgress(this.jobName, new Runnable(){

                @Override
                public void run() {
                    if (EmbeddedBrowser.this.creationParticipant != null) {
                        EmbeddedBrowser.this.creationParticipant.configureBrowserOnCreation(EmbeddedBrowser.this.browser, EmbeddedBrowser.this.getBaseUri(EmbeddedBrowser.this.repository));
                    }
                    EmbeddedBrowser.this.browser.setUrl(EmbeddedBrowser.this.url);
                    if (EmbeddedBrowser.this.isTracingEnabled()) {
                        EmbeddedBrowser.this.trace(NLS.bind((String)"Updated to URL {0}", (Object)EmbeddedBrowser.this.url, (Object[])new Object[0]));
                    }
                }
            });
        }
    }

    private void repositoryRunWithProgress(final String jobName, final Runnable browserRunner) {
        if (this.browser != null && !this.browser.isDisposed()) {
            final Display display = this.browser.getDisplay();
            if (this.authDiscoveryComplete && this.repository.loggedIn() || this.opRunner == null) {
                if (!display.isDisposed()) {
                    display.asyncExec(() -> {
                        this.startProgress(jobName);
                        browserRunner.run();
                    });
                }
            } else {
                this.opRunner.enqueue(jobName, (Operation)new RepositoryOperation(this.repository){

                    public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, OperationFailedException {
                        if (!display.isDisposed()) {
                            display.asyncExec(() -> {
                                EmbeddedBrowser.this.startProgress(jobName);
                                browserRunner.run();
                            });
                        }
                    }
                });
            }
        }
    }

    private void runBrowserOperation(final Runnable browserRunner) {
        if (this.browser != null && !this.browser.isDisposed()) {
            final Display display = this.browser.getDisplay();
            if (this.authDiscoveryComplete && this.repository.loggedIn() || this.opRunner == null) {
                if (!display.isDisposed()) {
                    display.asyncExec(browserRunner);
                }
            } else {
                this.opRunner.enqueue(this.jobName == null ? "" : this.jobName, (Operation)new RepositoryOperation(this.repository){

                    public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, OperationFailedException {
                        if (!display.isDisposed()) {
                            display.asyncExec(browserRunner);
                        }
                    }
                });
            }
        }
    }

    private boolean isCurrentlyDisplayed() {
        return this.browser != null && this.apology != null;
    }

    public void setNoUrlApology(String string) {
        this.noUrlApology = string;
    }

    public void setBrowserCreationParticipant(BrowserCreationParticipant browserCreationParticipant) {
        this.creationParticipant = browserCreationParticipant;
    }

    public void dispose() {
        try {
            this.dispose(this.browserFunction);
            this.browserFunction = null;
            this.dispose(this.eclipseLogFunction);
            this.eclipseLogFunction = null;
            this.dispose(this.richClientXhrFunction);
            this.richClientXhrFunction = null;
            this.dispose(this.richClientItemManagerFunction);
            this.richClientItemManagerFunction = null;
            if (this.browser != null && !this.browser.isDisposed()) {
                this.browser.dispose();
                this.browser = null;
            }
        }
        finally {
            if (this.repository != null) {
                this.repository.removeLoginParticipant((ITeamRepository.ILoginParticipant)this);
                this.repository = null;
            }
        }
    }

    private void dispose(BrowserFunction function) {
        if (function == null) {
            return;
        }
        try {
            function.dispose();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void refresh(final String targetUrl, String refreshJobName) {
        if (this.browser != null) {
            if (this.isTracingEnabled()) {
                this.trace(NLS.bind((String)"Refresh of {1} requested for repository {0}", (Object)(this.repository == null ? "<no repository>" : this.repository.getRepositoryURI()), (Object[])new Object[]{targetUrl}));
            }
            this.repositoryRunWithProgress(refreshJobName, new Runnable(){

                @Override
                public void run() {
                    if (EmbeddedBrowser.this.isTracingEnabled()) {
                        EmbeddedBrowser.this.trace(NLS.bind((String)"Starting refresh of {1} for repository {0}", (Object)(EmbeddedBrowser.this.repository == null ? "<no repository>" : EmbeddedBrowser.this.repository.getRepositoryURI()), (Object[])new Object[]{targetUrl}));
                    }
                    EmbeddedBrowser.this.internalUpdateBrowserCredentials(EmbeddedBrowser.this.repository);
                    if (targetUrl != null) {
                        EmbeddedBrowser.this.url = targetUrl;
                    }
                    if (EmbeddedBrowser.this.browser.getUrl().equals(EmbeddedBrowser.this.url)) {
                        EmbeddedBrowser.this.browser.refresh();
                    } else {
                        EmbeddedBrowser.this.update();
                    }
                    if (EmbeddedBrowser.this.isTracingEnabled()) {
                        EmbeddedBrowser.this.trace(NLS.bind((String)"Refresh of {1} for repository {0} completed", (Object)(EmbeddedBrowser.this.repository == null ? "<no repository>" : EmbeddedBrowser.this.repository.getRepositoryURI()), (Object[])new Object[]{targetUrl}));
                    }
                }
            });
        }
    }

    public Browser getBrowser() {
        return this.browser;
    }

    public void handleLogin(ITeamRepository loggedInRepository) {
        if (this.repository != null && this.repository.getId().equals((Object)loggedInRepository.getId())) {
            this.updateBrowserCredentials(loggedInRepository);
        }
    }

    public void handleLogout(ITeamRepository repository) {
    }

    private void determineAuthURLs(final ITeamRepository repository) {
        if (this.isTracingEnabled()) {
            this.trace(NLS.bind((String)"Requesting determination of authentication URLs for repository {0}", (Object)(repository == null ? "<no repository>" : repository.getRepositoryURI()), (Object[])new Object[0]));
        }
        this.authDiscoveryComplete = false;
        this.opRunner.enqueue(Messages.EmbeddedBrowser_configuringBrowser, (Operation)new RepositoryOperation(repository){

            public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, OperationFailedException {
                if (EmbeddedBrowser.this.isTracingEnabled()) {
                    EmbeddedBrowser.this.trace(NLS.bind((String)"Starting to determine authentication URLs for repository {0}", (Object)(repository == null ? "<no repository>" : repository.getRepositoryURI()), (Object[])new Object[0]));
                }
                EmbeddedBrowser.this.initAllowedPrefixes();
                String repoUrl = repository.getRepositoryURI();
                if (!repoUrl.endsWith("/")) {
                    repoUrl = String.valueOf(repoUrl) + "/";
                }
                IClientLibraryContext context = (IClientLibraryContext)repository;
                IRepositoryRemoteService remoteService = (IRepositoryRemoteService)context.getServiceInterface(IRepositoryRemoteService.class);
                String publicUriRoot = remoteService.getPublicUriRoot();
                String authServerUrl = null;
                try {
                    authServerUrl = EmbeddedBrowser.this.getAuthServer(String.valueOf(repoUrl) + EmbeddedBrowser.AUTHENTICATED_IDENTITY);
                }
                catch (Exception e) {
                    LoggingHelper.log((IStatus)new Status(4, "com.ibm.team.filesystem.ide.ui", e.getMessage(), (Throwable)e));
                }
                if (authServerUrl != null) {
                    EmbeddedBrowser.this.oidcEnabled = true;
                    if (authServerUrl.endsWith(EmbeddedBrowser.JAZZOP_ENDPOINT)) {
                        String authPrefix = authServerUrl.substring(0, authServerUrl.length() - EmbeddedBrowser.JAZZOP_ENDPOINT.length());
                        EmbeddedBrowser.this.allowedPrefixes.add(authPrefix);
                        EmbeddedBrowser.this.allowedPrefixes.add(String.valueOf(repoUrl) + EmbeddedBrowser.JSA_SUFFIX);
                        EmbeddedBrowser.this.allowedPrefixes.add(String.valueOf(repoUrl) + EmbeddedBrowser.OIDC_INTERCEPT_SERVICE);
                        if (publicUriRoot != null) {
                            EmbeddedBrowser.this.allowedPrefixes.add(String.valueOf(publicUriRoot) + "/" + EmbeddedBrowser.JSA_SUFFIX);
                            EmbeddedBrowser.this.allowedPrefixes.add(String.valueOf(publicUriRoot) + "/" + EmbeddedBrowser.OIDC_INTERCEPT_SERVICE);
                        }
                        if (authPrefix.endsWith(EmbeddedBrowser.OIDC_SUFFIX)) {
                            String authServer = authPrefix.substring(0, authPrefix.length() - EmbeddedBrowser.OIDC_SUFFIX.length());
                            EmbeddedBrowser.this.allowedPrefixes.add(String.valueOf(authServer) + EmbeddedBrowser.JAZZOP_SUFFIX);
                        }
                    }
                }
                EmbeddedBrowser.this.authDiscoveryComplete = true;
                if (EmbeddedBrowser.this.isTracingEnabled()) {
                    EmbeddedBrowser.this.trace(NLS.bind((String)"Done determining authentication URLs for repository {0}", (Object)(repository == null ? "<no repository>" : repository.getRepositoryURI()), (Object[])new Object[0]));
                }
            }
        });
    }

    public boolean isOidcEnabled() {
        return this.oidcEnabled;
    }

    String getAuthServer(String url) throws Exception {
        HttpClientBuilder builder = HttpClients.custom().setSSLHostnameVerifier((HostnameVerifier)NoopHostnameVerifier.INSTANCE);
        builder.setSSLContext(new SSLContextBuilder().loadTrustMaterial(null, new TrustStrategy(){

            public boolean isTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
                return true;
            }
        }).build());
        Throwable throwable = null;
        Object var4_5 = null;
        try (CloseableHttpClient client = builder.build();){
            CloseableHttpResponse response = client.execute((HttpUriRequest)new HttpHead(url));
            Header jsaURL = response.getFirstHeader(JSA_AUTH_URL_HEADER);
            String string = jsaURL == null ? null : jsaURL.getValue();
            return string;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void initLogging() {
        if (this.log == null) {
            this.log = LoggingHelper.getLog(this.getClass());
        }
    }

    private boolean isTracingEnabled() {
        this.initLogging();
        return this.log.isTraceEnabled();
    }

    private void trace(String message) {
        this.log.trace((Object)message);
    }

    public static class BrowserArguments {
        private final IJSONSerializable args;

        private BrowserArguments(IJSONSerializable args) {
            this.args = args;
        }

        public <T> T getUntyped(int idx, T undef) {
            try {
                if (this.args instanceof JSONArray) {
                    try {
                        return (T)((JSONArray)this.args).get(idx);
                    }
                    catch (IndexOutOfBoundsException e) {
                        return undef;
                    }
                }
                if (((JSONObject)this.args).containsKey((Object)Integer.toString(idx))) {
                    return (T)((JSONObject)this.args).get((Object)Integer.toString(idx));
                }
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
            return undef;
        }

        public int size() {
            if (this.args instanceof JSONArray) {
                return ((JSONArray)this.args).size();
            }
            if (this.args instanceof JSONObject) {
                return ((JSONObject)this.args).size();
            }
            return 0;
        }
    }

    public static abstract class BrowserCreationParticipant {
        public abstract void configureBrowserOnCreation(Browser var1, String var2);
    }

    private class BrowserProgress
    extends Job {
        private volatile int progress;

        public BrowserProgress(String name) {
            super(name);
            this.progress = 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(IProgressMonitor progressMonitor) {
            SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progressMonitor, (int)100);
            while (EmbeddedBrowser.this.browser != null && !EmbeddedBrowser.this.browser.isDisposed() && !monitor.isCanceled()) {
                int currentProgress;
                BrowserProgress browserProgress = this;
                synchronized (browserProgress) {
                    currentProgress = this.progress;
                }
                try {
                    if (currentProgress < 0 || currentProgress >= 100) break;
                    monitor.setWorkRemaining(100 - currentProgress);
                    Thread.sleep(250L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            monitor.done();
            return new Status(0, "com.ibm.team.filesystem.ide.ui", "");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setProgress(int newProgress) {
            BrowserProgress browserProgress = this;
            synchronized (browserProgress) {
                this.progress = newProgress;
            }
        }
    }

    public static abstract class EmbeddedFunction {
        public abstract void run(EmbeddedBrowser var1, String var2, BrowserArguments var3, EmbeddedFunctionCallback var4);

        protected void setRepository(ITeamRepository repository) {
        }
    }

    public static interface EmbeddedFunctionCallback {
        public void setResult(JSONObject var1, Exception var2);
    }
}

