/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.web.common;

import com.ibm.team.filesystem.client.internal.era.EraDescriptor;
import com.ibm.team.filesystem.client.internal.namespace.EraNamespace;
import com.ibm.team.filesystem.client.internal.namespace.ItemNamespace;
import com.ibm.team.filesystem.client.internal.namespace.WorkspaceNamespace;
import com.ibm.team.internal.filesystem.ui.web.common.EmbeddedBrowser;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IFetchResult;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.json.JSONObject;
import com.ibm.team.repository.common.model.ItemHandle;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.scm.common.IBaseline;
import com.ibm.team.scm.common.IBaselineHandle;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.internal.ChangeHistoryHandle;
import com.ibm.team.scm.common.internal.ScmFactory;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ui.IWorkbenchPartSite;

public abstract class AbstractRichClientHook
extends EmbeddedBrowser.EmbeddedFunction {
    private static final IItemType CHANGE_HISTORY_TYPE = ScmFactory.eINSTANCE.createChangeHistoryHandle().getItemType();
    private ITeamRepository fRepo;
    private final IWorkbenchPartSite fPartSite;
    private final IOperationRunner fOperationRunner;

    public AbstractRichClientHook(ITeamRepository repo, IWorkbenchPartSite site, IOperationRunner operationRunner) {
        this.fRepo = repo;
        this.fPartSite = site;
        this.fOperationRunner = operationRunner;
    }

    public ITeamRepository getRepository() {
        return this.fRepo;
    }

    @Override
    protected void setRepository(ITeamRepository repository) {
        this.fRepo = repository;
    }

    public IWorkbenchPartSite getWorkbenchPartSite() {
        return this.fPartSite;
    }

    public IOperationRunner getOperationRunner() {
        return this.fOperationRunner;
    }

    protected Map<String, IItemHandle> getContext(EmbeddedBrowser.BrowserArguments callArgs, int index) {
        if (index >= callArgs.size()) {
            return null;
        }
        HashMap<String, IItemHandle> context = new HashMap<String, IItemHandle>();
        IItemType[] types = new IItemType[]{IBaseline.ITEM_TYPE, IComponent.ITEM_TYPE, IWorkspace.ITEM_TYPE, CHANGE_HISTORY_TYPE};
        JSONObject json = callArgs.getUntyped(index, null);
        IItemType[] iItemTypeArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            IItemType type = iItemTypeArray[n2];
            if (json.containsKey((Object)type.getName())) {
                UUID id = UUID.valueOf((String)((String)json.get((Object)type.getName())));
                ItemHandle handle = (ItemHandle)type.createItemHandle((Object)this.fRepo, id, null);
                context.put(type.getName(), (IItemHandle)handle);
            }
            ++n2;
        }
        return context;
    }

    protected ItemNamespace getItemNamespace(Map<String, IItemHandle> context, IProgressMonitor monitor) throws TeamRepositoryException {
        if (context == null) {
            return null;
        }
        if (context.containsKey(IBaseline.ITEM_TYPE.getName())) {
            IBaselineHandle baselineHandle = (IBaselineHandle)context.get(IBaseline.ITEM_TYPE.getName());
            IFetchResult result = this.fRepo.itemManager().fetchCompleteItemsPermissionAware(Arrays.asList(baselineHandle), 0, monitor);
            List retrievedItems = result.getRetrievedItems();
            String errorMsg = null;
            if (retrievedItems.size() != 1) {
                errorMsg = "Could not fetch baselines.";
                if (result.getNotFoundItems().size() == 1) {
                    errorMsg = NLS.bind((String)"The baseline with the following UUID was not found on the server: {0}", (Object)((IItemHandle)result.getNotFoundItems().get(0)).getItemId().getUuidValue(), (Object[])new Object[0]);
                } else if (result.getPermissionDeniedItems().size() == 1) {
                    errorMsg = NLS.bind((String)"You do not have permission to fetch the baseline with the following UUID: {0}", (Object)((IItemHandle)result.getNotFoundItems().get(0)).getItemId().getUuidValue(), (Object[])new Object[0]);
                }
            }
            if (errorMsg != null) {
                StatusUtil.log((Object)this, (int)4, (String)errorMsg);
                return null;
            }
            IBaseline baseline = (IBaseline)retrievedItems.get(0);
            return ItemNamespace.getNamespace((ITeamRepository)this.fRepo, (IContextHandle)baseline, (IComponentHandle)baseline.getComponent());
        }
        ChangeHistoryHandle ch = (ChangeHistoryHandle)context.get(CHANGE_HISTORY_TYPE.getName());
        IWorkspaceHandle workspace = (IWorkspaceHandle)context.get(IWorkspace.ITEM_TYPE.getName());
        IComponentHandle component = (IComponentHandle)context.get(IComponent.ITEM_TYPE.getName());
        if (workspace == null || component == null || ch == null) {
            return null;
        }
        WorkspaceNamespace workspaceNamespace = (WorkspaceNamespace)WorkspaceNamespace.create((IWorkspaceHandle)workspace, (IComponentHandle)component);
        return EraNamespace.create((EraDescriptor)EraDescriptor.createStaticDescriptor((WorkspaceNamespace)workspaceNamespace, (ChangeHistoryHandle)ch, (IProgressMonitor)monitor));
    }
}

