/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.structuralchanges.queries;

import com.ibm.team.filesystem.client.internal.ClientConfigurationChangeFactory;
import com.ibm.team.filesystem.client.internal.namespace.ItemNamespace;
import com.ibm.team.filesystem.client.internal.snapshot.FlowType;
import com.ibm.team.filesystem.common.changemodel.ConfigurationChange;
import com.ibm.team.filesystem.common.changemodel.FileChange;
import com.ibm.team.filesystem.common.changemodel.FileState;
import com.ibm.team.filesystem.common.changemodel.IPathResolver;
import com.ibm.team.filesystem.common.changemodel.ResolvedConfigurationChangePaths;
import com.ibm.team.filesystem.common.internal.util.ChangeSetUtil;
import com.ibm.team.filesystem.common.internal.util.SubComponentUtil;
import com.ibm.team.filesystem.ui.wrapper.ChangeSetWrapper;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.patches.ChangeFolder;
import com.ibm.team.internal.filesystem.ui.views.structuralchanges.nodes.StructuralChangesChangeSetNode;
import com.ibm.team.internal.filesystem.ui.views.structuralchanges.nodes.StructuralChangesSubcomponentNode;
import com.ibm.team.internal.filesystem.ui.views.structuralchanges.nodes.StructuralChangesViewFolderNode;
import com.ibm.team.internal.filesystem.ui.views.structuralchanges.nodes.StructuralChangesViewNode;
import com.ibm.team.internal.filesystem.ui.views.structuralchanges.queries.FilesInFolderQuery;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IFetchResult;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.internal.viewers.RepositoryQuery;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.client.internal.RepoFetcher;
import com.ibm.team.scm.common.IChange;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.dto.IVersionablePermissionsReport;
import com.ibm.team.scm.common.internal.FetchedItems;
import com.ibm.team.scm.common.internal.util.StateId;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class RootNodesInChangeSetQuery
extends RepositoryQuery<StructuralChangesViewNode> {
    private StructuralChangesChangeSetNode node;
    private ChangeSetWrapper wrapper;
    private FlowType type;
    private IPathResolver pathResolver;
    private ItemNamespace namespace;
    private boolean showSubcomponentNodes;

    public RootNodesInChangeSetQuery(ChangeSetWrapper wrapper, FlowType type, IPathResolver pathResolver, ItemNamespace namespace, IOperationRunner runner, boolean showSubcomponentNodes) {
        super(wrapper.getRepository(), runner);
        this.wrapper = wrapper;
        this.type = type;
        this.pathResolver = pathResolver;
        this.namespace = namespace;
        this.showSubcomponentNodes = showSubcomponentNodes;
    }

    public RootNodesInChangeSetQuery(IPathResolver pathResolver, IOperationRunner runner, StructuralChangesChangeSetNode node, boolean showSubcomponentNodes) {
        this(node.getWrapper(), node.getType(), pathResolver, node.getNamespace(), runner, showSubcomponentNodes);
        this.node = node;
    }

    protected void attachListeners() {
    }

    protected void detachListeners() {
    }

    private void removeInaccessibleVersionables(ITeamRepository repo, IComponentHandle component, Map<UUID, IVersionableHandle> versionables, IProgressMonitor monitor) throws TeamRepositoryException {
        IVersionablePermissionsReport[] reports;
        IWorkspaceManager workspaceManager = SCMPlatform.getWorkspaceManager((ITeamRepository)repo);
        IVersionablePermissionsReport[] iVersionablePermissionsReportArray = reports = workspaceManager.getPermissions(versionables.values().toArray(new IVersionableHandle[versionables.size()]), component, monitor);
        int n = reports.length;
        int n2 = 0;
        while (n2 < n) {
            IVersionablePermissionsReport report = iVersionablePermissionsReportArray[n2];
            if (report.isReportOfInaccessible()) {
                for (Object id : report.getItemsIds()) {
                    versionables.remove(id);
                }
            }
            ++n2;
        }
    }

    private Collection<StateId<IVersionable>> getAffectedVersionables(List<?> changes, Map<UUID, IVersionableHandle> versionables) {
        HashSet<StateId<IVersionable>> toFetch = new HashSet<StateId<IVersionable>>();
        for (Object change : changes) {
            IChange c = (IChange)change;
            IVersionableHandle handle = c.item();
            if (!versionables.containsKey(handle.getItemId())) continue;
            toFetch.addAll(ChangeSetUtil.getBeforeStates((IChange)c));
            toFetch.add((StateId<IVersionable>)ChangeSetUtil.getAfterState((IChange)c));
        }
        return toFetch;
    }

    public String getName() {
        return Messages.FoldersInChangeSetQuery_queryName;
    }

    protected List<StructuralChangesViewNode> fetchResult(boolean needsRefresh, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(this.showSubcomponentNodes ? 130 : 100));
        ITeamRepository repo = this.getRepository();
        IChangeSet changeSet = this.wrapper.getChangeSet();
        List changes = changeSet.changes();
        HashMap<UUID, IVersionableHandle> versionables = new HashMap<UUID, IVersionableHandle>();
        for (Object change : changes) {
            IVersionableHandle handle = ((IChange)change).item();
            versionables.put(handle.getItemId(), handle);
        }
        int numVersionables = versionables.size();
        this.removeInaccessibleVersionables(repo, changeSet.getComponent(), versionables, (IProgressMonitor)progress.newChild(25));
        this.node.setInaccessibleChanges(numVersionables - versionables.size());
        if (versionables.isEmpty()) {
            return Collections.emptyList();
        }
        Collection<StateId<IVersionable>> toFetch = this.getAffectedVersionables(changes, versionables);
        FetchedItems fetched = RepoFetcher.fetchItemsWithLinks((ITeamRepository)repo, toFetch, (IProgressMonitor)progress.newChild(20));
        ConfigurationChange change = ClientConfigurationChangeFactory.createChange((FetchedItems)fetched, (ITeamRepository)repo, (IChangeSet)changeSet);
        List<ChangeFolder> folders = ChangeFolder.computeChanges(change.getChanges());
        Iterator<ChangeFolder> iterator = folders.iterator();
        while (iterator.hasNext()) {
            ChangeFolder changeFolder = iterator.next();
            if (!changeFolder.getFolderChanges().isEmpty()) continue;
            boolean shouldSkipAllChildren = true;
            for (FileChange fileChange : changeFolder.getChanges()) {
                if (FilesInFolderQuery.shouldSkipFile(fileChange)) continue;
                shouldSkipAllChildren = false;
                break;
            }
            if (!shouldSkipAllChildren) continue;
            iterator.remove();
        }
        ResolvedConfigurationChangePaths paths = ResolvedConfigurationChangePaths.resolve((IPathResolver)this.pathResolver, (ConfigurationChange)change, (boolean)true, (boolean)true, (IProgressMonitor)progress.newChild(45));
        ArrayList<StructuralChangesViewNode> result = new ArrayList<StructuralChangesViewNode>(folders.size());
        result.addAll(StructuralChangesViewFolderNode.createListFrom(this.namespace, this.node, folders, paths, this.type, (IProgressMonitor)progress.newChild(10)));
        if (this.showSubcomponentNodes) {
            progress.setWorkRemaining(30);
            try {
                try {
                    FileChange subComponentInfoChange = SubComponentUtil.getSubComponentInfoFile((Collection)change.getChanges());
                    if (subComponentInfoChange != null) {
                        IComponent component;
                        Map<UUID, IComponentHandle> beforeSubCompIds = this.extractComponentHandles(repo, subComponentInfoChange.getInitial(), (IProgressMonitor)progress.newChild(10));
                        Map<UUID, IComponentHandle> afterSubCompIds = this.extractComponentHandles(repo, subComponentInfoChange.getFinal(), (IProgressMonitor)progress.newChild(10));
                        HashMap<UUID, IComponentHandle> subCompsAdded = new HashMap<UUID, IComponentHandle>(afterSubCompIds);
                        subCompsAdded.keySet().removeAll(beforeSubCompIds.keySet());
                        HashMap<UUID, IComponentHandle> subCompsRemoved = new HashMap<UUID, IComponentHandle>(beforeSubCompIds);
                        subCompsRemoved.keySet().removeAll(afterSubCompIds.keySet());
                        HashMap<UUID, IComponent> fetchedComponents = new HashMap<UUID, IComponent>();
                        ArrayList handlesToFetch = new ArrayList();
                        handlesToFetch.addAll(subCompsAdded.values());
                        handlesToFetch.addAll(subCompsRemoved.values());
                        IFetchResult fetchResult = repo.itemManager().fetchCompleteItemsPermissionAware(handlesToFetch, 0, (IProgressMonitor)progress.newChild(10));
                        for (Object o : fetchResult.getRetrievedItems()) {
                            if (!(o instanceof IComponent)) continue;
                            IComponent component2 = (IComponent)o;
                            fetchedComponents.put(component2.getItemId(), component2);
                        }
                        StructuralChangesSubcomponentNode.ChangeType changeType = StructuralChangesSubcomponentNode.ChangeType.Addition;
                        for (Map.Entry entry : subCompsAdded.entrySet()) {
                            component = (IComponent)fetchedComponents.get(entry.getKey());
                            result.add(new StructuralChangesSubcomponentNode(repo, (IComponentHandle)entry.getValue(), component, changeType, subComponentInfoChange));
                        }
                        changeType = StructuralChangesSubcomponentNode.ChangeType.Removal;
                        for (Map.Entry entry : subCompsRemoved.entrySet()) {
                            component = (IComponent)fetchedComponents.get(entry.getKey());
                            result.add(new StructuralChangesSubcomponentNode(repo, (IComponentHandle)entry.getValue(), component, changeType, subComponentInfoChange));
                        }
                    }
                }
                catch (IOException e) {
                    StatusUtil.log((Object)((Object)this), (Throwable)e);
                    progress.worked(30);
                }
            }
            finally {
                progress.worked(30);
            }
        }
        return result;
    }

    private Map<UUID, IComponentHandle> extractComponentHandles(ITeamRepository repo, FileState fileState, IProgressMonitor monitor) throws IOException {
        HashMap<UUID, IComponentHandle> result = new HashMap<UUID, IComponentHandle>();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        if (repo != null && fileState != null) {
            List componentIds = SubComponentUtil.extractComponentItemIds((FileState)fileState, (IProgressMonitor)progress.newChild(100));
            for (String compId : componentIds) {
                try {
                    UUID uuid = UUID.valueOf((String)compId);
                    result.put(uuid, (IComponentHandle)IComponent.ITEM_TYPE.createItemHandle((Object)repo, uuid, null));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        progress.done();
        return result;
    }
}

