/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.structuralchanges.queries;

import com.ibm.team.filesystem.client.internal.snapshot.FlowType;
import com.ibm.team.filesystem.ui.wrapper.ChangeSetWrapper;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.views.structuralchanges.nodes.StructuralChangesOriginalPortSourceNode;
import com.ibm.team.internal.filesystem.ui.views.structuralchanges.nodes.StructuralChangesPortSourceNode;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IFetchResult;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.ui.internal.viewers.RepositoryQuery;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.internal.util.NewCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class PortSourceQuery
extends RepositoryQuery<StructuralChangesPortSourceNode> {
    private ChangeSetWrapper fChangeSetWrapper;

    public PortSourceQuery(ITeamRepository repository, ChangeSetWrapper wrapper, IOperationRunner runner) {
        super(repository, runner);
        this.fChangeSetWrapper = wrapper;
    }

    protected List<StructuralChangesPortSourceNode> fetchResult(boolean needsRefresh, IProgressMonitor monitor) throws TeamRepositoryException {
        ArrayList result = NewCollection.arrayList();
        ITeamRepository repo = this.fChangeSetWrapper.getRepository();
        IChangeSet changeSet = this.fChangeSetWrapper.getChangeSet();
        IChangeSetHandle originalChangeSetHandle = changeSet.getOriginalChangeSet();
        IChangeSetHandle sourceChangeSetHandle = changeSet.getSourceChangeSet();
        if (sourceChangeSetHandle != null && !sourceChangeSetHandle.sameItemId(changeSet.getItemHandle())) {
            ChangeSetWrapper wrapper;
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            int refreshFlag = needsRefresh ? 1 : 0;
            IFetchResult fetchedLinks = repo.itemManager().fetchCompleteItemsPermissionAware(Arrays.asList(sourceChangeSetHandle), refreshFlag, (IProgressMonitor)progress.newChild(50));
            for (Object item : fetchedLinks.getRetrievedItems()) {
                if (!(item instanceof IChangeSet)) continue;
                IChangeSet sourceChangeSet = (IChangeSet)item;
                wrapper = new ChangeSetWrapper(repo, sourceChangeSet);
                result.add(new StructuralChangesPortSourceNode(FlowType.Outgoing, wrapper));
                break;
            }
            if (originalChangeSetHandle != null && !originalChangeSetHandle.sameItemId((IItemHandle)sourceChangeSetHandle)) {
                fetchedLinks = repo.itemManager().fetchCompleteItemsPermissionAware(Arrays.asList(originalChangeSetHandle), refreshFlag, (IProgressMonitor)progress.newChild(50));
                for (Object item : fetchedLinks.getRetrievedItems()) {
                    if (!(item instanceof IChangeSet)) continue;
                    IChangeSet originalSourceChangeSet = (IChangeSet)item;
                    wrapper = new ChangeSetWrapper(repo, originalSourceChangeSet);
                    result.add(new StructuralChangesOriginalPortSourceNode(FlowType.Outgoing, wrapper));
                    break;
                }
            }
            progress.done();
        }
        return result;
    }

    public String getName() {
        return Messages.PortSourceQuery_queryName;
    }

    protected void attachListeners() {
    }

    protected void detachListeners() {
    }
}

