/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.structuralchanges.queries;

import com.ibm.team.filesystem.common.internal.util.ComponentHierarchyCompareResult;
import com.ibm.team.filesystem.ui.wrapper.BaselineHierarchyWrapper;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.views.structuralchanges.nodes.StructuralChangesComponentNode;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IFetchResult;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.rcp.ui.internal.viewers.RepositoryQuery;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.scm.common.IBaselineHierarchyNode;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;

public class HierarchicalRootBaselineSetQuery
extends RepositoryQuery<BaselineHierarchyWrapper> {
    private ComponentHierarchyCompareResult compareResult;
    private Map<UUID, StructuralChangesComponentNode> structuralChangesMap = new HashMap<UUID, StructuralChangesComponentNode>();

    public HierarchicalRootBaselineSetQuery(ITeamRepository repository, ComponentHierarchyCompareResult compareResult, IOperationRunner runner) {
        super(repository, runner);
        this.compareResult = compareResult;
    }

    public HierarchicalRootBaselineSetQuery(ITeamRepository repository, ComponentHierarchyCompareResult compareResult, Map<UUID, StructuralChangesComponentNode> structuralChangesMap, IOperationRunner runner) {
        this(repository, compareResult, runner);
        this.structuralChangesMap = structuralChangesMap;
    }

    protected void attachListeners() {
    }

    protected void detachListeners() {
    }

    protected List<BaselineHierarchyWrapper> fetchResult(boolean needsRefresh, IProgressMonitor monitor) throws TeamRepositoryException {
        ArrayList<BaselineHierarchyWrapper> result = new ArrayList<BaselineHierarchyWrapper>();
        HashMap<UUID, IBaselineHierarchyNode> componentIdToHierarchyNodeMap = new HashMap<UUID, IBaselineHierarchyNode>();
        ArrayList<IComponentHandle> componentsToFetch = new ArrayList<IComponentHandle>();
        Collection<IBaselineHierarchyNode> nodes = this.getChildren();
        for (IBaselineHierarchyNode node : nodes) {
            if (!this.shouldIncludeChild(node)) continue;
            componentIdToHierarchyNodeMap.put(node.getComponentHandle().getItemId(), node);
            componentsToFetch.add(node.getComponentHandle());
        }
        IFetchResult fetchedResult = this.getRepository().itemManager().fetchCompleteItemsPermissionAware(componentsToFetch, 0, monitor);
        for (Object item : fetchedResult.getRetrievedItems()) {
            IComponent component;
            IBaselineHierarchyNode node;
            if (!(item instanceof IComponent) || (node = (IBaselineHierarchyNode)componentIdToHierarchyNodeMap.get((component = (IComponent)item).getItemHandle().getItemId())) == null) continue;
            BaselineHierarchyWrapper wrapper = new BaselineHierarchyWrapper(this.getRepository(), component, node);
            if (this.compareResult != null) {
                IComponentHandle parent = this.getCurrentNode() == null ? null : this.getCurrentNode().getComponentHandle();
                IComponent child = component;
                ComponentHierarchyCompareResult.MovedComponentResult moveResult = this.compareResult.getMoveResult(parent, (IComponentHandle)child);
                wrapper.setMoveResult(moveResult);
                wrapper.setStructuralChangesComponentNode(this.structuralChangesMap.get(child.getItemId()));
            }
            result.add(wrapper);
        }
        return result;
    }

    protected IBaselineHierarchyNode getCurrentNode() {
        return null;
    }

    protected Collection<IBaselineHierarchyNode> getChildren() {
        return this.compareResult.getLeftHierarchy().getRoots();
    }

    public String getName() {
        return Messages.HierarchicalRootBaselineSetQuery_Name;
    }

    private boolean shouldIncludeChild(IBaselineHierarchyNode node) {
        if (this.compareResult == null) {
            return true;
        }
        if (this.compareResult.getPrunedComponentIds() == null) {
            return true;
        }
        return this.compareResult.getPrunedComponentIds().contains(node.getComponentHandle().getItemId());
    }
}

