/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.structuralchanges.queries;

import com.ibm.team.filesystem.client.internal.namespace.ItemNamespace;
import com.ibm.team.filesystem.client.internal.snapshot.ComponentSyncReportFragment;
import com.ibm.team.filesystem.client.internal.snapshot.FlowType;
import com.ibm.team.filesystem.client.internal.snapshot.ISnapshot;
import com.ibm.team.filesystem.client.internal.snapshot.SnapshotId;
import com.ibm.team.filesystem.common.changemodel.ConfigurationChange;
import com.ibm.team.filesystem.common.changemodel.IPathResolver;
import com.ibm.team.filesystem.common.changemodel.ResolvedConfigurationChangePaths;
import com.ibm.team.filesystem.rcp.core.internal.rest.util.SyncViewDTOUtil;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.patches.ChangeFolder;
import com.ibm.team.internal.filesystem.ui.views.structuralchanges.nodes.StructuralChangesViewFolderNode;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.ui.internal.viewers.RepositoryQuery;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.internal.util.ItemId;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class FoldersInComponentSyncReportQuery
extends RepositoryQuery<StructuralChangesViewFolderNode> {
    private ComponentSyncReportFragment syncReport;
    private FlowType type;
    private IPathResolver pathResolver;
    private SnapshotId snapshotId;
    private ItemId<IComponent> component;

    public FoldersInComponentSyncReportQuery(ITeamRepository repo, ComponentSyncReportFragment syncReport, FlowType type, IPathResolver pathResolver, SnapshotId snapshotId, ItemId<IComponent> component, IOperationRunner runner) {
        super(repo, runner);
        this.syncReport = syncReport;
        this.type = type;
        this.pathResolver = pathResolver;
        this.snapshotId = snapshotId;
        this.component = component;
    }

    protected void attachListeners() {
    }

    protected void detachListeners() {
    }

    protected List<StructuralChangesViewFolderNode> fetchResult(boolean needsRefresh, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        ISnapshot snapshot = this.snapshotId.getSnapshot((IProgressMonitor)progress.newChild(10));
        ConfigurationChange change = SyncViewDTOUtil.getConfigurationChange((ITeamRepository)snapshot.getRepository(), (ComponentSyncReportFragment)this.syncReport, (boolean)needsRefresh, (IProgressMonitor)progress.newChild(40));
        List<ChangeFolder> folders = ChangeFolder.computeChanges(change.getChanges());
        ResolvedConfigurationChangePaths paths = ResolvedConfigurationChangePaths.resolve((IPathResolver)this.pathResolver, (ConfigurationChange)change, (boolean)true, (boolean)true, (IProgressMonitor)progress.newChild(20));
        ItemNamespace namespace = snapshot.getNamespaceFor(this.component, (IProgressMonitor)progress.newChild(10));
        return StructuralChangesViewFolderNode.createListFrom(namespace, null, folders, paths, this.type, (IProgressMonitor)progress.newChild(20));
    }

    public String getName() {
        return Messages.FoldersInComponentSyncReportQuery_queryName;
    }
}

