/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.structuralchanges.queries;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.namespace.ItemNamespace;
import com.ibm.team.filesystem.client.internal.snapshot.FlowType;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.common.ISymbolicLink;
import com.ibm.team.filesystem.common.changemodel.FileChange;
import com.ibm.team.filesystem.common.changemodel.FileState;
import com.ibm.team.filesystem.rcp.core.internal.CoreShareablesUtil;
import com.ibm.team.filesystem.rcp.ui.internal.RcpUiPlugin;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.views.structuralchanges.nodes.StructuralChangesSubcomponentNode;
import com.ibm.team.internal.filesystem.ui.views.structuralchanges.nodes.StructuralChangesViewFileNode;
import com.ibm.team.internal.filesystem.ui.views.structuralchanges.nodes.StructuralChangesViewFolderNode;
import com.ibm.team.internal.filesystem.ui.views.structuralchanges.nodes.StructuralChangesViewNode;
import com.ibm.team.internal.filesystem.ui.views.structuralchanges.nodes.StructuralChangesViewSymbolicLinkNode;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.internal.viewers.RepositoryQuery;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.dto.IVersionableIdentifier;
import com.ibm.team.scm.common.internal.util.NewCollection;
import com.ibm.team.scm.common.internal.util.SiloedItemId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.preference.IPreferenceStore;

public class FilesInFolderQuery
extends RepositoryQuery<StructuralChangesViewNode> {
    private StructuralChangesViewFolderNode folderNode;
    private boolean useCFA;

    public FilesInFolderQuery(IOperationRunner runner, StructuralChangesViewFolderNode folderNode, boolean useCFA) {
        super(folderNode.getRepository(), runner);
        this.useCFA = useCFA;
        this.folderNode = folderNode;
    }

    protected void attachListeners() {
    }

    protected void detachListeners() {
    }

    protected List<StructuralChangesViewNode> fetchResult(boolean needsRefresh, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        return FilesInFolderQuery.createListFrom(this.folderNode, this.useCFA, (IProgressMonitor)progress);
    }

    public String getName() {
        return Messages.FilesInFolderQuery_queryName;
    }

    static List<StructuralChangesViewNode> createListFrom(StructuralChangesViewFolderNode folder, boolean useCFA, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        Set<FileChange> changes = folder.getChangeFolder().getChanges();
        IPreferenceStore store = RcpUiPlugin.getDefault().getPreferenceStore();
        boolean showVersionIdentifiers = store.getBoolean("pref_show_version_identifiers_change_explorer");
        boolean showRepo = store.getBoolean("pref_show_version_identifiers_repository_id");
        ArrayList result = NewCollection.arrayList();
        HashSet<SiloedItemId> toResolve = new HashSet<SiloedItemId>();
        for (FileChange next : changes) {
            if (FilesInFolderQuery.shouldSkipFile(next)) continue;
            toResolve.add(next.getSiloedItemId());
        }
        HashMap<SiloedItemId, List> shareablesMap = null;
        if (useCFA) {
            shareablesMap = CoreShareablesUtil.findShareables(toResolve, (IProgressMonitor)progress.newChild(50));
        } else {
            shareablesMap = new HashMap<SiloedItemId, List>(toResolve.size());
            for (SiloedItemId siloedItem : toResolve) {
                shareablesMap.put(siloedItem, Collections.EMPTY_LIST);
            }
        }
        progress.setWorkRemaining(2);
        ArrayList<IVersionableHandle> handles = new ArrayList<IVersionableHandle>();
        for (FileChange change : changes) {
            FileState finalState;
            if (FilesInFolderQuery.shouldSkipFile(change) || (finalState = change.getFinal()).isDeleted() || !showVersionIdentifiers) continue;
            handles.add((IVersionableHandle)finalState.getStateId().toHandle());
        }
        IWorkspaceManager workspaceManager = SCMPlatform.getWorkspaceManager((ITeamRepository)folder.getRepository());
        IVersionableIdentifier[] identifiers = workspaceManager.getVersionableIdentifiers(handles.toArray(new IVersionableHandle[handles.size()]), (IProgressMonitor)progress.newChild(1));
        int idx = 0;
        progress.setWorkRemaining(changes.size());
        FlowType type = folder.getType();
        for (FileChange next : changes) {
            if (FilesInFolderQuery.shouldSkipFile(next)) {
                progress.worked(1);
                continue;
            }
            Collection shareables = (Collection)shareablesMap.get(next.getSiloedItemId());
            ItemNamespace nextNamespace = folder.getNamespace();
            if (nextNamespace.isEmpty() && !shareables.isEmpty()) {
                IShareable shareable = (IShareable)shareables.iterator().next();
                try {
                    ItemNamespace contributorPlace = CoreShareablesUtil.getContributorPlace((IShareable)shareable, (IProgressMonitor)progress.newChild(1));
                    if (contributorPlace != null) {
                        nextNamespace = contributorPlace;
                    }
                }
                catch (FileSystemException e) {
                    throw new TeamRepositoryException(e.getMessage(), StatusUtil.getCause((Throwable)e));
                }
            }
            String versionId = null;
            FileState finalState = next.getFinal();
            if (!finalState.isDeleted() && showVersionIdentifiers) {
                if (identifiers[idx] != null) {
                    versionId = showRepo ? identifiers[idx].getLongVersionId() : identifiers[idx].getShortVersionId();
                }
                ++idx;
            }
            IItemType itemType = next.getItemId().getItemType();
            StructuralChangesViewNode node = null;
            if (itemType == ISymbolicLink.ITEM_TYPE) {
                node = new StructuralChangesViewSymbolicLinkNode(folder, next, type, nextNamespace, versionId);
            } else if (itemType == IFileItem.ITEM_TYPE) {
                node = new StructuralChangesViewFileNode(folder, next, type, nextNamespace, versionId);
            } else {
                StatusUtil.log(FilesInFolderQuery.class, (String)"An unexpected versionable has been encountered");
                node = new StructuralChangesViewFileNode(folder, next, type, nextNamespace, versionId);
            }
            result.add(node);
        }
        return result;
    }

    protected static boolean shouldSkipFile(FileChange fileChange) {
        return !StructuralChangesSubcomponentNode.showSubcomponentInfoFile && fileChange != null && fileChange.isSubcomponentChange();
    }
}

