/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.structuralchanges.queries;

import com.ibm.team.filesystem.client.internal.namespace.ItemNamespace;
import com.ibm.team.filesystem.client.internal.snapshot.FlowType;
import com.ibm.team.filesystem.rcp.core.internal.FilteredFetcher;
import com.ibm.team.filesystem.rcp.core.internal.ItemChangeEvent;
import com.ibm.team.filesystem.ui.wrapper.ChangeSetWrapper;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.views.structuralchanges.nodes.StructuralChangesChangeSetNode;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IFetchResult;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.common.IChangeListener;
import com.ibm.team.repository.rcp.common.IRemoteFunction;
import com.ibm.team.repository.rcp.ui.internal.utils.SWTUtil;
import com.ibm.team.repository.rcp.ui.internal.viewers.RepositoryQuery;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.dto.IChangeSetSearchCriteria;
import com.ibm.team.scm.common.internal.util.ItemId;
import com.ibm.team.scm.common.internal.util.ItemLists;
import com.ibm.team.scm.common.internal.util.NewCollection;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class EquivalentChangeSetsQuery
extends RepositoryQuery<StructuralChangesChangeSetNode> {
    private IComponentHandle fComponentHandle;
    private IChangeSetHandle fChangeSetHandle;
    private FlowType fType;
    private IRemoteFunction<ItemNamespace> fNamespaceFunction;
    private int fMaxResults = 100;
    private boolean fAutoRefresh = true;
    private FilteredFetcher fFetcher;
    private IChangeSet fFullChangeSet;
    private IChangeSetSearchCriteria fSearchCriteria;
    private long fCounter = 0L;
    private IChangeListener<FilteredFetcher, List<ItemChangeEvent>> fListener = new IChangeListener<FilteredFetcher, List<ItemChangeEvent>>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void changed(FilteredFetcher source, List<ItemChangeEvent> events) {
            long timestamp;
            EquivalentChangeSetsQuery equivalentChangeSetsQuery = EquivalentChangeSetsQuery.this;
            synchronized (equivalentChangeSetsQuery) {
                timestamp = EquivalentChangeSetsQuery.this.fCounter;
            }
            final HashSet possibleRemovals = NewCollection.hashSet();
            final HashSet possibleAdditions = NewCollection.hashSet();
            final HashSet unknownChanges = NewCollection.hashSet();
            for (ItemChangeEvent event : events) {
                IChangeSet toAdd;
                boolean beforeWasIncluded = EquivalentChangeSetsQuery.this.mayPassFilter(event.getBeforeState());
                boolean afterWasIncluded = EquivalentChangeSetsQuery.this.mayPassFilter(event.getAfterState());
                if (beforeWasIncluded && !afterWasIncluded) {
                    IChangeSet toRemove = (IChangeSet)event.getSharedItem();
                    possibleRemovals.add(toRemove);
                    possibleAdditions.remove(toRemove);
                    unknownChanges.remove(toRemove);
                }
                if (afterWasIncluded && !beforeWasIncluded) {
                    toAdd = (IChangeSet)event.getSharedItem();
                    possibleAdditions.add(toAdd);
                    possibleRemovals.remove(toAdd);
                    unknownChanges.remove(toAdd);
                }
                if (!beforeWasIncluded || !afterWasIncluded) continue;
                toAdd = (IChangeSet)event.getSharedItem();
                unknownChanges.add(toAdd);
                possibleRemovals.remove(toAdd);
                possibleAdditions.remove(toAdd);
            }
            if (possibleAdditions.isEmpty() && possibleRemovals.isEmpty() && unknownChanges.isEmpty()) {
                return;
            }
            SWTUtil.greedyExec((Realm)EquivalentChangeSetsQuery.this.getRealm(), (Runnable)new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    EquivalentChangeSetsQuery equivalentChangeSetsQuery = EquivalentChangeSetsQuery.this;
                    synchronized (equivalentChangeSetsQuery) {
                        if (EquivalentChangeSetsQuery.this.fCounter != timestamp) {
                            return;
                        }
                    }
                    if (!unknownChanges.isEmpty()) {
                        EquivalentChangeSetsQuery.this.update();
                        return;
                    }
                    Collection currentValue = EquivalentChangeSetsQuery.this.computeElements();
                    if (!possibleAdditions.isEmpty() && currentValue.size() < EquivalentChangeSetsQuery.this.fMaxResults) {
                        EquivalentChangeSetsQuery.this.update();
                        return;
                    }
                    if (!possibleRemovals.isEmpty()) {
                        HashMap currentChangeSets = NewCollection.hashMap();
                        for (StructuralChangesChangeSetNode next : currentValue) {
                            currentChangeSets.put(ItemId.forItem((IItem)next.getWrapper().getChangeSet()), next);
                        }
                        ArrayList realRemovals = NewCollection.arrayList();
                        for (IChangeSet removal : possibleRemovals) {
                            ItemId nextId = ItemId.forItem((IItem)removal);
                            StructuralChangesChangeSetNode wrapper = (StructuralChangesChangeSetNode)currentChangeSets.get(nextId);
                            if (wrapper == null) continue;
                            realRemovals.add(wrapper);
                        }
                        if (realRemovals.isEmpty()) {
                            return;
                        }
                        if (currentValue.size() >= EquivalentChangeSetsQuery.this.fMaxResults) {
                            EquivalentChangeSetsQuery.this.update();
                            return;
                        }
                        EquivalentChangeSetsQuery.this.removeElements(realRemovals);
                    }
                }
            });
        }
    };

    public EquivalentChangeSetsQuery(ITeamRepository repository, IComponentHandle componentHandle, IChangeSetHandle changeSetHandle, FlowType type, IRemoteFunction<ItemNamespace> namespaceFunction, int maxResults, IOperationRunner runner) {
        super(repository, runner);
        this.fComponentHandle = componentHandle;
        this.fChangeSetHandle = changeSetHandle;
        this.fType = type;
        this.fNamespaceFunction = namespaceFunction;
        this.fMaxResults = maxResults;
        this.fFetcher = new FilteredFetcher(repository);
    }

    private boolean mayPassFilter(IItem item) {
        if (item == null) {
            return false;
        }
        if (!(item instanceof IChangeSet)) {
            return false;
        }
        IChangeSet changeSet = (IChangeSet)item;
        return this.fSearchCriteria != null && this.fSearchCriteria.matches(changeSet);
    }

    public void enableAutoRefresh(boolean enabled) {
        if (enabled == this.fAutoRefresh) {
            return;
        }
        this.fAutoRefresh = enabled;
        if (this.isAllocated()) {
            if (this.fAutoRefresh) {
                this.attachListeners();
                this.update();
            } else {
                this.detachListeners();
            }
        }
    }

    public void setMaxResults(int newMaxResults) {
        int oldMaxResults = this.fMaxResults;
        this.fMaxResults = newMaxResults;
        int oldSize = this.computeElements().size();
        if (oldSize >= oldMaxResults || oldSize > newMaxResults) {
            this.update();
        }
    }

    protected void attachListeners() {
        this.fFetcher.addListener(IChangeSet.ITEM_TYPE, this.fListener);
    }

    protected void detachListeners() {
        this.fFetcher.removeListener(IChangeSet.ITEM_TYPE, this.fListener);
    }

    protected List<StructuralChangesChangeSetNode> fetchResult(boolean needsRefresh, IProgressMonitor monitor) throws TeamRepositoryException {
        ArrayList result = NewCollection.arrayList();
        ITeamRepository repo = this.getRepository();
        int refreshFlag = needsRefresh ? 1 : 0;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IFetchResult fetchedLinks = repo.itemManager().fetchCompleteItemsPermissionAware(Arrays.asList(this.fChangeSetHandle), refreshFlag, (IProgressMonitor)progress.newChild(20));
        for (Object item : fetchedLinks.getRetrievedItems()) {
            IChangeSet changeSet;
            if (!(item instanceof IChangeSet)) continue;
            this.fFullChangeSet = changeSet = (IChangeSet)item;
            break;
        }
        if (this.fFullChangeSet != null) {
            ItemNamespace namespace = (ItemNamespace)this.fNamespaceFunction.compute((IProgressMonitor)progress.newChild(10));
            if (this.fFullChangeSet.getOriginalChangeSet() == null) {
                ChangeSetWrapper changeSetWrapper = new ChangeSetWrapper(this.getRepository(), this.fFullChangeSet);
                result.add(new StructuralChangesChangeSetNode(0, this.fType, namespace, changeSetWrapper));
            } else {
                IChangeSetSearchCriteria searchCriteria = IChangeSetSearchCriteria.FACTORY.newInstance();
                searchCriteria.setComponent(this.fComponentHandle);
                searchCriteria.setSourceId(this.fFullChangeSet.getOriginalChangeSet().getItemId());
                this.fSearchCriteria = searchCriteria;
                int toFetch = this.fMaxResults;
                int batches = toFetch / 512 + 1;
                SubMonitor changeSetQueryProgress = SubMonitor.convert((IProgressMonitor)progress, (int)70).setWorkRemaining(2 * batches + 2);
                IWorkspaceManager mgr = SCMPlatform.getWorkspaceManager((ITeamRepository)this.getRepository());
                IChangeSetSearchCriteria pagingCriteria = (IChangeSetSearchCriteria)EcoreUtil.copy((EObject)((EObject)searchCriteria));
                ArrayList<IChangeSet> fetchResult = new ArrayList<IChangeSet>(toFetch);
                List findResult = mgr.findChangeSets(pagingCriteria, toFetch, (IProgressMonitor)changeSetQueryProgress.newChild(1));
                List<IChangeSet> changeSets = this.fetchCurrentsInOrder(findResult, (IProgressMonitor)changeSetQueryProgress.newChild(1));
                fetchResult.addAll(changeSets);
                while (toFetch > 512 && findResult.size() == 512) {
                    toFetch -= findResult.size();
                    IChangeSet lastChangeSet = changeSets.get(changeSets.size() - 1);
                    if (pagingCriteria.isOldestFirst()) {
                        pagingCriteria.setModifiedAfter(new Timestamp(lastChangeSet.getLastChangeDate().getTime()));
                    } else {
                        pagingCriteria.setModifiedBefore(new Timestamp(lastChangeSet.getLastChangeDate().getTime()));
                    }
                    findResult = mgr.findChangeSets(pagingCriteria, toFetch, (IProgressMonitor)changeSetQueryProgress.newChild(1));
                    changeSets = this.fetchCurrentsInOrder(findResult, (IProgressMonitor)changeSetQueryProgress.newChild(1));
                    fetchResult.addAll(changeSets);
                }
                int counter = fetchResult.size() - 1;
                for (IChangeSet changeSet : fetchResult) {
                    if (changeSet == null) continue;
                    ChangeSetWrapper nextWrapper = new ChangeSetWrapper(this.getRepository(), changeSet);
                    result.add(new StructuralChangesChangeSetNode(counter--, this.fType, namespace, nextWrapper));
                }
            }
        }
        progress.done();
        return result;
    }

    private List<IChangeSet> fetchCurrentsInOrder(List<IChangeSetHandle> handles, IProgressMonitor monitor) throws TeamRepositoryException {
        List changeSetIds = ItemLists.handlesToIds(handles);
        Map currents = this.fFetcher.fetchCurrents((Collection)changeSetIds, false, monitor);
        ArrayList<IChangeSet> results = new ArrayList<IChangeSet>(currents.size());
        for (ItemId id : changeSetIds) {
            results.add((IChangeSet)currents.get(id));
        }
        return results;
    }

    public String getName() {
        return Messages.EquivalentChangeSetsQuery_QUERY_NAME;
    }
}

