/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.structuralchanges.queries;

import com.ibm.team.filesystem.client.internal.snapshot.FlowType;
import com.ibm.team.filesystem.ui.wrapper.ChangeSetWrapper;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.views.structuralchanges.nodes.StructuralChangesEquivalentChangeSetsContainerNode;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IFetchResult;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.common.collection.CollectionUtil;
import com.ibm.team.repository.rcp.ui.internal.viewers.RepositoryQuery;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.scm.client.internal.RepoFetcher;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.internal.util.ItemId;
import com.ibm.team.scm.common.internal.util.NewCollection;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class EquivalentChangeSetsContainerNodeQuery
extends RepositoryQuery<StructuralChangesEquivalentChangeSetsContainerNode> {
    private IComponent fComponent;
    private List<ItemId<IChangeSet>> fInputChangeSets;
    private FlowType fType;

    public EquivalentChangeSetsContainerNodeQuery(ITeamRepository repository, IComponent component, List<ItemId<IChangeSet>> changeSets, FlowType type, IOperationRunner runner) {
        super(repository, runner);
        this.fComponent = component;
        this.fInputChangeSets = changeSets;
        this.fType = type;
    }

    protected void attachListeners() {
    }

    protected void detachListeners() {
    }

    protected List<StructuralChangesEquivalentChangeSetsContainerNode> fetchResult(boolean needsRefresh, IProgressMonitor monitor) throws TeamRepositoryException {
        ArrayList result = NewCollection.arrayList();
        if (this.fInputChangeSets.size() > 0) {
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            List fetchedInputChangeSets = CollectionUtil.reorderValues((Map)RepoFetcher.fetchCurrents((ITeamRepository)this.getRepository(), this.fInputChangeSets, (boolean)needsRefresh, (IProgressMonitor)progress.newChild(50)), this.fInputChangeSets);
            ArrayList originalHandles = NewCollection.arrayList();
            for (IChangeSet inputChangeSet : fetchedInputChangeSets) {
                IChangeSetHandle originalHandle = inputChangeSet.getOriginalChangeSet();
                if (originalHandle == null) {
                    originalHandles.add(inputChangeSet);
                    continue;
                }
                originalHandles.add(originalHandle);
            }
            int refreshFlag = needsRefresh ? 1 : 0;
            IFetchResult fetchResult = this.getRepository().itemManager().fetchCompleteItemsPermissionAware((List)originalHandles, refreshFlag, (IProgressMonitor)progress.newChild(50));
            int counter = fetchResult.getRetrievedItems().size() - 1;
            for (Object item : fetchResult.getRetrievedItems()) {
                if (!(item instanceof IChangeSet)) continue;
                IChangeSet fetchedOriginalChangeSet = (IChangeSet)item;
                ChangeSetWrapper wrapper = new ChangeSetWrapper(this.getRepository(), fetchedOriginalChangeSet);
                result.add(new StructuralChangesEquivalentChangeSetsContainerNode(counter--, this.fType, this.fComponent, wrapper));
            }
            progress.done();
        }
        return result;
    }

    public String getName() {
        return Messages.EquivalentChangeSetsContainerNodeQuery_QUERY_NAME;
    }
}

