/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.structuralchanges.queries;

import com.ibm.team.filesystem.client.internal.namespace.IItemContext;
import com.ibm.team.filesystem.client.internal.namespace.ItemNamespace;
import com.ibm.team.filesystem.client.internal.snapshot.FlowType;
import com.ibm.team.filesystem.client.internal.snapshot.ISnapshot;
import com.ibm.team.filesystem.client.internal.snapshot.SnapshotId;
import com.ibm.team.filesystem.client.internal.snapshot.SnapshotSyncReport;
import com.ibm.team.filesystem.common.changemodel.IPathResolver;
import com.ibm.team.filesystem.ui.wrapper.ComponentWrapper;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.adapters.WrapperUtil;
import com.ibm.team.internal.filesystem.ui.views.structuralchanges.nodes.StructuralChangesComponentNode;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.common.collection.SetDiff;
import com.ibm.team.repository.rcp.ui.internal.viewers.RepositoryQuery;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.scm.client.internal.RepoFetcher;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.internal.util.ItemId;
import com.ibm.team.scm.common.internal.util.NewCollection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class ComponentsInSyncReportQuery
extends RepositoryQuery<StructuralChangesComponentNode> {
    private SnapshotSyncReport syncReport;
    private FlowType flowType;
    private IPathResolver pathResolver;
    private SnapshotId context;
    private ITeamRepository remote;

    public ComponentsInSyncReportQuery(ITeamRepository repo, ITeamRepository remote, SnapshotSyncReport syncReport, FlowType flowType, IPathResolver pathResolver, SnapshotId context, IOperationRunner runner) {
        super(repo, runner);
        this.syncReport = syncReport;
        this.flowType = flowType;
        this.pathResolver = pathResolver;
        this.context = context;
        this.remote = remote;
    }

    protected void attachListeners() {
    }

    protected void detachListeners() {
    }

    protected List<StructuralChangesComponentNode> fetchResult(boolean needsRefresh, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        ArrayList result = NewCollection.arrayList();
        Set modifiedComponents = this.syncReport.getModifiedComponents(this.flowType);
        Map changesPerRepo = this.syncReport.getComponentChangesPerRepo(this.flowType);
        HashMap<ITeamRepository, Map> fetchedPerRepo = new HashMap<ITeamRepository, Map>();
        ArrayList fetchedComponents = NewCollection.arrayList();
        Iterator iterator = changesPerRepo.keySet().iterator();
        while (iterator.hasNext()) {
            ITeamRepository repo;
            ITeamRepository itemRepository = repo = (ITeamRepository)iterator.next();
            if (repo == null) {
                itemRepository = this.getRepository();
            }
            HashSet toFetch = new HashSet();
            SetDiff setDiff = (SetDiff)changesPerRepo.get(repo);
            toFetch.addAll(modifiedComponents);
            toFetch.removeAll(fetchedComponents);
            toFetch.addAll(setDiff.getAdditions());
            toFetch.addAll(setDiff.getRemovals());
            Map fetched = RepoFetcher.fetchCurrents((ITeamRepository)itemRepository, toFetch, (IProgressMonitor)progress.newChild(25));
            fetchedComponents.addAll(fetched.keySet());
            fetchedPerRepo.put(repo, fetched);
        }
        ISnapshot snapshot = this.context.getSnapshot((IProgressMonitor)progress.newChild(25));
        snapshot.getNamespaces((IProgressMonitor)progress.newChild(25));
        Map contexts = snapshot.getContexts((IProgressMonitor)progress.newChild(25));
        HashMap<ItemId, ItemNamespace> namespaces = new HashMap<ItemId, ItemNamespace>();
        for (ItemId next : contexts.keySet()) {
            namespaces.put(next, ((IItemContext)contexts.get(next)).getNamespace());
        }
        Map<ItemNamespace, Object> namespaceWrappers = WrapperUtil.createWrapperFromNamespace(namespaces.values(), (IProgressMonitor)progress.newChild(25));
        HashMap<ItemId<IComponent>, Object> wrappers = new HashMap<ItemId<IComponent>, Object>();
        for (ItemId next : contexts.keySet()) {
            ItemNamespace ns = (ItemNamespace)namespaces.get(next);
            Object wrapper = namespaceWrappers.get(ns);
            if (wrapper instanceof String) continue;
            wrappers.put(next, wrapper);
        }
        for (ITeamRepository repo : fetchedPerRepo.keySet()) {
            Map fetched = (Map)fetchedPerRepo.get(repo);
            SetDiff changes = (SetDiff)changesPerRepo.get(repo);
            this.createWrappers(result, repo, modifiedComponents, fetched, StructuralChangesComponentNode.ChangeType.Modify, wrappers);
            this.createWrappers(result, repo, changes.getAdditions(), fetched, StructuralChangesComponentNode.ChangeType.Addition, wrappers);
            this.createWrappers(result, repo, changes.getRemovals(), fetched, StructuralChangesComponentNode.ChangeType.Removal, wrappers);
        }
        return result;
    }

    private void createWrappers(List<StructuralChangesComponentNode> result, ITeamRepository repo, Set<ItemId<IComponent>> modifiedComponents, Map<ItemId<IComponent>, IComponent> fetched, StructuralChangesComponentNode.ChangeType changeType, Map<ItemId<IComponent>, Object> wrappers) {
        for (ItemId<IComponent> nextHandle : modifiedComponents) {
            IComponent component = fetched.get(nextHandle);
            if (component == null) continue;
            Object wrapper = wrappers.get(nextHandle);
            if (wrapper == null) {
                wrapper = new ComponentWrapper(repo == null ? this.getRepository() : repo, component);
            }
            result.add(new StructuralChangesComponentNode(wrapper, this.getRepository(), this.remote, component, this.flowType, this.syncReport, this.pathResolver, changeType, this.context));
        }
    }

    public String getName() {
        return Messages.ComponentsInSyncReportQuery_queryName;
    }

    public ITeamRepository getRemoteRepository() {
        return this.remote;
    }
}

