/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.structuralchanges.queries;

import com.ibm.team.filesystem.client.internal.era.EraSyncReportFragment;
import com.ibm.team.filesystem.client.internal.namespace.ItemNamespace;
import com.ibm.team.filesystem.client.internal.snapshot.FlowType;
import com.ibm.team.filesystem.ui.wrapper.ChangeSetInContextWrapper;
import com.ibm.team.filesystem.ui.wrapper.ChangeSetWrapper;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.views.structuralchanges.nodes.StructuralChangesChangeSetNode;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.common.IRemoteFunction;
import com.ibm.team.repository.rcp.common.collection.CollectionUtil;
import com.ibm.team.repository.rcp.ui.internal.viewers.RepositoryQuery;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.scm.client.internal.RepoFetcher;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.internal.util.ItemId;
import com.ibm.team.scm.common.internal.util.NewCollection;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class ChangeSetsInSyncReportQuery
extends RepositoryQuery<StructuralChangesChangeSetNode> {
    private FlowType type;
    private EraSyncReportFragment syncReport;
    private IRemoteFunction<ItemNamespace> namespaceFunction;
    private ITeamRepository remote;

    public ChangeSetsInSyncReportQuery(ITeamRepository repository, ITeamRepository remote, EraSyncReportFragment syncReport, FlowType type, IRemoteFunction<ItemNamespace> namespaceFunction, IOperationRunner runner) {
        super(repository, runner);
        this.syncReport = syncReport;
        this.type = type;
        this.namespaceFunction = namespaceFunction;
        this.remote = remote;
    }

    protected void attachListeners() {
    }

    protected void detachListeners() {
    }

    protected List<StructuralChangesChangeSetNode> fetchResult(boolean needsRefresh, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        ItemNamespace namespace = (ItemNamespace)this.namespaceFunction.compute((IProgressMonitor)progress.newChild(5));
        ITeamRepository repo = this.type == FlowType.Outgoing ? this.getRepository() : (this.remote == null ? this.getRepository() : this.remote);
        return ChangeSetsInSyncReportQuery.createChangeSetNodes(repo, this.syncReport.getChangeSets(), this.type, namespace, needsRefresh, (IProgressMonitor)progress.newChild(95));
    }

    public static List<StructuralChangesChangeSetNode> createChangeSetNodes(ITeamRepository repo, List<ItemId<IChangeSet>> changeSets, FlowType type, ItemNamespace namespace, boolean needsRefresh, IProgressMonitor monitor) throws TeamRepositoryException {
        List fetchedChangeSets = CollectionUtil.reorderValues((Map)RepoFetcher.fetchCurrents((ITeamRepository)repo, changeSets, (boolean)needsRefresh, (IProgressMonitor)monitor), changeSets);
        ArrayList result = NewCollection.arrayList();
        int counter = fetchedChangeSets.size() - 1;
        for (IChangeSet next : fetchedChangeSets) {
            if (next == null) continue;
            ChangeSetWrapper nextWrapper = null;
            nextWrapper = namespace != null ? new ChangeSetInContextWrapper(namespace, next) : new ChangeSetWrapper(repo, next);
            result.add(new StructuralChangesChangeSetNode(counter--, type, namespace, nextWrapper));
        }
        return result;
    }

    public String getName() {
        return Messages.ChangeSetsInSyncReportQuery_queryName;
    }
}

