/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.structuralchanges.queries;

import com.ibm.team.filesystem.client.internal.namespace.ItemNamespace;
import com.ibm.team.filesystem.rcp.core.internal.rest.util.SyncViewDTOUtil;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.views.structuralchanges.nodes.StructuralChangesBaselineNode;
import com.ibm.team.internal.filesystem.ui.views.structuralchanges.nodes.StructuralChangesChangeSetNode;
import com.ibm.team.internal.filesystem.ui.views.structuralchanges.queries.ChangeSetsInSyncReportQuery;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.ui.internal.viewers.RepositoryQuery;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.scm.common.IBaseline;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.internal.util.ItemId;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class ChangeSetsInBaselineNodeQuery
extends RepositoryQuery<StructuralChangesChangeSetNode> {
    private StructuralChangesBaselineNode baseline;
    private ItemNamespace namespace;

    public ChangeSetsInBaselineNodeQuery(StructuralChangesBaselineNode baseline, ItemNamespace namespace, IOperationRunner runner) {
        super(baseline.getWrapper().getRepository(), runner);
        this.baseline = baseline;
        this.namespace = namespace;
    }

    protected void attachListeners() {
    }

    protected void detachListeners() {
    }

    protected List<StructuralChangesChangeSetNode> fetchResult(boolean needsRefresh, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        ItemId<IBaseline> current = this.baseline.getCurrentBaseline();
        ItemId<IBaseline> previous = this.baseline.getPreviousBaseline();
        Set<ItemId<IChangeSet>> permittedChangeSets = this.baseline.getPermittedChangeSets();
        List changeSets = SyncViewDTOUtil.fetchDifferentChangeSets((ITeamRepository)this.getRepository(), current, previous, permittedChangeSets, (SubMonitor)progress);
        return ChangeSetsInSyncReportQuery.createChangeSetNodes(this.getRepository(), changeSets, this.baseline.getType(), this.namespace, needsRefresh, (IProgressMonitor)progress.newChild(20));
    }

    public String getName() {
        return Messages.ChangeSetsInBaselineNodeQuery_queryName;
    }
}

