/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.structuralchanges.queries;

import com.ibm.team.filesystem.rcp.core.internal.oslc.OslcLinkWrapper;
import com.ibm.team.filesystem.ui.wrapper.ChangeSetLinkWrapper;
import com.ibm.team.filesystem.ui.wrapper.ChangeSetWrapper;
import com.ibm.team.foundation.rcp.core.IModelAccessor;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.links.client.ILinkEvent;
import com.ibm.team.links.client.ILinkManager;
import com.ibm.team.links.common.ILink;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.util.IListener;
import com.ibm.team.repository.common.IFetchResult;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.rcp.ui.internal.viewers.RepositoryQuery;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.scm.client.internal.ClientProviderFactory;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.internal.util.NewCollection;
import com.ibm.team.scm.common.links.ChangeSetLinks;
import com.ibm.team.scm.common.providers.ProviderFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;

public class ChangeSetLinksQuery
extends RepositoryQuery<IModelAccessor> {
    private ChangeSetWrapper wrapper;
    private IListener listener = new IListener(){

        public void handleEvents(List events) {
            for (Object obj : events) {
                if (!(obj instanceof ILinkEvent)) continue;
                ILinkEvent event = (ILinkEvent)obj;
                ILink link = event.getLink();
                Object ref = link.getSourceRef().resolve();
                if (!ChangeSetLinksQuery.this.wrapper.getChangeSet().sameItemId((IItemHandle)ref)) continue;
                ChangeSetLinksQuery.this.refresh();
            }
        }
    };

    public ChangeSetLinksQuery(ITeamRepository repository, ChangeSetWrapper wrapper, IOperationRunner runner) {
        super(repository, runner);
        this.wrapper = wrapper;
        ILinkManager linkManager = (ILinkManager)repository.getClientLibrary(ILinkManager.class);
        linkManager.addGenericListener((Object)"com.ibm.team.links.LinkDeletedEvent", this.listener);
        linkManager.addGenericListener((Object)"com.ibm.team.links.LinkSaveEvent", this.listener);
    }

    public synchronized void dispose() {
        ITeamRepository repository = this.wrapper.getRepository();
        ILinkManager linkManager = (ILinkManager)repository.getClientLibrary(ILinkManager.class);
        linkManager.removeGenericListener((Object)"com.ibm.team.links.LinkDeletedEvent", this.listener);
        linkManager.removeGenericListener((Object)"com.ibm.team.links.LinkSaveEvent", this.listener);
        this.listener = null;
        super.dispose();
    }

    protected List<IModelAccessor> fetchResult(boolean needsRefresh, IProgressMonitor monitor) throws TeamRepositoryException {
        IChangeSet changeSet = this.wrapper.getChangeSet();
        ArrayList result = NewCollection.arrayList();
        ITeamRepository changeSetRepo = this.wrapper.getRepository();
        List links = ChangeSetLinks.findLinks((ProviderFactory)new ClientProviderFactory(changeSetRepo), (IChangeSetHandle)this.wrapper.getChangeSet(), (String[])new String[]{"com.ibm.team.filesystem.workitems.change_set"}, (IProgressMonitor)monitor);
        Set calmLinks = OslcLinkWrapper.fetchScmCalmLinkWrappers((ITeamRepository)changeSetRepo, Collections.singletonList(changeSet), (IProgressMonitor)monitor);
        Map calmLinksByRepo = OslcLinkWrapper.sortByBestRepository((Collection)calmLinks);
        ArrayList<IItemHandle> reasonHandles = new ArrayList<IItemHandle>();
        HashMap<UUID, ILink> itemAndLink = new HashMap<UUID, ILink>();
        for (ILink link : links) {
            Iterator ref = link.getTargetRef().resolve();
            if (!(ref instanceof IItemHandle)) continue;
            reasonHandles.add((IItemHandle)ref);
            itemAndLink.put(((IItemHandle)ref).getItemId(), link);
        }
        IFetchResult fetchedLinks = changeSetRepo.itemManager().fetchCompleteItemsPermissionAware(reasonHandles, 0, monitor);
        for (Object item : fetchedLinks.getRetrievedItems()) {
            if (!(item instanceof IItem)) continue;
            ILink link = (ILink)itemAndLink.get(((IItem)item).getItemId());
            result.add(new ChangeSetLinkWrapper(changeSetRepo, (IItem)item, link));
        }
        Set entrySet = calmLinksByRepo.entrySet();
        for (Map.Entry entry : entrySet) {
            ITeamRepository repo = (ITeamRepository)entry.getKey();
            OslcLinkWrapper.fetchDetails((ITeamRepository)repo, (Collection)((Collection)entry.getValue()), (IProgressMonitor)monitor);
            for (OslcLinkWrapper wrapper : (Set)entry.getValue()) {
                result.add(wrapper);
            }
        }
        return result;
    }

    public String getName() {
        return Messages.ChangeSetLinksQuery_0;
    }

    protected void attachListeners() {
    }

    protected void detachListeners() {
    }
}

