/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.structuralchanges.queries;

import com.ibm.team.filesystem.client.internal.era.EraSyncReportFragment;
import com.ibm.team.filesystem.client.internal.namespace.ItemNamespace;
import com.ibm.team.filesystem.client.internal.snapshot.ComponentSyncReportFragment;
import com.ibm.team.filesystem.client.internal.snapshot.FlowType;
import com.ibm.team.filesystem.common.internal.util.ItemUtil;
import com.ibm.team.filesystem.ui.wrapper.BaselineWrapper;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.views.structuralchanges.nodes.StructuralChangesBaselineNode;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.common.IRemoteFunction;
import com.ibm.team.repository.rcp.common.collection.CollectionUtil;
import com.ibm.team.repository.rcp.ui.internal.viewers.RepositoryQuery;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.scm.client.internal.RepoFetcher;
import com.ibm.team.scm.common.IBaseline;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.internal.util.ItemId;
import com.ibm.team.scm.common.internal.util.NewCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class BaselinesInSyncReportQuery
extends RepositoryQuery<StructuralChangesBaselineNode> {
    private ComponentSyncReportFragment report;
    private FlowType type;
    private IRemoteFunction<ItemNamespace> namespace;
    private ITeamRepository remote;

    public BaselinesInSyncReportQuery(ITeamRepository repository, ITeamRepository remote, ComponentSyncReportFragment report, FlowType type, IRemoteFunction<ItemNamespace> namespace, IOperationRunner runner) {
        super(repository, runner);
        this.report = report;
        this.type = type;
        this.namespace = namespace;
        this.remote = remote;
    }

    protected void attachListeners() {
    }

    protected void detachListeners() {
    }

    protected List<StructuralChangesBaselineNode> fetchResult(boolean needsRefresh, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        ArrayList baselines = NewCollection.arrayList();
        baselines.addAll(this.report.getBaselines());
        if (baselines.isEmpty()) {
            return Collections.emptyList();
        }
        baselines.add(this.report.commonAncestor());
        List fetched = CollectionUtil.reorderValues((Map)RepoFetcher.fetchCurrents((ITeamRepository)this.getRepository(), (Collection)baselines, (IProgressMonitor)progress.newChild(35)), (List)baselines);
        HashSet components = NewCollection.hashSet();
        for (IBaseline next : fetched) {
            if (next == null) continue;
            components.add(ItemUtil.getComponent((IBaseline)next));
        }
        ItemNamespace namespaceId = (ItemNamespace)this.namespace.compute((IProgressMonitor)progress.newChild(10));
        EraSyncReportFragment netChange = this.report.computeNetChange(this.getRepository(), (IProgressMonitor)progress.newChild(20));
        HashSet allChangeSets = NewCollection.hashSet();
        allChangeSets.addAll(netChange.getChangeSets());
        Map fetchedComponents = RepoFetcher.fetchCurrents((ITeamRepository)(this.remote == null ? this.getRepository() : this.remote), (Collection)components, (IProgressMonitor)progress.newChild(35));
        ArrayList result = NewCollection.arrayList();
        int order = 0;
        IBaseline current = null;
        for (IBaseline previous : fetched) {
            if (previous == null) continue;
            if (current != null) {
                BaselineWrapper wrapper = new BaselineWrapper(this.getRepository(), current, (IComponent)fetchedComponents.get(ItemUtil.getComponent((IBaseline)current)));
                StructuralChangesBaselineNode nextNode = new StructuralChangesBaselineNode(order++, wrapper, (ItemId<IBaseline>)ItemId.forItem((IItem)current), (ItemId<IBaseline>)ItemId.forItem((IItem)previous), this.type, allChangeSets, namespaceId);
                result.add(nextNode);
            }
            current = previous;
        }
        return result;
    }

    public String getName() {
        return Messages.BaselinesInSyncReportQuery_queryName;
    }
}

