/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.structuralchanges.nodes;

import com.ibm.team.filesystem.client.internal.namespace.ItemNamespace;
import com.ibm.team.filesystem.client.internal.snapshot.FlowType;
import com.ibm.team.filesystem.common.changemodel.FileChange;
import com.ibm.team.filesystem.common.changemodel.FileState;
import com.ibm.team.filesystem.ui.wrapper.SymbolicLinkItemWrapper;
import com.ibm.team.internal.filesystem.ui.views.structuralchanges.nodes.StructuralChangesViewFolderNode;
import com.ibm.team.internal.filesystem.ui.views.structuralchanges.nodes.StructuralChangesViewNode;
import com.ibm.team.scm.common.internal.util.StateId;
import org.eclipse.core.runtime.IAdaptable;

public class StructuralChangesViewSymbolicLinkNode
extends StructuralChangesViewNode
implements IAdaptable {
    private FileChange change;
    private StructuralChangesViewFolderNode folder;
    private ItemNamespace namespace;
    private int cachedHashcode = 0;
    private String versionId;

    public StructuralChangesViewSymbolicLinkNode(StructuralChangesViewFolderNode folder, FileChange change, FlowType flags, ItemNamespace namespace, String versionId) {
        super(flags);
        this.change = change;
        this.folder = folder;
        this.namespace = namespace;
        this.versionId = versionId;
    }

    public FileChange getChange() {
        return this.change;
    }

    @Override
    public Object getWrapper() {
        return this.change;
    }

    public StructuralChangesViewFolderNode getFolder() {
        return this.folder;
    }

    public String getVersionId() {
        return this.versionId;
    }

    public Object getAdapter(Class adapter) {
        if (adapter == SymbolicLinkItemWrapper.class) {
            FileState fs = this.change.getNonDeleted(false);
            StateId stateId = fs.getStateId();
            return new SymbolicLinkItemWrapper(stateId, fs.getPath().getName(), this.namespace);
        }
        return null;
    }

    @Override
    public int hashCode() {
        if (this.cachedHashcode == 0) {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + (this.change == null ? 0 : this.change.hashCode());
            result = 31 * result + (this.folder == null ? 0 : this.folder.hashCode());
            this.cachedHashcode = result = 31 * result + (this.namespace == null ? 0 : this.namespace.hashCode());
        }
        return this.cachedHashcode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StructuralChangesViewSymbolicLinkNode other = (StructuralChangesViewSymbolicLinkNode)obj;
        if (this.change == null ? other.change != null : !this.change.equals((Object)other.change)) {
            return false;
        }
        if (this.folder == null ? other.folder != null : !this.folder.equals(other.folder)) {
            return false;
        }
        return !(this.namespace == null ? other.namespace != null : !this.namespace.equals((Object)other.namespace));
    }

    public ItemNamespace getNamespace() {
        return this.namespace;
    }

    public boolean hasContext() {
        return !this.namespace.isEmpty();
    }
}

