/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.structuralchanges.nodes;

import com.ibm.team.filesystem.client.internal.namespace.ItemNamespace;
import com.ibm.team.filesystem.client.internal.snapshot.FlowType;
import com.ibm.team.filesystem.common.changemodel.ResolvedConfigurationChangePaths;
import com.ibm.team.filesystem.common.changemodel.VersionablePath;
import com.ibm.team.internal.filesystem.ui.patches.ChangeFolder;
import com.ibm.team.internal.filesystem.ui.views.structuralchanges.nodes.StructuralChangesViewNode;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.common.internal.util.NewCollection;
import com.ibm.team.scm.common.internal.util.SiloedItemId;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;

public class StructuralChangesViewFolderNode
extends StructuralChangesViewNode {
    private ChangeFolder changeFolder;
    private VersionablePath resolvedPath;
    private ResolvedConfigurationChangePaths paths;
    private ItemNamespace namespace;
    private int cachedHashcode = 0;
    private String versionId;

    public StructuralChangesViewFolderNode(ItemNamespace namespace, ResolvedConfigurationChangePaths paths, ChangeFolder changeFolder, VersionablePath resolvedPath, FlowType flags) {
        super(flags);
        this.changeFolder = changeFolder;
        this.resolvedPath = resolvedPath;
        this.paths = paths;
        this.namespace = namespace;
    }

    public ITeamRepository getRepository() {
        return this.namespace.getRepository();
    }

    public ResolvedConfigurationChangePaths getPaths() {
        return this.paths;
    }

    public VersionablePath getPath() {
        return this.resolvedPath;
    }

    public ChangeFolder getChangeFolder() {
        return this.changeFolder;
    }

    public void setVersionId(String versionId) {
        this.versionId = versionId;
    }

    public String getVersionId() {
        return this.versionId;
    }

    @Override
    public Object getWrapper() {
        return this.changeFolder;
    }

    @Override
    public int hashCode() {
        if (this.cachedHashcode == 0) {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.changeFolder == null ? 0 : this.changeFolder.hashCode());
            this.cachedHashcode = result + super.hashCode();
        }
        return this.cachedHashcode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StructuralChangesViewFolderNode other = (StructuralChangesViewFolderNode)obj;
        if (this.changeFolder == null ? other.changeFolder != null : !this.changeFolder.equals(other.changeFolder)) {
            return false;
        }
        return super.equals(obj);
    }

    public static List<StructuralChangesViewFolderNode> createListFrom(ItemNamespace namespace, StructuralChangesViewNode parent, List<ChangeFolder> folders, ResolvedConfigurationChangePaths paths, FlowType type, IProgressMonitor monitor) throws TeamRepositoryException {
        ArrayList result = NewCollection.arrayList();
        HashSet<SiloedItemId> pathsToResolve = new HashSet<SiloedItemId>();
        for (ChangeFolder next : folders) {
            SiloedItemId nextFolder = SiloedItemId.upcast(next.getPath());
            pathsToResolve.add(nextFolder);
        }
        Map mapToPaths = paths.computePaths(pathsToResolve, false, monitor);
        for (ChangeFolder next : folders) {
            VersionablePath path = (VersionablePath)mapToPaths.get(next.getPath());
            StructuralChangesViewFolderNode structuralChangesViewFolderNode = new StructuralChangesViewFolderNode(namespace, paths, next, path, type);
            structuralChangesViewFolderNode.setParent(parent);
            result.add(structuralChangesViewFolderNode);
        }
        return result;
    }

    public ItemNamespace getNamespace() {
        return this.namespace;
    }
}

