/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.structuralchanges.nodes;

import com.ibm.team.filesystem.client.internal.snapshot.FlowType;
import com.ibm.team.filesystem.common.changemodel.FileChange;
import com.ibm.team.filesystem.ui.wrapper.ComponentWrapper;
import com.ibm.team.internal.filesystem.ui.views.structuralchanges.nodes.StructuralChangesViewNode;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;

public class StructuralChangesSubcomponentNode
extends StructuralChangesViewNode {
    public static final boolean hideSubcomponentNodes = Boolean.getBoolean(System.getProperty("com.ibm.team.filesystem.ide.ui.hideSubcomponentNodes", Boolean.toString(false)));
    public static final boolean showSubcomponentInfoFile = Boolean.getBoolean(System.getProperty("com.ibm.team.filesystem.ide.ui.showSubcomponentInfoFile", Boolean.toString(false)));
    private ITeamRepository repo;
    private IComponentHandle componentHandle;
    private ComponentWrapper componentWrapper;
    private ChangeType changeType;
    private FileChange subComponentInfoChange;

    public StructuralChangesSubcomponentNode(ITeamRepository repo, IComponentHandle componentHandle, IComponent fetchedComponent, ChangeType changeType, FileChange subComponentInfoChange) {
        super(FlowType.Both);
        this.repo = repo;
        this.componentHandle = componentHandle;
        this.changeType = changeType;
        this.subComponentInfoChange = subComponentInfoChange;
        subComponentInfoChange.isSubcomponentChange();
        if (fetchedComponent != null) {
            this.componentWrapper = new ComponentWrapper(repo, fetchedComponent);
        }
    }

    @Override
    public Object getWrapper() {
        return this.componentWrapper;
    }

    public ITeamRepository getRepository() {
        return this.repo;
    }

    public IComponentHandle getComponentHandle() {
        return this.componentHandle;
    }

    public IComponent getComponent() {
        return this.componentWrapper == null ? null : this.componentWrapper.getComponent();
    }

    public ChangeType getChangeType() {
        return this.changeType;
    }

    public FileChange getSubComponentInfoChange() {
        return this.subComponentInfoChange;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.changeType == null ? 0 : this.changeType.hashCode());
        result = 31 * result + (this.componentHandle == null ? 0 : this.componentHandle.getItemId().hashCode());
        result = 31 * result + (this.componentWrapper == null ? 0 : this.componentWrapper.hashCode());
        result = 31 * result + (this.repo == null ? 0 : this.repo.getRepositoryURI().hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StructuralChangesSubcomponentNode other = (StructuralChangesSubcomponentNode)obj;
        if (this.changeType != other.changeType) {
            return false;
        }
        if (this.componentHandle == null ? other.componentHandle != null : !this.componentHandle.sameItemId((IItemHandle)other.componentHandle)) {
            return false;
        }
        if (this.componentWrapper == null ? other.componentWrapper != null : !this.componentWrapper.equals((Object)other.componentWrapper)) {
            return false;
        }
        if (this.repo == null) {
            if (other.repo != null) {
                return false;
            }
        } else {
            String otherRepoString;
            String string = otherRepoString = other.repo == null ? null : other.repo.getRepositoryURI();
            if (!this.repo.getRepositoryURI().equals(otherRepoString)) {
                return false;
            }
        }
        return true;
    }

    public static enum ChangeType {
        Addition,
        Removal;

    }
}

