/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.structuralchanges.nodes;

import com.ibm.team.filesystem.client.internal.snapshot.ComponentSyncReportFragment;
import com.ibm.team.filesystem.client.internal.snapshot.FlowType;
import com.ibm.team.filesystem.client.internal.snapshot.SnapshotId;
import com.ibm.team.filesystem.client.internal.snapshot.SnapshotSyncReport;
import com.ibm.team.filesystem.client.internal.snapshot.SnapshotSyncReportFragment;
import com.ibm.team.filesystem.common.changemodel.IPathResolver;
import com.ibm.team.internal.filesystem.ui.views.structuralchanges.nodes.StructuralChangesViewNode;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.internal.util.ItemId;

public class StructuralChangesComponentNode
extends StructuralChangesViewNode {
    private SnapshotSyncReport report;
    private int cachedHashCode = 0;
    private Object wrapper;
    private IComponent component;
    private IPathResolver pathResolver;
    private ITeamRepository repository;
    private ITeamRepository remote;
    private ChangeType type;
    private SnapshotId context;
    private String contextWherePresent;
    private String contextWhereNotPresent;

    public StructuralChangesComponentNode(Object wrapper, ITeamRepository repository, ITeamRepository remote, IComponent component, FlowType flowType, SnapshotSyncReport syncReport, IPathResolver pathResolver, ChangeType type, SnapshotId context) {
        super(flowType);
        this.wrapper = wrapper;
        this.repository = repository;
        this.remote = remote;
        this.component = component;
        this.report = syncReport;
        this.pathResolver = pathResolver;
        this.type = type;
        this.context = context;
        SnapshotSyncReportFragment outgoingReport = syncReport.getOutgoing();
        SnapshotSyncReportFragment incomingReport = syncReport.getIncoming();
        boolean outgoingFlow = flowType.equals((Object)FlowType.Both) || flowType.equals((Object)FlowType.Outgoing);
        String localContext = outgoingFlow ? outgoingReport.getContextName() : incomingReport.getContextName();
        String remoteContext = outgoingFlow ? incomingReport.getContextName() : outgoingReport.getContextName();
        switch (type) {
            case Addition: {
                this.contextWherePresent = localContext;
                this.contextWhereNotPresent = remoteContext;
                break;
            }
            case Removal: {
                this.contextWherePresent = remoteContext;
                this.contextWhereNotPresent = localContext;
                break;
            }
        }
    }

    @Override
    public Object getWrapper() {
        return this.wrapper;
    }

    public ChangeType getChangeType() {
        return this.type;
    }

    public IPathResolver getPathResolver() {
        return this.pathResolver;
    }

    public ComponentSyncReportFragment getReport(FlowType type) {
        ComponentSyncReportFragment result = (ComponentSyncReportFragment)this.report.get(type).getComponentModifications().get(ItemId.forItem((IItem)this.component));
        if (result == null) {
            result = ComponentSyncReportFragment.emptyReport();
        }
        return result;
    }

    public SnapshotId getContext() {
        return this.context;
    }

    public IComponent getComponent() {
        return this.component;
    }

    public SnapshotSyncReport getReport() {
        return this.report;
    }

    public ITeamRepository getRepository() {
        return this.repository;
    }

    public ITeamRepository getRemote() {
        return this.remote;
    }

    public String getContextWherePresent() {
        return this.contextWherePresent;
    }

    public String getContextWhereNotPresent() {
        return this.contextWhereNotPresent;
    }

    @Override
    public int hashCode() {
        if (this.cachedHashCode == 0) {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.component == null ? 0 : this.component.hashCode());
            result = 31 * result + (this.report == null ? 0 : this.report.hashCode());
            this.cachedHashCode = result = 31 * result + super.hashCode();
        }
        return this.cachedHashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StructuralChangesComponentNode other = (StructuralChangesComponentNode)obj;
        if (this.component == null ? other.component != null : !this.component.equals((Object)other.component)) {
            return false;
        }
        if (this.report == null ? other.report != null : !this.report.equals((Object)other.report)) {
            return false;
        }
        return super.equals(obj);
    }

    public static enum ChangeType {
        Addition,
        Removal,
        Modify;

    }
}

