/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.structuralchanges.nodes;

import com.ibm.team.filesystem.client.internal.namespace.ItemNamespace;
import com.ibm.team.filesystem.client.internal.snapshot.FlowType;
import com.ibm.team.filesystem.ui.wrapper.BaselineWrapper;
import com.ibm.team.internal.filesystem.ui.views.structuralchanges.nodes.StructuralChangesViewNode;
import com.ibm.team.scm.common.IBaseline;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.internal.util.ItemId;
import java.util.Set;

public class StructuralChangesBaselineNode
extends StructuralChangesViewNode {
    private int order;
    private ItemId<IBaseline> currentBaseline;
    private ItemId<IBaseline> previousBaseline;
    private BaselineWrapper wrapper;
    private Set<ItemId<IChangeSet>> permittedChangeSets;
    private ItemNamespace namespace;

    public StructuralChangesBaselineNode(int order, BaselineWrapper wrapper, ItemId<IBaseline> baseline, ItemId<IBaseline> previousBaseline, FlowType type, Set<ItemId<IChangeSet>> changeSets, ItemNamespace namespace) {
        super(type);
        this.currentBaseline = baseline;
        this.previousBaseline = previousBaseline;
        this.wrapper = wrapper;
        this.order = order;
        this.permittedChangeSets = changeSets;
        this.namespace = namespace;
    }

    public int getOrder() {
        return this.order;
    }

    public Set<ItemId<IChangeSet>> getPermittedChangeSets() {
        return this.permittedChangeSets;
    }

    @Override
    public BaselineWrapper getWrapper() {
        return this.wrapper;
    }

    public ItemId<IBaseline> getCurrentBaseline() {
        return this.currentBaseline;
    }

    public ItemId<IBaseline> getPreviousBaseline() {
        return this.previousBaseline;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.currentBaseline == null ? 0 : this.currentBaseline.hashCode());
        result = 31 * result + (this.previousBaseline == null ? 0 : this.previousBaseline.hashCode());
        return result + super.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StructuralChangesBaselineNode other = (StructuralChangesBaselineNode)obj;
        if (this.currentBaseline == null ? other.currentBaseline != null : !this.currentBaseline.equals(other.currentBaseline)) {
            return false;
        }
        if (this.previousBaseline == null ? other.previousBaseline != null : !this.previousBaseline.equals(other.previousBaseline)) {
            return false;
        }
        return super.equals(obj);
    }

    public ItemNamespace getNamespace() {
        return this.namespace;
    }
}

