/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.structuralchanges;

import com.ibm.team.filesystem.client.internal.snapshot.FlowType;
import com.ibm.team.filesystem.client.internal.snapshot.SnapshotSyncReport;
import com.ibm.team.filesystem.common.changemodel.IPathResolver;
import com.ibm.team.internal.filesystem.ui.patches.PatchTreeProvider;
import com.ibm.team.internal.filesystem.ui.views.structuralchanges.SnapshotPair;
import com.ibm.team.internal.filesystem.ui.views.structuralchanges.nodes.StructuralChangesComponentNode;
import com.ibm.team.internal.filesystem.ui.views.structuralchanges.nodes.StructuralChangesPlaceholderNode;
import com.ibm.team.internal.filesystem.ui.views.structuralchanges.nodes.StructuralChangesViewFolderNode;
import com.ibm.team.internal.filesystem.ui.views.structuralchanges.queries.ComponentsInSyncReportQuery;
import com.ibm.team.internal.filesystem.ui.views.structuralchanges.queries.FilesInFolderQuery;
import com.ibm.team.internal.filesystem.ui.views.structuralchanges.queries.FoldersInComponentSyncReportQuery;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.rcp.ui.internal.viewers.ISetWithListeners;
import com.ibm.team.repository.rcp.ui.internal.viewers.ITreeProvider;
import com.ibm.team.repository.rcp.ui.internal.viewers.OptionalTreeLevel;
import com.ibm.team.repository.rcp.ui.internal.viewers.WritableSetWithListeners;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.internal.util.ItemId;

final class StructuralTreeProvider
implements ITreeProvider {
    private PatchTreeProvider contentsTree = new PatchTreeProvider();
    private IOperationRunner operationRunner;
    private FlowType type;
    private IPathResolver resolver;
    private ITeamRepository repo;
    private SnapshotPair snapshots;

    public StructuralTreeProvider(ITeamRepository repo, FlowType type, IOperationRunner operationRunner, IPathResolver resolver, SnapshotPair snapshots) {
        this.operationRunner = operationRunner;
        this.type = type;
        this.resolver = resolver;
        this.repo = repo;
        this.snapshots = snapshots;
    }

    public ISetWithListeners getChildren(Object element) {
        StructuralChangesPlaceholderNode placeholderNode;
        if (element instanceof SnapshotSyncReport) {
            SnapshotSyncReport report = (SnapshotSyncReport)element;
            if (this.type == FlowType.Both) {
                WritableSetWithListeners result = new WritableSetWithListeners();
                result.add((Object)new StructuralChangesPlaceholderNode(FlowType.Incoming, report, report.getIncoming().getRepository()));
                result.add((Object)new StructuralChangesPlaceholderNode(FlowType.Outgoing, report, report.getOutgoing().getRepository()));
                return result;
            }
            return this.getChildren(new StructuralChangesPlaceholderNode(this.type, report, report.getOutgoing().getRepository()));
        }
        if (element instanceof StructuralChangesPlaceholderNode && (placeholderNode = (StructuralChangesPlaceholderNode)element).getParent() instanceof SnapshotSyncReport) {
            SnapshotSyncReport syncReport = (SnapshotSyncReport)placeholderNode.getParent();
            ComponentsInSyncReportQuery nextLevel = new ComponentsInSyncReportQuery(this.repo, syncReport.getIncoming().getRepository(), syncReport, placeholderNode.getType(), this.resolver, this.snapshots.get(this.type == FlowType.Both ? FlowType.Outgoing : this.type), this.operationRunner);
            if (syncReport.getComponentChanges(this.type).isEmpty()) {
                return new OptionalTreeLevel((ISetWithListeners)nextLevel, (ITreeProvider)this);
            }
            return nextLevel;
        }
        if (element instanceof StructuralChangesComponentNode) {
            StructuralChangesComponentNode componentNode = (StructuralChangesComponentNode)element;
            FlowType type2 = componentNode.getType();
            if (componentNode.getChangeType() == StructuralChangesComponentNode.ChangeType.Modify && type2 != FlowType.Both) {
                return new FoldersInComponentSyncReportQuery(this.repo, componentNode.getReport(type2), type2, componentNode.getPathResolver(), this.snapshots.get(type2), (ItemId<IComponent>)ItemId.forItem((IItem)componentNode.getComponent()), this.operationRunner);
            }
            return null;
        }
        if (element instanceof StructuralChangesViewFolderNode) {
            StructuralChangesViewFolderNode folderNode = (StructuralChangesViewFolderNode)element;
            return new FilesInFolderQuery(this.operationRunner, folderNode, true);
        }
        return this.contentsTree.getChildren(element);
    }
}

