/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.structuralchanges;

import com.ibm.team.filesystem.client.internal.snapshot.FlowType;
import com.ibm.team.filesystem.common.changemodel.FileChange;
import com.ibm.team.filesystem.common.changemodel.IPathResolver;
import com.ibm.team.filesystem.common.changemodel.VersionablePath;
import com.ibm.team.filesystem.common.internal.util.ComponentHierarchyCompareResult;
import com.ibm.team.filesystem.rcp.core.internal.oslc.OslcLinkWrapper;
import com.ibm.team.filesystem.rcp.core.internal.rest.util.LabelsUtil;
import com.ibm.team.filesystem.ui.UiPlugin;
import com.ibm.team.filesystem.ui.changes.views.DecorationImageDescriptor;
import com.ibm.team.filesystem.ui.changes.views.LocalWorkspaceChangesViewLabelProvider;
import com.ibm.team.filesystem.ui.wrapper.BaselineHierarchyWrapper;
import com.ibm.team.filesystem.ui.wrapper.ChangeSetWrapper;
import com.ibm.team.filesystem.ui.wrapper.WorkspaceComponentWrapper;
import com.ibm.team.foundation.rcp.core.IModelAccessor;
import com.ibm.team.internal.filesystem.ui.ImagePool;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.changes.CustomTreeViewer;
import com.ibm.team.internal.filesystem.ui.labelproviders.ChangeFolderLabelProvider;
import com.ibm.team.internal.filesystem.ui.labelproviders.DecoratedChangeSetLabelProvider;
import com.ibm.team.internal.filesystem.ui.patches.ChangeFolder;
import com.ibm.team.internal.filesystem.ui.views.structuralchanges.PathFunction;
import com.ibm.team.internal.filesystem.ui.views.structuralchanges.nodes.StructuralChangesChangeSetNode;
import com.ibm.team.internal.filesystem.ui.views.structuralchanges.nodes.StructuralChangesComponentNode;
import com.ibm.team.internal.filesystem.ui.views.structuralchanges.nodes.StructuralChangesEquivalentChangeSetsContainerNode;
import com.ibm.team.internal.filesystem.ui.views.structuralchanges.nodes.StructuralChangesOriginalPortSourceNode;
import com.ibm.team.internal.filesystem.ui.views.structuralchanges.nodes.StructuralChangesPlaceholderNode;
import com.ibm.team.internal.filesystem.ui.views.structuralchanges.nodes.StructuralChangesPortSourceNode;
import com.ibm.team.internal.filesystem.ui.views.structuralchanges.nodes.StructuralChangesSubcomponentNode;
import com.ibm.team.internal.filesystem.ui.views.structuralchanges.nodes.StructuralChangesViewFileNode;
import com.ibm.team.internal.filesystem.ui.views.structuralchanges.nodes.StructuralChangesViewFolderNode;
import com.ibm.team.internal.filesystem.ui.views.structuralchanges.nodes.StructuralChangesViewNode;
import com.ibm.team.internal.filesystem.ui.views.structuralchanges.nodes.StructuralChangesViewSymbolicLinkNode;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.rcp.common.IChangeListener;
import com.ibm.team.repository.rcp.ui.internal.utils.BaseLabelProvider;
import com.ibm.team.repository.rcp.ui.internal.viewers.ConvertingLabelProvider;
import com.ibm.team.repository.rcp.ui.internal.viewers.ConvertingSet;
import com.ibm.team.repository.rcp.ui.internal.viewers.FilteredSetWithListeners;
import com.ibm.team.repository.rcp.ui.internal.viewers.IConversion;
import com.ibm.team.repository.rcp.ui.internal.viewers.IDynamicFunction;
import com.ibm.team.repository.rcp.ui.internal.viewers.ISetWithListeners;
import com.ibm.team.repository.rcp.ui.internal.viewers.MixedTypeLabelProvider;
import com.ibm.team.repository.rcp.ui.internal.viewers.SlowFunction;
import com.ibm.team.repository.rcp.ui.labelproviders.LabelProviders;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.repository.rcp.ui.utils.ImageDataImageDescriptor;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IFolder;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.internal.util.ItemId;
import com.ibm.team.scm.common.internal.util.SiloedItemId;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Set;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IViewerLabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;

public class StructuralChangesViewLabelProvider
extends BaseLabelProvider {
    protected final boolean customMarkup;
    private static final String ADDED = Messages.StructuralChangesViewLabelProvider_defaultOutgonigLabel;
    private static final String MISSING = Messages.StructuralChangesViewLabelProvider_defaultIncomingLabel;
    private final IViewerLabelProvider nestedLabelProvider;
    private ILabelProviderListener componentListener = new ILabelProviderListener(){

        public void labelProviderChanged(LabelProviderChangedEvent event) {
            if (event.getElements() == null) {
                StructuralChangesViewLabelProvider.this.fireAllElementsChangedEvent();
            } else {
                ArrayList<Object> elements = new ArrayList<Object>();
                int i = 0;
                while (i < event.getElements().length) {
                    Object next = event.getElements()[i];
                    elements.add(next);
                    ++i;
                }
                StructuralChangesViewLabelProvider.this.fireChangeEvent(elements);
            }
        }
    };
    private IChangeListener pathListener = new IChangeListener(){

        public void changed(Object source, Object property) {
            Object[] elements = (Object[])property;
            StructuralChangesViewLabelProvider.this.fireChangeEvent(elements);
        }
    };
    private ConvertingSet elementsToWrappersConversion;
    private MixedTypeLabelProvider wrapperLabelProvider;
    private ChangeFolderLabelProvider changeFolderLabelProvider;
    private SlowFunction<StructuralChangesViewFolderNode, VersionablePath> folderPathsFunction;
    private PathFunction<StructuralChangesViewNode> fileBeforePathsFunction;
    private PathFunction<StructuralChangesViewNode> fileAfterPathsFunction;
    private String incomingLabel = MISSING;
    private String outgoingLabel = ADDED;
    private String incomingStreamName;
    protected String outgoingStreamName;
    private boolean showOutgoingHierarchy;

    public StructuralChangesViewLabelProvider(ISetWithListeners knownElements, IOperationRunner runner, boolean customMarkup) {
        this.customMarkup = customMarkup;
        this.elementsToWrappersConversion = new ConvertingSet(knownElements, new IConversion(){
            private final Object dummyObject = new Object();

            public Object createAdapter(Object source) {
                if (source instanceof StructuralChangesViewNode) {
                    StructuralChangesViewNode node = (StructuralChangesViewNode)source;
                    Object wrapper = node.getWrapper();
                    if (wrapper == null) {
                        return this.dummyObject;
                    }
                    return wrapper;
                }
                if (source instanceof OslcLinkWrapper) {
                    OslcLinkWrapper wrapper = (OslcLinkWrapper)source;
                    Object resolvedTarget = wrapper.getResolvedTarget();
                    if (resolvedTarget instanceof IItem) {
                        return resolvedTarget;
                    }
                    return source;
                }
                if (source instanceof IModelAccessor) {
                    IModelAccessor modelAccessor = (IModelAccessor)source;
                    return modelAccessor.getModelInstance();
                }
                return source;
            }
        }, true);
        this.folderPathsFunction = new PathFunction<StructuralChangesViewFolderNode>((ISetWithListeners)FilteredSetWithListeners.createTypeFilter((ISetWithListeners)knownElements, StructuralChangesViewFolderNode.class), runner){

            @Override
            protected IPathResolver getResolverFor(StructuralChangesViewFolderNode next) {
                return next.getPaths().getPathResolver(false);
            }

            @Override
            protected SiloedItemId<IVersionable> getUnresolvedPath(StructuralChangesViewFolderNode nextFolder) {
                return SiloedItemId.upcast(nextFolder.getChangeFolder().getPath());
            }
        };
        FilteredSetWithListeners filteredStructuralChangesNodes = FilteredSetWithListeners.createTypeFilter((ISetWithListeners)knownElements, StructuralChangesViewNode.class);
        this.fileBeforePathsFunction = new FilePathFunction(true, (ISetWithListeners)filteredStructuralChangesNodes, runner);
        this.fileAfterPathsFunction = new FilePathFunction(false, (ISetWithListeners)filteredStructuralChangesNodes, runner);
        this.wrapperLabelProvider = new MixedTypeLabelProvider();
        this.wrapperLabelProvider.put(Object.class, LabelProviders.create((ISetWithListeners)this.elementsToWrappersConversion.getRange()));
        this.wrapperLabelProvider.put(ChangeSetWrapper.class, (IViewerLabelProvider)new DecoratedChangeSetLabelProvider(Messages.DecoratedChangeSetLabelProvider_authorWorkItemComment, Messages.DecoratedChangeSetLabelProvider_authorWorkItem, Messages.DecoratedChangeSetLabelProvider_authorComment, Messages.DecoratedChangeSetLabelProvider_authorNone, customMarkup, (ISetWithListeners<ChangeSetWrapper>)FilteredSetWithListeners.createTypeFilter((ISetWithListeners)this.elementsToWrappersConversion.getRange(), ChangeSetWrapper.class), runner));
        this.changeFolderLabelProvider = new ChangeFolderLabelProvider((ISetWithListeners)FilteredSetWithListeners.createTypeFilter((ISetWithListeners)this.elementsToWrappersConversion.getRange(), ChangeFolder.class), runner);
        this.wrapperLabelProvider.put(ChangeFolder.class, (IViewerLabelProvider)this.changeFolderLabelProvider);
        this.wrapperLabelProvider.put(OslcLinkWrapper.class, (IViewerLabelProvider)new BaseLabelProvider(){
            private LocalWorkspaceChangesViewLabelProvider labelProvider = new LocalWorkspaceChangesViewLabelProvider();

            public void updateLabel(ViewerLabel label, Object element) {
                label.setImage(this.labelProvider.getImage(element));
                label.setText(this.labelProvider.getText(element));
            }

            public void dispose() {
                super.dispose();
                this.labelProvider.dispose();
            }
        });
        this.wrapperLabelProvider.put(StructuralChangesPlaceholderNode.class, (IViewerLabelProvider)new BaseLabelProvider(){

            public void updateLabel(ViewerLabel label, Object element) {
                StructuralChangesPlaceholderNode node = (StructuralChangesPlaceholderNode)element;
                switch (node.getType()) {
                    case Incoming: {
                        label.setText(StructuralChangesViewLabelProvider.this.incomingLabel);
                        break;
                    }
                    case Outgoing: {
                        label.setText(StructuralChangesViewLabelProvider.this.outgoingLabel);
                    }
                }
                label.setImage((Image)this.getResources().get((DeviceResourceDescriptor)UiPlugin.getFileSystemImageDescriptor(null)));
            }
        });
        this.nestedLabelProvider = new ConvertingLabelProvider((IViewerLabelProvider)this.wrapperLabelProvider, (IDynamicFunction)this.elementsToWrappersConversion);
        this.getImage((ImageDescriptor)new DecorationImageDescriptor(UiPlugin.getFileSystemImageDescriptor(null), 0, 2));
    }

    public StructuralChangesViewLabelProvider(ISetWithListeners knownElements, IOperationRunner runner) {
        this(knownElements, runner, false);
    }

    public void setCustomContextLabels(String incoming, String outgoing) {
        this.incomingLabel = incoming;
        this.outgoingLabel = outgoing;
        this.fireAllElementsChangedEvent();
    }

    public ConvertingSet getConversion() {
        return this.elementsToWrappersConversion;
    }

    protected void firstListenerAdded() {
        this.folderPathsFunction.addListener(this.pathListener);
        this.fileBeforePathsFunction.addListener(this.pathListener);
        this.fileAfterPathsFunction.addListener(this.pathListener);
        this.nestedLabelProvider.addListener(this.componentListener);
        super.firstListenerAdded();
    }

    protected void lastListenerRemoved() {
        this.folderPathsFunction.removeListener(this.pathListener);
        this.fileBeforePathsFunction.addListener(this.pathListener);
        this.fileAfterPathsFunction.addListener(this.pathListener);
        this.nestedLabelProvider.removeListener(this.componentListener);
        super.lastListenerRemoved();
    }

    public void updateLabel(ViewerLabel label, Object element) {
        this.nestedLabelProvider.updateLabel(label, element);
        if (element instanceof StructuralChangesComponentNode) {
            StructuralChangesComponentNode componentNode = (StructuralChangesComponentNode)element;
            this.updateLabelComponentNode(label, componentNode);
        } else if (element instanceof StructuralChangesSubcomponentNode) {
            StructuralChangesSubcomponentNode componentNode = (StructuralChangesSubcomponentNode)element;
            this.updateLabelSubcomponentNode(label, componentNode);
        } else if (element instanceof StructuralChangesChangeSetNode) {
            StructuralChangesChangeSetNode changeSetNode = (StructuralChangesChangeSetNode)element;
            this.updateLabelChangeSetNode(label, changeSetNode);
        } else if (element instanceof StructuralChangesPortSourceNode) {
            StructuralChangesPortSourceNode portSourcenode = (StructuralChangesPortSourceNode)element;
            this.updateLabelPortSourceNode(label, portSourcenode);
        } else if (element instanceof StructuralChangesEquivalentChangeSetsContainerNode) {
            StructuralChangesEquivalentChangeSetsContainerNode equivalentChangeSetsContainerNode = (StructuralChangesEquivalentChangeSetsContainerNode)element;
            this.updateLabelEquivalentChangeSetsContainerNode(label, equivalentChangeSetsContainerNode);
        } else if (element instanceof StructuralChangesViewSymbolicLinkNode) {
            StructuralChangesViewSymbolicLinkNode symbolicLinkNode = (StructuralChangesViewSymbolicLinkNode)element;
            this.updateLabelSymbolicLinkNode(label, symbolicLinkNode);
        } else if (element instanceof StructuralChangesViewFileNode) {
            StructuralChangesViewFileNode fileNode = (StructuralChangesViewFileNode)element;
            this.updateLabelFileNode(label, fileNode);
        } else if (element instanceof StructuralChangesViewFolderNode) {
            StructuralChangesViewFolderNode folderNode = (StructuralChangesViewFolderNode)element;
            this.updateLabelFolderNode(label, folderNode);
        } else if (element instanceof WorkspaceComponentWrapper) {
            WorkspaceComponentWrapper node = (WorkspaceComponentWrapper)element;
            this.updateLabelWorkspaceComponentNode(label, node);
        } else if (element instanceof BaselineHierarchyWrapper) {
            BaselineHierarchyWrapper node = (BaselineHierarchyWrapper)((Object)element);
            this.updateLabelHierarchicalComponentWrapper(label, node);
        }
    }

    protected void updateLabelHierarchicalComponentWrapper(ViewerLabel label, BaselineHierarchyWrapper node) {
        StructuralChangesComponentNode structuralChangeNode = node.getStructuralChangesComponentNode();
        if (structuralChangeNode != null && !structuralChangeNode.getChangeType().equals((Object)StructuralChangesComponentNode.ChangeType.Modify)) {
            this.updateLabelComponentNode(label, structuralChangeNode);
            return;
        }
        String text = label.getText();
        Image image = label.getImage();
        ImageDescriptor imageDescriptor = null;
        BitSet flags = this.calculateFlags(node.getStructuralChangesComponentNode());
        ComponentHierarchyCompareResult.MovedComponentResult moveResult = node.getMoveResult();
        if (moveResult != null) {
            text = this.showOutgoingHierarchy ? NLS.bind((String)Messages.StructuralChangesViewLabelProvider_notHereInHierarchy, (Object)text, (Object)this.incomingStreamName) : NLS.bind((String)Messages.StructuralChangesViewLabelProvider_notHereInHierarchy, (Object)text, (Object)this.outgoingStreamName);
        }
        this.updateViewerLabel(label, text, image, imageDescriptor, flags);
    }

    protected void updateLabelWorkspaceComponentNode(ViewerLabel label, WorkspaceComponentWrapper node) {
        StructuralChangesComponentNode structuralChangeNode = node.getStructuralChangesComponentNode();
        if (structuralChangeNode != null && !structuralChangeNode.getChangeType().equals((Object)StructuralChangesComponentNode.ChangeType.Modify)) {
            this.updateLabelComponentNode(label, structuralChangeNode);
            return;
        }
        String text = label.getText();
        Image image = label.getImage();
        ImageDescriptor imageDescriptor = null;
        BitSet flags = this.calculateFlags(node.getStructuralChangesComponentNode());
        ComponentHierarchyCompareResult.MovedComponentResult moveResult = node.getMoveResult();
        if (moveResult != null) {
            text = this.showOutgoingHierarchy ? NLS.bind((String)Messages.StructuralChangesViewLabelProvider_notHereInHierarchy, (Object)text, (Object)this.incomingStreamName) : NLS.bind((String)Messages.StructuralChangesViewLabelProvider_notHereInHierarchy, (Object)text, (Object)this.outgoingStreamName);
        }
        this.updateViewerLabel(label, text, image, imageDescriptor, flags);
    }

    protected void updateLabelComponentNode(ViewerLabel label, StructuralChangesComponentNode componentNode) {
        String text = label.getText();
        Image image = label.getImage();
        ImageDescriptor imageDescriptor = null;
        if (image == null) {
            imageDescriptor = ImagePool.COMPONENT;
        }
        BitSet flags = this.calculateFlags(componentNode);
        text = this.getComponentLabelText(componentNode);
        this.updateViewerLabel(label, text, image, imageDescriptor, flags);
    }

    private BitSet calculateFlags(StructuralChangesComponentNode componentNode) {
        BitSet flags = new BitSet();
        if (componentNode == null) {
            return flags;
        }
        StructuralChangesComponentNode.ChangeType changeType = componentNode.getChangeType();
        if (changeType != StructuralChangesComponentNode.ChangeType.Modify) {
            FlowType flowType = componentNode.getType() == FlowType.Both ? FlowType.Outgoing : componentNode.getType();
            flags = StructuralChangesViewLabelProvider.flowTypeToDecorationFlag(flowType);
            flags.or(this.componentChangeTypeToDecorationFlag(changeType, flowType));
        }
        return flags;
    }

    protected void updateLabelSubcomponentNode(ViewerLabel label, StructuralChangesSubcomponentNode componentNode) {
        ImageDescriptor imageDescriptor = ImagePool.COMPONENT_UNLOADED;
        BitSet flags = new BitSet();
        IComponent component = componentNode.getComponent();
        String text = component != null ? component.getName() : NLS.bind((String)Messages.StructuralChangesViewLabelProvider_inaccessibleSubcomponentLabel, (Object)componentNode.getComponentHandle().getItemId().getUuidValue());
        if (componentNode.getChangeType() == StructuralChangesSubcomponentNode.ChangeType.Addition) {
            flags.set(33);
            text = String.valueOf(text) + Messages.StructuralChangesViewLabelProvider_subcomponentAddedLabelDecorator;
        } else if (componentNode.getChangeType() == StructuralChangesSubcomponentNode.ChangeType.Removal) {
            flags.set(34);
            text = String.valueOf(text) + Messages.StructuralChangesViewLabelProvider_subcomponentRemovedLabelDecorator;
        }
        if (component == null) {
            text = CustomTreeViewer.markupInaccessible(text, true);
        }
        this.updateViewerLabel(label, text, null, imageDescriptor, flags);
    }

    protected String getComponentLabelText(StructuralChangesComponentNode componentNode) {
        String componentName = componentNode.getComponent().getName();
        String contextWherePresent = componentNode.getContextWherePresent();
        String contextWhereNotPresent = componentNode.getContextWhereNotPresent();
        if (contextWherePresent != null && contextWhereNotPresent != null) {
            String decorator = NLS.bind((String)Messages.StructuralChangesViewLabelProvider_ComponentAddedOrRemovedDecorator, (Object)contextWherePresent, (Object)contextWhereNotPresent);
            String decoratorWithMarkup = CustomTreeViewer.markupName(decorator, this.customMarkup);
            componentName = NLS.bind((String)Messages.StructuralChangesViewLabelProvider_portSourceDecoratorBinding, (Object)componentName, (Object)decoratorWithMarkup);
        }
        return componentName;
    }

    protected void updateLabelChangeSetNode(ViewerLabel label, StructuralChangesChangeSetNode changeSetNode) {
        String text = label.getText();
        Image image = label.getImage();
        ImageDescriptor imageDescriptor = null;
        BitSet flags = new BitSet();
        int inaccessibleChanges = changeSetNode.getInaccessibleChanges();
        if (inaccessibleChanges > 0) {
            flags = StructuralChangesViewLabelProvider.flowTypeToDecorationFlag(changeSetNode.getType());
            String inaccessibleText = inaccessibleChanges > 1 ? NLS.bind((String)Messages.StructuralChangesViewLabelProvider_manyInaccessibleChanges, (Object)inaccessibleChanges) : Messages.StructuralChangesViewLabelProvider_oneInaccessibleChange;
            inaccessibleText = CustomTreeViewer.markupConflict(inaccessibleText, this.customMarkup);
            text = NLS.bind((String)Messages.StructuralChangesViewLabelProvider_inaccessibleChangesDecoration, (Object)text, (Object)inaccessibleText);
        }
        this.updateViewerLabel(label, text, image, imageDescriptor, flags);
    }

    protected void updateLabelPortSourceNode(ViewerLabel label, StructuralChangesPortSourceNode portSourceNode) {
        String text = label.getText();
        Image image = label.getImage();
        ImageDescriptor imageDescriptor = null;
        BitSet flags = StructuralChangesViewLabelProvider.flowTypeToDecorationFlag(portSourceNode.getType());
        String decorator = portSourceNode instanceof StructuralChangesOriginalPortSourceNode ? Messages.StructuralChangesViewLabelProvider_originalPortSourceDecorator : Messages.StructuralChangesViewLabelProvider_portSourceDecorator;
        String decoratorWithMarkup = CustomTreeViewer.markupConflict(decorator, this.customMarkup);
        text = NLS.bind((String)Messages.StructuralChangesViewLabelProvider_portSourceDecoratorBinding, (Object)text, (Object)decoratorWithMarkup);
        this.updateViewerLabel(label, text, image, imageDescriptor, flags);
    }

    protected void updateLabelEquivalentChangeSetsContainerNode(ViewerLabel label, StructuralChangesEquivalentChangeSetsContainerNode equivalentChangeSetsContainerNode) {
        String text = label.getText();
        Image image = label.getImage();
        ImageDescriptor imageDescriptor = null;
        BitSet flags = new BitSet();
        text = NLS.bind((String)Messages.StructuralChangesViewLabelProvider_RELATED_CHANGE_SETS_FOLDER_DECORATOR, (Object)CustomTreeViewer.markupName(text, true));
        imageDescriptor = ImagePool.PORTS_FOLDER_ICON;
        this.updateViewerLabel(label, text, image, imageDescriptor, flags);
    }

    protected void updateLabelSymbolicLinkNode(ViewerLabel label, StructuralChangesViewSymbolicLinkNode symbolicLinknode) {
        String text = label.getText();
        String versionId = this.getVersionId(symbolicLinknode);
        if (versionId != null) {
            versionId = CustomTreeViewer.markupDecorations(versionId, this.customMarkup);
            text = NLS.bind((String)Messages.StructuralChangesViewLabelProvider_versionedPathString, (Object)text, (Object)versionId);
        }
        Image image = label.getImage();
        ImageDescriptor imageDescriptor = null;
        FileChange fileChange = symbolicLinknode.getChange();
        BitSet flags = StructuralChangesViewLabelProvider.flowTypeToDecorationFlag(symbolicLinknode.getType());
        flags.or(this.fileChangeToDecorationFlag(fileChange));
        text = this.updateLabelFileChange(text, symbolicLinknode, fileChange);
        this.updateViewerLabel(label, text, image, imageDescriptor, flags);
    }

    protected void updateLabelFileNode(ViewerLabel label, StructuralChangesViewFileNode fileNode) {
        String text = label.getText();
        String versionId = this.getVersionId(fileNode);
        if (versionId != null) {
            versionId = CustomTreeViewer.markupDecorations(versionId, this.customMarkup);
            text = NLS.bind((String)Messages.StructuralChangesViewLabelProvider_versionedPathString, (Object)text, (Object)versionId);
        }
        Image image = label.getImage();
        ImageDescriptor imageDescriptor = null;
        FileChange fileChange = fileNode.getChange();
        BitSet flags = StructuralChangesViewLabelProvider.flowTypeToDecorationFlag(fileNode.getType());
        flags.or(this.fileChangeToDecorationFlag(fileChange));
        text = this.updateLabelFileChange(text, fileNode, fileChange);
        this.updateViewerLabel(label, text, image, imageDescriptor, flags);
    }

    protected void updateLabelFolderNode(ViewerLabel label, StructuralChangesViewFolderNode folderNode) {
        String text = label.getText();
        Image image = label.getImage();
        ImageDescriptor imageDescriptor = null;
        BitSet flags = new BitSet();
        VersionablePath path = (VersionablePath)this.folderPathsFunction.computeResult((Object)folderNode);
        text = path == null ? Messages.StructuralChangesViewLabelProvider_unknownPathString : path.toString();
        Set<FileChange> folderChanges = folderNode.getChangeFolder().getFolderChanges();
        if (folderChanges.size() == 1) {
            FileChange fileChange = folderChanges.iterator().next();
            flags = StructuralChangesViewLabelProvider.flowTypeToDecorationFlag(folderNode.getType());
            flags.or(this.fileChangeToDecorationFlag(fileChange));
            text = this.updateLabelFileChange(text, folderNode, fileChange);
        }
        this.updateViewerLabel(label, text, image, imageDescriptor, flags);
    }

    private void updateViewerLabel(ViewerLabel label, String text, Image image, ImageDescriptor imageDescriptor, BitSet flags) {
        if (imageDescriptor == null && image != null) {
            imageDescriptor = ImageDataImageDescriptor.createFromImage((Image)image);
        }
        if (imageDescriptor != null) {
            DecorationImageDescriptor decoratedDescriptor = new DecorationImageDescriptor(imageDescriptor, flags, 2);
            label.setImage(this.getImage((ImageDescriptor)decoratedDescriptor));
        }
        label.setText(text);
    }

    public void setPathResolver(IPathResolver pathResolver) {
        this.changeFolderLabelProvider.setPathResolver(pathResolver);
    }

    private static BitSet flowTypeToDecorationFlag(FlowType type) {
        BitSet flags = new BitSet();
        switch (type) {
            case Incoming: {
                flags.set(5);
                break;
            }
            case Outgoing: {
                flags.set(6);
                break;
            }
        }
        return flags;
    }

    private String getVersionId(StructuralChangesViewNode node) {
        if (node instanceof StructuralChangesViewFileNode) {
            return ((StructuralChangesViewFileNode)node).getVersionId();
        }
        if (node instanceof StructuralChangesViewFolderNode) {
            return ((StructuralChangesViewFolderNode)node).getVersionId();
        }
        if (node instanceof StructuralChangesViewSymbolicLinkNode) {
            return ((StructuralChangesViewSymbolicLinkNode)node).getVersionId();
        }
        return null;
    }

    private BitSet fileChangeToDecorationFlag(FileChange fileChange) {
        BitSet flags = new BitSet();
        if (fileChange.getFinal().isDeleted()) {
            flags.set(8);
        } else if (fileChange.getInitial().isDeleted()) {
            flags.set(7);
        }
        return flags;
    }

    private BitSet componentChangeTypeToDecorationFlag(StructuralChangesComponentNode.ChangeType changeType, FlowType flowType) {
        BitSet flags = new BitSet();
        block0 : switch (changeType) {
            case Addition: {
                switch (flowType) {
                    case Outgoing: {
                        flags.set(34);
                        break block0;
                    }
                    case Incoming: {
                        flags.set(31);
                        break block0;
                    }
                    case Both: {
                        break block0;
                    }
                }
                break;
            }
            case Removal: {
                switch (flowType) {
                    case Outgoing: {
                        flags.set(33);
                        break block0;
                    }
                    case Incoming: {
                        flags.set(32);
                        break block0;
                    }
                    case Both: {
                        break block0;
                    }
                }
            }
        }
        return flags;
    }

    private String updateLabelFileChange(String text, StructuralChangesViewNode node, FileChange fileChange) {
        if (!fileChange.getFinal().isDeleted() && !fileChange.getInitial().isDeleted()) {
            VersionablePath beforePath = (VersionablePath)this.fileBeforePathsFunction.computeResult(node);
            VersionablePath afterPath = (VersionablePath)this.fileAfterPathsFunction.computeResult(node);
            if (beforePath != null && afterPath != null && !beforePath.equals((Object)afterPath)) {
                String[] pathHint = beforePath.getStringSegments();
                String[] newPathHint = afterPath.getStringSegments();
                text = String.valueOf(text) + LabelsUtil.getTextDecoration((String[])pathHint, (String[])newPathHint);
            }
        } else if (fileChange.getInitial().isDeleted() && fileChange.getFinal().isDeleted()) {
            text = Messages.StructuralChangesViewLabelProvider_unresolvedChange;
        }
        return text;
    }

    public void dispose() {
        this.nestedLabelProvider.dispose();
        super.dispose();
    }

    public void clearCustomContextLabels() {
        this.setCustomContextLabels(MISSING, ADDED);
    }

    public void setStreamNames(String incomingName, String outgoingName) {
        this.incomingStreamName = incomingName;
        this.outgoingStreamName = outgoingName;
    }

    public void setShowOutgoingHierarchy(boolean showOutgoingHierarchy) {
        this.showOutgoingHierarchy = showOutgoingHierarchy;
    }

    private final class FilePathFunction
    extends PathFunction<StructuralChangesViewNode> {
        private boolean beforePaths;

        private FilePathFunction(boolean beforePaths, ISetWithListeners<StructuralChangesViewNode> domain, IOperationRunner runner) {
            super(domain, runner);
            this.beforePaths = beforePaths;
        }

        @Override
        protected IPathResolver getResolverFor(StructuralChangesViewNode next) {
            if (next instanceof StructuralChangesViewFileNode) {
                StructuralChangesViewFileNode fileNode = (StructuralChangesViewFileNode)next;
                return fileNode.getFolder().getPaths().getPathResolver(this.beforePaths);
            }
            if (next instanceof StructuralChangesViewSymbolicLinkNode) {
                StructuralChangesViewSymbolicLinkNode symbolicLinkNode = (StructuralChangesViewSymbolicLinkNode)next;
                return symbolicLinkNode.getFolder().getPaths().getPathResolver(this.beforePaths);
            }
            if (next instanceof StructuralChangesViewFolderNode) {
                StructuralChangesViewFolderNode folderNode = (StructuralChangesViewFolderNode)next;
                return folderNode.getPaths().getPathResolver(this.beforePaths);
            }
            return null;
        }

        @Override
        protected SiloedItemId<IVersionable> getUnresolvedPath(StructuralChangesViewNode nextFolder) {
            if (nextFolder instanceof StructuralChangesViewFileNode) {
                StructuralChangesViewFileNode fileNode = (StructuralChangesViewFileNode)nextFolder;
                return fileNode.getChange().getSiloedItemId();
            }
            if (nextFolder instanceof StructuralChangesViewSymbolicLinkNode) {
                StructuralChangesViewSymbolicLinkNode symbolicLinkNode = (StructuralChangesViewSymbolicLinkNode)nextFolder;
                return symbolicLinkNode.getChange().getSiloedItemId();
            }
            if (nextFolder instanceof StructuralChangesViewFolderNode) {
                StructuralChangesViewFolderNode folderNode = (StructuralChangesViewFolderNode)nextFolder;
                return SiloedItemId.upcast(folderNode.getChangeFolder().getPath());
            }
            return SiloedItemId.create((ItemId)ItemId.getNullItem((IItemType)IFolder.ITEM_TYPE), (ItemId)ItemId.getNullItem((IItemType)IComponent.ITEM_TYPE));
        }
    }
}

