/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.structuralchanges;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.internal.snapshot.BaselineSetId;
import com.ibm.team.filesystem.client.internal.snapshot.BaselineSnapshot;
import com.ibm.team.filesystem.client.internal.snapshot.FlowType;
import com.ibm.team.filesystem.client.internal.snapshot.ISnapshot;
import com.ibm.team.filesystem.client.internal.snapshot.SnapshotId;
import com.ibm.team.filesystem.client.internal.snapshot.SnapshotSyncReport;
import com.ibm.team.filesystem.client.internal.snapshot.WorkspaceId;
import com.ibm.team.filesystem.client.internal.snapshot.WorkspaceSnapshot;
import com.ibm.team.filesystem.common.changemodel.IPathResolver;
import com.ibm.team.filesystem.common.internal.util.ComponentHierarchyCompareResult;
import com.ibm.team.filesystem.ide.ui.internal.util.ExternalCompareToolUtils;
import com.ibm.team.filesystem.rcp.core.internal.FileSystemResourcesPlugin;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ComponentSyncUtil;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.FallbackPathResolver;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.SnapshotPathResolver;
import com.ibm.team.filesystem.rcp.core.internal.oslc.OslcLinkWrapper;
import com.ibm.team.filesystem.rcp.ui.internal.RcpUiPlugin;
import com.ibm.team.filesystem.ui.actions.TanActions;
import com.ibm.team.filesystem.ui.changes.actions.OpenFileChangeInExternalCompareAction;
import com.ibm.team.filesystem.ui.changes.views.LocalSynchronizeDecorator;
import com.ibm.team.filesystem.ui.wrapper.BaselineHierarchyWrapper;
import com.ibm.team.filesystem.ui.wrapper.BaselineWrapper;
import com.ibm.team.filesystem.ui.wrapper.ChangeSetLinkWrapper;
import com.ibm.team.filesystem.ui.wrapper.ChangeSetWrapper;
import com.ibm.team.filesystem.ui.wrapper.ComponentWrapper;
import com.ibm.team.filesystem.ui.wrapper.ContributorPlaceComponentWrapper;
import com.ibm.team.filesystem.ui.wrapper.WorkspaceComponentWrapper;
import com.ibm.team.foundation.common.util.Adapters;
import com.ibm.team.internal.filesystem.ui.ImagePool;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.changes.CustomSimpleTreeViewer;
import com.ibm.team.internal.filesystem.ui.changes.CustomTreeViewer;
import com.ibm.team.internal.filesystem.ui.patches.ChangeFolder;
import com.ibm.team.internal.filesystem.ui.util.MenuUtil;
import com.ibm.team.internal.filesystem.ui.views.structuralchanges.ChangeHistorySyncReportInput;
import com.ibm.team.internal.filesystem.ui.views.structuralchanges.ChangeSetInput;
import com.ibm.team.internal.filesystem.ui.views.structuralchanges.ChangeSetPortExplorationInput;
import com.ibm.team.internal.filesystem.ui.views.structuralchanges.ChangeSetPortExplorationTreeProvider;
import com.ibm.team.internal.filesystem.ui.views.structuralchanges.ChangesTreeProvider;
import com.ibm.team.internal.filesystem.ui.views.structuralchanges.GenerateChangeLogRepositoryOperation;
import com.ibm.team.internal.filesystem.ui.views.structuralchanges.PathResolverSelectionPage;
import com.ibm.team.internal.filesystem.ui.views.structuralchanges.SnapshotCompareInput;
import com.ibm.team.internal.filesystem.ui.views.structuralchanges.SnapshotPair;
import com.ibm.team.internal.filesystem.ui.views.structuralchanges.StructuralChangesDragTargetAdapter;
import com.ibm.team.internal.filesystem.ui.views.structuralchanges.StructuralChangesViewComparator;
import com.ibm.team.internal.filesystem.ui.views.structuralchanges.StructuralChangesViewInput;
import com.ibm.team.internal.filesystem.ui.views.structuralchanges.StructuralChangesViewLabelProvider;
import com.ibm.team.internal.filesystem.ui.views.structuralchanges.nodes.StructuralChangesBaselineNode;
import com.ibm.team.internal.filesystem.ui.views.structuralchanges.nodes.StructuralChangesComponentNode;
import com.ibm.team.internal.filesystem.ui.views.structuralchanges.nodes.StructuralChangesEquivalentChangeSetsContainerNode;
import com.ibm.team.internal.filesystem.ui.views.structuralchanges.nodes.StructuralChangesPlaceholderNode;
import com.ibm.team.internal.filesystem.ui.views.structuralchanges.nodes.StructuralChangesViewFileNode;
import com.ibm.team.internal.filesystem.ui.views.structuralchanges.nodes.StructuralChangesViewFolderNode;
import com.ibm.team.internal.filesystem.ui.views.structuralchanges.nodes.StructuralChangesViewSymbolicLinkNode;
import com.ibm.team.internal.filesystem.ui.views.structuralchanges.queries.ComponentsInSyncReportQuery;
import com.ibm.team.jface.viewerutilities.ContextMenuHelper;
import com.ibm.team.process.rcp.ui.teamnavigator.IMenuOperationTarget;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.rcp.common.IChangeListener;
import com.ibm.team.repository.rcp.common.collection.SetDiff;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.internal.menus.ActionExtContributionItem;
import com.ibm.team.repository.rcp.ui.internal.menus.IActionExt;
import com.ibm.team.repository.rcp.ui.internal.menus.PushAction;
import com.ibm.team.repository.rcp.ui.internal.menus.RadioAction;
import com.ibm.team.repository.rcp.ui.internal.menus.SeparatorExt;
import com.ibm.team.repository.rcp.ui.internal.query.PopupLayout;
import com.ibm.team.repository.rcp.ui.internal.utils.SWTUtil;
import com.ibm.team.repository.rcp.ui.internal.viewers.ConvertingSelectionProvider;
import com.ibm.team.repository.rcp.ui.internal.viewers.ConvertingSet;
import com.ibm.team.repository.rcp.ui.internal.viewers.FilteredSelectionProvider;
import com.ibm.team.repository.rcp.ui.internal.viewers.IConversion;
import com.ibm.team.repository.rcp.ui.internal.viewers.IDynamicFunction;
import com.ibm.team.repository.rcp.ui.internal.viewers.ISetListener;
import com.ibm.team.repository.rcp.ui.internal.viewers.ISetWithListeners;
import com.ibm.team.repository.rcp.ui.internal.viewers.ITreePathRunnable;
import com.ibm.team.repository.rcp.ui.internal.viewers.ITreeProvider;
import com.ibm.team.repository.rcp.ui.internal.viewers.SimpleTreeViewer;
import com.ibm.team.repository.rcp.ui.internal.viewers.WritableValue;
import com.ibm.team.repository.rcp.ui.openactions.OpenAction;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.LoggedInRunner;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.repository.rcp.ui.parts.AbstractViewWithInput;
import com.ibm.team.repository.rcp.ui.parts.IBusyHandler;
import com.ibm.team.repository.rcp.ui.parts.IContextMenuHandler;
import com.ibm.team.repository.rcp.ui.parts.IGlobalActionHandler;
import com.ibm.team.repository.rcp.ui.parts.IPartSite;
import com.ibm.team.repository.rcp.ui.parts.IPartSiteServices;
import com.ibm.team.repository.rcp.ui.parts.WidgetToolkit;
import com.ibm.team.repository.rcp.ui.parts.impl.MessageDialogFactory;
import com.ibm.team.repository.rcp.ui.utils.WidgetFactoryContext;
import com.ibm.team.repository.rcp.ui.wizards.IRunnableWithResult;
import com.ibm.team.repository.rcp.ui.wizards.WizardUtil;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IBaselineSetHandle;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IHierarchyResult;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.LegacyActionTools;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.LayoutConstants;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.IFilter;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;

public class StructuralChangesView
extends AbstractViewWithInput {
    private static final String NLS_SHOW_MISSING_CHANGES = Messages.StructuralChangesView_showIncomingChangesRadio;
    private static final String NLS_SHOW_ADDED_CHANGES = Messages.StructuralChangesView_showOutgoingChangesRadio;
    private static final String NLS_EXPAND_COMPONENTS = Messages.StructuralChangesView_expandComponentsAction;
    private static final String NLS_EXPAND_TO_CHANGE_SETS = Messages.StructuralChangesView_expandToChangeSetsAction;
    public static final String ID = "com.ibm.team.filesystem.ui.changes.views.ChangeExplorerView";
    private SimpleTreeViewer treeViewer;
    private Map<UUID, StructuralChangesComponentNode> structuralChangesMap = new HashMap<UUID, StructuralChangesComponentNode>();
    private IWorkspaceConnection incomingConnection;
    private IWorkspaceConnection outgoingConnection;
    private IHierarchyResult incomingHierarchy;
    private IHierarchyResult outgoingHierarchy;
    private IChangeListener filterListener = new IChangeListener(){

        public void changed(Object source, Object property) {
            StructuralChangesView.this.updateTreeInput();
        }
    };
    private SnapshotSyncReport currentSyncReport;
    private StructuralChangesViewInput input;
    private WritableValue filter = new WritableValue((Object)FlowType.Both);
    private RadioAction incomingAction;
    private RadioAction outgoingAction;
    private RadioAction noFilterAction;
    private PushAction swapHierarchiesAction;
    private PushAction selectContextAction;
    private PushAction expandComponentsAction;
    private PushAction expandToChangeSetsAction;
    private PushAction collapseAllAction;
    private PushAction changeLogAction;
    private PushAction expandAllContextMenuAction;
    private Composite popupParent;
    private Composite unresolvedPathsWarning;
    private int unresolvedCount;
    private SnapshotId selectedSnapshot;
    private StructuralChangesViewLabelProvider labelProvider;
    private LoggedInRunner loggedInRunner;
    private PushAction refreshAction;
    private Image warningImage;
    private IPropertyChangeListener versionIdentifierPreferenceListener;
    private Preferences.IPropertyChangeListener fileSystemResourcesPluginPreferenceListener;

    public StructuralChangesView(IPartSite site, StructuralChangesViewInput initialInput) {
        super(site, StructuralChangesViewInput.class, (Object)initialInput);
        this.loggedInRunner = new LoggedInRunner(site.getOperationRunner());
        WidgetFactoryContext context = site.getContext();
        WidgetToolkit toolkit = context.getToolkit();
        Composite parent = site.getParent();
        IContextMenuHandler cmh = (IContextMenuHandler)Adapters.getAdapter((Object)site, IContextMenuHandler.class);
        if (cmh == null) {
            throw new IllegalArgumentException("This view can only be hosted in a site that supports context menus");
        }
        IGlobalActionHandler gah = (IGlobalActionHandler)Adapters.getAdapter((Object)site, IGlobalActionHandler.class);
        final IPartSiteServices pss = (IPartSiteServices)Adapters.getAdapter((Object)site, IPartSiteServices.class);
        this.popupParent = toolkit.createComposite(parent);
        Tree tree = new Tree(this.popupParent, 770);
        CustomTreeViewer customTreeViewer = new CustomTreeViewer(tree);
        this.treeViewer = new CustomSimpleTreeViewer(customTreeViewer, new ITreeProvider(){

            public ISetWithListeners getChildren(Object element) {
                return null;
            }
        });
        TanActions.addTanActions(gah, (IMenuManager)this.treeViewer.getContextMenu(), (IWorkbenchSite)pss.getPart().getSite(), this.treeViewer.getSelectionProvider(), IMenuOperationTarget.ALL_TYPES);
        ContextMenuHelper.addNewSubmenu((IMenuManager)this.treeViewer.getContextMenu(), (boolean)false);
        this.labelProvider = new StructuralChangesViewLabelProvider(this.treeViewer.getKnownElements(), site.getOperationRunner(), true);
        customTreeViewer.init(new DecoratingLabelProvider((ILabelProvider)this.labelProvider, (ILabelDecorator)new LocalSynchronizeDecorator(true)));
        this.treeViewer.setProgressService((IBusyHandler)site);
        ConvertingSet convertingSet = new ConvertingSet(this.treeViewer.getKnownElements(), new IConversion(){

            public Object createAdapter(Object source) {
                if (source instanceof StructuralChangesEquivalentChangeSetsContainerNode) {
                    return source;
                }
                return StructuralChangesView.this.labelProvider.getConversion().computeResult(source);
            }
        }, true);
        cmh.registerContextMenu(this.treeViewer.getContextMenu(), (ISelectionProvider)new ConvertingSelectionProvider(this.treeViewer.getSelectionProvider(), (IDynamicFunction)convertingSet));
        cmh.registerContextMenu(this.treeViewer.getContextMenu(), (ISelectionProvider)new FilteredSelectionProvider(this.treeViewer.getSelectionProvider(), new IFilter(){

            public boolean select(Object toTest) {
                if (toTest instanceof OslcLinkWrapper) {
                    OslcLinkWrapper wrapper = (OslcLinkWrapper)toTest;
                    return wrapper.getResolvedTarget() instanceof IItem;
                }
                return true;
            }
        }));
        this.treeViewer.setSorter(StructuralChangesViewComparator.getComparator());
        this.treeViewer.getKnownElements().addListener((ISetListener)new ISetListener<Object>(){

            public void changed(SetDiff<Object> diff) {
                StructuralChangesViewFolderNode node;
                for (Object object : diff.getRemovals()) {
                    if (!(object instanceof StructuralChangesViewFolderNode) || (node = (StructuralChangesViewFolderNode)object).getPath().isResolved() && node.getPath() != null) continue;
                    StructuralChangesView.this.reportUnresolved(false);
                }
                for (Object object : diff.getAdditions()) {
                    if (!(object instanceof StructuralChangesViewFolderNode) || (node = (StructuralChangesViewFolderNode)object).getPath().isResolved() && node.getPath() != null) continue;
                    StructuralChangesView.this.reportUnresolved(true);
                }
            }
        });
        this.treeViewer.setHoverProvider(new IConversion(){

            public Object createAdapter(Object source) {
                return StructuralChangesView.this.labelProvider.getConversion().computeResult(source);
            }
        });
        if (pss != null) {
            this.treeViewer.setDoubleClickHandler(new ITreePathRunnable(){

                public void run(TreePath selectedObject, Shell targetShell) {
                    Object newSelection = StructuralChangesView.this.labelProvider.getConversion().computeResult(selectedObject.getLastSegment());
                    if (newSelection != null) {
                        if (newSelection instanceof BaselineWrapper || newSelection instanceof IComponent || newSelection instanceof ChangeFolder || newSelection instanceof ChangeSetWrapper || newSelection instanceof ComponentWrapper || newSelection instanceof ContributorPlaceComponentWrapper || newSelection instanceof StructuralChangesPlaceholderNode) {
                            StructuralChangesView.this.treeViewer.toggleExpandedState(selectedObject);
                        } else {
                            if (newSelection instanceof ChangeSetLinkWrapper) {
                                newSelection = ((ChangeSetLinkWrapper)((Object)newSelection)).getItem();
                            }
                            if (ExternalCompareToolUtils.shouldUseExternalCompareTool(newSelection)) {
                                OpenFileChangeInExternalCompareAction action = new OpenFileChangeInExternalCompareAction();
                                action.run(targetShell, pss.getPage(), (IStructuredSelection)new StructuredSelection(newSelection));
                            } else {
                                OpenAction openAction = new OpenAction(pss.getPage());
                                openAction.run(newSelection, targetShell);
                            }
                        }
                    }
                }
            });
        }
        GridDataFactory.fillDefaults().grab(true, true).applyTo(this.treeViewer.getControl());
        this.unresolvedPathsWarning = this.createUnresolvedPathsWarning(this.popupParent, context);
        PopupLayout layout = new PopupLayout();
        layout.setMainControl(this.treeViewer.getControl());
        this.popupParent.setLayout((Layout)layout);
        this.refreshAction = new PushAction(ImagePool.REFRESH_ICON, Messages.StructuralChangesView_refreshAction, new Runnable(){

            @Override
            public void run() {
                StructuralChangesView.this.refreshView(StructuralChangesView.this.input, Display.getCurrent(), true);
                StructuralChangesView.this.treeViewer.refresh();
            }
        });
        this.addDragSupport(this.treeViewer);
        this.outgoingAction = new RadioAction(ImagePool.SHOW_OUTGOING, NLS_SHOW_ADDED_CHANGES, (Object)FlowType.Outgoing, this.filter);
        this.incomingAction = new RadioAction(ImagePool.SHOW_INCOMING, NLS_SHOW_MISSING_CHANGES, (Object)FlowType.Incoming, this.filter);
        this.noFilterAction = new RadioAction(ImagePool.SHOW_INCOMING_OUTGOING, Messages.StructuralChangesView_showAllChangesRadio, (Object)FlowType.Both, this.filter);
        this.swapHierarchiesAction = new PushAction(ImagePool.SWAP_HIERARCHIES, Messages.StructuralChangesView_swapHierarchiesAction, new Runnable(){

            @Override
            public void run() {
                if (StructuralChangesView.this.input instanceof SnapshotCompareInput) {
                    StructuralChangesView.this.setInput(SnapshotCompareInput.create(StructuralChangesView.this.input.getIncoming(), StructuralChangesView.this.input.getOutgoing()));
                }
            }
        });
        this.swapHierarchiesAction.setEnabled(this.areComponentHierarchiesEnabled());
        this.selectContextAction = new PushAction(ImagePool.SUMMARY_CHANGE_CONTEXT, Messages.ChangeSummaryView_selectContextAction, new Runnable(){

            @Override
            public void run() {
                StructuralChangesView.this.resolvePaths();
            }
        });
        this.expandComponentsAction = new PushAction(ImagePool.EXPANDCOMPONENTS_ICON, NLS_EXPAND_COMPONENTS, new Runnable(){

            @Override
            public void run() {
                StructuralChangesView.this.expandComponents();
            }
        });
        this.expandToChangeSetsAction = new PushAction(ImagePool.EXPANDTOCHANGES_ICON, NLS_EXPAND_TO_CHANGE_SETS, new Runnable(){

            @Override
            public void run() {
                StructuralChangesView.this.expandToChangeSets();
            }
        });
        this.collapseAllAction = new PushAction(ImagePool.COLLAPSEALL_ICON, Messages.StructuralChangesView_collapseAllAction, new Runnable(){

            @Override
            public void run() {
                StructuralChangesView.this.collapseAll();
            }
        });
        this.changeLogAction = new PushAction(ImagePool.HISTORY_OF_STREAM, Messages.StructuralChangesView_saveChangeLog, new Runnable(){

            @Override
            public void run() {
                if (StructuralChangesView.this.selectedSnapshot == null) {
                    return;
                }
                GenerateChangeLogRepositoryOperation operation = new GenerateChangeLogRepositoryOperation(StructuralChangesView.this.input, StructuralChangesView.this.selectedSnapshot, StructuralChangesView.this.currentSyncReport, (FlowType)StructuralChangesView.this.filter.getValue(), StructuralChangesView.this.getControlSite().getShell());
                if (operation.prompt()) {
                    StructuralChangesView.this.getControlSite().getOperationRunner().enqueue(Messages.CopyChangeLogDialog_SAVE_CHANGELOG_JOB_NAME, (Operation)operation);
                }
            }
        });
        this.changeLogAction.setEnabled(false);
        this.changeLogAction.setImage(ImagePool.CREATE_CHANGELOG);
        this.expandAllContextMenuAction = new PushAction(Messages.StructuralChangesView_expandChildrenAction, new Runnable(){

            @Override
            public void run() {
                StructuralChangesView.this.expandAllContextAction();
            }
        });
        this.treeViewer.getContextMenu().add((IContributionItem)new ActionExtContributionItem((IActionExt)this.expandAllContextMenuAction));
        this.treeViewer.getContextMenu().add((IContributionItem)new Separator("relatedArtifactsGroup"));
        this.filter.addListener(this.filterListener);
        site.setSelectionProvider(this.treeViewer.getSelectionProvider());
        String helpID = this.input instanceof ChangeSetPortExplorationInput ? "com.ibm.team.filesystem.ide.ui.view_changeexplorerforlinks" : "com.ibm.team.filesystem.ide.ui.view_changeexplorer";
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.popupParent, helpID);
        if (this.versionIdentifierPreferenceListener == null) {
            this.versionIdentifierPreferenceListener = new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    String property = event.getProperty();
                    if (("pref_show_version_identifiers_change_explorer".equals(property) || "pref_show_version_identifiers_repository_id".equals(property)) && !StructuralChangesView.this.treeViewer.getControl().isDisposed()) {
                        StructuralChangesView.this.treeViewer.refresh();
                    }
                }
            };
            RcpUiPlugin.getDefault().getPreferenceStore().addPropertyChangeListener(this.versionIdentifierPreferenceListener);
            if (this.fileSystemResourcesPluginPreferenceListener == null) {
                this.fileSystemResourcesPluginPreferenceListener = new Preferences.IPropertyChangeListener(){

                    public void propertyChange(Preferences.PropertyChangeEvent event) {
                        String property = event.getProperty();
                        if ("show_components_in_hierarchy".equals(property) && !StructuralChangesView.this.treeViewer.getControl().isDisposed()) {
                            StructuralChangesView.this.refreshView(StructuralChangesView.this.input, Display.getCurrent(), true);
                            StructuralChangesView.this.treeViewer.refresh();
                        }
                    }
                };
            }
            FileSystemResourcesPlugin.getDefault().getPluginPreferences().addPropertyChangeListener(this.fileSystemResourcesPluginPreferenceListener);
        }
        final Menu menu = this.treeViewer.getContextMenu().getMenu();
        this.treeViewer.getContextMenu().addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                StructuralChangesView.this.treeViewer.getContextMenu().remove("com.ibm.team.enterprise.menu2");
            }
        });
        menu.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuShown(MenuEvent e) {
                ISelection selection = StructuralChangesView.this.treeViewer.getSelectionProvider().getSelection();
                if (selection instanceof IStructuredSelection) {
                    MenuItem menuItem = StructuralChangesView.this.getDefaultMenuItem(menu, (IStructuredSelection)selection);
                    if (menuItem != null && !menuItem.isEnabled()) {
                        menuItem = null;
                    }
                    menu.setDefaultItem(menuItem);
                }
            }
        });
    }

    private MenuItem getDefaultMenuItem(Menu menu, IStructuredSelection selection) {
        if (selection == null || selection.size() != 1) {
            return null;
        }
        Object o = selection.getFirstElement();
        if (o instanceof StructuralChangesViewFileNode || o instanceof StructuralChangesViewSymbolicLinkNode) {
            if (ExternalCompareToolUtils.shouldUseExternalCompareTool(selection)) {
                return MenuUtil.findItemForAction(menu, "com.ibm.team.filesystem.common.changemodel.FileChange.actions.OpenFileChangeInExternalCompareAction");
            }
            return MenuUtil.findItemForAction(menu, "com.ibm.team.filesystem.ui.changes.actions.conflict.OpenAction");
        }
        return null;
    }

    private void addDragSupport(SimpleTreeViewer viewer) {
        viewer.addDragSupport(23, new Transfer[]{LocalSelectionTransfer.getTransfer()}, (DragSourceListener)new StructuralChangesDragTargetAdapter(viewer));
    }

    protected void reportUnresolved(boolean added) {
        this.unresolvedCount = added ? ++this.unresolvedCount : --this.unresolvedCount;
        this.showUnresolvedPathsWarning(this.unresolvedCount > 0);
    }

    private Composite createUnresolvedPathsWarning(Composite parent, WidgetFactoryContext context) {
        WidgetToolkit toolkit = context.getToolkit();
        Composite result = toolkit.createComposite(parent);
        this.warningImage = this.getSite().getResources().createImageWithDefault(ImagePool.WARNING_ICON);
        Label separator = toolkit.createLabel(result, "", 258);
        GridDataFactory.fillDefaults().span(2, 1).grab(true, false).applyTo((Control)separator);
        Label warningLabel = toolkit.createLabel(result, "", 256);
        warningLabel.setImage(this.warningImage);
        GridDataFactory.fillDefaults().indent(5, 0).align(1, 2).applyTo((Control)warningLabel);
        Link hyperlink = new Link(result, 0);
        hyperlink.setText(Messages.StructuralChangesView_unableToResolveLink);
        hyperlink.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                StructuralChangesView.this.resolvePaths();
            }
        });
        GridDataFactory.fillDefaults().align(1, 2).applyTo((Control)hyperlink);
        hyperlink.setBackground(separator.getBackground());
        GridLayoutFactory.fillDefaults().numColumns(2).extendedMargins(0, 0, 0, LayoutConstants.getSpacing().y).generateLayout(result);
        result.setVisible(false);
        return result;
    }

    public void showUnresolvedPathsWarning(boolean shouldBeVisible) {
        if (shouldBeVisible == this.unresolvedPathsWarning.getVisible()) {
            return;
        }
        this.unresolvedPathsWarning.setVisible(shouldBeVisible);
        this.popupParent.changed(new Control[]{this.unresolvedPathsWarning});
        this.popupParent.layout(false);
    }

    protected void expandAllContextAction() {
        ITreeSelection treeSelection = this.treeViewer.getSelection();
        final TreePath[] paths = treeSelection.getPaths();
        this.treeViewer.expandMatching(new IFilter(){

            public boolean select(Object toTest) {
                List testPaths = StructuralChangesView.this.treeViewer.getPathsToElement(toTest);
                for (TreePath next : testPaths) {
                    int i = 0;
                    while (i < paths.length) {
                        TreePath nextSelection = paths[i];
                        if (next.startsWith(nextSelection, null)) {
                            return true;
                        }
                        ++i;
                    }
                }
                return false;
            }
        });
    }

    protected void collapseAll() {
        this.treeViewer.collapseAll();
    }

    protected void expandComponents() {
        this.treeViewer.expandMatching(new IFilter(){

            public boolean select(Object toTest) {
                return toTest instanceof StructuralChangesComponentNode || toTest instanceof StructuralChangesPlaceholderNode || toTest instanceof WorkspaceComponentWrapper || toTest instanceof BaselineHierarchyWrapper;
            }
        });
    }

    protected void expandToChangeSets() {
        this.treeViewer.expandMatching(new IFilter(){

            public boolean select(Object toTest) {
                return toTest instanceof StructuralChangesComponentNode || toTest instanceof StructuralChangesPlaceholderNode || toTest instanceof WorkspaceComponentWrapper || toTest instanceof BaselineHierarchyWrapper || toTest instanceof StructuralChangesBaselineNode || toTest instanceof BaselineWrapper;
            }
        });
    }

    protected void updateTreeInput() {
        ITeamRepository repository;
        this.treeViewer.setInput((Object)this.currentSyncReport);
        if (this.input == null) {
            return;
        }
        FlowType flowType = (FlowType)this.filter.getValue();
        ITeamRepository iTeamRepository = repository = flowType == FlowType.Incoming ? this.input.getIncoming().getRepository() : this.input.getOutgoing().getRepository();
        if (this.input instanceof ChangeSetPortExplorationInput) {
            this.treeViewer.setTreeProvider((ITreeProvider)new ChangeSetPortExplorationTreeProvider(repository, flowType, this.getControlSite().getOperationRunner(), this.getPathResolver(), this.getSnapshotPair()));
        } else {
            ChangesTreeProvider changesTreeProvider = new ChangesTreeProvider(repository, flowType, this.getSnapshotPair(), this.getPathResolver(), true, this.getControlSite().getOperationRunner());
            if (this.areComponentHierarchiesEnabled()) {
                changesTreeProvider.setStructuralChangesMap(this.structuralChangesMap);
                if (this.outgoingHierarchy != null && this.incomingHierarchy != null) {
                    changesTreeProvider.setLeftConnection(this.outgoingConnection);
                    changesTreeProvider.setRightConnection(this.incomingConnection);
                    changesTreeProvider.setHierarchiesCompareResult(new ComponentHierarchyCompareResult(this.outgoingHierarchy, this.incomingHierarchy, this.structuralChangesMap.keySet()));
                }
            }
            this.treeViewer.setTreeProvider((ITreeProvider)changesTreeProvider);
        }
        this.treeViewer.expandMatching(null);
        this.expandComponentsAction.setText(NLS_EXPAND_COMPONENTS);
        this.expandComponentsAction.setTooltip(LegacyActionTools.removeMnemonics((String)NLS_EXPAND_COMPONENTS));
        this.expandToChangeSetsAction.setText(NLS_EXPAND_TO_CHANGE_SETS);
        this.expandToChangeSetsAction.setTooltip(LegacyActionTools.removeMnemonics((String)NLS_EXPAND_TO_CHANGE_SETS));
    }

    private SnapshotId getOutgoingSnapshotId() {
        if (this.selectedSnapshot.isEmpty()) {
            return this.input.getOutgoing();
        }
        return this.selectedSnapshot;
    }

    private SnapshotPair getSnapshotPair() {
        return new SnapshotPair(this.input.getIncoming(), this.getOutgoingSnapshotId());
    }

    private IPathResolver getPathResolver() {
        ArrayList<SnapshotPathResolver> pathResolvers = new ArrayList<SnapshotPathResolver>();
        pathResolvers.add(SnapshotPathResolver.create((SnapshotId)this.getOutgoingSnapshotId()));
        pathResolvers.add(SnapshotPathResolver.create((SnapshotId)this.input.getIncoming()));
        return new FallbackPathResolver(pathResolvers, true);
    }

    public void addMenuEntries(List output) {
        output.add(new SeparatorExt());
        this.addCommonActions(output);
        output.add(this.changeLogAction);
        super.addMenuEntries(output);
    }

    public void addCommonActions(List output) {
        output.add(this.refreshAction);
        output.add(new SeparatorExt());
        output.add(this.swapHierarchiesAction);
        output.add(new SeparatorExt());
        output.add(this.outgoingAction);
        output.add(this.incomingAction);
        output.add(this.noFilterAction);
        output.add(new SeparatorExt());
        output.add(this.selectContextAction);
        output.add(this.collapseAllAction);
        output.add(this.expandComponentsAction);
        output.add(this.expandToChangeSetsAction);
        output.add(new SeparatorExt());
    }

    public void addToolbarEntries(List output) {
        this.addCommonActions(output);
        super.addToolbarEntries(output);
    }

    protected boolean shouldSetInputIfEqual(Object currentInput, Object newInput) {
        if (newInput instanceof SnapshotCompareInput) {
            return true;
        }
        return super.shouldSetInputIfEqual(currentInput, newInput);
    }

    protected void inputChanged(Object item) {
        StructuralChangesViewInput input;
        Display display = Display.getCurrent();
        this.input = input = (StructuralChangesViewInput)item;
        this.selectedSnapshot = SnapshotId.createEmptyId((ITeamRepository)input.getRepository());
        if (input instanceof ChangeSetInput || input instanceof ChangeHistorySyncReportInput) {
            this.selectContextAction.setEnabled(true);
        } else {
            this.selectContextAction.setEnabled(false);
        }
        this.refreshView(input, display, false);
        if (this.popupParent != null) {
            String helpID = input instanceof ChangeSetPortExplorationInput ? "com.ibm.team.filesystem.ide.ui.view_changeexplorerforlinks" : "com.ibm.team.filesystem.ide.ui.view_changeexplorer";
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.popupParent, helpID);
        }
        super.inputChanged(item);
    }

    private void refreshView(StructuralChangesViewInput item, final Display display, boolean forceRefresh) {
        Composite c = this.getSite().getParent();
        if (this.input == null) {
            return;
        }
        StructuralChangesViewInput newInput = this.input;
        ComponentsInSyncReportQuery[] query = new ComponentsInSyncReportQuery[1];
        this.loggedInRunner.cancelAll();
        this.loggedInRunner.enqueue(this.input.getRepository(), Messages.StructuralChangesView_computingInputJobName, (Operation)new RepositoryOperation((Control)c, newInput, forceRefresh, query, item){
            private final /* synthetic */ Control val$c;
            private final /* synthetic */ StructuralChangesViewInput val$newInput;
            private final /* synthetic */ boolean val$forceRefresh;
            private final /* synthetic */ ComponentsInSyncReportQuery[] val$query;
            private final /* synthetic */ StructuralChangesViewInput val$item;
            {
                this.val$c = control;
                this.val$newInput = structuralChangesViewInput;
                this.val$forceRefresh = bl;
                this.val$query = componentsInSyncReportQueryArray;
                this.val$item = structuralChangesViewInput2;
            }

            public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, FileSystemException, OperationFailedException {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                SWTUtil.greedyExec((Display)display, (Control)this.val$c, (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        StructuralChangesView.this.setInputDescription(val$item, Messages.StructuralChangesView_pendingDescription);
                    }
                });
                final SnapshotId incomingId = this.val$newInput.getIncoming();
                final SnapshotId outgoingId = this.val$newInput.getOutgoing();
                final String incomingName = incomingId.getSnapshot((IProgressMonitor)progress.newChild(5)).getName();
                final String outgoingName = StructuralChangesView.this.getOutgoingName(StructuralChangesView.this.selectedSnapshot, this.val$newInput, (IProgressMonitor)progress.newChild(5));
                StructuralChangesView.this.labelProvider.setStreamNames(incomingName, outgoingName);
                StructuralChangesView.this.updateHeader(StructuralChangesView.this.selectedSnapshot, this.val$newInput, display, this.val$c, (IProgressMonitor)progress.newChild(5));
                final SnapshotSyncReport syncReport = this.val$newInput.computeSyncReport(this.val$forceRefresh, (IProgressMonitor)progress.newChild(30));
                FlowType flowType = (FlowType)StructuralChangesView.this.filter.getValue();
                final ITeamRepository repository = flowType == FlowType.Incoming ? this.val$newInput.getIncoming().getRepository() : this.val$newInput.getOutgoing().getRepository();
                display.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        val$query[0] = new ComponentsInSyncReportQuery(repository, val$newInput.getIncoming().getRepository(), syncReport, FlowType.Both, StructuralChangesView.this.getPathResolver(), StructuralChangesView.this.selectedSnapshot, StructuralChangesView.this.getControlSite().getOperationRunner());
                    }
                });
                try {
                    StructuralChangesView.this.structuralChangesMap.clear();
                    List structuralChangesComponentNodes = this.val$query[0].computeResult((IProgressMonitor)progress.newChild(10));
                    for (StructuralChangesComponentNode node : structuralChangesComponentNodes) {
                        StructuralChangesView.this.structuralChangesMap.put(node.getComponent().getItemId(), node);
                    }
                }
                catch (InvocationTargetException e) {
                    problems.reportException((Throwable)e);
                }
                StructuralChangesView.this.incomingConnection = null;
                StructuralChangesView.this.outgoingConnection = null;
                StructuralChangesView.this.incomingHierarchy = null;
                StructuralChangesView.this.outgoingHierarchy = null;
                if (StructuralChangesView.this.areComponentHierarchiesEnabled()) {
                    if (incomingId instanceof WorkspaceId) {
                        StructuralChangesView.this.incomingConnection = (IWorkspaceConnection)incomingId.getConnection((IProgressMonitor)progress.newChild(5));
                        StructuralChangesView.this.incomingHierarchy = (IHierarchyResult)StructuralChangesView.this.incomingConnection.getComponentHierarchy(null);
                    } else if (incomingId instanceof BaselineSetId) {
                        StructuralChangesView.this.incomingHierarchy = (IHierarchyResult)SCMPlatform.getWorkspaceManager((ITeamRepository)this.val$newInput.getIncoming().getRepository()).getBaselineSetHierarchy((IBaselineSetHandle)incomingId.getIdentifyingHandle(), (IProgressMonitor)progress.newChild(10));
                    }
                    if (outgoingId instanceof WorkspaceId) {
                        StructuralChangesView.this.outgoingConnection = (IWorkspaceConnection)outgoingId.getConnection((IProgressMonitor)progress.newChild(5));
                        StructuralChangesView.this.outgoingHierarchy = (IHierarchyResult)StructuralChangesView.this.outgoingConnection.getComponentHierarchy(null);
                    } else if (outgoingId instanceof BaselineSetId) {
                        StructuralChangesView.this.outgoingHierarchy = (IHierarchyResult)SCMPlatform.getWorkspaceManager((ITeamRepository)this.val$newInput.getOutgoing().getRepository()).getBaselineSetHierarchy((IBaselineSetHandle)outgoingId.getIdentifyingHandle(), (IProgressMonitor)progress.newChild(10));
                    }
                }
                SWTUtil.greedyExec((Display)display, (Control)this.val$c, (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        FlowType inputFlowType;
                        StructuralChangesView.this.currentSyncReport = syncReport;
                        StructuralChangesView.this.swapHierarchiesAction.setEnabled(StructuralChangesView.this.areComponentHierarchiesEnabled());
                        if (StructuralChangesView.this.getStructuralChangesInput() instanceof ChangeSetPortExplorationInput) {
                            StructuralChangesView.this.changeLogAction.setEnabled(false);
                        } else {
                            StructuralChangesView.this.changeLogAction.setEnabled(true);
                        }
                        if (StructuralChangesView.this.currentSyncReport.getIncoming().isEmpty() && StructuralChangesView.this.currentSyncReport.getOutgoing().isEmpty()) {
                            String description = NLS.bind((String)Messages.StructuralChangesView_noChangesDescription, (Object)incomingName, (Object)outgoingName);
                            StructuralChangesView.this.setInputDescription(val$newInput, description);
                        }
                        if ((inputFlowType = val$newInput.forceMode()) != null) {
                            if (!incomingId.equals(outgoingId)) {
                                StructuralChangesView.this.setCustomStreamLabels(incomingName, outgoingName, val$newInput);
                            } else {
                                StructuralChangesView.this.clearCustomStreamLabels();
                            }
                            StructuralChangesView.this.forceMode(inputFlowType);
                        } else if (StructuralChangesView.this.currentSyncReport.getIncoming().isEmpty()) {
                            StructuralChangesView.this.clearCustomStreamLabels();
                            StructuralChangesView.this.forceMode(FlowType.Outgoing);
                        } else if (StructuralChangesView.this.currentSyncReport.getOutgoing().isEmpty()) {
                            StructuralChangesView.this.clearCustomStreamLabels();
                            StructuralChangesView.this.forceMode(FlowType.Incoming);
                        } else {
                            if (!incomingId.equals(outgoingId)) {
                                StructuralChangesView.this.setCustomStreamLabels(incomingName, outgoingName, val$newInput);
                            } else {
                                StructuralChangesView.this.clearCustomStreamLabels();
                            }
                            StructuralChangesView.this.forceMode(FlowType.Both);
                        }
                        StructuralChangesView.this.updateTreeInput();
                    }
                });
            }
        });
    }

    private void setCustomStreamLabels(String incomingName, String outgoingName, StructuralChangesViewInput input) {
        String outgoingNodeLabel;
        String incomingString = NLS.bind((String)Messages.StructuralChangesView_showIncomingActionDetailed, (Object)incomingName);
        this.incomingAction.setText(incomingString);
        this.incomingAction.setTooltip(LegacyActionTools.removeMnemonics((String)incomingString));
        String outgoingString = NLS.bind((String)Messages.StructuralChangesView_showOutgoingActionDetailed, (Object)outgoingName);
        this.outgoingAction.setText(outgoingString);
        this.outgoingAction.setTooltip(LegacyActionTools.removeMnemonics((String)outgoingString));
        String incomingNodeLabel = input.getCustomIncomingNodeLabel();
        if (incomingNodeLabel == null) {
            incomingNodeLabel = NLS.bind((String)Messages.StructuralChangesView_incomingNodeLabel, (Object)incomingName);
        }
        if ((outgoingNodeLabel = input.getCustomOutgoingNodeLabel()) == null) {
            outgoingNodeLabel = NLS.bind((String)Messages.StructuralChangesView_outgoingNodeLabel, (Object)outgoingName);
        }
        this.labelProvider.setCustomContextLabels(incomingNodeLabel, outgoingNodeLabel);
    }

    private void clearCustomStreamLabels() {
        this.incomingAction.setText(NLS_SHOW_MISSING_CHANGES);
        this.incomingAction.setTooltip(NLS_SHOW_MISSING_CHANGES);
        this.outgoingAction.setText(NLS_SHOW_ADDED_CHANGES);
        this.outgoingAction.setTooltip(NLS_SHOW_ADDED_CHANGES);
        this.labelProvider.clearCustomContextLabels();
    }

    private String getOutgoingName(ISnapshot snapshot) throws TeamRepositoryException {
        return snapshot.getName();
    }

    private String getOutgoingName(SnapshotId newSelectedSnapshot, StructuralChangesViewInput newInput, IProgressMonitor monitor) throws TeamRepositoryException {
        ISnapshot snapshot = this.getOutgoingSnapshot(newSelectedSnapshot, newInput, monitor);
        return this.getOutgoingName(snapshot);
    }

    private ISnapshot getOutgoingSnapshot(SnapshotId newSelectedSnapshot, StructuralChangesViewInput newInput, IProgressMonitor monitor) throws TeamRepositoryException {
        if (newSelectedSnapshot != null && !newSelectedSnapshot.isEmpty()) {
            return newSelectedSnapshot.getSnapshot(monitor);
        }
        SnapshotId Id = newInput.getOutgoing();
        return Id.getSnapshot(monitor);
    }

    private void updateHeader(SnapshotId newSelectedSnapshot, final StructuralChangesViewInput newInput, Display display, Control c, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        String title = newInput.computeName((IProgressMonitor)progress.newChild(50));
        ISnapshot snapshot = this.getOutgoingSnapshot(newSelectedSnapshot, newInput, (IProgressMonitor)progress.newChild(50));
        String outgoingName = this.getOutgoingName(snapshot);
        final String contentDescription = this.areComponentHierarchiesEnabled() ? NLS.bind((String)Messages.StructuralChangesView_titleDecoration, (Object)title, (Object)outgoingName) : (snapshot instanceof WorkspaceSnapshot || snapshot instanceof BaselineSnapshot ? NLS.bind((String)Messages.StructuralChangesView_titlePathDecoration, (Object)title, (Object)outgoingName) : title);
        SWTUtil.greedyExec((Display)display, (Control)c, (Runnable)new Runnable(){

            @Override
            public void run() {
                StructuralChangesView.this.setInputDescription(newInput, contentDescription);
            }
        });
    }

    protected void resolvePaths() {
        if (this.input == null) {
            MessageDialogFactory.showMessage((Shell)this.getControlSite().getShell(), (IStatus)StatusUtil.newStatus((Object)((Object)this), (String)Messages.StructuralChangesView_noInputResolveError));
            return;
        }
        Composite c = this.getSite().getParent();
        final Display display = Display.getCurrent();
        String dialogDescription = this.unresolvedCount > 0 ? Messages.PathResolverSelectionPage_unresolvedPathsExplanationText2 : Messages.PathResolverSelectionPage_unresolvedPathsExplanationText1;
        final PathResolverSelectionPage page = new PathResolverSelectionPage("page1", this.selectedSnapshot, 22, dialogDescription);
        WizardUtil.open((Shell)this.getControlSite().getShell(), (String)Messages.StructuralChangesView_resolvePathsDialogTitle, (IWizardPage)page, (IRunnableWithResult)new IRunnableWithResult<Boolean>((Control)c){
            private final /* synthetic */ Control val$c;
            {
                this.val$c = control;
            }

            public Boolean run() {
                SnapshotId newSelectedSnapshot = page.getSelectedSnapshot();
                if (!newSelectedSnapshot.equals(StructuralChangesView.this.selectedSnapshot)) {
                    StructuralChangesView.this.selectedSnapshot = newSelectedSnapshot;
                    StructuralChangesView.this.loggedInRunner.enqueue(StructuralChangesView.this.input.getRepository(), Messages.StructuralChangesView_computingInputJobName, (Operation)new RepositoryOperation(){

                        public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, FileSystemException, OperationFailedException {
                            StructuralChangesView.this.updateHeader(StructuralChangesView.this.selectedSnapshot, StructuralChangesView.this.input, display, val$c, monitor);
                        }
                    });
                    StructuralChangesView.this.updateTreeInput();
                }
                return true;
            }
        }, (String)"com.ibm.team.filesystem.ide.ui.wizard_resolvepaths");
    }

    private void forceMode(FlowType filter) {
        this.incomingAction.setEnabled(!filter.equals((Object)FlowType.Outgoing));
        this.outgoingAction.setEnabled(!filter.equals((Object)FlowType.Incoming));
        this.noFilterAction.setEnabled(filter.equals((Object)FlowType.Both));
        this.filter.setValue((Object)filter);
    }

    public StructuralChangesViewInput getStructuralChangesInput() {
        return this.input;
    }

    public void dispose() {
        this.loggedInRunner.dispose();
        if (this.versionIdentifierPreferenceListener != null) {
            RcpUiPlugin.getDefault().getPreferenceStore().removePropertyChangeListener(this.versionIdentifierPreferenceListener);
            this.versionIdentifierPreferenceListener = null;
        }
        if (this.fileSystemResourcesPluginPreferenceListener != null) {
            FileSystemResourcesPlugin.getDefault().getPluginPreferences().removePropertyChangeListener(this.fileSystemResourcesPluginPreferenceListener);
            this.fileSystemResourcesPluginPreferenceListener = null;
        }
        super.dispose();
    }

    private boolean areComponentHierarchiesEnabled() {
        boolean isCorrectInputType = this.input instanceof SnapshotCompareInput;
        boolean isComponentPrefEnabled = ComponentSyncUtil.shouldShowComponentHierarchies();
        return isCorrectInputType && isComponentPrefEnabled;
    }
}

