/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.structuralchanges;

import com.ibm.team.filesystem.client.internal.snapshot.FlowType;
import com.ibm.team.filesystem.client.internal.snapshot.SnapshotId;

public class SnapshotPair {
    private SnapshotId incoming;
    private SnapshotId outgoing;

    public SnapshotPair(SnapshotId incoming, SnapshotId outgoing) {
        this.incoming = incoming;
        this.outgoing = outgoing;
    }

    public SnapshotId get(FlowType flow) {
        if (flow == FlowType.Incoming) {
            return this.incoming;
        }
        if (flow == FlowType.Outgoing) {
            return this.outgoing;
        }
        throw new IllegalArgumentException("Expecting flow type of Incoming or Outgoing");
    }

    public SnapshotId getIncoming() {
        return this.incoming;
    }

    public SnapshotId getOutgoing() {
        return this.outgoing;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.incoming == null ? 0 : this.incoming.hashCode());
        result = 31 * result + (this.outgoing == null ? 0 : this.outgoing.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SnapshotPair other = (SnapshotPair)obj;
        if (this.incoming == null ? other.incoming != null : !this.incoming.equals(other.incoming)) {
            return false;
        }
        return !(this.outgoing == null ? other.outgoing != null : !this.outgoing.equals(other.outgoing));
    }
}

