/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.structuralchanges;

import com.ibm.team.filesystem.client.internal.namespace.ItemNamespace;
import com.ibm.team.filesystem.client.internal.snapshot.ISnapshot;
import com.ibm.team.filesystem.client.internal.snapshot.NamespaceSetId;
import com.ibm.team.filesystem.client.internal.snapshot.SnapshotId;
import com.ibm.team.filesystem.client.internal.snapshot.SnapshotSyncReport;
import com.ibm.team.filesystem.rcp.core.internal.rest.util.SyncViewDTOUtil;
import com.ibm.team.internal.filesystem.ui.views.structuralchanges.StructuralChangesViewInput;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class SnapshotCompareInput
extends StructuralChangesViewInput {
    private SnapshotId snapshot1;
    private SnapshotId snapshot2;

    private SnapshotCompareInput(SnapshotId snapshot1, SnapshotId snapshot2) {
        this.snapshot1 = snapshot1;
        this.snapshot2 = snapshot2;
    }

    public static SnapshotCompareInput create(SnapshotId snapshot1, SnapshotId snapshot2) {
        return new SnapshotCompareInput(snapshot1, snapshot2);
    }

    public static SnapshotCompareInput create(ItemNamespace namespace1, ItemNamespace namespace2) {
        return new SnapshotCompareInput((SnapshotId)NamespaceSetId.create((ItemNamespace)namespace1), (SnapshotId)NamespaceSetId.create((ItemNamespace)namespace2));
    }

    @Override
    public SnapshotId getOutgoing() {
        return this.snapshot1;
    }

    @Override
    public SnapshotId getIncoming() {
        return this.snapshot2;
    }

    @Override
    public String computeName(IProgressMonitor monitor) throws TeamRepositoryException {
        return SyncViewDTOUtil.computeComparisonName((SnapshotId)this.snapshot1, (SnapshotId)this.snapshot2, (IProgressMonitor)monitor);
    }

    @Override
    public SnapshotSyncReport computeSyncReport(boolean refresh, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(refresh ? 140 : 100));
        ISnapshot s1 = this.snapshot1.getSnapshot((IProgressMonitor)progress.newChild(30));
        ISnapshot s2 = this.snapshot2.getSnapshot((IProgressMonitor)progress.newChild(30));
        if (refresh) {
            s1.refresh((IProgressMonitor)progress.newChild(20));
            s2.refresh((IProgressMonitor)progress.newChild(20));
        }
        return SnapshotSyncReport.compare((ISnapshot)s1, (ISnapshot)s2, null, (IProgressMonitor)progress.newChild(40));
    }

    @Override
    public ITeamRepository getRepository() {
        return this.snapshot1.getRepository();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.snapshot1 == null ? 0 : this.snapshot1.hashCode());
        result = 31 * result + (this.snapshot2 == null ? 0 : this.snapshot2.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SnapshotCompareInput other = (SnapshotCompareInput)obj;
        if (this.snapshot1 == null ? other.snapshot1 != null : !this.snapshot1.equals(other.snapshot1)) {
            return false;
        }
        return !(this.snapshot2 == null ? other.snapshot2 != null : !this.snapshot2.equals(other.snapshot2));
    }
}

