/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.structuralchanges;

import com.ibm.team.filesystem.client.internal.snapshot.SnapshotId;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.picker.LocationCombo;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.rcp.ui.internal.databinding.CombinedStatus;
import com.ibm.team.repository.rcp.ui.internal.databinding.DatabindingUtil;
import com.ibm.team.repository.rcp.ui.parts.WidgetToolkit;
import com.ibm.team.repository.rcp.ui.utils.LayoutConstants2;
import com.ibm.team.repository.rcp.ui.utils.WidgetFactoryContext;
import com.ibm.team.repository.rcp.ui.wizards.BaseWizardPage;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Composite;

public class PathResolverSelectionPage
extends BaseWizardPage {
    private ITeamRepository repo;
    private SnapshotId initialSnapshot;
    private LocationCombo selectedLocation;
    private CombinedStatus combinedStatus = new CombinedStatus();
    private int flags;
    private String dialogDescription;

    public PathResolverSelectionPage(String pageName, SnapshotId initialSnapshot, int flags, String dialogDescription) {
        super(pageName, Messages.PathResolverSelectionPage_pageTitle, null);
        this.setDescription(Messages.PathResolverSelectionPage_pageDescription);
        this.repo = initialSnapshot.getRepository();
        this.initialSnapshot = initialSnapshot;
        this.flags = flags;
        this.dialogDescription = dialogDescription;
    }

    protected void createBody(Composite parent) {
        WidgetFactoryContext context = WidgetFactoryContext.forWizardPage((IWizardPage)this);
        WidgetToolkit toolkit = context.getToolkit();
        toolkit.createLabel(parent, this.dialogDescription, 64);
        Composite remoteOption = toolkit.createComposite(parent);
        toolkit.createLabel(remoteOption, context.getMnemonics().generate(Messages.PathResolverSelectionPage_resolvePathsComboLabel));
        this.selectedLocation = new LocationCombo(remoteOption, context, this.repo, this.flags);
        this.selectedLocation.setSelectedSnapshot(this.initialSnapshot);
        GridDataFactory.fillDefaults().grab(true, false).applyTo(this.selectedLocation.getControl());
        GridLayoutFactory.fillDefaults().numColumns(2).generateLayout(remoteOption);
        GridLayoutFactory.fillDefaults().extendedMargins(LayoutConstants2.getWizardPageMargins()).generateLayout(parent);
        this.combinedStatus.addStatus(this.selectedLocation.getValidationStatus());
        DatabindingUtil.bindMessage((DialogPage)this, (IObservableValue)this.combinedStatus);
    }

    public SnapshotId getSelectedSnapshot() {
        SnapshotId snap = this.selectedLocation.getSelectedSnapshot();
        if (snap == null) {
            return SnapshotId.createEmptyId((ITeamRepository)this.repo);
        }
        return snap;
    }

    public void dispose() {
        this.combinedStatus.dispose();
        super.dispose();
    }
}

