/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.structuralchanges;

import com.ibm.team.filesystem.common.changemodel.IPathResolver;
import com.ibm.team.filesystem.common.changemodel.VersionablePath;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.common.collection.CollectionUtil;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.internal.viewers.ISetWithListeners;
import com.ibm.team.repository.rcp.ui.internal.viewers.SlowFunction;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.internal.util.SiloedItemId;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.widgets.Display;

public abstract class PathFunction<T>
extends SlowFunction<T, VersionablePath> {
    public PathFunction(ISetWithListeners<T> domain, IOperationRunner runner) {
        this(domain, runner, Display.getCurrent(), true);
    }

    public PathFunction(ISetWithListeners<T> domain, IOperationRunner runner, Display display, boolean isLazy) {
        super(domain, runner, display, isLazy);
    }

    protected Map<T, VersionablePath> doFetch(Collection<T> toFetch, IProgressMonitor reporter) throws OperationFailedException {
        HashMap result = new HashMap();
        HashMap groupByResolver = new HashMap();
        for (T next : toFetch) {
            IPathResolver resolver = this.getResolverFor(next);
            if (resolver == null) continue;
            CollectionUtil.addToMapOfLists(groupByResolver, (Object)resolver, next);
        }
        for (IPathResolver nextResolver : groupByResolver.keySet()) {
            List folders = (List)groupByResolver.get(nextResolver);
            try {
                HashSet<SiloedItemId<IVersionable>> versionablesToFetch = new HashSet<SiloedItemId<IVersionable>>();
                for (Object nextFolder : folders) {
                    versionablesToFetch.add(this.getUnresolvedPath(nextFolder));
                }
                Map paths = nextResolver.resolve(versionablesToFetch, reporter);
                for (Object nextFolder : folders) {
                    SiloedItemId<IVersionable> next = this.getUnresolvedPath(nextFolder);
                    VersionablePath path = (VersionablePath)paths.get(next);
                    result.put(nextFolder, path);
                }
            }
            catch (TeamRepositoryException e) {
                throw new OperationFailedException(StatusUtil.newStatus((Object)((Object)this), (Throwable)e));
            }
        }
        return result;
    }

    protected abstract IPathResolver getResolverFor(T var1);

    protected abstract SiloedItemId<IVersionable> getUnresolvedPath(T var1);

    protected VersionablePath getDefaultValue() {
        return null;
    }

    protected String getOperationName() {
        return Messages.PathFunction_resolvingPathsOperationName0;
    }
}

