/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.structuralchanges;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.internal.snapshot.FlowType;
import com.ibm.team.filesystem.client.internal.snapshot.SnapshotId;
import com.ibm.team.filesystem.client.internal.snapshot.SnapshotSyncReport;
import com.ibm.team.filesystem.common.changemodel.IPathResolver;
import com.ibm.team.filesystem.common.internal.rest.client.changelog.ChangeLogEntryDTO;
import com.ibm.team.filesystem.ide.ui.internal.dialogs.ClipboardOrFilePart;
import com.ibm.team.filesystem.rcp.core.internal.changelog.BaseChangeLogEntryVisitor;
import com.ibm.team.filesystem.rcp.core.internal.changelog.BufferedChangeLogOutput;
import com.ibm.team.filesystem.rcp.core.internal.changelog.ChangeLogCustomizer;
import com.ibm.team.filesystem.rcp.core.internal.changelog.ChangeLogEntryVisitor;
import com.ibm.team.filesystem.rcp.core.internal.changelog.GenerateChangeLogOperation;
import com.ibm.team.filesystem.rcp.core.internal.changelog.IChangeLogOutput;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.CopyFileAreaPathResolver;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.FallbackPathResolver;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.SnapshotPathResolver;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.views.structuralchanges.GenerateChangeLogDialog;
import com.ibm.team.internal.filesystem.ui.views.structuralchanges.StructuralChangesViewInput;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.ui.internal.utils.JFaceUtils;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class GenerateChangeLogRepositoryOperation
extends RepositoryOperation {
    private StructuralChangesViewInput input;
    private SnapshotId selectedSnapshot;
    private SnapshotSyncReport syncReport;
    private FlowType flowType;
    private Shell shell;
    private ITeamRepository repo;
    private ChangeLogCustomizer customizer;
    private BaseChangeLogEntryVisitor visitor;
    private ClipboardOrFilePart.ClipboardOrFileResult clipboardOrFile;
    private IPathResolver pathResolver;

    public GenerateChangeLogRepositoryOperation(StructuralChangesViewInput input, SnapshotId selectedSnapshot, SnapshotSyncReport syncReport, FlowType flowType, Shell shell) {
        super(input.getRepository());
        this.input = input;
        this.selectedSnapshot = selectedSnapshot;
        this.syncReport = syncReport;
        this.flowType = flowType;
        this.shell = shell;
    }

    public boolean prompt() {
        GenerateChangeLogDialog dialog = new GenerateChangeLogDialog(this.shell, new GenerateChangeLogDialog.GenerateChangeLogDialogInput(this.flowType));
        int code = dialog.open();
        if (code != 0) {
            return false;
        }
        GenerateChangeLogDialog.GenerateChangeLogDialogResult result = dialog.getResult();
        this.clipboardOrFile = result.getClipboardOrFile();
        if (!this.clipboardOrFile.confirmOverwrite(this.shell)) {
            return false;
        }
        this.customizer = result.getCustomizer();
        this.visitor = result.getVisitor();
        this.repo = this.input.getRepository();
        ArrayList<Object> pathResolvers = new ArrayList<Object>();
        if (!this.customizer.shouldUseRepositoryPathsOnly()) {
            pathResolvers.add(CopyFileAreaPathResolver.create());
        }
        pathResolvers.add(SnapshotPathResolver.create((SnapshotId)this.input.getOutgoing()));
        pathResolvers.add(SnapshotPathResolver.create((SnapshotId)this.input.getIncoming()));
        pathResolvers.add(SnapshotPathResolver.create((SnapshotId)this.selectedSnapshot));
        this.pathResolver = new FallbackPathResolver(pathResolvers, true);
        return true;
    }

    public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, OperationFailedException {
        Display display;
        GenerateChangeLogOperation op = new GenerateChangeLogOperation();
        op.setChangeLogRequest(this.repo, this.syncReport, this.pathResolver, this.customizer);
        ChangeLogEntryDTO dto = op.run(monitor);
        BufferedChangeLogOutput buf = new BufferedChangeLogOutput(this.customizer);
        this.visitor.setOutput((IChangeLogOutput)buf);
        ChangeLogEntryVisitor.acceptInto((ChangeLogEntryDTO)dto, (ChangeLogEntryVisitor)this.visitor);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            outputStream.write(buf.getOutput().getBytes());
        }
        catch (IOException e) {
            throw new FileSystemException((Throwable)e);
        }
        IStatus status = this.clipboardOrFile.write(outputStream, this.shell.getDisplay());
        if (!status.isOK()) {
            JFaceUtils.showError(null, null, (IStatus)status);
        }
        if (dto.getChildEntries().isEmpty() && this.customizer.shouldIncludeIncoming() ^ this.customizer.shouldIncludeOutgoing() && !(display = this.shell.getDisplay()).isDisposed()) {
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    String oppositeDirection;
                    String currentDirection;
                    if (GenerateChangeLogRepositoryOperation.this.customizer.shouldIncludeIncoming()) {
                        currentDirection = Messages.GenerateChangeLogRepositoryOperation_INCOMING;
                        oppositeDirection = Messages.GenerateChangeLogRepositoryOperation_OUTGOING;
                    } else {
                        currentDirection = Messages.GenerateChangeLogRepositoryOperation_OUTGOING;
                        oppositeDirection = Messages.GenerateChangeLogRepositoryOperation_INCOMING;
                    }
                    String dialogTitle = NLS.bind((String)Messages.GenerateChangeLogRepositoryOperation_NO_CHANGES_DIALOG_TITLE, (Object)currentDirection);
                    String dialogMessage = NLS.bind((String)Messages.GenerateChangeLogRepositoryOperation_NO_CHANGES_DIALOG_MESSAGE, (Object)currentDirection, (Object)oppositeDirection);
                    MessageDialog.open((int)2, null, (String)dialogTitle, (String)dialogMessage, (int)0);
                }
            });
        }
    }
}

