/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.structuralchanges;

import com.ibm.team.filesystem.client.internal.FileSystemStatusUtil;
import com.ibm.team.filesystem.client.internal.snapshot.FlowType;
import com.ibm.team.filesystem.ide.ui.internal.dialogs.ClipboardOrFilePart;
import com.ibm.team.filesystem.rcp.core.internal.changelog.BaseChangeLogEntryVisitor;
import com.ibm.team.filesystem.rcp.core.internal.changelog.ChangeLogCustomizer;
import com.ibm.team.filesystem.rcp.core.internal.changelog.CsvChangeLogEntryVisitor;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.picker.BrowsableFilenameField;
import com.ibm.team.repository.rcp.ui.internal.databinding.CombinedStatus;
import com.ibm.team.repository.rcp.ui.internal.databinding.DatabindingUtil;
import com.ibm.team.repository.rcp.ui.parts.WidgetToolkit;
import com.ibm.team.repository.rcp.ui.utils.WidgetFactoryContext;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.LayoutConstants;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.keys.IBindingService;
import org.osgi.service.prefs.Preferences;

public class GenerateChangeLogDialog
extends TitleAreaDialog {
    private static final String DEFAULT_FILE_EXTENSION = ".changelog";
    private static final String PREF_TYPE_COMPONENTS = "selected_type_components";
    private static final String PREF_TYPE_BASELINES = "selected_type_baselines";
    private static final String PREF_TYPE_CHANGESETS = "selected_type_changesets";
    private static final String PREF_TYPE_WORKITEMS = "selected_type_workitesm";
    private static final String PREF_TYPE_FILESYSTEM = "selected_type_filesystem";
    private static final String PREF_TYPE_FULL_VERSIONIDS = "selected_type_full_versionIds";
    private static final String PREF_TYPE_ITEM_IDS = "selected_type_Item_IDs";
    private static final String PREF_HIDE_EMPTY_DIRECTIONS = "selected_hide_empty_direction";
    private static final String PREF_HIDE_UNCHANGED_COMPONENTS = "selected_hide_unchanged_components";
    private static final String PREF_APPEARANCE_BL_CONTRIB = "selected_show_bl_contrib";
    private static final String PREF_APPEARANCE_BL_DATE = "selected_show_bl_date";
    private static final String PREF_APPEARANCE_CS_CONTRIB = "selected_show_cs_contrib";
    private static final String PREF_APPEARANCE_CS_DATE = "selected_show_cs_date";
    private static final String PREF_APPEARANCE_CS_WORKITEMS = "selected_show_cs_workitems";
    private static final String PREF_OUTPUT_IN_CSV = "output_in_csv";
    private static final String PREF_REROOT = "selected_reroot";
    private static final String PREF_TEMPLATE_NAME = "text_template_name";
    private static final String DEFAULT_CONTRIB_FORMAT = "{name} <{email}>";
    private static final String CONTRIB_FORMAT_USER_ID = "{userid}";
    private static final String CONTRIB_FORMAT_NAME = "{name}";
    private static final String CONTRIB_FORMAT_EMAIL = "{email}";
    private static final String CONTRIB_FORMAT_ITEM_ID = "{itemid}";
    private static final String PREF_TEMPLATE_DATE = "text_template_date";
    private static final String DEFAULT_DATE_FORMAT = "yyyy/MM/dd HH:mm:ss";
    private static final String DATE_FORMAT_0 = "yyyy/MM/dd HH:mm:ss";
    private static final String DATE_FORMAT_1 = "dd/MM/yyyy HH:mm:ss";
    private static final String DATE_FORMAT_2 = "EEE, MMM d, ''yy HH:mm:ss";
    private static final String PREF_USE_REPOSITORY_PATHS_ONLY = "use_repository_paths_only";
    private static final String[] REROOT_STRINGS = new String[]{Messages.GenerateChangeLogDialog_REROOT_DISABLED, Messages.GenerateChangeLogDialog_REROOT_ROOT, Messages.GenerateChangeLogDialog_REROOT_DIRECTION, Messages.GenerateChangeLogDialog_REROOT_COMPONENTS, Messages.GenerateChangeLogDialog_REROOT_BASELINES};
    private static final String REROOT_VALUE_DEFAULT = "(nothing)";
    private static final String[] REROOT_VALUES = new String[]{"(nothing)", "clentry_root", "clentry_direction", "clentry_component", "clentry_baseline"};
    private HashMap<Button, List<Button>> buttonDependencies = new HashMap();
    private HashMap<String, Button> buttonPrefKeys = new HashMap();
    private HashMap<String, Text> textPrefKeys = new HashMap();
    private Button includeComponents;
    private Button includeBaselines;
    private Button showBaselinesContrib;
    private Button showBaselinesCreationDate;
    private Button includeChangeSets;
    private Button showChangeSetsContrib;
    private Button showChangeSetsCreationDate;
    private Button showChangeSetsWorkItems;
    private Button includeWorkItems;
    private Button includeFilesystemChanges;
    private Button showFullVersionIdentifiers;
    private Button showFlowIncoming;
    private Button showFlowOutgoing;
    private Button showFlowBoth;
    private Button filterEmptyDirections;
    private Button filterUnchangedComponents;
    private Button showItemIDs;
    private Button outputInCSV;
    private Combo formatWorkitemParent;
    private Text templateName;
    private DateFormatPart templateDate;
    private Button useRepositoryPathsOnly;
    private CombinedStatus validationStatus = new CombinedStatus();
    private Preferences prefs;
    private ControlDecoration templateNameDecoration;
    private ControlDecoration templateDateDecoration;
    private GenerateChangeLogDialogResult result;
    private ClipboardOrFilePart clipboardOrFilePart;
    private final GenerateChangeLogDialogInput input;

    public GenerateChangeLogDialog(Shell shell, GenerateChangeLogDialogInput input) {
        super(shell);
        this.input = input;
        this.prefs = this.getInstanceScope();
    }

    public void create() {
        super.create();
        this.setTitle(Messages.CopyChangeLogDialog_HEADING_TITLE);
        DatabindingUtil.bindMessage((TitleAreaDialog)this, (Button)this.getButton(0), (IObservableValue)this.validationStatus, (String)Messages.CopyChangeLogDialog_HEADING_TEXT);
    }

    private Preferences getInstanceScope() {
        return new InstanceScope().getNode("com.ibm.team.filesystem.ide.ui").node(((Object)((Object)this)).getClass().getName());
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        final ScrolledComposite scroll = new ScrolledComposite(dialogArea, 512);
        final Composite composite = new Composite((Composite)scroll, 0);
        scroll.setExpandVertical(true);
        scroll.setExpandHorizontal(true);
        scroll.setContent((Control)composite);
        GridLayoutFactory layoutFactory = GridLayoutFactory.fillDefaults().margins(LayoutConstants.getMargins());
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)scroll);
        scroll.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                GenerateChangeLogDialog.this.resizeForScroll(scroll, composite);
            }
        });
        this.clipboardOrFilePart = new ClipboardOrFilePart(new ClipboardOrFilePart.ClipboardOrFilePartInput(null, Messages.ClipboardOrFilePart_FILE, Messages.BrowsableFilenameField_0, this.prefs.node("clipboardOrFile"), true, new String[]{"*.changelog", "*.*"}, new String[]{Messages.GenerateChangeLogDialog_CHANGE_LOG_FILE_NAME, Messages.CreatePatchPart_12}));
        this.clipboardOrFilePart.create(composite, WidgetFactoryContext.forDialogBox());
        SelectionAdapter rootSelectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GenerateChangeLogDialog.this.updateEnablement((Button)e.widget);
            }
        };
        Group groupType = new Group(composite, 0);
        groupType.setText(Messages.CopyChangeLogDialog_TYPE_GROUP_HEADING);
        this.includeComponents = this.createRootButton(groupType, Messages.CopyChangeLogDialog_TYPE_COMPONENTS, PREF_TYPE_COMPONENTS, true, (SelectionListener)rootSelectionListener);
        this.includeBaselines = this.createRootButton(groupType, Messages.CopyChangeLogDialog_TYPE_BASELINES, PREF_TYPE_BASELINES, true, (SelectionListener)rootSelectionListener);
        this.showBaselinesContrib = this.createIndentedButton(groupType, Messages.CopyChangeLogDialog_SHOW_BASELINE_CREATOR, PREF_APPEARANCE_BL_CONTRIB, false, this.includeBaselines);
        this.showBaselinesCreationDate = this.createIndentedButton(groupType, Messages.CopyChangeLogDialog_SHOW_BASELINE_CREATION_DATE, PREF_APPEARANCE_BL_DATE, false, this.includeBaselines);
        this.includeChangeSets = this.createRootButton(groupType, Messages.CopyChangeLogDialog_TYPE_CHANGESETS, PREF_TYPE_CHANGESETS, true, (SelectionListener)rootSelectionListener);
        this.includeChangeSets.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                GenerateChangeLogDialog.this.updateEnablement();
            }
        });
        this.showChangeSetsContrib = this.createIndentedButton(groupType, Messages.CopyChangeLogDialog_SHOW_CHANGESET_CREATOR, PREF_APPEARANCE_CS_CONTRIB, false, this.includeChangeSets);
        this.showChangeSetsCreationDate = this.createIndentedButton(groupType, Messages.CopyChangeLogDialog_SHOW_CHANGESET_CREATION_DATE, PREF_APPEARANCE_CS_DATE, false, this.includeChangeSets);
        this.showChangeSetsWorkItems = this.createIndentedButton(groupType, Messages.GenerateChangeLogDialog_SHOW_CHANGESET_WORKITEMS, PREF_APPEARANCE_CS_WORKITEMS, false, this.includeChangeSets);
        this.includeWorkItems = this.createRootButton(groupType, Messages.CopyChangeLogDialog_TYPE_WORKITEMS, PREF_TYPE_WORKITEMS, true, (SelectionListener)rootSelectionListener);
        this.includeWorkItems.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                GenerateChangeLogDialog.this.updateEnablement();
            }
        });
        this.includeFilesystemChanges = this.createRootButton(groupType, Messages.CopyChangeLogDialog_TYPE_FILESYSTEM, PREF_TYPE_FILESYSTEM, false, (SelectionListener)rootSelectionListener);
        this.showFullVersionIdentifiers = this.createIndentedButton(groupType, Messages.GenerateChangeLogDialog_INCLUDE_FULL_VERSION_IDS_BUTTON, PREF_TYPE_FULL_VERSIONIDS, false, this.includeFilesystemChanges);
        layoutFactory.generateLayout((Composite)groupType);
        WidgetToolkit toolkit = WidgetFactoryContext.forDialogBox().getToolkit();
        ExpandableComposite advancedOptions = toolkit.createExpandableComposite(composite, 2);
        advancedOptions.setText(Messages.LoadAsWizardPage_AdvancedOptions);
        GridDataFactory.defaultsFor((Control)advancedOptions).grab(true, false).align(4, 4).applyTo((Control)advancedOptions);
        advancedOptions.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                GenerateChangeLogDialog.this.resizeForScroll(scroll, composite);
            }
        });
        Composite advancedOptionsArea = new Composite((Composite)advancedOptions, 0);
        advancedOptions.setClient((Control)advancedOptionsArea);
        this.createAdvancedOptions(advancedOptionsArea);
        GenerateChangeLogDialog.applyDialogFont((Control)parent);
        layoutFactory.generateLayout(advancedOptionsArea);
        layoutFactory.generateLayout(composite);
        this.updateEnablement();
        this.validationStatus.addStatus(this.clipboardOrFilePart.getValidationStatus());
        this.validationStatus.addStatus(this.templateDate.getValidationStatus());
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.ibm.team.filesystem.ide.ui.dialog_generatechangelog");
        return dialogArea;
    }

    private void resizeForScroll(ScrolledComposite scroll, Composite composite) {
        Rectangle r = scroll.getClientArea();
        Point size = composite.computeSize(r.width, -1);
        scroll.setMinSize(size.x, size.y - 5);
    }

    private void createAdvancedOptions(Composite advancedOptionsArea) {
        Group groupFilter = new Group(advancedOptionsArea, 0);
        groupFilter.setText(Messages.GenerateChangeLogDialog_FILTER_GROUP);
        this.filterEmptyDirections = this.createRootButton(groupFilter, Messages.GenerateChangeLogDialog_HIDE_EMPTY_DIRECTIONS, PREF_HIDE_EMPTY_DIRECTIONS, false, null);
        this.filterUnchangedComponents = this.createRootButton(groupFilter, Messages.GenerateChangeLogDialog_HIDE_UNCHANGED_COMPONENTS, PREF_HIDE_UNCHANGED_COMPONENTS, false, null);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)groupFilter);
        GridLayoutFactory.fillDefaults().margins(LayoutConstants.getMargins()).generateLayout((Composite)groupFilter);
        Group groupAppearance = new Group(advancedOptionsArea, 0);
        groupAppearance.setText(Messages.CopyChangeLogDialog_FORMATTING_GROUP);
        this.showItemIDs = this.createRootButton(groupAppearance, Messages.GenerateChangeLogDialog_SHOW_ITEM_IDS, PREF_TYPE_ITEM_IDS, false, null);
        this.outputInCSV = this.createRootButton(groupAppearance, Messages.GenerateChangeLogDialog_OUTPUT_IN_CSV, PREF_OUTPUT_IN_CSV, false, (SelectionListener)new SelectionAdapter(){
            final String CSV_EXTENSION = ".csv";
            String previousExtension = ".changelog";

            public void widgetSelected(SelectionEvent e) {
                if (GenerateChangeLogDialog.this.outputInCSV.getSelection()) {
                    GenerateChangeLogDialog.this.setRerootDefault(true);
                    GenerateChangeLogDialog.this.showChangeSetsWorkItems.setSelection(false);
                    if (GenerateChangeLogDialog.this.clipboardOrFilePart != null) {
                        int p;
                        BrowsableFilenameField nameField = GenerateChangeLogDialog.this.clipboardOrFilePart.getBrowseableFilenameField();
                        String filePath = nameField.getText();
                        int i = filePath.lastIndexOf(46);
                        if (i > (p = Math.max(filePath.lastIndexOf(47), filePath.lastIndexOf(92)))) {
                            this.previousExtension = filePath.substring(i);
                            nameField.setText(String.valueOf(filePath.substring(0, filePath.length() - this.previousExtension.length())) + ".csv");
                        } else {
                            this.previousExtension = GenerateChangeLogDialog.DEFAULT_FILE_EXTENSION;
                            nameField.setText(String.valueOf(filePath) + ".csv");
                        }
                    }
                } else {
                    GenerateChangeLogDialog.this.setRerootDefault(false);
                    GenerateChangeLogDialog.this.showChangeSetsWorkItems.setSelection(GenerateChangeLogDialog.this.prefs.getBoolean(GenerateChangeLogDialog.PREF_APPEARANCE_CS_WORKITEMS, false));
                    if (GenerateChangeLogDialog.this.clipboardOrFilePart != null) {
                        int p;
                        BrowsableFilenameField nameField = GenerateChangeLogDialog.this.clipboardOrFilePart.getBrowseableFilenameField();
                        String filePath = nameField.getText();
                        int i = filePath.lastIndexOf(46);
                        if (i > (p = Math.max(filePath.lastIndexOf(47), filePath.lastIndexOf(92)))) {
                            String currentExtension = filePath.substring(i);
                            nameField.setText(String.valueOf(filePath.substring(0, filePath.length() - currentExtension.length())) + this.previousExtension);
                        } else {
                            nameField.setText(String.valueOf(filePath) + this.previousExtension);
                        }
                    }
                }
                GenerateChangeLogDialog.this.updateEnablement();
            }
        });
        GridDataFactory.fillDefaults().grab(true, true).span(2, 1).applyTo((Control)this.outputInCSV);
        this.createLabel(groupAppearance, Messages.GenerateChangeLogDialog_LABEL_REROOT);
        this.formatWorkitemParent = new Combo((Composite)groupAppearance, 8);
        this.formatWorkitemParent.setItems(REROOT_STRINGS);
        this.setRerootDefault(false);
        if (this.outputInCSV.getSelection()) {
            this.setRerootDefault(true);
            this.formatWorkitemParent.setEnabled(false);
        }
        this.createLabel(groupAppearance, Messages.CopyChangeLogDialog_LABEL_NAME_TEMPLATE);
        this.templateName = new Text((Composite)groupAppearance, 2048);
        this.createTemplateText(this.templateName, PREF_TEMPLATE_NAME, DEFAULT_CONTRIB_FORMAT);
        this.templateNameDecoration = new ControlDecoration((Control)this.templateName, 16512);
        this.templateNameDecoration.hide();
        Listener nameListener = new Listener(){

            public void handleEvent(Event event) {
                if (event.type == 26) {
                    GenerateChangeLogDialog.this.templateNameDecoration.show();
                }
                if (event.type == 27) {
                    GenerateChangeLogDialog.this.templateNameDecoration.hide();
                }
            }
        };
        this.templateName.addListener(26, nameListener);
        this.templateName.addListener(27, nameListener);
        String contentMessage = Messages.GenerateChangeLogDialog_CONTENT_ASSIST_ICON_0;
        IBindingService bindingService = (IBindingService)PlatformUI.getWorkbench().getAdapter(IBindingService.class);
        TriggerSequence[] activeBindings = bindingService.getActiveBindingsFor("org.eclipse.ui.edit.text.contentAssist.proposals");
        if (activeBindings.length != 0) {
            contentMessage = NLS.bind((String)Messages.GenerateChangeLogDialog_CONTENT_ASSIST_ICON_1, (Object)activeBindings[0].format());
        }
        this.templateNameDecoration.setDescriptionText(contentMessage);
        this.templateNameDecoration.setImage(FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_CONTENT_PROPOSAL").getImage());
        KeyStroke keyStroke = activeBindings.length != 0 && activeBindings[0].getTriggers().length > 0 && activeBindings[0].getTriggers()[0] instanceof KeyStroke ? (KeyStroke)activeBindings[0].getTriggers()[0] : KeyStroke.getInstance((int)SWT.MOD1, (int)32);
        IContentProposalProvider nameTemplateProposalProvider = this.getNameTemplateProposalProvider(GenerateChangeLogDialog.getContribFormatValues());
        ContentProposalAdapter nameContentProposalAdapter = new ContentProposalAdapter((Control)this.templateName, (IControlContentAdapter)new TextContentAdapter(), nameTemplateProposalProvider, keyStroke, null);
        nameContentProposalAdapter.setPopupSize(new Point(175, 90));
        this.createLabel(groupAppearance, Messages.CopyChangeLogDialog_LABEL_DATE_TEMPLATE);
        this.templateDate = new DateFormatPart((Composite)groupAppearance, 2048);
        this.createTemplateText(this.templateDate.getControl(), PREF_TEMPLATE_DATE, "yyyy/MM/dd HH:mm:ss");
        this.templateDateDecoration = new ControlDecoration((Control)this.templateDate.getControl(), 16512);
        this.templateDateDecoration.hide();
        Listener dateListener = new Listener(){

            public void handleEvent(Event event) {
                if (event.type == 26) {
                    GenerateChangeLogDialog.this.templateDateDecoration.show();
                }
                if (event.type == 27) {
                    GenerateChangeLogDialog.this.templateDateDecoration.hide();
                }
            }
        };
        this.templateDate.getControl().addListener(26, dateListener);
        this.templateDate.getControl().addListener(27, dateListener);
        String contentMessageforDateTemplate = contentMessage;
        this.templateDateDecoration.setDescriptionText(contentMessageforDateTemplate);
        this.templateDateDecoration.setImage(FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_CONTENT_PROPOSAL").getImage());
        IContentProposalProvider dateTemplateProposalProvider = this.getDateTemplateProposalProvider(GenerateChangeLogDialog.getDateFormatValues());
        ContentProposalAdapter dateContentProposalAdapter = new ContentProposalAdapter((Control)this.templateDate.getControl(), (IControlContentAdapter)new TextContentAdapter(), dateTemplateProposalProvider, keyStroke, null);
        dateContentProposalAdapter.setPopupSize(new Point(356, 75));
        dateContentProposalAdapter.setProposalAcceptanceStyle(2);
        Group groupFilter2 = new Group(advancedOptionsArea, 0);
        groupFilter2.setText(Messages.GenerateChangeLogDialog_PATH_RESOLUTION_GROUP);
        this.useRepositoryPathsOnly = this.createRootButton(groupFilter2, Messages.GenerateChangeLogDialog_USE_REPOSITORY_PATHS_ONLY, PREF_USE_REPOSITORY_PATHS_ONLY, true, null);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)groupFilter2);
        GridLayoutFactory.fillDefaults().margins(LayoutConstants.getMargins()).generateLayout((Composite)groupFilter2);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)groupAppearance);
        GridLayoutFactory.fillDefaults().margins(LayoutConstants.getMargins()).numColumns(2).generateLayout((Composite)groupAppearance);
        Group groupDirection = new Group(advancedOptionsArea, 0);
        groupDirection.setText(Messages.GenerateChangeLogDialog_DIRECTION_GROUP);
        this.showFlowIncoming = this.createRadioButton(groupDirection, Messages.GenerateChangeLogDialog_DIRECTION_INCOMING, this.input.getSuggestedFlowType() == FlowType.Incoming);
        this.showFlowOutgoing = this.createRadioButton(groupDirection, Messages.GenerateChangeLogDialog_DIRECTION_OUTGOING, this.input.getSuggestedFlowType() == FlowType.Outgoing);
        this.showFlowBoth = this.createRadioButton(groupDirection, Messages.GenerateChangeLogDialog_DIRECTION_BOTH, this.input.getSuggestedFlowType() == FlowType.Both);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)groupDirection);
        GridLayoutFactory.fillDefaults().margins(LayoutConstants.getMargins()).numColumns(3).generateLayout((Composite)groupDirection);
    }

    private void createLabel(Group parent, String text) {
        Label label = new Label((Composite)parent, 4);
        label.setText(text);
    }

    private void setRerootDefault(boolean forceDefaultValue) {
        String defaultValue = this.outputInCSV != null && this.outputInCSV.getSelection() ? "clentry_component" : REROOT_VALUE_DEFAULT;
        String value = forceDefaultValue ? defaultValue : this.prefs.get(PREF_REROOT, REROOT_VALUE_DEFAULT);
        int i = 0;
        while (i < REROOT_VALUES.length) {
            if (REROOT_VALUES[i].equals(value)) {
                this.formatWorkitemParent.select(i);
                return;
            }
            ++i;
        }
    }

    private Button createRadioButton(Group groupDirection, String text, boolean isSelected) {
        Button b = new Button((Composite)groupDirection, 16);
        b.setText(text);
        b.setSelection(isSelected);
        GridData data = new GridData(4, 4, true, false);
        data.horizontalIndent = LayoutConstants.getMargins().x * 2;
        b.setLayoutData((Object)data);
        return b;
    }

    private Text createTemplateText(Text t, String prefKey, String defaultValue) {
        String text = this.prefs.get(prefKey, defaultValue);
        t.setText(text == null ? "" : text);
        this.textPrefKeys.put(prefKey, t);
        return t;
    }

    private Button createRootButton(Group groupType, String text, String prefKey, boolean defaultValue, SelectionListener listener) {
        Button b = new Button((Composite)groupType, 32);
        b.setText(text);
        b.setSelection(this.prefs.getBoolean(prefKey, defaultValue));
        GridData data = new GridData(4, 4, true, false);
        b.setLayoutData((Object)data);
        if (listener != null) {
            b.addSelectionListener(listener);
        }
        this.buttonPrefKeys.put(prefKey, b);
        return b;
    }

    private Button createIndentedButton(Group parent, String text, String prefKey, boolean defaultValue, Button dependsOn) {
        Button button = new Button((Composite)parent, 32);
        button.setText(text);
        button.setSelection(this.prefs.getBoolean(prefKey, defaultValue));
        GridData data = new GridData(4, 4, true, false);
        data.horizontalIndent = LayoutConstants.getMargins().x * 2;
        button.setLayoutData((Object)data);
        List<Button> depList = this.buttonDependencies.get(dependsOn);
        if (depList == null) {
            depList = new LinkedList<Button>();
            this.buttonDependencies.put(dependsOn, depList);
        }
        depList.add(button);
        this.buttonPrefKeys.put(prefKey, button);
        return button;
    }

    protected void setShellStyle(int newShellStyle) {
        super.setShellStyle(0x10060 | GenerateChangeLogDialog.getDefaultOrientation());
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.CopyChangeLogDialog_DIALOG_TITLE);
    }

    private void updateEnablement() {
        for (Button b : this.buttonDependencies.keySet()) {
            this.updateEnablement(b);
        }
        this.formatWorkitemParent.setEnabled(!this.outputInCSV.getSelection());
        this.showChangeSetsWorkItems.setEnabled(this.includeWorkItems.getSelection() && this.includeChangeSets.getSelection() && !this.outputInCSV.getSelection());
    }

    private void updateEnablement(Button item) {
        List<Button> toToggle = this.buttonDependencies.get(item);
        if (toToggle == null) {
            return;
        }
        for (Button dependent : toToggle) {
            dependent.setEnabled(item.getSelection());
        }
    }

    public GenerateChangeLogDialogResult getResult() {
        return this.result;
    }

    protected void okPressed() {
        ChangeLogCustomizer customizer = new ChangeLogCustomizer();
        customizer.setFlowsToInclude(this.getFlowType()).setIncludeDirection(this.showFlowBoth.getSelection()).setPruneEmptyDirections(this.filterEmptyDirections.getSelection()).setIncludeComponents(this.includeComponents.getSelection()).setPruneUnchangedComponents(this.filterUnchangedComponents.getSelection()).setIncludeBaselines(this.includeBaselines.getSelection()).setIncludeChangeSets(this.includeChangeSets.getSelection()).setIncludeWorkItems(this.includeWorkItems.getSelection()).setIncludeOslcLinks(this.includeWorkItems.getSelection()).setWorkItemRerootDepth(this.getRerootValue()).setIncludePaths(this.includeFilesystemChanges.getSelection()).setIncludeVersionIdentifiers(true).setIncludeFullVersionIdentifiers(this.showFullVersionIdentifiers.getSelection()).setOutputInCSV(this.outputInCSV.getSelection()).setUseRepositoryPathsOnly(this.useRepositoryPathsOnly.getSelection());
        BaseChangeLogEntryVisitor visitor = this.createChangeLogVisitor();
        this.clipboardOrFilePart.savePreferences();
        this.result = new GenerateChangeLogDialogResult(customizer, visitor, this.clipboardOrFilePart.getResult());
        for (Map.Entry<String, Button> entry : this.buttonPrefKeys.entrySet()) {
            this.prefs.putBoolean(entry.getKey(), entry.getValue().getSelection());
        }
        for (Map.Entry<String, Button> entry : this.textPrefKeys.entrySet()) {
            this.prefs.put(entry.getKey(), ((Text)entry.getValue()).getText());
        }
        this.prefs.put(PREF_REROOT, REROOT_VALUES[this.getRerootIndex()]);
        super.okPressed();
    }

    private int getRerootIndex() {
        int i = this.formatWorkitemParent.getSelectionIndex();
        if (i == -1) {
            i = 0;
        }
        return i;
    }

    private String getRerootValue() {
        int i = this.formatWorkitemParent.getSelectionIndex();
        if (REROOT_VALUE_DEFAULT.equals(REROOT_VALUES[i])) {
            return null;
        }
        return REROOT_VALUES[i];
    }

    private FlowType getFlowType() {
        if (this.showFlowIncoming.getSelection()) {
            return FlowType.Incoming;
        }
        if (this.showFlowOutgoing.getSelection()) {
            return FlowType.Outgoing;
        }
        return FlowType.Both;
    }

    private BaseChangeLogEntryVisitor createChangeLogVisitor() {
        CsvChangeLogEntryVisitor visitor;
        Object object = visitor = this.outputInCSV.getSelection() ? new CsvChangeLogEntryVisitor() : new BaseChangeLogEntryVisitor();
        if (this.outputInCSV.getSelection()) {
            visitor.setShowDirectionNodes(this.showFlowBoth.getSelection());
        }
        visitor.setShowComponents(this.includeComponents.getSelection());
        visitor.setShowBaselines(this.includeBaselines.getSelection());
        visitor.setShowBaselineCreator(this.showBaselinesContrib.getSelection());
        visitor.setShowBaselineCreationDate(this.showBaselinesCreationDate.getSelection());
        visitor.setShowChangeSets(this.includeChangeSets.getSelection());
        visitor.setShowChangeSetCreator(this.showChangeSetsContrib.getSelection());
        visitor.setShowChangeSetCreationDate(this.showChangeSetsCreationDate.getSelection());
        visitor.setShowChangeSetWorkItems(this.showChangeSetsWorkItems.getSelection());
        visitor.setShowChangeSetOslcLinks(this.showChangeSetsWorkItems.getSelection());
        visitor.setShowWorkItems(this.includeWorkItems.getSelection());
        visitor.setShowOslcLinks(this.includeWorkItems.getSelection());
        visitor.setShowVersionables(this.includeFilesystemChanges.getSelection());
        visitor.setShowVersionIDs(true);
        visitor.setShowFullVersionIDs(this.showFullVersionIdentifiers.getSelection());
        visitor.setShowItemIds(this.showItemIDs.getSelection());
        visitor.setContributorFormat(this.templateName.getText());
        visitor.setDateFormat(this.templateDate.getControl().getText());
        return visitor;
    }

    private static String[] getContribFormatValues() {
        String[] contribFormatValueList = new String[]{CONTRIB_FORMAT_USER_ID, CONTRIB_FORMAT_NAME, CONTRIB_FORMAT_EMAIL, CONTRIB_FORMAT_ITEM_ID};
        return contribFormatValueList;
    }

    private static String[] getDateFormatValues() {
        String[] dateFormatValueList = new String[]{"yyyy/MM/dd HH:mm:ss", DATE_FORMAT_1, DATE_FORMAT_2};
        return dateFormatValueList;
    }

    private IContentProposalProvider getNameTemplateProposalProvider(final String[] nameTemplateProposals) {
        return new IContentProposalProvider(){

            public IContentProposal[] getProposals(String contents, int position) {
                ArrayList<IContentProposal> proposals = new ArrayList<IContentProposal>(nameTemplateProposals.length);
                String[] stringArray = nameTemplateProposals;
                int n = nameTemplateProposals.length;
                int n2 = 0;
                while (n2 < n) {
                    String nameProposal = stringArray[n2];
                    proposals.add(this.newNameTemplateProposal(nameProposal));
                    ++n2;
                }
                return proposals.toArray(new IContentProposal[proposals.size()]);
            }

            private IContentProposal newNameTemplateProposal(final String proposal) {
                return new IContentProposal(){

                    public String getContent() {
                        return proposal;
                    }

                    public int getCursorPosition() {
                        return proposal.length();
                    }

                    public String getDescription() {
                        return null;
                    }

                    public String getLabel() {
                        String label = proposal.equals(GenerateChangeLogDialog.CONTRIB_FORMAT_USER_ID) ? NLS.bind((String)Messages.GenerateChangeLogDialog_CONTENT_ASSIST_NAME_LABEL, (Object)GenerateChangeLogDialog.CONTRIB_FORMAT_USER_ID, (Object)Messages.GenerateChangeLogDialog_CONTENT_ASSIST_NAME_0) : (proposal.equals(GenerateChangeLogDialog.CONTRIB_FORMAT_NAME) ? NLS.bind((String)Messages.GenerateChangeLogDialog_CONTENT_ASSIST_NAME_LABEL, (Object)GenerateChangeLogDialog.CONTRIB_FORMAT_NAME, (Object)Messages.GenerateChangeLogDialog_CONTENT_ASSIST_NAME_1) : (proposal.equals(GenerateChangeLogDialog.CONTRIB_FORMAT_EMAIL) ? NLS.bind((String)Messages.GenerateChangeLogDialog_CONTENT_ASSIST_NAME_LABEL, (Object)GenerateChangeLogDialog.CONTRIB_FORMAT_EMAIL, (Object)Messages.GenerateChangeLogDialog_CONTENT_ASSIST_NAME_2) : (proposal.equals(GenerateChangeLogDialog.CONTRIB_FORMAT_ITEM_ID) ? NLS.bind((String)Messages.GenerateChangeLogDialog_CONTENT_ASSIST_NAME_LABEL, (Object)GenerateChangeLogDialog.CONTRIB_FORMAT_ITEM_ID, (Object)Messages.GenerateChangeLogDialog_CONTENT_ASSIST_NAME_3) : proposal)));
                        return label;
                    }
                };
            }
        };
    }

    private IContentProposalProvider getDateTemplateProposalProvider(final String[] dateTemplateProposals) {
        return new IContentProposalProvider(){

            public IContentProposal[] getProposals(String contents, int position) {
                ArrayList<IContentProposal> proposals = new ArrayList<IContentProposal>(dateTemplateProposals.length);
                String[] stringArray = dateTemplateProposals;
                int n = dateTemplateProposals.length;
                int n2 = 0;
                while (n2 < n) {
                    String nameProposal = stringArray[n2];
                    proposals.add(this.newDateTemplateProposal(nameProposal));
                    ++n2;
                }
                return proposals.toArray(new IContentProposal[proposals.size()]);
            }

            private IContentProposal newDateTemplateProposal(final String proposal) {
                return new IContentProposal(){

                    public String getContent() {
                        return proposal;
                    }

                    public int getCursorPosition() {
                        return proposal.length();
                    }

                    public String getDescription() {
                        return null;
                    }

                    public String getLabel() {
                        String label = proposal.equals("yyyy/MM/dd HH:mm:ss") ? NLS.bind((String)Messages.GenerateChangeLogDialog_CONTENT_ASSIST_DATE_LABEL, (Object)"yyyy/MM/dd HH:mm:ss", (Object)Messages.GenerateChangeLogDialog_CONTENT_ASSIST_DATE_0) : (proposal.equals(GenerateChangeLogDialog.DATE_FORMAT_1) ? NLS.bind((String)Messages.GenerateChangeLogDialog_CONTENT_ASSIST_DATE_LABEL, (Object)GenerateChangeLogDialog.DATE_FORMAT_1, (Object)Messages.GenerateChangeLogDialog_CONTENT_ASSIST_DATE_1) : (proposal.equals(GenerateChangeLogDialog.DATE_FORMAT_2) ? NLS.bind((String)Messages.GenerateChangeLogDialog_CONTENT_ASSIST_DATE_LABEL, (Object)GenerateChangeLogDialog.DATE_FORMAT_2, (Object)Messages.GenerateChangeLogDialog_CONTENT_ASSIST_DATE_2) : proposal));
                        return label;
                    }
                };
            }
        };
    }

    private static class DateFormatPart {
        private WritableValue validationStatus;
        private Text text;

        public DateFormatPart(Composite composite, int style) {
            this.text = new Text(composite, style);
            this.text.addVerifyListener(new VerifyListener(){

                public void verifyText(VerifyEvent e) {
                    String string = new StringBuilder(text.getText()).replace(e.start, e.end, e.text).toString();
                    this.verifyText(string);
                    e.doit = true;
                }
            });
            this.validationStatus = new WritableValue();
            this.validationStatus.setValue((Object)Status.OK_STATUS);
        }

        private void verifyText(String string) {
            try {
                new SimpleDateFormat(string);
                this.validationStatus.setValue((Object)Status.OK_STATUS);
            }
            catch (IllegalArgumentException e) {
                this.validationStatus.setValue((Object)FileSystemStatusUtil.getStatusFor((int)4, (String)NLS.bind((String)Messages.GenerateChangeLogDialog_INVALID_DATE_FORMAT, (Object)string), (Throwable)e));
            }
        }

        public Text getControl() {
            return this.text;
        }

        public IObservableValue getValidationStatus() {
            return this.validationStatus;
        }
    }

    public static class GenerateChangeLogDialogInput {
        private final FlowType suggestedFlowType;

        public GenerateChangeLogDialogInput(FlowType t) {
            this.suggestedFlowType = t;
        }

        public FlowType getSuggestedFlowType() {
            return this.suggestedFlowType;
        }
    }

    public static class GenerateChangeLogDialogResult {
        private ChangeLogCustomizer customizer;
        private BaseChangeLogEntryVisitor visitor;
        private ClipboardOrFilePart.ClipboardOrFileResult clipboardOrFile;

        public GenerateChangeLogDialogResult(ChangeLogCustomizer customizer, BaseChangeLogEntryVisitor visitor, ClipboardOrFilePart.ClipboardOrFileResult clipboardOrFile) {
            this.customizer = customizer;
            this.visitor = visitor;
            this.clipboardOrFile = clipboardOrFile;
        }

        public ChangeLogCustomizer getCustomizer() {
            return this.customizer;
        }

        public BaseChangeLogEntryVisitor getVisitor() {
            return this.visitor;
        }

        public ClipboardOrFilePart.ClipboardOrFileResult getClipboardOrFile() {
            return this.clipboardOrFile;
        }
    }
}

