/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.structuralchanges;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.internal.namespace.ItemNamespace;
import com.ibm.team.filesystem.client.internal.snapshot.ISnapshot;
import com.ibm.team.filesystem.client.internal.snapshot.NamespaceSetId;
import com.ibm.team.filesystem.client.internal.snapshot.SnapshotId;
import com.ibm.team.internal.filesystem.ui.BaselineSelectionDialog;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.views.structuralchanges.ChangeSetPortExplorationInput;
import com.ibm.team.internal.filesystem.ui.views.structuralchanges.SnapshotCompareInput;
import com.ibm.team.internal.filesystem.ui.views.structuralchanges.StructuralChangesViewInput;
import com.ibm.team.internal.filesystem.ui.wizards.component.ComponentConfigurationPickerWizard;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.ui.internal.utils.JFaceUtils;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.repository.rcp.ui.parts.Parts;
import com.ibm.team.repository.rcp.ui.parts.impl.IPartResult;
import com.ibm.team.repository.rcp.ui.utils.UIContext;
import com.ibm.team.scm.common.internal.util.ItemId;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;

public class ChangesViewConverter {
    public static void openChangeExplorer(IWorkbenchPage page, StructuralChangesViewInput input) {
        ChangeSetPortExplorationInput portExplorationInput;
        if (input instanceof ChangeSetPortExplorationInput && (portExplorationInput = (ChangeSetPortExplorationInput)input).isEmpty()) {
            JFaceUtils.showMessage((String)Messages.ChangesViewConverter_NOTHING_TO_SHOW_DIALOG_TITLE, (String)Messages.ChangesViewConverter_NOTHING_TO_SHOW_DIALOG_MESSAGE, (int)0);
            return;
        }
        Parts.openView((IWorkbenchPage)page, (Object)input, (String)"com.ibm.team.filesystem.ui.changes.views.ChangeExplorerView");
    }

    public static void compare(IWorkbenchPage page, SnapshotId snapshot1, SnapshotId snapshot2) {
        ChangesViewConverter.compare(UIContext.createPageContext((Shell)page.getWorkbenchWindow().getShell(), (IWorkbenchPage)page), snapshot1, snapshot2);
    }

    public static void compare(UIContext context, SnapshotId snapshot1, SnapshotId snapshot2) {
        ChangesViewConverter.openChangeExplorer(context.getPage(), SnapshotCompareInput.create(snapshot1, snapshot2));
    }

    private static void compare(final UIContext context, final ItemNamespace source, final SnapshotId target, final boolean invertArguments) {
        if (target == null || source == null || context == null) {
            throw new IllegalArgumentException("Arguments must not be null");
        }
        context.getUserOperationRunner().enqueue(Messages.ChangesViewConverter_fetchingComponentJobName, (Operation)new RepositoryOperation(source.getRepository()){

            public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, FileSystemException, OperationFailedException {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                ItemId component = source.fetchComponentId((IProgressMonitor)progress.newChild(20));
                ISnapshot snapshot = target.getSnapshot((IProgressMonitor)progress.newChild(40));
                final ItemNamespace targetNamespace = snapshot.getNamespaceFor(component, (IProgressMonitor)progress.newChild(20));
                context.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (invertArguments) {
                            ChangesViewConverter.compare(context, targetNamespace, source);
                        } else {
                            ChangesViewConverter.compare(context, source, targetNamespace);
                        }
                    }
                });
            }
        });
    }

    public static void compare(UIContext context, SnapshotId source, ItemNamespace target) {
        ChangesViewConverter.compare(context, target, source, true);
    }

    public static void compare(UIContext context, ItemNamespace source, SnapshotId target) {
        ChangesViewConverter.compare(context, source, target, true);
    }

    public static void compare(UIContext context, ItemNamespace source, ItemNamespace target) {
        ChangesViewConverter.compare(context, (SnapshotId)NamespaceSetId.create((ItemNamespace)source), (SnapshotId)NamespaceSetId.create((ItemNamespace)target));
    }

    public static void compareWithBaseline(final UIContext context, final ItemNamespace namespace) {
        BaselineSelectionDialog.getBaseline(new ComponentConfigurationPickerWizard.ConfigurationPickerInput(ComponentConfigurationPickerWizard.ConfigurationPickerInput.ConfigurationPickerMode.NON_SPECIFIC, false), context, Messages.BaselineSelectionDialog_2, namespace, new IPartResult<BaselineSelectionDialog.BaselineSelectionDialogResult>(){

            public void setResult(BaselineSelectionDialog.BaselineSelectionDialogResult result) {
                ChangesViewConverter.compare(context, namespace, (ItemNamespace)result.getBaselineNamespace());
            }
        });
    }
}

