/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.structuralchanges;

import com.ibm.team.filesystem.client.internal.namespace.ItemNamespace;
import com.ibm.team.filesystem.client.internal.snapshot.ComponentSyncReportFragment;
import com.ibm.team.filesystem.client.internal.snapshot.FlowType;
import com.ibm.team.filesystem.client.internal.snapshot.ISnapshot;
import com.ibm.team.filesystem.client.internal.snapshot.SnapshotSyncReport;
import com.ibm.team.filesystem.common.changemodel.IPathResolver;
import com.ibm.team.filesystem.common.internal.util.ComponentHierarchyCompareResult;
import com.ibm.team.filesystem.ui.queries.HierarchicalRootComponentQuery;
import com.ibm.team.filesystem.ui.queries.HierarchicalSubComponentQuery;
import com.ibm.team.filesystem.ui.wrapper.BaselineHierarchyWrapper;
import com.ibm.team.filesystem.ui.wrapper.WorkspaceComponentWrapper;
import com.ibm.team.internal.filesystem.ui.patches.PatchTreeProvider;
import com.ibm.team.internal.filesystem.ui.views.structuralchanges.SnapshotPair;
import com.ibm.team.internal.filesystem.ui.views.structuralchanges.nodes.StructuralChangesBaselineNode;
import com.ibm.team.internal.filesystem.ui.views.structuralchanges.nodes.StructuralChangesChangeSetNode;
import com.ibm.team.internal.filesystem.ui.views.structuralchanges.nodes.StructuralChangesComponentNode;
import com.ibm.team.internal.filesystem.ui.views.structuralchanges.nodes.StructuralChangesPlaceholderNode;
import com.ibm.team.internal.filesystem.ui.views.structuralchanges.nodes.StructuralChangesSubcomponentNode;
import com.ibm.team.internal.filesystem.ui.views.structuralchanges.nodes.StructuralChangesViewFolderNode;
import com.ibm.team.internal.filesystem.ui.views.structuralchanges.queries.BaselinesInSyncReportQuery;
import com.ibm.team.internal.filesystem.ui.views.structuralchanges.queries.ChangeSetLinksQuery;
import com.ibm.team.internal.filesystem.ui.views.structuralchanges.queries.ChangeSetsInBaselineNodeQuery;
import com.ibm.team.internal.filesystem.ui.views.structuralchanges.queries.ChangeSetsInSyncReportQuery;
import com.ibm.team.internal.filesystem.ui.views.structuralchanges.queries.ComponentsInSyncReportQuery;
import com.ibm.team.internal.filesystem.ui.views.structuralchanges.queries.FilesInFolderQuery;
import com.ibm.team.internal.filesystem.ui.views.structuralchanges.queries.HierarchicalRootBaselineSetQuery;
import com.ibm.team.internal.filesystem.ui.views.structuralchanges.queries.HierarchicalSubBaselineSetQuery;
import com.ibm.team.internal.filesystem.ui.views.structuralchanges.queries.PortSourceQuery;
import com.ibm.team.internal.filesystem.ui.views.structuralchanges.queries.RootNodesInChangeSetQuery;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.rcp.common.IRemoteFunction;
import com.ibm.team.repository.rcp.ui.internal.viewers.ISetWithListeners;
import com.ibm.team.repository.rcp.ui.internal.viewers.ITreeProvider;
import com.ibm.team.repository.rcp.ui.internal.viewers.UnionSet;
import com.ibm.team.repository.rcp.ui.internal.viewers.WritableSetWithListeners;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.internal.util.ItemId;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public final class ChangesTreeProvider
implements ITreeProvider {
    private ITeamRepository repo;
    private FlowType flowType;
    private SnapshotPair snapshots;
    private IPathResolver resolver;
    private boolean useCFA;
    private IOperationRunner runner;
    private PatchTreeProvider contentsTree = new PatchTreeProvider();
    private Map<UUID, StructuralChangesComponentNode> structuralChangesMap = new HashMap<UUID, StructuralChangesComponentNode>();
    private IWorkspaceConnection leftConnection;
    private IWorkspaceConnection rightConnection;
    private ComponentHierarchyCompareResult componentHierarchyCompareResult;

    public ChangesTreeProvider(ITeamRepository repo, FlowType type, SnapshotPair snapshots, IPathResolver pathResolver, boolean useCFA, IOperationRunner operationRunner) {
        this.repo = repo;
        this.flowType = type;
        this.snapshots = snapshots;
        this.resolver = pathResolver;
        this.useCFA = useCFA;
        this.runner = operationRunner;
    }

    public ISetWithListeners getChildren(Object element) {
        StructuralChangesPlaceholderNode node;
        IOperationRunner operationRunner = this.runner;
        if (element instanceof SnapshotSyncReport) {
            ITeamRepository incomingRepository;
            SnapshotSyncReport report = (SnapshotSyncReport)element;
            ITeamRepository outgoingRepository = report.getOutgoing().getRepository();
            if (outgoingRepository == null) {
                outgoingRepository = this.repo;
            }
            if ((incomingRepository = report.getIncoming().getRepository()) == null) {
                incomingRepository = this.repo;
            }
            if (this.componentHierarchyCompareResult == null) {
                return new ComponentsInSyncReportQuery(this.repo, incomingRepository, report, FlowType.Both, this.resolver, this.snapshots.getOutgoing(), operationRunner);
            }
            UnionSet result = new UnionSet();
            if (this.leftConnection != null) {
                IWorkspace workspace = this.leftConnection.getResolvedWorkspace();
                result.add((ISetWithListeners)new HierarchicalRootComponentQuery(outgoingRepository, workspace, this.componentHierarchyCompareResult, this.structuralChangesMap, operationRunner));
                if (this.rightConnection != null) {
                    for (StructuralChangesComponentNode node2 : this.structuralChangesMap.values()) {
                        if (!node2.getChangeType().equals((Object)StructuralChangesComponentNode.ChangeType.Removal)) continue;
                        WritableSetWithListeners set = new WritableSetWithListeners();
                        set.add((Object)node2);
                        result.add((ISetWithListeners)set);
                    }
                } else {
                    for (StructuralChangesComponentNode node3 : this.structuralChangesMap.values()) {
                        if (!node3.getChangeType().equals((Object)StructuralChangesComponentNode.ChangeType.Removal)) continue;
                        WritableSetWithListeners set = new WritableSetWithListeners();
                        set.add((Object)node3);
                        result.add((ISetWithListeners)set);
                    }
                }
            } else {
                result.add((ISetWithListeners)new HierarchicalRootBaselineSetQuery(outgoingRepository, this.componentHierarchyCompareResult, this.structuralChangesMap, operationRunner));
                for (StructuralChangesComponentNode node4 : this.structuralChangesMap.values()) {
                    if (!node4.getChangeType().equals((Object)StructuralChangesComponentNode.ChangeType.Removal)) continue;
                    WritableSetWithListeners set = new WritableSetWithListeners();
                    set.add((Object)node4);
                    result.add((ISetWithListeners)set);
                }
            }
            return result;
        }
        if (element instanceof BaselineHierarchyWrapper) {
            BaselineHierarchyWrapper node5 = (BaselineHierarchyWrapper)((Object)element);
            StructuralChangesComponentNode structuralChangeNode = node5.getStructuralChangesComponentNode();
            if (structuralChangeNode != null && !structuralChangeNode.getChangeType().equals((Object)StructuralChangesComponentNode.ChangeType.Modify)) {
                return null;
            }
            UUID componentId = node5.getComponent().getItemId();
            UnionSet result = this.getStructuralChanges(componentId);
            result.add((ISetWithListeners)new HierarchicalSubBaselineSetQuery(node5, this.componentHierarchyCompareResult, this.structuralChangesMap, operationRunner));
            return result;
        }
        if (element instanceof WorkspaceComponentWrapper) {
            WorkspaceComponentWrapper node6 = (WorkspaceComponentWrapper)element;
            StructuralChangesComponentNode structuralChangeNode = node6.getStructuralChangesComponentNode();
            if (structuralChangeNode != null && !structuralChangeNode.getChangeType().equals((Object)StructuralChangesComponentNode.ChangeType.Modify)) {
                return null;
            }
            UUID componentId = node6.getComponent().getItemId();
            UnionSet result = this.getStructuralChanges(componentId);
            result.add((ISetWithListeners)new HierarchicalSubComponentQuery(node6, this.componentHierarchyCompareResult, this.structuralChangesMap, operationRunner));
            return result;
        }
        if (element instanceof StructuralChangesComponentNode) {
            StructuralChangesComponentNode componentNode = (StructuralChangesComponentNode)element;
            if (componentNode.getChangeType() != StructuralChangesComponentNode.ChangeType.Modify) {
                return null;
            }
            if (this.flowType == FlowType.Both) {
                WritableSetWithListeners children = new WritableSetWithListeners();
                if (!componentNode.getReport(FlowType.Incoming).isEmpty()) {
                    children.add((Object)new StructuralChangesPlaceholderNode(FlowType.Incoming, componentNode, componentNode.getRemote()));
                }
                if (!componentNode.getReport(FlowType.Outgoing).isEmpty()) {
                    children.add((Object)new StructuralChangesPlaceholderNode(FlowType.Outgoing, componentNode, componentNode.getRepository()));
                }
                return children;
            }
            ITeamRepository repo = componentNode.getRepository();
            if (this.flowType == FlowType.Incoming) {
                repo = componentNode.getRemote();
            }
            return this.getChildren(new StructuralChangesPlaceholderNode(this.flowType, componentNode, repo));
        }
        if (element instanceof StructuralChangesPlaceholderNode && (node = (StructuralChangesPlaceholderNode)element).getParent() instanceof StructuralChangesComponentNode) {
            StructuralChangesComponentNode component = (StructuralChangesComponentNode)node.getParent();
            FlowType type = node.getType();
            ItemId componentId = ItemId.forItem((IItem)component.getComponent());
            ComponentSyncReportFragment report = component.getReport(node.getType());
            return this.getComponentSyncReportChildren(node.getRepo(), component.getRemote(), report, node.getType(), this.getNamespaceFunction((ItemId<IComponent>)componentId, type), operationRunner);
        }
        if (element instanceof StructuralChangesBaselineNode) {
            StructuralChangesBaselineNode baselineNode = (StructuralChangesBaselineNode)element;
            return new ChangeSetsInBaselineNodeQuery(baselineNode, baselineNode.getNamespace(), operationRunner);
        }
        if (element instanceof StructuralChangesChangeSetNode) {
            StructuralChangesChangeSetNode changeSet = (StructuralChangesChangeSetNode)element;
            return this.getChangeSetNodeChildren(changeSet, operationRunner);
        }
        if (element instanceof StructuralChangesViewFolderNode) {
            StructuralChangesViewFolderNode folderNode = (StructuralChangesViewFolderNode)element;
            return new FilesInFolderQuery(operationRunner, folderNode, this.useCFA);
        }
        return this.contentsTree.getChildren(element);
    }

    private UnionSet getStructuralChanges(UUID componentId) {
        UnionSet result = new UnionSet();
        if (this.structuralChangesMap == null) {
            return result;
        }
        StructuralChangesComponentNode componentNode = this.structuralChangesMap.get(componentId);
        if (componentNode == null) {
            return result;
        }
        if (componentNode.getChangeType() != StructuralChangesComponentNode.ChangeType.Modify) {
            return result;
        }
        if (this.flowType == FlowType.Both) {
            WritableSetWithListeners children = new WritableSetWithListeners();
            if (!componentNode.getReport(FlowType.Incoming).isEmpty()) {
                children.add((Object)new StructuralChangesPlaceholderNode(FlowType.Incoming, componentNode, componentNode.getRemote()));
            }
            if (!componentNode.getReport(FlowType.Outgoing).isEmpty()) {
                children.add((Object)new StructuralChangesPlaceholderNode(FlowType.Outgoing, componentNode, componentNode.getRepository()));
            }
            result.add((ISetWithListeners)children);
        } else {
            ITeamRepository repo = componentNode.getRepository();
            if (this.flowType == FlowType.Incoming) {
                repo = componentNode.getRemote();
            }
            result.add(this.getChildren(new StructuralChangesPlaceholderNode(this.flowType, componentNode, repo)));
        }
        return result;
    }

    private IRemoteFunction<ItemNamespace> getNamespaceFunction(final ItemId<IComponent> componentItemId, final FlowType type) {
        return new IRemoteFunction<ItemNamespace>(){

            public ItemNamespace compute(IProgressMonitor monitor) throws TeamRepositoryException {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                ISnapshot snapshot = ChangesTreeProvider.this.snapshots.get(type).getSnapshot((IProgressMonitor)progress.newChild(50));
                return snapshot.getNamespaceFor(componentItemId, (IProgressMonitor)progress.newChild(50));
            }
        };
    }

    private UnionSet getChangeSetNodeChildren(StructuralChangesChangeSetNode node, IOperationRunner operationRunner) {
        UnionSet result = new UnionSet();
        result.add((ISetWithListeners)new RootNodesInChangeSetQuery(this.resolver, operationRunner, node, !StructuralChangesSubcomponentNode.hideSubcomponentNodes));
        result.add((ISetWithListeners)new ChangeSetLinksQuery(this.repo, node.getWrapper(), operationRunner));
        result.add((ISetWithListeners)new PortSourceQuery(this.repo, node.getWrapper(), operationRunner));
        return result;
    }

    private UnionSet getComponentSyncReportChildren(ITeamRepository repository, ITeamRepository remote, ComponentSyncReportFragment report, FlowType type, IRemoteFunction<ItemNamespace> namespace, IOperationRunner operationRunner) {
        UnionSet result = new UnionSet();
        result.add((ISetWithListeners)new ChangeSetsInSyncReportQuery(repository, remote, report.getChangeSets(), type, namespace, operationRunner));
        result.add((ISetWithListeners)new BaselinesInSyncReportQuery(repository, remote, report, type, namespace, operationRunner));
        return result;
    }

    public void setStructuralChangesMap(Map<UUID, StructuralChangesComponentNode> structuralChangesMap) {
        this.structuralChangesMap = structuralChangesMap;
    }

    public void setLeftConnection(IWorkspaceConnection connection) {
        this.leftConnection = connection;
    }

    public void setRightConnection(IWorkspaceConnection connection) {
        this.rightConnection = connection;
    }

    public void setHierarchiesCompareResult(ComponentHierarchyCompareResult componentHierarchyCompareResult) {
        this.componentHierarchyCompareResult = componentHierarchyCompareResult;
    }
}

