/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.structuralchanges;

import com.ibm.team.filesystem.client.internal.namespace.ItemNamespace;
import com.ibm.team.filesystem.client.internal.snapshot.ComponentSyncReportFragment;
import com.ibm.team.filesystem.client.internal.snapshot.FlowType;
import com.ibm.team.filesystem.client.internal.snapshot.ISnapshot;
import com.ibm.team.filesystem.client.internal.snapshot.SnapshotId;
import com.ibm.team.filesystem.client.internal.snapshot.SnapshotSyncReport;
import com.ibm.team.filesystem.common.changemodel.IPathResolver;
import com.ibm.team.internal.filesystem.ui.patches.PatchTreeProvider;
import com.ibm.team.internal.filesystem.ui.views.structuralchanges.SnapshotPair;
import com.ibm.team.internal.filesystem.ui.views.structuralchanges.nodes.StructuralChangesChangeSetNode;
import com.ibm.team.internal.filesystem.ui.views.structuralchanges.nodes.StructuralChangesComponentNode;
import com.ibm.team.internal.filesystem.ui.views.structuralchanges.nodes.StructuralChangesEquivalentChangeSetsContainerNode;
import com.ibm.team.internal.filesystem.ui.views.structuralchanges.nodes.StructuralChangesPlaceholderNode;
import com.ibm.team.internal.filesystem.ui.views.structuralchanges.nodes.StructuralChangesSubcomponentNode;
import com.ibm.team.internal.filesystem.ui.views.structuralchanges.nodes.StructuralChangesViewFolderNode;
import com.ibm.team.internal.filesystem.ui.views.structuralchanges.nodes.StructuralChangesViewNode;
import com.ibm.team.internal.filesystem.ui.views.structuralchanges.queries.ChangeSetLinksQuery;
import com.ibm.team.internal.filesystem.ui.views.structuralchanges.queries.ComponentsInSyncReportQuery;
import com.ibm.team.internal.filesystem.ui.views.structuralchanges.queries.EquivalentChangeSetsContainerNodeQuery;
import com.ibm.team.internal.filesystem.ui.views.structuralchanges.queries.EquivalentChangeSetsQuery;
import com.ibm.team.internal.filesystem.ui.views.structuralchanges.queries.FilesInFolderQuery;
import com.ibm.team.internal.filesystem.ui.views.structuralchanges.queries.PortSourceQuery;
import com.ibm.team.internal.filesystem.ui.views.structuralchanges.queries.RootNodesInChangeSetQuery;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.common.IRemoteFunction;
import com.ibm.team.repository.rcp.ui.internal.viewers.ISetWithListeners;
import com.ibm.team.repository.rcp.ui.internal.viewers.ITreeProvider;
import com.ibm.team.repository.rcp.ui.internal.viewers.UnionSet;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.internal.util.ItemId;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class ChangeSetPortExplorationTreeProvider
implements ITreeProvider {
    private IOperationRunner fRunner;
    private FlowType fFlowType;
    private IPathResolver fResolver;
    private PatchTreeProvider fContentsTree = new PatchTreeProvider();
    private ITeamRepository fRepo;
    private SnapshotPair fSnapshots;

    public ChangeSetPortExplorationTreeProvider(ITeamRepository repo, FlowType type, IOperationRunner operationRunner, IPathResolver pathResolver, SnapshotPair snapshots) {
        this.fFlowType = type;
        this.fRunner = operationRunner;
        this.fResolver = pathResolver;
        this.fRepo = repo;
        this.fSnapshots = snapshots;
    }

    public ISetWithListeners getChildren(Object element) {
        StructuralChangesViewNode node;
        IOperationRunner operationRunner = this.fRunner;
        if (element instanceof SnapshotSyncReport) {
            SnapshotSyncReport report = (SnapshotSyncReport)element;
            ITeamRepository outgoingRepository = report.getOutgoing().getRepository();
            ITeamRepository incomingRepository = report.getIncoming().getRepository();
            if (outgoingRepository == null) {
                outgoingRepository = this.fRepo;
            }
            if (incomingRepository == null) {
                incomingRepository = this.fRepo;
            }
            ComponentsInSyncReportQuery nextLevel = new ComponentsInSyncReportQuery(this.fRepo, incomingRepository, report, FlowType.Both, this.fResolver, this.fSnapshots.getOutgoing(), operationRunner);
            return nextLevel;
        }
        if (element instanceof StructuralChangesComponentNode) {
            StructuralChangesComponentNode componentNode = (StructuralChangesComponentNode)element;
            if (componentNode.getChangeType() != StructuralChangesComponentNode.ChangeType.Modify) {
                return null;
            }
            if (this.fFlowType == FlowType.Outgoing) {
                ITeamRepository repo = componentNode.getRepository();
                return this.getChildren(new StructuralChangesPlaceholderNode(this.fFlowType, componentNode, repo));
            }
        }
        if (element instanceof StructuralChangesPlaceholderNode && (node = (StructuralChangesPlaceholderNode)element).getParent() instanceof StructuralChangesComponentNode) {
            StructuralChangesComponentNode component = (StructuralChangesComponentNode)node.getParent();
            FlowType type = node.getType();
            ComponentSyncReportFragment report = component.getReport(type);
            return new EquivalentChangeSetsContainerNodeQuery(((StructuralChangesPlaceholderNode)node).getRepo(), component.getComponent(), report.getChangeSets().getChangeSets(), type, operationRunner);
        }
        if (element instanceof StructuralChangesEquivalentChangeSetsContainerNode) {
            node = (StructuralChangesEquivalentChangeSetsContainerNode)element;
            FlowType type = node.getType();
            final SnapshotId snapshotId = this.fSnapshots.get(type);
            final ItemId componentId = ItemId.forItem((IItem)((StructuralChangesEquivalentChangeSetsContainerNode)node).getComponent());
            int MAX_RESULT = 512;
            IRemoteFunction<ItemNamespace> namespace = new IRemoteFunction<ItemNamespace>(){

                public ItemNamespace compute(IProgressMonitor monitor) throws TeamRepositoryException {
                    SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                    ISnapshot snapshot = snapshotId.getSnapshot((IProgressMonitor)progress.newChild(50));
                    return snapshot.getNamespaceFor(componentId, (IProgressMonitor)progress.newChild(50));
                }
            };
            return new EquivalentChangeSetsQuery(((StructuralChangesEquivalentChangeSetsContainerNode)node).getRepository(), (IComponentHandle)((StructuralChangesEquivalentChangeSetsContainerNode)node).getComponent(), (IChangeSetHandle)((StructuralChangesEquivalentChangeSetsContainerNode)node).getWrapper().getChangeSet(), type, namespace, MAX_RESULT, operationRunner);
        }
        if (element instanceof StructuralChangesChangeSetNode) {
            StructuralChangesChangeSetNode changeSet = (StructuralChangesChangeSetNode)element;
            return this.getChangeSetNodeChildren(changeSet, operationRunner);
        }
        if (element instanceof StructuralChangesViewFolderNode) {
            StructuralChangesViewFolderNode folderNode = (StructuralChangesViewFolderNode)element;
            return new FilesInFolderQuery(operationRunner, folderNode, true);
        }
        return this.fContentsTree.getChildren(element);
    }

    private UnionSet getChangeSetNodeChildren(StructuralChangesChangeSetNode node, IOperationRunner operationRunner) {
        UnionSet result = new UnionSet();
        result.add((ISetWithListeners)new RootNodesInChangeSetQuery(this.fResolver, operationRunner, node, !StructuralChangesSubcomponentNode.hideSubcomponentNodes));
        result.add((ISetWithListeners)new ChangeSetLinksQuery(this.fRepo, node.getWrapper(), operationRunner));
        result.add((ISetWithListeners)new PortSourceQuery(this.fRepo, node.getWrapper(), operationRunner));
        return result;
    }
}

