/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.structuralchanges;

import com.ibm.team.filesystem.client.internal.snapshot.SnapshotId;
import com.ibm.team.filesystem.client.internal.snapshot.SnapshotSyncReport;
import com.ibm.team.filesystem.rcp.core.internal.rest.util.SyncViewDTOUtil;
import com.ibm.team.internal.filesystem.ui.views.structuralchanges.StructuralChangesViewInput;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.common.IRemoteFunction;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.internal.util.ItemId;
import com.ibm.team.scm.common.internal.util.ItemLists;
import com.ibm.team.scm.common.internal.util.NewCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

public class ChangeSetPortExplorationInput
extends StructuralChangesViewInput {
    private List<ItemId<IChangeSet>> fOriginalChangeSets = NewCollection.arrayList();
    private IRemoteFunction<String> fDescription;
    private SnapshotId fSnapshot;

    public ChangeSetPortExplorationInput(List<IChangeSet> changeSets) {
        this.fSnapshot = SnapshotId.createEmptyId((ITeamRepository)((ITeamRepository)changeSets.get(0).getOrigin()));
        HashMap originals = NewCollection.hashMap();
        ArrayList unPorted = NewCollection.arrayList();
        for (IChangeSet changeSet : changeSets) {
            IChangeSetHandle originalChangeSet = changeSet.getOriginalChangeSet();
            if (originalChangeSet == null) {
                unPorted.add(changeSet);
                continue;
            }
            originals.put(originalChangeSet.getItemId(), originalChangeSet);
        }
        if (originals.size() > 0) {
            this.fOriginalChangeSets.addAll(ItemLists.handlesToIds(originals.values()));
            this.fOriginalChangeSets.addAll(ItemLists.handlesToIds((Collection)unPorted));
        }
        this.fDescription = new DescriptionFunction(this.fSnapshot.getRepository(), this.fOriginalChangeSets);
    }

    public boolean isEmpty() {
        return this.fOriginalChangeSets.isEmpty();
    }

    @Override
    public SnapshotId getOutgoing() {
        return this.fSnapshot;
    }

    @Override
    public SnapshotId getIncoming() {
        return SnapshotId.createEmptyId((ITeamRepository)this.fSnapshot.getRepository());
    }

    @Override
    public SnapshotSyncReport computeSyncReport(boolean refresh, IProgressMonitor monitor) throws TeamRepositoryException {
        return SnapshotSyncReport.generateSyncReport((ITeamRepository)this.getRepository(), Collections.emptyList(), this.fOriginalChangeSets, (IProgressMonitor)monitor);
    }

    @Override
    public String computeName(IProgressMonitor monitor) throws TeamRepositoryException {
        return (String)this.fDescription.compute(monitor);
    }

    @Override
    public ITeamRepository getRepository() {
        return this.fSnapshot.getRepository();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.fOriginalChangeSets == null ? 0 : this.fOriginalChangeSets.hashCode());
        result = 31 * result + (this.fDescription == null ? 0 : this.fDescription.hashCode());
        result = 31 * result + (this.fSnapshot == null ? 0 : this.fSnapshot.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ChangeSetPortExplorationInput other = (ChangeSetPortExplorationInput)obj;
        if (this.fOriginalChangeSets == null ? other.fOriginalChangeSets != null : !this.fOriginalChangeSets.equals(other.fOriginalChangeSets)) {
            return false;
        }
        if (this.fDescription == null ? other.fDescription != null : !this.fDescription.equals(other.fDescription)) {
            return false;
        }
        return !(this.fSnapshot == null ? other.fSnapshot != null : !this.fSnapshot.equals(other.fSnapshot));
    }

    private static class DescriptionFunction
    implements IRemoteFunction<String> {
        private ITeamRepository fRepo;
        private List<ItemId<IChangeSet>> fChangeSets;

        public DescriptionFunction(ITeamRepository repo, List<ItemId<IChangeSet>> changeSets) {
            this.fRepo = repo;
            this.fChangeSets = changeSets;
        }

        public String compute(IProgressMonitor monitor) throws TeamRepositoryException {
            return SyncViewDTOUtil.computeChangeSetPortExplorationInputDescription(this.fChangeSets, (ITeamRepository)this.fRepo, (IProgressMonitor)monitor);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.fRepo == null ? 0 : this.fRepo.hashCode());
            result = 31 * result + (this.fChangeSets == null ? 0 : this.fChangeSets.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            DescriptionFunction other = (DescriptionFunction)obj;
            if (this.fRepo == null ? other.fRepo != null : !this.fRepo.equals(other.fRepo)) {
                return false;
            }
            return !(this.fChangeSets == null ? other.fChangeSets != null : !this.fChangeSets.equals(other.fChangeSets));
        }
    }
}

