/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.structuralchanges;

import com.ibm.team.filesystem.client.internal.snapshot.SnapshotId;
import com.ibm.team.filesystem.client.internal.snapshot.SnapshotSyncReport;
import com.ibm.team.filesystem.common.changemodel.ConfigurationChange;
import com.ibm.team.filesystem.rcp.core.internal.rest.util.SyncViewDTOUtil;
import com.ibm.team.internal.filesystem.ui.views.structuralchanges.StructuralChangesViewInput;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.rcp.common.IRemoteFunction;
import com.ibm.team.repository.rcp.ui.internal.viewers.ConstantFunction;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.internal.util.ItemId;
import com.ibm.team.scm.common.internal.util.ItemLists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

public class ChangeSetInput
extends StructuralChangesViewInput {
    private List<ItemId<IChangeSet>> changeSets;
    private List<UUID> states;
    private IRemoteFunction<String> description;
    private SnapshotId snapshot;

    public ChangeSetInput(SnapshotId snapshot, IChangeSetHandle changeSet) {
        this(snapshot, Collections.singletonList(changeSet));
    }

    public ChangeSetInput(SnapshotId snapshot, List<? extends IChangeSetHandle> changeSets) {
        this(snapshot, changeSets, new DescriptionFunction(snapshot.getRepository(), ItemLists.handlesToIds(changeSets)));
    }

    public ChangeSetInput(List<? extends IChangeSetHandle> changeSetsToShow) {
        this(SnapshotId.createEmptyId((ITeamRepository)((ITeamRepository)changeSetsToShow.get(0).getOrigin())), changeSetsToShow);
    }

    public ChangeSetInput(SnapshotId snapshot, List<? extends IChangeSetHandle> changeSets, IRemoteFunction<String> descriptionFunction) {
        this.snapshot = snapshot;
        this.changeSets = ItemLists.handlesToIds(changeSets);
        this.description = descriptionFunction;
        this.states = new ArrayList<UUID>();
        for (IChangeSetHandle iChangeSetHandle : changeSets) {
            if (!iChangeSetHandle.hasStateId()) continue;
            this.states.add(iChangeSetHandle.getStateId());
        }
    }

    public ChangeSetInput(SnapshotId snapshot, List<IChangeSetHandle> changeSets, String description) {
        this(snapshot, changeSets, (IRemoteFunction<String>)new ConstantFunction((Object)description));
    }

    @Override
    public SnapshotId getIncoming() {
        return SnapshotId.createEmptyId((ITeamRepository)this.snapshot.getRepository());
    }

    @Override
    public SnapshotSyncReport computeSyncReport(boolean refresh, IProgressMonitor monitor) throws TeamRepositoryException {
        return SnapshotSyncReport.generateSyncReport((ITeamRepository)this.getRepository(), (List)Collections.EMPTY_LIST, this.changeSets, (IProgressMonitor)monitor);
    }

    public ConfigurationChange getIncoming(IProgressMonitor monitor) throws TeamRepositoryException {
        return new ConfigurationChange();
    }

    @Override
    public String computeName(IProgressMonitor monitor) throws TeamRepositoryException {
        return (String)this.description.compute(monitor);
    }

    @Override
    public ITeamRepository getRepository() {
        return this.snapshot.getRepository();
    }

    @Override
    public SnapshotId getOutgoing() {
        return this.snapshot;
    }

    public List<ItemId<IChangeSet>> getChangeSets() {
        return this.changeSets;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.changeSets == null ? 0 : this.changeSets.hashCode());
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.snapshot == null ? 0 : this.snapshot.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ChangeSetInput other = (ChangeSetInput)obj;
        if (this.changeSets == null ? other.changeSets != null : !this.changeSets.equals(other.changeSets)) {
            return false;
        }
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.snapshot == null ? other.snapshot != null : !this.snapshot.equals(other.snapshot)) {
            return false;
        }
        return !(this.states == null ? other.states != null : !this.states.equals(other.states));
    }

    private static class DescriptionFunction
    implements IRemoteFunction<String> {
        private List<ItemId<IChangeSet>> changeSets;
        private ITeamRepository repo;

        public DescriptionFunction(ITeamRepository repo, List<ItemId<IChangeSet>> changeSets) {
            this.repo = repo;
            this.changeSets = changeSets;
        }

        public String compute(IProgressMonitor monitor) throws TeamRepositoryException {
            return SyncViewDTOUtil.computeChangeSetInputDescription(this.changeSets, (ITeamRepository)this.repo, (IProgressMonitor)monitor);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.changeSets == null ? 0 : this.changeSets.hashCode());
            result = 31 * result + (this.repo == null ? 0 : this.repo.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            DescriptionFunction other = (DescriptionFunction)obj;
            if (this.changeSets == null ? other.changeSets != null : !this.changeSets.equals(other.changeSets)) {
                return false;
            }
            return !(this.repo == null ? other.repo != null : !this.repo.equals(other.repo));
        }
    }
}

