/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.structuralchanges;

import com.ibm.team.filesystem.client.internal.IRepositoryResolver;
import com.ibm.team.filesystem.client.internal.snapshot.FlowType;
import com.ibm.team.filesystem.client.internal.snapshot.ISnapshot;
import com.ibm.team.filesystem.client.internal.snapshot.SnapshotId;
import com.ibm.team.filesystem.client.internal.snapshot.SnapshotSyncReport;
import com.ibm.team.filesystem.client.internal.utils.RepositoryUtils;
import com.ibm.team.filesystem.rcp.core.internal.rest.util.SyncViewDTOUtil;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.views.structuralchanges.StructuralChangesViewInput;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.rcp.common.IRemoteFunction;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.dto.IChangeHistorySyncReport;
import com.ibm.team.scm.common.dto.IRepositoryDescriptor;
import com.ibm.team.scm.common.internal.util.ItemId;
import com.ibm.team.scm.common.internal.util.ItemLists;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

public class ChangeHistorySyncReportInput
extends StructuralChangesViewInput {
    private IChangeHistorySyncReport report;
    private SnapshotId incoming;
    private SnapshotId outgoing;
    private IRemoteFunction<String> description;

    public ChangeHistorySyncReportInput(IChangeHistorySyncReport report, SnapshotId snapshot) {
        this(report, snapshot, snapshot);
        this.description = new DescriptionFunction(snapshot.getRepository(), ItemLists.handlesToIds((Collection)report.outgoingChangeSets()));
    }

    public ChangeHistorySyncReportInput(IChangeHistorySyncReport report, SnapshotId incoming, SnapshotId outgoing) {
        this.report = report;
        this.incoming = incoming;
        this.outgoing = outgoing;
    }

    public ChangeHistorySyncReportInput(IChangeHistorySyncReport report, ITeamRepository repository) {
        this.report = report;
        this.incoming = SnapshotId.createEmptyId((ITeamRepository)repository);
        this.outgoing = SnapshotId.createEmptyId((ITeamRepository)repository);
    }

    @Override
    public SnapshotId getOutgoing() {
        return this.outgoing;
    }

    @Override
    public SnapshotId getIncoming() {
        return this.incoming;
    }

    @Override
    public SnapshotSyncReport computeSyncReport(boolean refresh, IProgressMonitor monitor) throws TeamRepositoryException {
        return SnapshotSyncReport.createFrom((IChangeHistorySyncReport)this.report, (IRepositoryResolver)new IRepositoryResolver(){

            public ITeamRepository getRepoFor(String uri, UUID id) throws TeamRepositoryException {
                if (id.equals((Object)ChangeHistorySyncReportInput.this.getRepository().getId())) {
                    return ChangeHistorySyncReportInput.this.getRepository();
                }
                IRepositoryDescriptor repositoryDescriptor = ChangeHistorySyncReportInput.this.report.getRemoteRepositoryInfo();
                if (repositoryDescriptor != null) {
                    return RepositoryUtils.getTeamRepository((String)repositoryDescriptor.getRepositoryURI(), (UUID)repositoryDescriptor.getRepositoryId());
                }
                return null;
            }

            public ITeamRepository getDefaultRepository() {
                return ChangeHistorySyncReportInput.this.getRepository();
            }
        });
    }

    @Override
    public String computeName(IProgressMonitor monitor) throws TeamRepositoryException {
        if (this.description != null) {
            return (String)this.description.compute(monitor);
        }
        if (this.incoming != null && this.outgoing != null) {
            if (!this.incoming.isEmpty()) {
                return SyncViewDTOUtil.computeComparisonName((SnapshotId)this.outgoing, (SnapshotId)this.incoming, (IProgressMonitor)monitor);
            }
            ISnapshot s1 = this.outgoing.getSnapshot(monitor);
            return s1.getName();
        }
        return null;
    }

    @Override
    public ITeamRepository getRepository() {
        return this.incoming.getRepository();
    }

    @Override
    public FlowType forceMode() {
        return FlowType.Both;
    }

    @Override
    public String getCustomIncomingNodeLabel() {
        if (this.incoming.isEmpty()) {
            return Messages.ChangeHistorySyncReport_IncomingLabel;
        }
        return null;
    }

    private static class DescriptionFunction
    implements IRemoteFunction<String> {
        private List<ItemId<IChangeSet>> changeSets;
        private ITeamRepository repo;

        public DescriptionFunction(ITeamRepository repo, List<ItemId<IChangeSet>> changeSets) {
            this.repo = repo;
            this.changeSets = changeSets;
        }

        public String compute(IProgressMonitor monitor) throws TeamRepositoryException {
            return SyncViewDTOUtil.computeChangeSetInputDescription(this.changeSets, (ITeamRepository)this.repo, (IProgressMonitor)monitor);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.changeSets == null ? 0 : this.changeSets.hashCode());
            result = 31 * result + (this.repo == null ? 0 : this.repo.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            DescriptionFunction other = (DescriptionFunction)obj;
            if (this.changeSets == null ? other.changeSets != null : !this.changeSets.equals(other.changeSets)) {
                return false;
            }
            return !(this.repo == null ? other.repo != null : !this.repo.equals(other.repo));
        }
    }
}

