/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.search.workspace;

import com.ibm.team.filesystem.client.internal.namespace.ItemLocator;
import com.ibm.team.filesystem.common.internal.util.ItemUtil;
import com.ibm.team.filesystem.ui.wrapper.AbstractPlaceWrapper;
import com.ibm.team.filesystem.ui.wrapper.ReadScopeWrapper;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.views.history.ContributorFunction;
import com.ibm.team.internal.filesystem.ui.views.search.AbstractSearchInput;
import com.ibm.team.internal.filesystem.ui.views.search.AbstractSearchPage;
import com.ibm.team.internal.filesystem.ui.views.search.changeset.SimpleLocalSelectionTargetAdapter;
import com.ibm.team.internal.filesystem.ui.views.search.workspace.WorkspaceReadScopeFunction;
import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.client.ISharedItemChangeEvent;
import com.ibm.team.repository.client.ISharedItemChangeListener;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.rcp.ui.internal.viewers.ConvertColumn;
import com.ibm.team.repository.rcp.ui.internal.viewers.IConversion;
import com.ibm.team.repository.rcp.ui.internal.viewers.IDynamicFunction;
import com.ibm.team.repository.rcp.ui.internal.viewers.ISetWithListeners;
import com.ibm.team.repository.rcp.ui.internal.viewers.LabelColumn;
import com.ibm.team.repository.rcp.ui.internal.viewers.SimpleTableViewer;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.repository.rcp.ui.parts.IControlSite;
import com.ibm.team.repository.rcp.ui.utils.WidgetFactoryContext;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.internal.util.ItemId;
import java.util.List;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.Transfer;

public class WorkspaceSearchView
extends AbstractSearchPage<AbstractPlaceWrapper> {
    @Override
    protected String getMenuID() {
        return "com.ibm.team.filesystem.views.search.workspace";
    }

    public WorkspaceSearchView(IControlSite site, AbstractSearchInput<AbstractPlaceWrapper> input) {
        super(site, input);
    }

    @Override
    protected void addColumns(WidgetFactoryContext context, SimpleTableViewer<AbstractPlaceWrapper> viewer) {
        ISetWithListeners workspaces = viewer.getKnownElements();
        IOperationRunner opRunner = this.getControlSite().getOperationRunner();
        String nameColumnTitle = Messages.WorkspaceSearchView_nameColumn;
        LabelColumn nameColumn = new LabelColumn(viewer, nameColumnTitle, 200);
        nameColumn.setComparator(abstractPlaceWrapperComparator);
        nameColumn.setHoverProvider((IConversion)new IConversion<AbstractPlaceWrapper, Object>(){

            public Object createAdapter(AbstractPlaceWrapper source) {
                return source;
            }
        });
        String ownerColumnTitle = Messages.WorkspaceSearchView_ownerColumn;
        WorkspaceOwnerFunction ownerFunction = new WorkspaceOwnerFunction(workspaces, opRunner);
        ConvertColumn ownerColumn = new ConvertColumn(viewer, ownerColumnTitle, 200, (IDynamicFunction)ownerFunction);
        ownerColumn.setCellComparator(ownerComparator);
        String visibilityColumnTitle = Messages.WorkspaceSearchView_visibilityColumn;
        WorkspaceReadScopeFunction visibilityFunction = new WorkspaceReadScopeFunction((ISetWithListeners<AbstractPlaceWrapper>)workspaces, opRunner);
        ConvertColumn visibilityColumn = new ConvertColumn(viewer, visibilityColumnTitle, 200, (IDynamicFunction)visibilityFunction);
        visibilityColumn.setShowItemInContextMenu(false);
        visibilityColumn.setCellLabelProvider(ReadScopeWrapper.getLabelProvider());
        viewer.addDragSupport(21, new Transfer[]{LocalSelectionTransfer.getTransfer()}, (DragSourceListener)new SimpleLocalSelectionTargetAdapter(viewer));
    }

    private final class WorkspaceOwnerFunction
    extends ContributorFunction<AbstractPlaceWrapper> {
        private ISharedItemChangeListener listener;

        private WorkspaceOwnerFunction(ISetWithListeners domain, IOperationRunner runner) {
            super(domain, runner);
            this.listener = new ISharedItemChangeListener(){

                public void itemsChanged(List events) {
                    for (ISharedItemChangeEvent event : events) {
                        ItemId afterOwner;
                        ItemId beforeOwner;
                        IWorkspace beforeState = (IWorkspace)event.getBeforeState();
                        IWorkspace afterState = (IWorkspace)event.getAfterState();
                        if (beforeState == null || afterState == null || (beforeOwner = ItemUtil.getOwner((IWorkspace)beforeState)).equals((Object)(afterOwner = ItemUtil.getOwner((IWorkspace)afterState)))) continue;
                        AbstractPlaceWrapper changed = AbstractPlaceWrapper.newWrapper((IWorkspace)event.getSharedItem());
                        WorkspaceOwnerFunction.this.markDirty((Object)changed);
                    }
                }
            };
        }

        protected void elementAdded(AbstractPlaceWrapper wrapper) {
            IItemManager mgr = wrapper.getRepository().itemManager();
            mgr.addItemChangeListener((IItem)wrapper.getWorkspace(), this.listener);
            super.elementAdded((Object)wrapper);
        }

        protected void elementRemoved(AbstractPlaceWrapper wrapper) {
            IItemManager mgr = wrapper.getRepository().itemManager();
            mgr.removeItemChangeListener((IItem)wrapper.getWorkspace(), this.listener);
            super.elementRemoved((Object)wrapper);
        }

        @Override
        protected ItemLocator getContributor(AbstractPlaceWrapper wrapper) {
            return new ItemLocator(wrapper.getRepository(), wrapper.getWorkspace().getOwner());
        }
    }
}

