/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.search.workspace;

import com.ibm.team.filesystem.client.internal.namespace.ItemLocator;
import com.ibm.team.filesystem.ui.wrapper.AbstractPlaceWrapper;
import com.ibm.team.filesystem.ui.wrapper.ReadScopeWrapper;
import com.ibm.team.internal.filesystem.ui.views.search.workspace.ReadScopeFunction;
import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.client.ISharedItemChangeEvent;
import com.ibm.team.repository.client.ISharedItemChangeListener;
import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.repository.rcp.ui.internal.viewers.ISetWithListeners;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.dto.IReadScope;
import com.ibm.team.scm.common.internal.util.NewCollection;
import com.ibm.team.scm.common.internal.util.ReadScopeUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;

public class WorkspaceReadScopeFunction
extends ReadScopeFunction<AbstractPlaceWrapper> {
    private ISharedItemChangeListener fListener = new ISharedItemChangeListener(){

        public void itemsChanged(List events) {
            for (Object o : events) {
                IReadScope afterScope;
                IReadScope beforeScope;
                ISharedItemChangeEvent event;
                if (!(o instanceof ISharedItemChangeEvent) || !((event = (ISharedItemChangeEvent)o).getSharedItem() instanceof IWorkspace)) continue;
                IWorkspace beforeState = (IWorkspace)event.getBeforeState();
                IWorkspace afterState = (IWorkspace)event.getAfterState();
                if (beforeState == null || afterState == null || ReadScopeUtils.equals((IReadScope)(beforeScope = beforeState.getReadScope()), (IReadScope)(afterScope = afterState.getReadScope()))) continue;
                AbstractPlaceWrapper changed = AbstractPlaceWrapper.newWrapper((IWorkspace)event.getSharedItem());
                WorkspaceReadScopeFunction.this.markDirty((Object)changed);
            }
        }
    };

    public WorkspaceReadScopeFunction(ISetWithListeners<AbstractPlaceWrapper> domain, IOperationRunner runner) {
        super(domain, runner);
    }

    protected void elementAdded(AbstractPlaceWrapper wrapper) {
        IItemManager mgr = wrapper.getRepository().itemManager();
        mgr.addItemChangeListener(wrapper.getItem(), this.fListener);
        super.elementAdded((Object)wrapper);
    }

    protected void elementRemoved(AbstractPlaceWrapper wrapper) {
        IItemManager mgr = wrapper.getRepository().itemManager();
        mgr.removeItemChangeListener(wrapper.getItem(), this.fListener);
        super.elementRemoved((Object)wrapper);
    }

    @Override
    protected Map<AbstractPlaceWrapper, IReadScope> getReadScopes(Collection<AbstractPlaceWrapper> toFetch, IProgressMonitor monitor) {
        HashMap results = NewCollection.hashMap();
        for (AbstractPlaceWrapper wrapper : toFetch) {
            results.put(wrapper, wrapper.getWorkspace().getReadScope());
        }
        return results;
    }

    public ReadScopeWrapper doComputeResult(AbstractPlaceWrapper element) {
        IReadScope scope = element.getWorkspace().getReadScope();
        ItemLocator<IAuditable> context = this.getContext(scope, element.getRepository());
        if (context != null) {
            super.doComputeResult((Object)element);
        }
        return ReadScopeWrapper.newWrapper(scope);
    }
}

